/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.sat.GEOSTransform;

public class Geostationary
extends ProjectionImpl {
    private static final String NAME = "geostationary";
    GEOSTransform navigation = null;

    public Geostationary(double subLonDegrees, double perspective_point_height, double semi_minor_axis, double semi_major_axis, double inv_flattening, boolean isSweepX) {
        super(NAME, false);
        String scanGeometry = "GOES";
        if (!isSweepX) {
            scanGeometry = "GEOS";
        }
        this.navigation = new GEOSTransform(subLonDegrees, perspective_point_height /= 1000.0, semi_minor_axis /= 1000.0, semi_major_axis /= 1000.0, inv_flattening, scanGeometry);
        this.makePP();
    }

    public Geostationary() {
        super(NAME, false);
        this.navigation = new GEOSTransform();
        this.makePP();
    }

    public Geostationary(double subLonDegrees) {
        super(NAME, false);
        this.navigation = new GEOSTransform(subLonDegrees, "GOES");
        this.makePP();
    }

    public Geostationary(double subLonDegrees, boolean isSweepX) {
        super(NAME, false);
        String scanGeometry = "GOES";
        if (!isSweepX) {
            scanGeometry = "GEOS";
        }
        this.navigation = new GEOSTransform(subLonDegrees, scanGeometry);
        this.makePP();
    }

    public Geostationary(double subLonDegrees, String sweepAngleAxis) {
        super(NAME, false);
        String scanGeometry = "GOES";
        if (sweepAngleAxis.equals("x")) {
            scanGeometry = "GOES";
        } else if (sweepAngleAxis.equals("y")) {
            scanGeometry = "GEOS";
        }
        this.navigation = new GEOSTransform(subLonDegrees, scanGeometry);
        this.makePP();
    }

    private void makePP() {
        this.addParameter("grid_mapping_name", NAME);
        this.addParameter("longitude_of_projection_origin", this.navigation.sub_lon_degrees);
        this.addParameter("latitude_of_projection_origin", 0.0);
        this.addParameter("sweep_angle_axis", this.navigation.scan_geom.equals("GOES") ? "x" : "y");
        this.addParameter("semi_major_axis", this.navigation.r_eq * 1000.0);
        this.addParameter("semi_minor_axis", this.navigation.r_pol * 1000.0);
    }

    @Override
    public ProjectionImpl constructCopy() {
        return new Geostationary(this.navigation.sub_lon_degrees, this.navigation.scan_geom);
    }

    @Override
    public String paramsToString() {
        return "";
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double[] satCoords = this.navigation.earthToSat(latlon.getLongitude(), latlon.getLatitude());
        destPoint.setLocation(satCoords[0], satCoords[1]);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double[] lonlat = this.navigation.satToEarth(ppt.getX(), ppt.getY());
        destPoint.setLongitude(lonlat[0]);
        destPoint.setLatitude(lonlat[1]);
        return destPoint;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 100.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Geostationary that = (Geostationary)o;
        return this.navigation.equals(that.navigation);
    }

    public int hashCode() {
        return this.navigation.hashCode();
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        return super.latLonToProjBB(rect);
    }
}

