/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hwp;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.hpsf.NoPropertySetStreamException;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.OfficeOpenXMLCore;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.hwp.HwpStreamReader;
import org.apache.tika.sax.XHTMLContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class HwpTextExtractorV5
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static Logger LOG = LoggerFactory.getLogger(HwpTextExtractorV5.class);
    private static final byte[] HWP_V5_SIGNATURE = "HWP Document File".getBytes(StandardCharsets.US_ASCII);
    private static final int HWPTAG_BEGIN = 16;
    private static final int I = 1;
    private static final int C = 2;
    private static final int X = 3;
    private static final int[] HWP_CHAR_TYPE = new int[]{2, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2, 3, 3, 2, 3, 3, 3, 3, 3, 1, 1, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2};

    public void extract(InputStream source, Metadata metadata, XHTMLContentHandler xhtml) throws FileNotFoundException, IOException, TikaException, SAXException {
        if (source == null || xhtml == null) {
            throw new IllegalArgumentException();
        }
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem((InputStream)new CloseShieldInputStream(source));
            DirectoryNode root = fs.getRoot();
            this.extract0(root, metadata, xhtml);
        }
        catch (IOException e) {
            try {
                throw new TikaException("error occurred when parsing HWP Format, It may not HWP Format.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    private void extract0(DirectoryNode root, Metadata metadata, XHTMLContentHandler xhtml) throws IOException, SAXException, TikaException {
        Entry headerEntry = root.getEntry("FileHeader");
        if (!headerEntry.isDocumentEntry()) {
            throw new UnsupportedFormatException("cannot parse the File Header");
        }
        FileHeader header = this.getHeader(headerEntry);
        if (header == null) {
            throw new UnsupportedFormatException("cannot parse the File Header");
        }
        if (header.encrypted) {
            throw new EncryptedDocumentException("document is encrypted");
        }
        this.parseSummaryInformation(root, metadata);
        if (header.viewtext) {
            this.parseViewText(header, root, xhtml);
        } else {
            this.parseBodyText(header, root, xhtml);
        }
    }

    private void parseSummaryInformation(DirectoryNode root, Metadata metadata) throws TikaException {
        try {
            Entry summaryEntry = root.getEntry("\u0005HwpSummaryInformation");
            this.populateMatadata(summaryEntry, metadata);
        }
        catch (IOException | NoPropertySetStreamException e) {
            throw new UnsupportedFormatException("cannot parse the Summary Information");
        }
    }

    private void populateMatadata(Entry summaryEntry, Metadata metadata) throws IOException, NoPropertySetStreamException {
        Property[] props;
        DocumentInputStream summaryStream = new DocumentInputStream((DocumentEntry)summaryEntry);
        PropertySet ps = new PropertySet((InputStream)summaryStream);
        block11: for (Property prop : props = ps.getProperties()) {
            int propID = (int)prop.getID();
            Object value = prop.getValue();
            switch (propID) {
                case 2: {
                    metadata.set(TikaCoreProperties.TITLE, (String)value);
                    continue block11;
                }
                case 3: {
                    metadata.set(OfficeOpenXMLCore.SUBJECT, (String)value);
                    continue block11;
                }
                case 4: {
                    metadata.set(TikaCoreProperties.CREATOR, (String)value);
                    continue block11;
                }
                case 5: {
                    metadata.set(Office.KEYWORDS, (String)value);
                    continue block11;
                }
                case 6: {
                    metadata.set(TikaCoreProperties.COMMENTS, (String)value);
                    continue block11;
                }
                case 8: {
                    metadata.set(TikaCoreProperties.MODIFIER, (String)value);
                    continue block11;
                }
                case 12: {
                    metadata.set(TikaCoreProperties.CREATED, (Date)value);
                    continue block11;
                }
                case 13: {
                    metadata.set(TikaCoreProperties.MODIFIED, (Date)value);
                    continue block11;
                }
                case 14: {
                    metadata.set(Office.PAGE_COUNT, ((Integer)value).intValue());
                    continue block11;
                }
            }
        }
    }

    private FileHeader getHeader(Entry headerEntry) throws IOException {
        byte[] header = new byte[256];
        try (DocumentInputStream headerStream = new DocumentInputStream((DocumentEntry)headerEntry);){
            int read = headerStream.read(header);
            if (read != 256 || !Arrays.equals(HWP_V5_SIGNATURE, Arrays.copyOfRange(header, 0, HWP_V5_SIGNATURE.length))) {
                FileHeader fileHeader = null;
                return fileHeader;
            }
        }
        FileHeader fileHeader = new FileHeader();
        fileHeader.version = HwpVersion.parseVersion(LittleEndian.getUInt((byte[])header, (int)32));
        long flags = LittleEndian.getUInt((byte[])header, (int)36);
        LOG.debug("Flags={}", (Object)Long.toBinaryString(flags).replace(' ', '0'));
        fileHeader.compressed = (flags & 1L) == 1L;
        fileHeader.encrypted = (flags & 2L) == 2L;
        fileHeader.viewtext = (flags & 4L) == 4L;
        return fileHeader;
    }

    private void parseBodyText(FileHeader header, DirectoryNode root, XHTMLContentHandler xhtml) throws IOException, SAXException {
        Entry bodyText = root.getEntry("BodyText");
        if (bodyText == null || !bodyText.isDirectoryEntry()) {
            throw new IOException("Invalid BodyText");
        }
        Iterator iterator = ((DirectoryEntry)bodyText).getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.getName().startsWith("Section") && entry instanceof DocumentEntry) {
                LOG.debug("extract {}", (Object)entry.getName());
                Object input = new DocumentInputStream((DocumentEntry)entry);
                if (header.compressed) {
                    input = new InflaterInputStream((InputStream)input, new Inflater(true));
                }
                HwpStreamReader reader = new HwpStreamReader((InputStream)input);
                this.parse(reader, xhtml);
                continue;
            }
            LOG.warn("Unknown Entry '{}'({})", (Object)entry.getName(), (Object)entry);
        }
    }

    private void parseViewText(FileHeader header, DirectoryNode root, XHTMLContentHandler xhtml) throws IOException {
        Entry bodyText = root.getEntry("ViewText");
        if (bodyText == null || !bodyText.isDirectoryEntry()) {
            throw new IOException("Invalid ViewText");
        }
        Iterator iterator = ((DirectoryEntry)bodyText).getEntries();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (entry.getName().startsWith("Section") && entry instanceof DocumentEntry) {
                LOG.debug("extract {}", (Object)entry.getName());
                Object input = new DocumentInputStream((DocumentEntry)entry);
                try {
                    Key key = this.readKey((InputStream)input);
                    input = this.createDecryptStream((InputStream)input, key);
                    if (header.compressed) {
                        input = new InflaterInputStream((InputStream)input, new Inflater(true));
                    }
                    HwpStreamReader sectionStream = new HwpStreamReader((InputStream)input);
                    this.parse(sectionStream, xhtml);
                    continue;
                }
                catch (InvalidKeyException e) {
                    throw new IOException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e);
                }
                catch (NoSuchPaddingException e) {
                    throw new IOException(e);
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
                finally {
                    IOUtils.closeQuietly((Closeable)input);
                    continue;
                }
            }
            LOG.warn("unknown Entry '{}'({})", (Object)entry.getName(), (Object)entry);
        }
    }

    private Key readKey(InputStream input) throws IOException {
        byte[] data = new byte[260];
        if (IOUtils.readFully((InputStream)input, (byte[])data, (int)0, (int)4) != 4) {
            throw new EOFException();
        }
        if (IOUtils.readFully((InputStream)input, (byte[])data, (int)0, (int)256) != 256) {
            throw new EOFException();
        }
        SRand srand = new SRand(LittleEndian.getInt((byte[])data));
        byte xor = 0;
        int i = 0;
        int n = 0;
        while (i < 256) {
            if (n == 0) {
                xor = (byte)(srand.rand() & 0xFF);
                n = (srand.rand() & 0xF) + 1;
            }
            if (i >= 4) {
                data[i] = (byte)(data[i] ^ xor);
            }
            ++i;
            --n;
        }
        int offset = 4 + (data[0] & 0xF);
        byte[] key = Arrays.copyOfRange(data, offset, offset + 16);
        SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
        return secretKey;
    }

    public InputStream createDecryptStream(InputStream input, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = null;
        cipher = Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(2, key);
        return new CipherInputStream(input, cipher);
    }

    private void parse(HwpStreamReader reader, XHTMLContentHandler xhtml) throws IOException, SAXException {
        StringBuilder buf = new StringBuilder();
        TagInfo tag = new TagInfo();
        while (this.readTag(reader, tag)) {
            if (67L == tag.id) {
                if (tag.length % 2L != 0L) {
                    throw new IOException("Invalid block size");
                }
                buf.setLength(0);
                this.writeParaText(reader, tag.length, buf);
                if (buf.length() <= 0) continue;
                buf.append('\n');
                xhtml.startElement("p");
                xhtml.characters(buf.toString());
                xhtml.endElement("p");
                continue;
            }
            reader.ensureSkip(tag.length);
        }
    }

    private void writeParaText(HwpStreamReader reader, long datasize, StringBuilder buf) throws IOException {
        int[] chars = reader.uint16((int)(datasize / 2L));
        for (int index = 0; index < chars.length; ++index) {
            int ch = chars[index];
            if (ch < 32) {
                if (ch == 9) {
                    buf.append('\t');
                    index += 7;
                    continue;
                }
                int type = HWP_CHAR_TYPE[ch];
                if (1 == type) {
                    index += 7;
                    continue;
                }
                if (3 == type) {
                    index += 7;
                    continue;
                }
                if (2 != type) continue;
                buf.append(' ');
                continue;
            }
            buf.append((char)ch);
        }
    }

    private boolean readTag(HwpStreamReader reader, TagInfo tag) throws IOException {
        long recordHeader = reader.uint32();
        if (recordHeader == -1L) {
            return false;
        }
        tag.id = recordHeader & 0x3FFL;
        tag.level = recordHeader >> 10 & 0x3FFL;
        tag.length = recordHeader >> 20 & 0xFFFL;
        if (tag.length == 4095L) {
            tag.length = reader.uint32();
        }
        return true;
    }

    static class HwpVersion {
        int m;
        int n;
        int p;
        int r;

        HwpVersion() {
        }

        public String toString() {
            return String.format(Locale.US, "%d.%d.%d.%d", this.m, this.n, this.p, this.r);
        }

        public static HwpVersion parseVersion(long longVersion) {
            HwpVersion version = new HwpVersion();
            version.m = (int)((longVersion & 0xFF000000L) >> 24);
            version.n = (int)((longVersion & 0xFF0000L) >> 16);
            version.p = (int)((longVersion & 0xFF00L) >> 8);
            version.r = (int)(longVersion & 0xFFL);
            return version;
        }
    }

    static class TagInfo {
        long id;
        long level;
        long length;

        TagInfo() {
        }
    }

    static class FileHeader {
        HwpVersion version;
        boolean compressed;
        boolean encrypted;
        boolean viewtext;

        FileHeader() {
        }
    }

    private static class SRand {
        private int random_seed;

        private SRand(int seed) {
            this.random_seed = seed;
        }

        private int rand() {
            this.random_seed = this.random_seed * 214013 + 2531011 & 0xFFFFFFFF;
            return this.random_seed >> 16 & Short.MAX_VALUE;
        }
    }
}

