/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.elasticsearch;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Locale;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConfig;
import org.apache.manifoldcf.agents.output.elasticsearch.ElasticSearchConnection;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.system.Logging;

public class ElasticSearchAction
extends ElasticSearchConnection {
    public ElasticSearchAction(HttpClient client, ElasticSearchConfig config) throws ManifoldCFException {
        super(config, client);
    }

    public void executeGET(CommandEnum cmd, boolean checkConnection) throws ManifoldCFException, ServiceInterruption {
        StringBuffer url = this.getApiUrl(cmd.toString(), checkConnection);
        HttpGet method = new HttpGet(url.toString());
        this.call((HttpRequestBase)method);
        String error = this.checkJson("\"error\"");
        if (this.getResult() == ElasticSearchConnection.Result.OK && error == null) {
            return;
        }
        this.setResult("JSONERROR", ElasticSearchConnection.Result.ERROR, error);
        Logging.connectors.warn((Object)("ES: Commit failed: " + this.getResponse()));
    }

    public void executePOST(CommandEnum cmd, boolean checkConnection) throws ManifoldCFException, ServiceInterruption {
        StringBuffer url = this.getApiUrl(cmd.toString(), checkConnection);
        HttpPost method = new HttpPost(url.toString());
        this.call((HttpRequestBase)method);
        String error = this.checkJson("\"error\"");
        if (this.getResult() == ElasticSearchConnection.Result.OK && error == null) {
            return;
        }
        this.setResult("JSONERROR", ElasticSearchConnection.Result.ERROR, error);
        Logging.connectors.warn((Object)("ES: Commit failed: " + this.getResponse()));
    }

    @Override
    protected void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException)) {
            throw new ManifoldCFException(e.getMessage(), 2);
        }
        this.setResult(e.getClass().getSimpleName().toUpperCase(Locale.ROOT), ElasticSearchConnection.Result.ERROR, e.getMessage());
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 60000L, currentTime + 3600000L, 1, false);
    }

    public static enum CommandEnum {
        _optimize,
        _refresh,
        _stats,
        _forcemerge;

    }
}

