/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;

public class TestingRepositoryConnector
extends BaseRepositoryConnector {
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String docCount = "3";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals("documentcount")) continue;
            docCount = sn.getAttributeValue("count");
        }
        int count = Integer.parseInt(docCount);
        for (int i = 0; i < count; ++i) {
            String doc = "test" + i + ".txt";
            activities.addSeedDocument(doc, null);
        }
        return "";
    }

    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        for (int i = 0; i < documentIdentifiers.length; ++i) {
            String documentIdentifier = documentIdentifiers[i];
            RepositoryDocument rd = new RepositoryDocument();
            byte[] bytes = documentIdentifier.getBytes(StandardCharsets.UTF_8);
            rd.setBinary((InputStream)new ByteArrayInputStream(bytes), (long)bytes.length);
            try {
                activities.ingestDocumentWithException(documentIdentifier, "", "http://" + documentIdentifier, rd);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Shouldn't be seeing IOException from binary array input stream: " + e.getMessage(), e);
            }
        }
    }
}

