/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.AbstractConnection;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.AbstractEndPoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.ByteBufferPool;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.Connection;
import org.apache.hadoop.shaded.org.eclipse.jetty.io.EndPoint;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.BufferUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.Callback;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.StringUtil;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.component.Dumpable;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Log;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.log.Logger;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.thread.Scheduler;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.BatchMode;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.CloseException;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.StatusCode;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.SuspendToken;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketException;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.WriteCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.Frame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.CloseInfo;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.Generator;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.LogicalConnection;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.Parser;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io.ConnectionState;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io.DisconnectCallback;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io.FrameFlusher;
import org.apache.hadoop.shaded.org.eclipse.jetty.websocket.common.io.ReadState;

public abstract class AbstractWebSocketConnection
extends AbstractConnection
implements LogicalConnection,
Connection.UpgradeTo,
Dumpable {
    private static final Logger LOG = Log.getLogger(AbstractWebSocketConnection.class);
    private static final AtomicLong ID_GEN = new AtomicLong(0L);
    private static final int MIN_BUFFER_SIZE = 28;
    private final ByteBufferPool bufferPool;
    private final Scheduler scheduler;
    private final Generator generator;
    private final Parser parser;
    private final WebSocketPolicy policy;
    private final ReadState readState = new ReadState();
    private final ConnectionState connectionState = new ConnectionState();
    private final FrameFlusher flusher;
    private final String id;
    private final LongAdder bytesIn = new LongAdder();
    private WebSocketSession session;
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
    private ByteBuffer initialBuffer;
    private Stats stats = new Stats();
    private CloseInfo fatalCloseInfo;

    public AbstractWebSocketConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool) {
        super(endp, executor);
        this.id = Long.toString(ID_GEN.incrementAndGet());
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.generator = new Generator(policy, bufferPool);
        this.parser = new Parser(policy, bufferPool);
        this.scheduler = scheduler;
        this.flusher = new Flusher(bufferPool, this.generator, endp);
        this.setInputBufferSize(policy.getInputBufferSize());
        this.setMaxIdleTimeout(policy.getIdleTimeout());
    }

    @Override
    public Executor getExecutor() {
        return super.getExecutor();
    }

    @Override
    public void close(CloseInfo close, Callback callback) {
        if (this.connectionState.closing()) {
            boolean transmit;
            boolean bl = transmit = close.getStatusCode() == 1005 || StatusCode.isTransmittable(close.getStatusCode());
            if (transmit) {
                CloseFrame frame = close.asFrame();
                this.outgoingFrame(frame, new CallbackBridge(callback), BatchMode.OFF);
                if (StatusCode.isFatal(close.getStatusCode())) {
                    this.fatalCloseInfo = close;
                }
            } else {
                this.disconnect();
            }
        } else if (callback != null) {
            callback.failed(new IllegalStateException("Local Close already called"));
        }
    }

    @Override
    public void close(Throwable cause) {
        String reason;
        int statusCode;
        this.session.callApplicationOnError(cause);
        int n = statusCode = this.policy.getBehavior() == WebSocketBehavior.SERVER ? 1011 : 1006;
        if (cause instanceof CloseException) {
            statusCode = ((CloseException)cause).getStatusCode();
        }
        if (StringUtil.isBlank(reason = cause.getMessage())) {
            reason = cause.getClass().getSimpleName();
        }
        CloseInfo closeInfo = new CloseInfo(statusCode, reason);
        this.session.callApplicationOnClose(closeInfo);
        this.close(closeInfo, new DisconnectCallback(this));
    }

    @Override
    public boolean canWriteWebSocketFrames() {
        return this.connectionState.canWriteWebSocketFrames();
    }

    @Override
    public boolean canReadWebSocketFrames() {
        return this.connectionState.canReadWebSocketFrames();
    }

    @Override
    public String toStateString() {
        return this.connectionState.toString();
    }

    @Override
    public boolean opening() {
        return this.connectionState.opening();
    }

    @Override
    public boolean opened() {
        if (this.connectionState.opened()) {
            if (BufferUtil.hasContent(this.initialBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parsing upgrade initial buffer ({} remaining)", this.initialBuffer.remaining());
                }
                this.parser.parse(this.initialBuffer);
                this.initialBuffer = null;
            }
            this.fillInterested();
            return true;
        }
        return false;
    }

    @Override
    public void remoteClose(CloseInfo close) {
        this.session.callApplicationOnClose(close);
        this.close(close, new DisconnectCallback(this));
    }

    @Override
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    @Override
    public boolean onIdleExpired() {
        return super.onIdleExpired();
    }

    @Override
    public void close() {
        this.close(new CloseInfo(), Callback.NOOP);
    }

    @Override
    public void disconnect() {
        if (this.connectionState.disconnected()) {
            if (this.connectionState.wasOpened()) {
                CloseInfo closeInfo = this.fatalCloseInfo;
                if (closeInfo == null) {
                    closeInfo = new CloseInfo(1006, "Disconnected");
                }
                this.session.callApplicationOnClose(closeInfo);
            } else {
                this.session.callApplicationOnError(new WebSocketException("Shutdown"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} disconnect()", new Object[]{this.policy.getBehavior()});
            }
            this.flusher.terminate(new EOFException("Disconnected"));
            EndPoint endPoint = this.getEndPoint();
            endPoint.shutdownOutput();
            endPoint.close();
        }
    }

    @Override
    public void fillInterested() {
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.fillInterested();
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public long getIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.getEndPoint().getIdleTimeout();
    }

    public Parser getParser() {
        return this.parser;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Deprecated
    public Stats getStats() {
        return this.stats;
    }

    @Override
    public boolean isOpen() {
        return this.getEndPoint().isOpen();
    }

    @Override
    public boolean isReading() {
        return this.readState.isReading();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable()", new Object[]{this.policy.getBehavior()});
        }
        this.stats.countOnFillableEvents.incrementAndGet();
        if (this.readState.getBuffer() != null) {
            throw new IllegalStateException();
        }
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), true);
        this.onFillable(buffer);
    }

    private void onFillable(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillable(ByteBuffer): {}", new Object[]{this.policy.getBehavior(), buffer});
        }
        block11: while (true) {
            ReadState.Action action = this.readState.getAction(buffer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ReadState Action: {}", new Object[]{action});
            }
            switch (action) {
                case PARSE: {
                    try {
                        this.parser.parseSingleFrame(buffer);
                    }
                    catch (Throwable t) {
                        this.close(t);
                        this.readState.discard();
                    }
                    continue block11;
                }
                case FILL: {
                    try {
                        int filled = this.getEndPoint().fill(buffer);
                        if (filled < 0) {
                            this.readState.eof();
                            break;
                        }
                        if (filled == 0) {
                            this.bufferPool.release(buffer);
                            this.fillInterested();
                            return;
                        }
                        this.bytesIn.add(filled);
                        if (!LOG.isDebugEnabled()) continue block11;
                        LOG.debug("Filled {} bytes - {}", filled, BufferUtil.toDetailString(buffer));
                    }
                    catch (IOException e) {
                        this.close(e);
                        this.readState.eof();
                    }
                    continue block11;
                }
                case DISCARD: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Discarded buffer - {}", BufferUtil.toDetailString(buffer));
                    }
                    BufferUtil.clear(buffer);
                    break;
                }
                case SUSPEND: {
                    return;
                }
                case EOF: {
                    this.bufferPool.release(buffer);
                    CloseInfo close = new CloseInfo(1001);
                    this.close(close, new DisconnectCallback(this));
                    return;
                }
                default: {
                    throw new IllegalStateException(action.name());
                }
            }
        }
    }

    @Override
    public void resume() {
        ByteBuffer resume = this.readState.resume();
        if (resume != null) {
            this.getExecutor().execute(() -> this.onFillable(resume));
        }
    }

    @Override
    public SuspendToken suspend() {
        this.readState.suspending();
        return this;
    }

    @Override
    protected void onFillInterestedFailed(Throwable cause) {
        LOG.ignore(cause);
        this.stats.countFillInterestedEvents.incrementAndGet();
        super.onFillInterestedFailed(cause);
    }

    protected void setInitialBuffer(ByteBuffer initialBuffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Set initial buffer - {}", BufferUtil.toDetailString(initialBuffer));
        }
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected boolean onReadTimeout(Throwable timeout) {
        this.close(new CloseException(1001, timeout));
        return false;
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {})", frame, callback);
        }
        if (this.flusher.enqueue(frame, callback, batchMode)) {
            this.flusher.iterate();
        }
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
        this.extensions = extensions;
    }

    @Override
    public void setInputBufferSize(int inputBufferSize) {
        if (inputBufferSize < 28) {
            throw new IllegalArgumentException("Cannot have buffer size less than 28");
        }
        super.setInputBufferSize(inputBufferSize);
    }

    @Override
    public void setMaxIdleTimeout(long ms) {
        this.getEndPoint().setIdleTimeout(ms);
    }

    @Override
    public String dumpSelf() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        EndPoint endp = this.getEndPoint();
        String endpRef = endp.toString();
        if (endp instanceof AbstractEndPoint) {
            endpRef = ((AbstractEndPoint)endp).toEndPointString();
        }
        Dumpable.dumpObjects(out, indent, this, endpRef, this.flusher, this.generator, this.parser);
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x[s=%s,f=%s,g=%s,p=%s]", this.getClass().getSimpleName(), this.hashCode(), this.connectionState, this.flusher, this.generator, this.parser);
    }

    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onUpgradeTo({})", BufferUtil.toDetailString(buffer));
        }
        this.setInitialBuffer(buffer);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }

    @Override
    public long getMessagesIn() {
        return this.parser.getMessagesIn();
    }

    @Override
    public long getMessagesOut() {
        return this.flusher.getMessagesOut();
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    @Override
    public long getBytesOut() {
        return this.flusher.getBytesOut();
    }

    @Deprecated
    public static class Stats {
        private AtomicLong countFillInterestedEvents = new AtomicLong(0L);
        private AtomicLong countOnFillableEvents = new AtomicLong(0L);
        private AtomicLong countFillableErrors = new AtomicLong(0L);

        public long getFillableErrorCount() {
            return this.countFillableErrors.get();
        }

        public long getFillInterestedCount() {
            return this.countFillInterestedEvents.get();
        }

        public long getOnFillableCount() {
            return this.countOnFillableEvents.get();
        }
    }

    private class Flusher
    extends FrameFlusher {
        private Flusher(ByteBufferPool bufferPool, Generator generator, EndPoint endpoint) {
            super(bufferPool, generator, endpoint, AbstractWebSocketConnection.this.getPolicy().getMaxBinaryMessageBufferSize(), 8);
        }

        @Override
        public void onCompleteFailure(Throwable failure) {
            AbstractWebSocketConnection.this.close(failure);
            super.onCompleteFailure(failure);
        }
    }

    private static class CallbackBridge
    implements WriteCallback {
        private final Callback callback;

        public CallbackBridge(Callback callback) {
            this.callback = callback != null ? callback : Callback.NOOP;
        }

        @Override
        public void writeFailed(Throwable x) {
            this.callback.failed(x);
        }

        @Override
        public void writeSuccess() {
            this.callback.succeeded();
        }
    }
}

