/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.filter;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AutoReadWriteLock;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterSkipCollector {
    public static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterSkipCollector.class);
    public static final Cache<String, AtomicLong> queryTotalBloomBlocks = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> querySkipBloomBlocks = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> querySkipBloomRows = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> queryFooterReadTime = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<String, AtomicLong> queryFooterReadNumber = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final AtomicLong logCounter = new AtomicLong(0L);
    private static final AtomicLong globalBloomBlocks = new AtomicLong(0L);
    private static final AtomicLong globalSkipBloomBlocks = new AtomicLong(0L);
    private static final AutoReadWriteLock LOCK = new AutoReadWriteLock(new ReentrantReadWriteLock());

    public static void addQueryMetrics(String queryId, long totalBloomBlocks, long skipBloomBlocks, long skipBloomRows, long footerReadTime, long footerReadNumber) {
        long start = System.currentTimeMillis();
        try (AutoReadWriteLock.AutoLock writeLock = LOCK.lockForWrite();){
            BloomFilterSkipCollector.addQueryCounter(queryId, queryTotalBloomBlocks, totalBloomBlocks);
            BloomFilterSkipCollector.addQueryCounter(queryId, querySkipBloomBlocks, skipBloomBlocks);
            BloomFilterSkipCollector.addQueryCounter(queryId, querySkipBloomRows, skipBloomRows);
            BloomFilterSkipCollector.addQueryCounter(queryId, queryFooterReadTime, footerReadTime);
            BloomFilterSkipCollector.addQueryCounter(queryId, queryFooterReadNumber, footerReadNumber);
            globalBloomBlocks.addAndGet(totalBloomBlocks);
            globalSkipBloomBlocks.addAndGet(skipBloomBlocks);
        }
        catch (Exception e) {
            LOGGER.error("Error when add query metrics.", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (end - start > 100L) {
            LOGGER.warn("BloomFilter collector cost too much time: {} ms ", (Object)(end - start));
        }
    }

    private static void addQueryCounter(String queryId, Cache<String, AtomicLong> counter, long step) throws ExecutionException {
        AtomicLong totalBlocks = (AtomicLong)counter.get((Object)queryId, () -> new AtomicLong(0L));
        totalBlocks.addAndGet(step);
    }

    public static void logAndCleanStatus(String queryId) {
        try {
            AtomicLong readTime = (AtomicLong)queryFooterReadTime.get((Object)queryId, () -> new AtomicLong(0L));
            AtomicLong readNumber = (AtomicLong)queryFooterReadNumber.get((Object)queryId, () -> new AtomicLong(1L));
            if (readNumber.get() > 0L && readTime.get() > 0L) {
                LOGGER.info("Reading footer avg time is {}, total read time is {}, number of row groups is {}", new Object[]{readTime.get() / readNumber.get(), readTime.get(), readNumber});
            }
            AtomicLong totalBloomBlocks = (AtomicLong)queryTotalBloomBlocks.getIfPresent((Object)queryId);
            if (KylinConfig.getInstanceFromEnv().isBloomCollectFilterEnabled() && totalBloomBlocks != null && totalBloomBlocks.get() > 0L) {
                AtomicLong skipBlocks = (AtomicLong)querySkipBloomBlocks.get((Object)queryId, () -> new AtomicLong(0L));
                AtomicLong skipRows = (AtomicLong)querySkipBloomRows.get((Object)queryId, () -> new AtomicLong(0L));
                LOGGER.info("BloomFilter total bloom blocks is {}, skip bloom blocks is {}, skip rows is {}", new Object[]{totalBloomBlocks.get(), skipBlocks.get(), skipRows.get()});
            }
            queryFooterReadTime.invalidate((Object)queryId);
            queryFooterReadNumber.invalidate((Object)queryId);
            queryTotalBloomBlocks.invalidate((Object)queryId);
            querySkipBloomBlocks.invalidate((Object)queryId);
            querySkipBloomRows.invalidate((Object)queryId);
            logCounter.incrementAndGet();
            if (logCounter.get() >= 100L) {
                LOGGER.info("Global BloomFilter total bloom blocks is {},  skip bloom blocks is {}", (Object)globalBloomBlocks.get(), (Object)globalSkipBloomBlocks.get());
                logCounter.set(0L);
            }
            if (globalBloomBlocks.get() < 0L || globalSkipBloomBlocks.get() < 0L) {
                globalBloomBlocks.set(0L);
                globalSkipBloomBlocks.set(0L);
            }
        }
        catch (ExecutionException e) {
            LOGGER.error("Error when log query metrics.", (Throwable)e);
        }
    }

    private BloomFilterSkipCollector() {
    }
}

