/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CollectionUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.util.OlapRelUtil;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.RexUtils;
import org.apache.kylin.query.util.SparkSQLFunctionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputedColumnRewriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputedColumnRewriter.class);
    public static final Map<String, String> CC_TO_REX_NODE_STR_CACHE = Maps.newConcurrentMap();
    public static final Map<String, ComputedColumnDesc> EXP_TO_CC_MAP = Maps.newConcurrentMap();
    public static final String NAME_SPLIT = "@@";
    private static final SparkSQLFunctionConverter FUNCTION_CONVERTER = new SparkSQLFunctionConverter();

    private ComputedColumnRewriter() {
    }

    public static void rewriteCcInnerCol(OlapContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)model.getProject());
        if (ComputedColumnRewriter.canSkipRewrite(projectConfig, model)) {
            return;
        }
        ComputedColumnRewriter.rewriteAggInnerCol(projectConfig, context, model, matchInfo);
        ComputedColumnRewriter.rewriteTopNInnerCol(projectConfig, context, model, matchInfo);
        ComputedColumnRewriter.rewriteGroupByInnerCol(projectConfig, context, model, matchInfo);
    }

    private static void rewriteAggInnerCol(KylinConfig kylinConfig, OlapContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        for (FunctionDesc agg : context.getAggregations()) {
            if (CollectionUtils.isEmpty((Collection)agg.getParameters())) continue;
            ArrayList parameters = Lists.newArrayList();
            for (ParameterDesc parameter : agg.getParameters()) {
                if (!parameter.getColRef().isInnerColumn()) {
                    parameters.add(parameter);
                    continue;
                }
                String innerExp = parameter.getColRef().getParserDescription();
                TblColRef translatedInnerCol = ComputedColumnRewriter.rewriteInnerCol(kylinConfig, innerExp, model, matchInfo);
                if (translatedInnerCol == null) continue;
                parameters.add(ParameterDesc.newInstance((Object)translatedInnerCol));
                context.getAllColumns().add(translatedInnerCol);
            }
            if (parameters.isEmpty()) continue;
            agg.setParameters((List)parameters);
        }
    }

    private static TblColRef rewriteInnerCol(KylinConfig kylinConfig, String innerExpression, NDataModel model, QueryAliasMatchInfo matchInfo) {
        try {
            ComputedColumnDesc cc = ComputedColumnRewriter.matchComputedColumn(kylinConfig, innerExpression, model, matchInfo);
            if (cc != null) {
                ColumnDesc[] ccCols = ComputedColumnUtil.createComputedColumns((List)Lists.newArrayList((Object[])new ComputedColumnDesc[]{cc}), (TableDesc)model.getRootFactTable().getTableDesc());
                log.debug("Replacing CC expr [{},{}]", (Object)cc.getColumnName(), (Object)cc.getExpression());
                return new TblColRef(model.getRootFactTable(), ccCols[0]);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse expression: `{}`, therefore cannot match ComputedColumn.", (Object)innerExpression);
        }
        return null;
    }

    private static ComputedColumnDesc matchComputedColumn(KylinConfig kylinConfig, String innerExpression, NDataModel model, QueryAliasMatchInfo matchInfo) throws SqlParseException {
        if (innerExpression == null) {
            return null;
        }
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            String key = cc.getTableIdentity() + NAME_SPLIT + StringHelper.backtickToDoubleQuote((String)cc.getInnerExpression());
            EXP_TO_CC_MAP.put(key, cc);
            if (CC_TO_REX_NODE_STR_CACHE.containsKey(key)) continue;
            String rexNodeStr = ComputedColumnRewriter.extractCcRexNode(model, kylinConfig, cc.getInnerExpression());
            CC_TO_REX_NODE_STR_CACHE.put(key, rexNodeStr);
        }
        for (Map.Entry entry : matchInfo.getAliasMap().entrySet()) {
            innerExpression = innerExpression.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        boolean onlyReuseUserDefinedCC = kylinConfig.onlyReuseUserDefinedCC();
        String aliasInnerExpression = model.getRootFactTableName() + NAME_SPLIT + innerExpression;
        if (EXP_TO_CC_MAP.containsKey(aliasInnerExpression)) {
            ComputedColumnDesc cc = EXP_TO_CC_MAP.get(aliasInnerExpression);
            if (onlyReuseUserDefinedCC && cc.isAutoCC()) {
                return null;
            }
            return cc;
        }
        String rexNodeStr = ComputedColumnRewriter.extractCcRexNode(model, kylinConfig, innerExpression);
        for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
            String key;
            String rexNodeStrOfCc;
            if (onlyReuseUserDefinedCC && cc.isAutoCC() || !Objects.equals(rexNodeStr, rexNodeStrOfCc = CC_TO_REX_NODE_STR_CACHE.get(key = cc.getTableIdentity() + NAME_SPLIT + StringHelper.backtickToDoubleQuote((String)cc.getInnerExpression())))) continue;
            return cc;
        }
        return null;
    }

    private static String extendToQuery(NDataModel model, String project, String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return null;
        }
        String ccSql = PushDownUtil.expandComputedColumnExp(model, project, StringHelper.backtickToDoubleQuote((String)expression));
        ccSql = FUNCTION_CONVERTER.convert(ccSql, project, "DEFAULT");
        return QueryUtil.adaptCalciteSyntax(ccSql);
    }

    public static String extractCcRexNode(NDataModel model, KylinConfig kylinConfig, String innerExpression) throws SqlParseException {
        String project = model.getProject();
        String extendedQuery = ComputedColumnRewriter.extendToQuery(model, project, innerExpression);
        return ComputedColumnRewriter.getRexNodeStr(kylinConfig, project, extendedQuery);
    }

    public static String getRexNodeStr(KylinConfig kylinConfig, String project, String extendedQuery) throws SqlParseException {
        RelNode relNode = OlapRelUtil.toRel(project, kylinConfig, extendedQuery);
        if (relNode instanceof LogicalProject) {
            List projects = ((LogicalProject)relNode).getProjects();
            RexNode rexNode = (RexNode)projects.get(0);
            InputRefFinder finder = new InputRefFinder(((LogicalProject)relNode).getInput());
            RexNode accepted = (RexNode)rexNode.accept((RexVisitor)finder);
            accepted = RexUtils.symmetricalExchange(relNode.getCluster().getRexBuilder(), accepted);
            String str = accepted.toString();
            for (Map.Entry<String, RelDataTypeField> entry : finder.getFieldMap().entrySet()) {
                str = str.replace(entry.getKey(), entry.getValue().getName());
            }
            return str;
        }
        return null;
    }

    private static void rewriteTopNInnerCol(KylinConfig kylinConfig, OlapContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        context.getSortColumns().stream().filter(TblColRef::isInnerColumn).forEach(column -> {
            if (CollectionUtils.isEmpty((Collection)column.getOperands())) {
                return;
            }
            ArrayList translatedOperands = Lists.newArrayList();
            for (TblColRef tblColRef : column.getOperands()) {
                TblColRef translated;
                String innerExp = tblColRef.getParserDescription();
                if (innerExp == null || (translated = ComputedColumnRewriter.rewriteInnerCol(kylinConfig, innerExp, model, matchInfo)) == null) continue;
                translatedOperands.add(translated);
            }
            column.setOperands((List)translatedOperands);
        });
    }

    private static void rewriteGroupByInnerCol(KylinConfig kylinConfig, OlapContext context, NDataModel model, QueryAliasMatchInfo matchInfo) {
        HashMap<OlapAggregateRel, Map> relColRefMapping = new HashMap<OlapAggregateRel, Map>();
        for (TableColRefWithRel innerColRefWithRel : context.getInnerGroupByColumns()) {
            String innerExp = innerColRefWithRel.getTblColRef().getParserDescription();
            TblColRef translated = ComputedColumnRewriter.rewriteInnerCol(kylinConfig, innerExp, model, matchInfo);
            if (translated == null) continue;
            ColumnDesc innerCol = translated.getColumnDesc();
            CollectionUtil.find(context.getFirstTableScan().getColumnRowType().getAllColumns(), tblColRef -> tblColRef.getColumnDesc().equals((Object)innerCol)).ifPresent(ccColRef -> {
                OlapAggregateRel olapAggRel = innerColRefWithRel.getRelNodeAs(OlapAggregateRel.class);
                relColRefMapping.putIfAbsent(olapAggRel, new HashMap());
                ((Map)relColRefMapping.get(olapAggRel)).put(innerColRefWithRel.getTblColRef(), ccColRef);
                log.info("Replacing CC expr [{},{}] in group key {}", new Object[]{innerCol.getName(), innerCol.getComputedColumnExpr(), innerColRefWithRel.getTblColRef()});
            });
        }
        relColRefMapping.forEach(OlapAggregateRel::reBuildGroups);
    }

    private static boolean canSkipRewrite(KylinConfig kylinConfig, NDataModel model) {
        return CollectionUtils.isEmpty((Collection)model.getComputedColumnDescs()) || !kylinConfig.isConvertExpressionToCcEnabled();
    }

    public static void cacheCcRexNode(KylinConfig kylinConfig, String project) {
        NDataflowManager dflMgr = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        boolean onlyReuseUserDefinedCC = kylinConfig.onlyReuseUserDefinedCC();
        dflMgr.listOnlineDataModels().forEach(model -> {
            for (ComputedColumnDesc cc : model.getComputedColumnDescs()) {
                if (onlyReuseUserDefinedCC && cc.isAutoCC()) continue;
                try {
                    String key = cc.getTableIdentity() + NAME_SPLIT + StringHelper.backtickToDoubleQuote((String)cc.getInnerExpression());
                    if (CC_TO_REX_NODE_STR_CACHE.containsKey(key)) continue;
                    String rexNodeStr = ComputedColumnRewriter.extractCcRexNode(model, kylinConfig, cc.getInnerExpression());
                    CC_TO_REX_NODE_STR_CACHE.put(key, rexNodeStr);
                }
                catch (Exception exception) {}
            }
        });
    }

    public static class InputRefFinder
    extends RexVisitorImpl<RexNode> {
        private Map<String, RelDataTypeField> fieldMap = Maps.newHashMap();
        final RelNode sourceRel;

        public InputRefFinder(RelNode sourceRel) {
            super(true);
            this.sourceRel = sourceRel;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataTypeField field = (RelDataTypeField)this.sourceRel.getRowType().getFieldList().get(inputRef.getIndex());
            this.fieldMap.put("$" + inputRef.getIndex(), field);
            return inputRef;
        }

        public RexNode visitCall(RexCall call) {
            List rexNodes = call.getOperands();
            List converted = rexNodes.stream().map(rex -> (RexNode)rex.accept((RexVisitor)this)).collect(Collectors.toList());
            if (call.getOperator().getName().equalsIgnoreCase("substr")) {
                return this.sourceRel.getCluster().getRexBuilder().makeCall(call.getType(), (SqlOperator)SqlStdOperatorTable.SUBSTRING, converted);
            }
            return call.clone(call.getType(), converted);
        }

        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return dynamicParam;
        }

        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        @Generated
        public Map<String, RelDataTypeField> getFieldMap() {
            return this.fieldMap;
        }
    }
}

