/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.schema.OlapSchema;
import org.apache.kylin.query.schema.OlapTable;
import org.apache.kylin.storage.StorageContext;
import org.apache.logging.log4j.util.Strings;
import org.apache.spark.sql.util.SparderTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapContext {
    private static final Logger logger = LoggerFactory.getLogger(OlapContext.class);
    public static final String PRM_ACCEPT_PARTIAL_RESULT = "AcceptPartialResult";
    public static final HashSet<String> UNSUPPORTED_FUNCTION_IN_LOOKUP = new HashSet<String>(Collections.singleton("INTERSECT_COUNT"));
    private final int id;
    private final StorageContext storageContext;
    private OlapSchema olapSchema = null;
    private OlapTableScan firstTableScan = null;
    private Set<OlapTableScan> allTableScans = new LinkedHashSet<OlapTableScan>();
    private final Set<OlapJoinRel> allOlapJoins = new HashSet<OlapJoinRel>();
    private TupleInfo returnTupleInfo = null;
    private boolean afterAggregate = false;
    private boolean afterHavingClauseFilter = false;
    private boolean afterLimit = false;
    private boolean limitPrecedesAggr = false;
    private boolean hasWindow = false;
    private IRealization realization;
    private final IncapableInfo incapableInfo = new IncapableInfo();
    private Set<TblColRef> allColumns = new HashSet<TblColRef>();
    private final Set<TblColRef> metricsColumns = new HashSet<TblColRef>();
    private List<FunctionDesc> aggregations = new ArrayList<FunctionDesc>();
    private final Set<TblColRef> filterColumns = new LinkedHashSet<TblColRef>();
    private final List<JoinDesc> joins = new LinkedList<JoinDesc>();
    private final Map<String, RelDataType> rewriteFields = new HashMap<String, RelDataType>();
    private String sql = "";
    private boolean isExactlyAggregate = false;
    private boolean hasBitmapMeasure = false;
    private boolean isExactlyFastBitmap = false;
    private boolean fixedModel;
    private final List<SQLDigest.OrderEnum> sortOrders;
    private SQLDigest sqlDigest;
    private OlapRel topNode = null;
    private RelNode parentOfTopNode;
    private int limit = Integer.MAX_VALUE;
    private boolean hasJoin;
    private boolean hasPreCalcJoin;
    private boolean hasAgg;
    private boolean hasSelected;
    private Set<TblColRef> groupByColumns = new LinkedHashSet<TblColRef>();
    private Set<TableColRefWithRel> innerGroupByColumns = new LinkedHashSet<TableColRefWithRel>();
    private Set<TableColRefWithRel> innerFilterColumns = new LinkedHashSet<TableColRefWithRel>();
    private final Set<TblColRef> subqueryJoinParticipants = new HashSet<TblColRef>();
    private final Set<TblColRef> outerJoinParticipants = new HashSet<TblColRef>();
    private final List<FunctionDesc> constantAggregations = new ArrayList<FunctionDesc>();
    private final List<RexNode> expandedFilterConditions = new LinkedList<RexNode>();
    private final List<OlapFilterRel> allFilterRels = new LinkedList<OlapFilterRel>();
    private final Set<TableRef> notNullTables = new HashSet<TableRef>();
    private JoinsGraph joinsGraph;
    private List<TblColRef> sortColumns;
    private final Set<String> containedNotSupportedFunc = new HashSet<String>();
    private Map<TblColRef, TblColRef> groupCCColRewriteMapping = new HashMap<TblColRef, TblColRef>();
    private boolean needToManyDerived;
    private String boundedModelAlias;
    public static final String SEP = System.getProperty("line.separator");
    public static final String INDENT = "  ";
    public static final String olapContextFormat = SEP + "{" + SEP + "  " + "\"Fact Table\" = \"%s\"," + SEP + "  " + "\"Dimension Tables\" = [%s]," + SEP + "  " + "\"Recommend Dimension(Group by)\" = [%s]," + SEP + "  " + "\"Recommend Dimension(Filter cond)\" = [%s]," + SEP + "  " + "\"Measures\" = [%s]," + SEP + "}" + SEP;

    public OlapContext(int seq) {
        this.id = seq;
        this.storageContext = new StorageContext(seq);
        this.sortColumns = Lists.newArrayList();
        this.sortOrders = Lists.newArrayList();
    }

    public boolean isConstantQuery() {
        return this.allColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public boolean isConstantQueryWithAggregations() {
        return this.allColumns.isEmpty() && this.aggregations.isEmpty() && !this.constantAggregations.isEmpty();
    }

    public SQLDigest getSQLDigest() {
        if (this.sqlDigest == null) {
            this.sqlDigest = new SQLDigest(this.firstTableScan.getTableName(), (Set)Sets.newHashSet(this.allColumns), (List)Lists.newLinkedList(this.joins), (List)Lists.newArrayList(this.groupByColumns), (Set)Sets.newHashSet(this.subqueryJoinParticipants), (Set)Sets.newHashSet(this.metricsColumns), (List)Lists.newArrayList(this.aggregations), (Set)Sets.newLinkedHashSet(this.filterColumns), (List)Lists.newArrayList(this.sortColumns), (List)Lists.newArrayList(this.sortOrders), this.limit, this.limitPrecedesAggr);
        }
        return this.sqlDigest;
    }

    public String getFirstTableIdentity() {
        return this.firstTableScan.getTableRef().getTableIdentity();
    }

    public boolean isFirstTableLookupTableInModel(NDataModel model) {
        return this.joins.isEmpty() && model.isLookupTable(this.getFirstTableIdentity());
    }

    public boolean hasPrecalculatedFields() {
        NLayoutCandidate candidate = this.storageContext.getBatchCandidate();
        if (candidate.isEmpty()) {
            return false;
        }
        boolean isTableIndex = candidate.getLayoutEntity().getIndex().isTableIndex();
        boolean isLookupTable = this.isFirstTableLookupTableInModel(this.realization.getModel());
        return !isTableIndex && !isLookupTable;
    }

    public void resetSQLDigest() {
        this.sqlDigest = null;
    }

    public boolean belongToContextTables(TblColRef tblColRef) {
        for (OlapTableScan olapTableScan : this.allTableScans) {
            if (!olapTableScan.getColumnRowType().getAllColumns().contains(tblColRef)) continue;
            return true;
        }
        return false;
    }

    public boolean isOriginAndBelongToCtxTables(TblColRef tblColRef) {
        return this.belongToContextTables(tblColRef) && !tblColRef.getName().startsWith("_KY_");
    }

    public void setReturnTupleInfo(RelDataType rowType, ColumnRowType columnRowType) {
        TupleInfo info = new TupleInfo();
        List fieldList = rowType.getFieldList();
        for (int i = 0; i < fieldList.size(); ++i) {
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            TblColRef col = columnRowType == null ? null : columnRowType.getColumnByIndex(i);
            info.setField(field.getName(), col, i);
        }
        this.returnTupleInfo = info;
    }

    public void addSort(TblColRef col, SQLDigest.OrderEnum order) {
        if (col != null) {
            this.sortColumns.add(col);
            this.sortOrders.add(order);
        }
    }

    public void fixModel(NDataModel model, Map<String, String> aliasMap) {
        if (this.fixedModel) {
            return;
        }
        for (OlapTableScan tableScan : this.allTableScans) {
            tableScan.fixColumnRowTypeWithModel(model, aliasMap);
        }
        this.fixedModel = true;
    }

    public void unfixModel() {
        if (!this.fixedModel) {
            return;
        }
        for (OlapTableScan tableScan : this.allTableScans) {
            tableScan.unfixColumnRowTypeWithModel();
        }
        this.fixedModel = false;
    }

    public void clearCtxInfo() {
        this.afterAggregate = false;
        this.afterHavingClauseFilter = false;
        this.afterLimit = false;
        this.limitPrecedesAggr = false;
        this.hasJoin = false;
        this.hasPreCalcJoin = false;
        this.hasAgg = false;
        this.hasWindow = false;
        this.allColumns.clear();
        this.groupByColumns.clear();
        this.subqueryJoinParticipants.clear();
        this.metricsColumns.clear();
        this.allOlapJoins.clear();
        this.joins.clear();
        this.allTableScans.clear();
        this.filterColumns.clear();
        this.aggregations.clear();
        this.sortColumns.clear();
        this.sortOrders.clear();
        this.joinsGraph = null;
        this.sqlDigest = null;
        this.getConstantAggregations().clear();
    }

    public boolean isAnsweredByTableIndex() {
        NLayoutCandidate candidate = this.realization.isStreaming() ? this.storageContext.getStreamCandidate() : this.storageContext.getBatchCandidate();
        return candidate.isTableIndex();
    }

    public void simplify() {
        if (this.firstTableScan != null) {
            this.firstTableScan = this.firstTableScan.cleanRelOptCluster();
        }
        HashSet simplifiedTableScans = Sets.newHashSet();
        this.allTableScans.forEach(olapTableScan -> olapTableScan.getCluster().getPlanner().clear());
        this.allTableScans.forEach(olapTableScan -> simplifiedTableScans.add(olapTableScan.cleanRelOptCluster()));
        this.allTableScans = simplifiedTableScans;
    }

    public String toString() {
        return "OlapContext{firstTableScan=" + this.firstTableScan + ", allTableScans=" + this.allTableScans + ", allOlapJoins=" + this.allOlapJoins + ", groupByColumns=" + this.groupByColumns + ", innerGroupByColumns=" + this.innerGroupByColumns + ", innerFilterColumns=" + this.innerFilterColumns + ", aggregations=" + this.aggregations + ", filterColumns=" + this.filterColumns + '}';
    }

    public boolean isBoundedModel(NDataModel model) {
        if (this.boundedModelAlias == null) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)model.getAlias(), (CharSequence)this.boundedModelAlias);
    }

    public Map<String, String> matchJoins(NDataModel model, boolean isInnerJoinPartial, boolean isNonEquivJoinPartial) {
        if (this.joinsGraph == null) {
            this.joinsGraph = new JoinsGraph(this.firstTableScan.getTableRef(), this.joins);
        }
        HashMap<String, String> tableAliasMap = new HashMap<String, String>();
        boolean matched = this.joinsGraph.match(model.getJoinsGraph(), tableAliasMap, isInnerJoinPartial, isNonEquivJoinPartial);
        if (!matched) {
            logger.debug("Context joinsGraph missed model {}, model join graph {}", (Object)model, (Object)model.getJoinsGraph());
            logger.debug("Mismatch nodes - Context {}, Model {}", (Object)this.joinsGraph.unmatched(model.getJoinsGraph()), (Object)model.getJoinsGraph().unmatched(this.joinsGraph));
            if (this.olapSchema.getConfig().isJoinMatchOptimizationEnabled()) {
                String project = model.getProject();
                String mAlias = model.getAlias();
                logger.info("Rewrite the joinsGraph by filter conditions and match with model({}/{}).", (Object)project, (Object)mAlias);
                this.transformJoinsGraphByFilterConditions();
                matched = this.joinsGraph.match(model.getJoinsGraph(), tableAliasMap, isInnerJoinPartial, isNonEquivJoinPartial);
                logger.info("Match result of rewritten joinsGraph of model({}/{}): {}", new Object[]{project, mAlias, matched});
            }
        }
        if (!matched) {
            this.incapableInfo.addIncapableReason(model, IncapableInfo.Type.MODEL_UNMATCHED_JOIN);
            tableAliasMap.clear();
        }
        return tableAliasMap;
    }

    public boolean isInvalidContext() {
        return !this.allTableScans.isEmpty() && this.joins.size() != this.allTableScans.size() - 1;
    }

    public void markInvalid() {
        this.incapableInfo.addIncapableReason(IncapableInfo.Type.BAD_OLAP_CONTEXT);
    }

    public String tipsForUser() {
        Set allTables = this.allTableScans.stream().map(OlapTableScan::getTableName).collect(Collectors.toSet());
        if (!allTables.isEmpty() && this.firstTableScan != null) {
            allTables.remove(this.firstTableScan.getTableName());
            return String.format(Locale.ROOT, olapContextFormat, this.firstTableScan.getTableName(), Strings.join(allTables.stream().map(c -> "\"" + c + "\"").iterator(), (char)','), Strings.join(this.groupByColumns.stream().map(c -> "\"" + c.getColumnWithTableAndSchema() + "\"").iterator(), (char)','), Strings.join(this.filterColumns.stream().map(c -> "\"" + c.getColumnWithTableAndSchema() + "\"").iterator(), (char)','), Strings.join(this.aggregations.stream().map(c -> "\"" + c.getFullExpression() + "\"").iterator(), (char)','));
        }
        return "empty";
    }

    public String toHumanReadString() {
        String r = this.realization == null ? "not matched" : this.realization.getCanonicalName();
        return "{id = " + this.id + ", model = " + r + ", fact table = " + (this.firstTableScan != null ? this.firstTableScan.getTableName() : "?") + "}";
    }

    private void transformJoinsGraphByFilterConditions() {
        Set<TableRef> leftOrInnerTables = this.getNotNullTables();
        if (CollectionUtils.isNotEmpty(leftOrInnerTables)) {
            for (JoinDesc join : this.joins) {
                if (!leftOrInnerTables.contains(join.getPKSide())) continue;
                this.joinsGraph.setJoinToLeftOrInner(join);
                logger.info("Current join: {} is set to LEFT_OR_INNER", (Object)join);
            }
        }
        this.joinsGraph.normalize();
    }

    public NLookupCandidate.Policy deduceLookupTableType() {
        NLookupCandidate.Policy policy = NLookupCandidate.Policy.NONE;
        boolean noUnsupportedAgg = this.getSQLDigest().getAggregations().stream().noneMatch(fun -> UNSUPPORTED_FUNCTION_IN_LOOKUP.contains(fun.getExpression()));
        boolean noCc = this.getSQLDigest().getAllColumns().stream().noneMatch(col -> col.getColumnDesc().isComputedColumn());
        if (noUnsupportedAgg && noCc && this.getSQLDigest().getJoinDescs().isEmpty()) {
            KylinConfig olapConfig = this.olapSchema.getConfig();
            String project = this.olapSchema.getProject();
            String factTable = this.getSQLDigest().getFactTable();
            NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)olapConfig, (String)project);
            TableDesc tableDesc = tableMgr.getTableDesc(factTable);
            if (tableDesc == null) {
                return policy;
            }
            if (olapConfig.isInternalTableEnabled() && tableDesc.isHasInternal()) {
                if (!this.isUniqueAsyncQuery(olapConfig) || this.asyncQueryUseGlutenEnabled(olapConfig)) {
                    logger.info("Hit internal table {}", (Object)factTable);
                    policy = this.getSQLDigest().isDigestOfRawQuery() ? NLookupCandidate.Policy.INTERNAL_TABLE : NLookupCandidate.Policy.AGG_THEN_INTERNAL_TABLE;
                }
            } else if (!olapConfig.isInternalTableEnabled() && !StringUtils.isBlank((CharSequence)tableDesc.getLastSnapshotPath())) {
                logger.info("Hit the snapshot {}, the path is: {}", (Object)factTable, (Object)tableDesc.getLastSnapshotPath());
                policy = this.getSQLDigest().isDigestOfRawQuery() ? NLookupCandidate.Policy.SNAPSHOT : NLookupCandidate.Policy.AGG_THEN_SNAPSHOT;
            }
        }
        return policy;
    }

    public boolean isUniqueAsyncQuery(KylinConfig olapConfig) {
        return QueryContext.current().getQueryTagInfo().isAsyncQuery() && olapConfig.isUniqueAsyncQueryYarnQueue();
    }

    public boolean asyncQueryUseGlutenEnabled(KylinConfig olapConfig) {
        return this.isUniqueAsyncQuery(olapConfig) && olapConfig.uniqueAsyncQueryUseGlutenEnabled();
    }

    public String incapableMsg() {
        StringBuilder buf = new StringBuilder("OlapContext");
        if (this.incapableInfo.getReason() != null) {
            buf.append(", ").append((Object)this.incapableInfo.getReason());
        }
        for (Set<IncapableInfo.Type> types : this.incapableInfo.getReasons().values()) {
            types.forEach(type -> buf.append(", ").append(type));
        }
        buf.append(", ").append(this.firstTableScan);
        this.joins.forEach(join -> buf.append(", ").append(join));
        return buf.toString();
    }

    public String genExecFunc(OlapRel rel) {
        this.setReturnTupleInfo(rel.getRowType(), rel.getColumnRowType());
        if (this.isConstantQueryWithAggregations()) {
            return "executeSimpleAggregationQuery";
        }
        if (this.getStorageContext().getLookupCandidate() != null) {
            return "executeLookupTableQuery";
        }
        if (this.canMinMaxDimAnsweredByMetadata(rel, true)) {
            return "executeMetadataQuery";
        }
        return "executeOlapQuery";
    }

    public boolean checkOlapContextAnsweredByMetadata() {
        OlapRel aggChildTableOrJoin = this.getAggChildTableOrJoin(this.topNode);
        return null != aggChildTableOrJoin && this.canMinMaxDimAnsweredByMetadata(aggChildTableOrJoin, false);
    }

    private OlapRel getAggChildTableOrJoin(RelNode parentNode) {
        if (CollectionUtils.isEmpty((Collection)parentNode.getInputs())) {
            return null;
        }
        if (!(parentNode instanceof OlapAggregateRel)) {
            return this.getAggChildTableOrJoin(parentNode.getInput(0));
        }
        RelNode aggChildNode = parentNode.getInput(0);
        if (!(aggChildNode instanceof OlapProjectRel)) {
            return this.getAggChildTableOrJoin(aggChildNode);
        }
        RelNode projectChildNode = aggChildNode.getInput(0);
        if (projectChildNode instanceof OlapTableScan || projectChildNode instanceof OlapJoinRel) {
            return (OlapRel)projectChildNode;
        }
        return this.getAggChildTableOrJoin(projectChildNode);
    }

    private boolean canMinMaxDimAnsweredByMetadata(OlapRel rel, boolean resetAggWhenMatch) {
        OlapRel current;
        if (!KylinConfig.getInstanceFromEnv().isRouteToMetadataEnabled()) {
            return false;
        }
        if (!(this.realization instanceof NDataflow) || !(rel instanceof OlapJoinRel) && !(rel instanceof OlapTableScan)) {
            logger.info("Can't route to metadata, the realization is {} and this OlapRel is {}", (Object)this.realization, (Object)rel);
            return false;
        }
        ArrayList<OlapRel> relStack = new ArrayList<OlapRel>();
        for (current = this.topNode; current != rel && current.getInputs().size() == 1 && current.getInput(0) instanceof OlapRel; current = (OlapRel)current.getInput(0)) {
            relStack.add(current);
        }
        if (current != rel || relStack.size() < 2 || !(relStack.get(relStack.size() - 1) instanceof OlapProjectRel) || !(relStack.get(relStack.size() - 2) instanceof OlapAggregateRel)) {
            logger.info("Can't route to query metadata, the rel stack is not matched");
            return false;
        }
        OlapAggregateRel aggregateRel = (OlapAggregateRel)relStack.get(relStack.size() - 2);
        if (aggregateRel.getGroups().size() > 1 || aggregateRel.getGroups().size() == 1 && !TblColRef.InnerDataTypeEnum.LITERAL.getDataType().equals(aggregateRel.getGroups().get(0).getDatatype())) {
            logger.info("Cannot route to query metadata, only group by constants are supported.");
            return false;
        }
        if (this.aggregations.isEmpty() || !this.aggregations.stream().allMatch(agg -> agg.isMin() || agg.isMax())) {
            logger.info("Cannot route to query metadata, only min/max aggregate functions are supported.");
            return false;
        }
        if (this.aggregations.stream().anyMatch(agg -> TblColRef.InnerDataTypeEnum.contains((String)((TblColRef)agg.getColRefs().get(0)).getDatatype()))) {
            logger.info("Cannot route to query metadata, not support min(expression), such as min(id+1)");
            return false;
        }
        if (!Sets.newHashSet((Iterable)this.realization.getAllDimensions()).containsAll(this.allColumns)) {
            logger.info("Cannot route to query metadata, not all columns queried are treated as dimensions of index.");
            return false;
        }
        if (resetAggWhenMatch) {
            aggregateRel.getRewriteAggCalls().clear();
            aggregateRel.getRewriteAggCalls().addAll(aggregateRel.getAggCallList());
            logger.info("Use kylin metadata to answer query with realization : {}", (Object)this.realization);
        } else {
            logger.info("OlapContext can be answered by kylin metadata with realization : {}", (Object)this.realization);
        }
        return true;
    }

    public List<Object[]> getColValuesRange() {
        return this.getColValuesRange(false);
    }

    public List<Object[]> getColValuesRange(boolean isCalciteEngine) {
        Preconditions.checkState((boolean)(this.realization instanceof NDataflow), (Object)"Only support dataflow");
        List cols = this.aggregations.stream().map(FunctionDesc::getColRefs).filter(tblColRefs -> tblColRefs.size() == 1).map(tblColRefs -> (TblColRef)tblColRefs.get(0)).collect(Collectors.toList());
        ArrayList allFields = new ArrayList();
        this.allTableScans.forEach(tableScan -> {
            List<TblColRef> colRefs = tableScan.getColumnRowType().getAllColumns();
            allFields.addAll(colRefs);
        });
        RelDataTypeFactory typeFactory = this.getTopNode().getCluster().getTypeFactory();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (NDataSegment segment : ((NDataflow)this.realization).getSegments()) {
            if (segment.getStatus() != SegmentStatusEnum.READY) continue;
            Map infoMap = segment.getDimensionRangeInfoMap();
            Object[] minList = new Object[allFields.size()];
            Object[] maxList = new Object[allFields.size()];
            for (TblColRef col : cols) {
                int colId = allFields.indexOf(col);
                String tblColRefIndex = this.getTblColRefIndex(col, this.realization);
                DimensionRangeInfo rangeInfo = (DimensionRangeInfo)infoMap.get(tblColRefIndex);
                if (rangeInfo == null) {
                    minList[colId] = null;
                    maxList[colId] = null;
                    continue;
                }
                ColumnDesc c = col.getColumnDesc();
                if (isCalciteEngine) {
                    DataType dataType = c.getUpgradedType();
                    minList[colId] = this.convertToColumnDataType(rangeInfo.getMin(), dataType);
                    maxList[colId] = this.convertToColumnDataType(rangeInfo.getMax(), dataType);
                    continue;
                }
                RelDataType sqlType = OlapTable.createSqlType(typeFactory, c.getUpgradedType(), c.isNullable());
                minList[colId] = SparderTypeUtil.convertToStringWithCalciteType((Object)rangeInfo.getMin(), (RelDataType)sqlType, (boolean)false);
                maxList[colId] = SparderTypeUtil.convertToStringWithCalciteType((Object)rangeInfo.getMax(), (RelDataType)sqlType, (boolean)false);
            }
            result.add(minList);
            result.add(maxList);
        }
        return result;
    }

    private Object convertToColumnDataType(String strVal, DataType dataType) {
        String dataTypeName = dataType.getName();
        Object value = Tuple.convertOptiqCellValue((String)strVal, (String)dataTypeName);
        if ("decimal".equals(dataTypeName)) {
            BigDecimal decimalVal = (BigDecimal)value;
            value = decimalVal.setScale(dataType.getScale(), RoundingMode.HALF_EVEN);
        }
        return value;
    }

    private String getTblColRefIndex(TblColRef colRef, IRealization df) {
        NDataModel model = df.getModel();
        return String.valueOf(model.getColumnIdByColumnName(colRef.getAliasDotName()));
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public StorageContext getStorageContext() {
        return this.storageContext;
    }

    @Generated
    public OlapSchema getOlapSchema() {
        return this.olapSchema;
    }

    @Generated
    public OlapTableScan getFirstTableScan() {
        return this.firstTableScan;
    }

    @Generated
    public Set<OlapTableScan> getAllTableScans() {
        return this.allTableScans;
    }

    @Generated
    public Set<OlapJoinRel> getAllOlapJoins() {
        return this.allOlapJoins;
    }

    @Generated
    public TupleInfo getReturnTupleInfo() {
        return this.returnTupleInfo;
    }

    @Generated
    public boolean isAfterAggregate() {
        return this.afterAggregate;
    }

    @Generated
    public boolean isAfterHavingClauseFilter() {
        return this.afterHavingClauseFilter;
    }

    @Generated
    public boolean isAfterLimit() {
        return this.afterLimit;
    }

    @Generated
    public boolean isLimitPrecedesAggr() {
        return this.limitPrecedesAggr;
    }

    @Generated
    public boolean isHasWindow() {
        return this.hasWindow;
    }

    @Generated
    public IRealization getRealization() {
        return this.realization;
    }

    @Generated
    public IncapableInfo getIncapableInfo() {
        return this.incapableInfo;
    }

    @Generated
    public Set<TblColRef> getAllColumns() {
        return this.allColumns;
    }

    @Generated
    public Set<TblColRef> getMetricsColumns() {
        return this.metricsColumns;
    }

    @Generated
    public List<FunctionDesc> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public Set<TblColRef> getFilterColumns() {
        return this.filterColumns;
    }

    @Generated
    public List<JoinDesc> getJoins() {
        return this.joins;
    }

    @Generated
    public Map<String, RelDataType> getRewriteFields() {
        return this.rewriteFields;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public boolean isExactlyAggregate() {
        return this.isExactlyAggregate;
    }

    @Generated
    public boolean isHasBitmapMeasure() {
        return this.hasBitmapMeasure;
    }

    @Generated
    public boolean isExactlyFastBitmap() {
        return this.isExactlyFastBitmap;
    }

    @Generated
    public boolean isFixedModel() {
        return this.fixedModel;
    }

    @Generated
    public List<SQLDigest.OrderEnum> getSortOrders() {
        return this.sortOrders;
    }

    @Generated
    public OlapRel getTopNode() {
        return this.topNode;
    }

    @Generated
    public RelNode getParentOfTopNode() {
        return this.parentOfTopNode;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isHasJoin() {
        return this.hasJoin;
    }

    @Generated
    public boolean isHasPreCalcJoin() {
        return this.hasPreCalcJoin;
    }

    @Generated
    public boolean isHasAgg() {
        return this.hasAgg;
    }

    @Generated
    public boolean isHasSelected() {
        return this.hasSelected;
    }

    @Generated
    public Set<TblColRef> getGroupByColumns() {
        return this.groupByColumns;
    }

    @Generated
    public Set<TableColRefWithRel> getInnerGroupByColumns() {
        return this.innerGroupByColumns;
    }

    @Generated
    public Set<TableColRefWithRel> getInnerFilterColumns() {
        return this.innerFilterColumns;
    }

    @Generated
    public Set<TblColRef> getSubqueryJoinParticipants() {
        return this.subqueryJoinParticipants;
    }

    @Generated
    public Set<TblColRef> getOuterJoinParticipants() {
        return this.outerJoinParticipants;
    }

    @Generated
    public List<FunctionDesc> getConstantAggregations() {
        return this.constantAggregations;
    }

    @Generated
    public List<RexNode> getExpandedFilterConditions() {
        return this.expandedFilterConditions;
    }

    @Generated
    public List<OlapFilterRel> getAllFilterRels() {
        return this.allFilterRels;
    }

    @Generated
    public Set<TableRef> getNotNullTables() {
        return this.notNullTables;
    }

    @Generated
    public JoinsGraph getJoinsGraph() {
        return this.joinsGraph;
    }

    @Generated
    public List<TblColRef> getSortColumns() {
        return this.sortColumns;
    }

    @Generated
    public Set<String> getContainedNotSupportedFunc() {
        return this.containedNotSupportedFunc;
    }

    @Generated
    public Map<TblColRef, TblColRef> getGroupCCColRewriteMapping() {
        return this.groupCCColRewriteMapping;
    }

    @Generated
    public boolean isNeedToManyDerived() {
        return this.needToManyDerived;
    }

    @Generated
    public String getBoundedModelAlias() {
        return this.boundedModelAlias;
    }

    @Generated
    public void setOlapSchema(OlapSchema olapSchema) {
        this.olapSchema = olapSchema;
    }

    @Generated
    public void setFirstTableScan(OlapTableScan firstTableScan) {
        this.firstTableScan = firstTableScan;
    }

    @Generated
    public void setAfterAggregate(boolean afterAggregate) {
        this.afterAggregate = afterAggregate;
    }

    @Generated
    public void setAfterHavingClauseFilter(boolean afterHavingClauseFilter) {
        this.afterHavingClauseFilter = afterHavingClauseFilter;
    }

    @Generated
    public void setAfterLimit(boolean afterLimit) {
        this.afterLimit = afterLimit;
    }

    @Generated
    public void setLimitPrecedesAggr(boolean limitPrecedesAggr) {
        this.limitPrecedesAggr = limitPrecedesAggr;
    }

    @Generated
    public void setHasWindow(boolean hasWindow) {
        this.hasWindow = hasWindow;
    }

    @Generated
    public void setRealization(IRealization realization) {
        this.realization = realization;
    }

    @Generated
    public void setAllColumns(Set<TblColRef> allColumns) {
        this.allColumns = allColumns;
    }

    @Generated
    public void setAggregations(List<FunctionDesc> aggregations) {
        this.aggregations = aggregations;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setExactlyAggregate(boolean isExactlyAggregate) {
        this.isExactlyAggregate = isExactlyAggregate;
    }

    @Generated
    public void setHasBitmapMeasure(boolean hasBitmapMeasure) {
        this.hasBitmapMeasure = hasBitmapMeasure;
    }

    @Generated
    public void setExactlyFastBitmap(boolean isExactlyFastBitmap) {
        this.isExactlyFastBitmap = isExactlyFastBitmap;
    }

    @Generated
    public void setTopNode(OlapRel topNode) {
        this.topNode = topNode;
    }

    @Generated
    public void setParentOfTopNode(RelNode parentOfTopNode) {
        this.parentOfTopNode = parentOfTopNode;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public void setHasJoin(boolean hasJoin) {
        this.hasJoin = hasJoin;
    }

    @Generated
    public void setHasPreCalcJoin(boolean hasPreCalcJoin) {
        this.hasPreCalcJoin = hasPreCalcJoin;
    }

    @Generated
    public void setHasAgg(boolean hasAgg) {
        this.hasAgg = hasAgg;
    }

    @Generated
    public void setHasSelected(boolean hasSelected) {
        this.hasSelected = hasSelected;
    }

    @Generated
    public void setGroupByColumns(Set<TblColRef> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    @Generated
    public void setInnerGroupByColumns(Set<TableColRefWithRel> innerGroupByColumns) {
        this.innerGroupByColumns = innerGroupByColumns;
    }

    @Generated
    public void setInnerFilterColumns(Set<TableColRefWithRel> innerFilterColumns) {
        this.innerFilterColumns = innerFilterColumns;
    }

    @Generated
    public void setJoinsGraph(JoinsGraph joinsGraph) {
        this.joinsGraph = joinsGraph;
    }

    @Generated
    public void setSortColumns(List<TblColRef> sortColumns) {
        this.sortColumns = sortColumns;
    }

    @Generated
    public void setGroupCCColRewriteMapping(Map<TblColRef, TblColRef> groupCCColRewriteMapping) {
        this.groupCCColRewriteMapping = groupCCColRewriteMapping;
    }

    @Generated
    public void setNeedToManyDerived(boolean needToManyDerived) {
        this.needToManyDerived = needToManyDerived;
    }

    @Generated
    public void setBoundedModelAlias(String boundedModelAlias) {
        this.boundedModelAlias = boundedModelAlias;
    }

    public static class IncapableInfo {
        private Type reason;
        private final Map<NDataModel, Set<Type>> reasons = Maps.newHashMap();

        public void addIncapableReason(Type reason) {
            this.reason = reason;
        }

        public void addIncapableReason(NDataModel model, Type reason) {
            this.reasons.putIfAbsent(model, new LinkedHashSet());
            this.reasons.get(model).add(reason);
        }

        @Generated
        public Type getReason() {
            return this.reason;
        }

        @Generated
        public Map<NDataModel, Set<Type>> getReasons() {
            return this.reasons;
        }

        public static enum Type {
            MODEL_UNMATCHED_JOIN,
            BAD_OLAP_CONTEXT;

        }
    }
}

