/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Hints;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Util;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.basic.BasicMeasureType;
import org.apache.kylin.measure.topn.TopNMeasureType;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KylinAggregateCall;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.TableColRefWithRel;
import org.apache.kylin.query.schema.OlapTable;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapAggregateRel
extends Aggregate
implements OlapRel {
    private static final Map<String, String> AGGR_FUNC_MAP = new HashMap<String, String>();
    public static final Set<String> SUPPORTED_FUNCTIONS = ImmutableSet.of((Object)"SUM", (Object)"MIN", (Object)"MAX", (Object)"COUNT_DISTINCT", (Object)"BITMAP_UUID", (Object)"PERCENTILE_APPROX", (Object[])new String[]{"BITMAP_BUILD", "SUM_LC"});
    private OlapContext context;
    private ColumnRowType columnRowType;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private List<TblColRef> groups;
    private final Set<TblColRef> groupByInnerColumns = new HashSet<TblColRef>();
    private ImmutableList<Integer> rewriteGroupKeys;
    private List<ImmutableBitSet> rewriteGroupSets;
    private final List<AggregateCall> aggregateCalls;
    private List<AggregateCall> rewriteAggCalls;
    private List<FunctionDesc> aggregations;
    private boolean afterAggregate;

    public OlapAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggregateCalls) throws InvalidRelException {
        super(cluster, traits, child, groupSet, groupSets, aggregateCalls);
        Preconditions.checkArgument((this.getConvention() == OlapRel.CONVENTION ? 1 : 0) != 0);
        this.afterAggregate = false;
        this.rewriteAggCalls = aggregateCalls;
        this.rowType = this.getRowType();
        this.rewriteGroupKeys = ImmutableList.copyOf((Collection)groupSet.toList());
        this.aggregateCalls = aggregateCalls;
        this.rewriteGroupSets = groupSets;
    }

    static String getSqlFuncName(AggregateCall aggCall) {
        String sqlName = aggCall.getAggregation().getName();
        if (aggCall.isDistinct()) {
            sqlName = sqlName + "_DISTINCT";
        }
        return sqlName;
    }

    public static String getAggrFuncName(AggregateCall aggCall) {
        if (SqlKind.SINGLE_VALUE == aggCall.getAggregation().kind) {
            return SqlKind.SINGLE_VALUE.sql;
        }
        String sqlName = OlapAggregateRel.getSqlFuncName(aggCall);
        String funcName = AGGR_FUNC_MAP.get(sqlName);
        if (funcName == null) {
            throw new IllegalStateException("Not-support aggregation: " + sqlName);
        }
        return funcName;
    }

    public Aggregate copy(RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new OlapAggregateRel(this.getCluster(), traitSet, input, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OlapAggregateRel!", e);
        }
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan((SingleRel)this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        if (tempState.hasFreeTable()) {
            if (CollectionUtils.exists(this.aggregateCalls, aggCall -> ((AggregateCall)aggCall).getAggregation().getKind() == SqlKind.SINGLE_VALUE)) {
                contextImpl.allocateContext((OlapRel)this.getInput(), this);
            } else {
                contextImpl.allocateContext(this, null);
            }
            tempState.setHasFreeTable(false);
        }
        state.merge(tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl implementor) {
        this.context = null;
        this.columnRowType = null;
        implementor.visitChild(this.getInput());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        for (AggregateCall call : this.aggregateCalls) {
            if (KylinConfig.getInstanceFromEnv().getSkipCorrReduceRule() || !"CORR".equalsIgnoreCase(call.getAggregation().getName())) continue;
            return planner.getCostFactory().makeInfiniteCost();
        }
        RelOptCost cost = this.getGroupType() == Aggregate.Group.SIMPLE ? super.computeSelfCost(planner, mq).multiplyBy(0.05) : super.computeSelfCost(planner, mq).multiplyBy(0.05).plus(planner.getCost(this.getInput(), mq)).multiplyBy((double)this.groupSets.size() * 1.5);
        return cost;
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        olapImpl.visitChild(this.getInput(), this);
        for (AggregateCall aggCall : this.aggregateCalls) {
            if (!FunctionDesc.NOT_SUPPORTED_FUNCTION.contains((Object)aggCall.getAggregation().getName())) continue;
            this.context.getContainedNotSupportedFunc().add(aggCall.getAggregation().getName());
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.context.setHasAgg(true);
            this.afterAggregate = this.context.isAfterAggregate();
            if (!this.afterAggregate) {
                this.updateContextGroupByColumns();
                this.addAggFunctions();
                this.context.setAfterAggregate(true);
                if (this.context.isAfterLimit()) {
                    this.context.setLimitPrecedesAggr(true);
                }
                this.addSourceColsToContext();
                return;
            }
            this.checkAggCallAfterAggRel();
        }
    }

    private void addAggFunctions() {
        for (FunctionDesc agg : this.aggregations) {
            if (agg.isAggregateOnConstant()) {
                this.context.getConstantAggregations().add(agg);
                continue;
            }
            this.context.getAggregations().add(agg);
        }
    }

    public ColumnRowType buildColumnRowType() {
        this.buildGroups();
        this.buildAggregations();
        ColumnRowType colRowType = ((OlapRel)this.getInput()).getColumnRowType();
        ArrayList columns = Lists.newArrayListWithCapacity((int)this.rowType.getFieldCount());
        columns.addAll(this.getGroupColsOfColumnRowType());
        for (int i = 0; i < this.aggregations.size(); ++i) {
            String aggOutName;
            FunctionDesc aggFunc = this.aggregations.get(i);
            ArrayList operands = Lists.newArrayList();
            if (aggFunc != null) {
                operands.addAll(aggFunc.getColRefs());
                aggOutName = aggFunc.getRewriteFieldName();
            } else {
                AggregateCall aggCall = this.rewriteAggCalls.get(i);
                int index = (Integer)aggCall.getArgList().get(0);
                aggOutName = OlapAggregateRel.getSqlFuncName(aggCall) + "_" + colRowType.getColumnByIndex(index).getIdentity().replace('.', '_') + "_";
                aggCall.getArgList().forEach(argIndex -> operands.add(colRowType.getColumnByIndex((int)argIndex)));
            }
            TblColRef aggOutCol = TblColRef.newInnerColumn((String)aggOutName, (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.AGGREGATION_TYPE);
            aggOutCol.setOperator((SqlOperator)this.rewriteAggCalls.get(i).getAggregation());
            aggOutCol.setOperands((List)operands);
            aggOutCol.getColumnDesc().setId(String.valueOf(i + 1));
            columns.add(aggOutCol);
        }
        Preconditions.checkState((columns.size() == this.rowType.getFieldCount() ? 1 : 0) != 0);
        return new ColumnRowType(columns);
    }

    private TblColRef buildRewriteColumn(FunctionDesc aggFunc) {
        if (!aggFunc.needRewriteField()) {
            throw new IllegalStateException("buildRewriteColumn on a aggrFunc that does not need rewrite " + aggFunc);
        }
        String colName = aggFunc.getRewriteFieldName();
        TblColRef colRef = this.context.getFirstTableScan().makeRewriteColumn(colName);
        return colRef;
    }

    private void buildGroups() {
        this.buildGroupSet();
        this.buildGroupSets();
    }

    private void buildGroupSet() {
        ArrayList<TblColRef> groupCols = new ArrayList<TblColRef>();
        LinkedList<Integer> groupKeys = new LinkedList<Integer>();
        this.doBuildGroupSet(this.getGroupSet(), groupCols, groupKeys);
        this.groups = groupCols;
        this.rewriteGroupKeys = ImmutableList.copyOf(groupKeys);
    }

    private void buildGroupSets() {
        LinkedList<ImmutableBitSet> newRewriteGroupSets = new LinkedList<ImmutableBitSet>();
        for (ImmutableBitSet subGroup : this.groupSets) {
            ArrayList<TblColRef> groupCols = new ArrayList<TblColRef>();
            LinkedList<Integer> groupKeys = new LinkedList<Integer>();
            this.doBuildGroupSet(subGroup, groupCols, groupKeys);
            ImmutableBitSet rewriteGroupSet = ImmutableBitSet.of(groupKeys);
            newRewriteGroupSets.add(rewriteGroupSet);
        }
        this.rewriteGroupSets = newRewriteGroupSets;
    }

    private void doBuildGroupSet(ImmutableBitSet groupSet, List<TblColRef> groups, List<Integer> groupKeys) {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        int i = groupSet.nextSetBit(0);
        while (i >= 0) {
            TblColRef originalColumn = inputColumnRowType.getColumnByIndex(i);
            if (null != this.context && this.context.getGroupCCColRewriteMapping().containsKey(originalColumn)) {
                groups.add(this.context.getGroupCCColRewriteMapping().get(originalColumn));
                String colName = this.context.getGroupCCColRewriteMapping().get(originalColumn).getName();
                groupKeys.add(inputColumnRowType.getIndexByName(colName));
            } else {
                Set<TblColRef> sourceColumns = inputColumnRowType.getSourceColumnsByIndex(i);
                groups.addAll(sourceColumns);
                groupKeys.add(i);
            }
            if (originalColumn.isInnerColumn()) {
                this.groupByInnerColumns.add(originalColumn);
            }
            i = groupSet.nextSetBit(i + 1);
        }
    }

    public void reBuildGroups(Map<TblColRef, TblColRef> colReplacementMapping) {
        this.context.setGroupCCColRewriteMapping(colReplacementMapping);
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        HashSet<TblColRef> groupCols = new HashSet<TblColRef>();
        int i = this.getGroupSet().nextSetBit(0);
        while (i >= 0) {
            TblColRef originalColumn = inputColumnRowType.getColumnByIndex(i);
            Set<TblColRef> sourceColumns = inputColumnRowType.getSourceColumnsByIndex(i);
            if (colReplacementMapping.containsKey(originalColumn)) {
                groupCols.add(colReplacementMapping.get(originalColumn));
            } else {
                groupCols.addAll(sourceColumns);
            }
            i = this.getGroupSet().nextSetBit(i + 1);
        }
        this.setGroups(new ArrayList<TblColRef>(groupCols));
        this.updateContextGroupByColumns();
    }

    private void updateContextGroupByColumns() {
        this.context.getGroupByColumns().clear();
        for (TblColRef col : this.groups) {
            if (col.isInnerColumn() || !this.context.belongToContextTables(col)) continue;
            this.context.getGroupByColumns().add(col);
        }
        for (TblColRef tblColRef : this.groupByInnerColumns) {
            this.context.getInnerGroupByColumns().add(new TableColRefWithRel(this, tblColRef));
        }
    }

    public List<TblColRef> getGroupColsOfColumnRowType() {
        ArrayList allColumns = Lists.newArrayList();
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        int i = this.getGroupSet().nextSetBit(0);
        while (i >= 0) {
            TblColRef tblColRef = inputColumnRowType.getColumnByIndex(i);
            allColumns.add(tblColRef);
            i = this.getGroupSet().nextSetBit(i + 1);
        }
        return allColumns;
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context != null) {
            return false;
        }
        if (((OlapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    private void buildAggregations() {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        this.aggregations = new ArrayList<FunctionDesc>();
        for (AggregateCall aggCall : this.rewriteAggCalls) {
            ArrayList parameters = Lists.newArrayList();
            if (!aggCall.getArgList().isEmpty()) {
                ArrayList columns = Lists.newArrayList();
                List args = Lists.newArrayList();
                if ("PERCENTILE".equals(OlapAggregateRel.getSqlFuncName(aggCall)) || "PERCENTILE_APPROX".equals(OlapAggregateRel.getSqlFuncName(aggCall))) {
                    args.add(aggCall.getArgList().get(0));
                } else {
                    args = aggCall.getArgList();
                }
                for (Integer index : args) {
                    TblColRef column2 = inputColumnRowType.getColumnByIndex(index);
                    if ("SUM".equals(OlapAggregateRel.getSqlFuncName(aggCall))) {
                        column2 = this.rewriteCastInSumIfNecessary(aggCall, inputColumnRowType, index);
                    }
                    columns.add(column2);
                }
                if (!columns.isEmpty()) {
                    columns.forEach(column -> parameters.add(ParameterDesc.newInstance((Object)column)));
                }
            }
            String expression = OlapAggregateRel.getAggrFuncName(aggCall);
            FunctionDesc aggFunc = FunctionDesc.newInstance((String)expression, (List)parameters, null);
            this.aggregations.add(aggFunc);
        }
    }

    private TblColRef rewriteCastInSumIfNecessary(AggregateCall aggCall, ColumnRowType colRowType, Integer index) {
        TblColRef innerColumn;
        TblColRef column = colRowType.getColumnByIndex(index);
        if (this.getInput() instanceof OlapProjectRel && SqlTypeUtil.isBigint((RelDataType)aggCall.type) && column.isCastInnerColumn() && !(innerColumn = (TblColRef)column.getOperands().get(0)).isInnerColumn() && innerColumn.getType().isIntegerFamily()) {
            colRowType.getAllColumns().set(index, innerColumn);
            column = colRowType.getColumnByIndex(index);
        }
        return column;
    }

    public boolean needRewrite() {
        return this.context.getRealization() != null && !this.afterAggregate;
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        if (this.context == null) {
            QueryContext.current().getQueryTagInfo().setHasRuntimeAgg(true);
        } else if (this.needRewrite()) {
            this.translateAggregation();
            this.buildRewriteFieldsAndMetricsColumns();
        }
        rewriteImpl.visitChild(this, this.getInput());
        if (this.context == null) {
            return;
        }
        if (this.needRewrite()) {
            this.rewriteAggCalls = new ArrayList<AggregateCall>(this.aggregateCalls.size());
            for (int i = 0; i < this.aggregateCalls.size(); ++i) {
                AggregateCall aggCall = this.aggregateCalls.get(i);
                if (SqlStdOperatorTable.GROUPING == aggCall.getAggregation() || this.aggregations.get(i).isAggregateOnConstant()) {
                    this.rewriteAggCalls.add(aggCall);
                    continue;
                }
                aggCall = this.rewriteAggCall(aggCall, this.aggregations.get(i));
                this.rewriteAggCalls.add(aggCall);
            }
            this.getContext().setExactlyAggregate(this.isExactlyMatched());
            if (this.getContext().isExactlyAggregate()) {
                boolean fastBitmapEnabled = this.getContext().getStorageContext().getBatchCandidate().getLayoutEntity().getIndex().getIndexPlan().isFastBitmapEnabled();
                this.getContext().setExactlyFastBitmap(fastBitmapEnabled && this.getContext().isHasBitmapMeasure());
            }
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    private Boolean isExactlyMatched() {
        if (!KapConfig.getInstanceFromEnv().needReplaceAggWhenExactlyMatched()) {
            return false;
        }
        if (this.getSubContexts().size() > 1) {
            return false;
        }
        NLayoutCandidate candidate = this.getContext().getStorageContext().getBatchCandidate();
        if (candidate.isEmpty()) {
            return false;
        }
        NDataModel model = candidate.getLayoutEntity().getModel();
        if (model.getStorageType().isInvalidStorage()) {
            return false;
        }
        if (model.getModelType() != NDataModel.ModelType.BATCH) {
            return false;
        }
        if (!this.checkAggCall()) {
            return false;
        }
        HashSet<String> cuboidDimSet = new HashSet();
        if (this.getContext() != null && this.getContext().getStorageContext().getBatchCandidate() != null) {
            cuboidDimSet = this.getContext().getStorageContext().getBatchCandidate().getLayoutEntity().getOrderedDimensions().values().stream().map(TblColRef::getIdentity).collect(Collectors.toSet());
        }
        Set<String> groupByCols = this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet());
        OlapRel.logger.info("group by cols:{}", groupByCols);
        OlapRel.logger.info("cuboid dimensions: {}", cuboidDimSet);
        boolean isDimensionMatch = this.isDimExactlyMatch(groupByCols, cuboidDimSet);
        if (KylinConfig.getInstanceFromEnv().isRouteToMetadataEnabled()) {
            boolean bl = isDimensionMatch = isDimensionMatch && !groupByCols.isEmpty();
        }
        if (!isDimensionMatch) {
            return false;
        }
        NDataflow dataflow = (NDataflow)this.getContext().getRealization();
        PartitionDesc partitionDesc = dataflow.getModel().getPartitionDesc();
        MultiPartitionDesc multiPartitionDesc = dataflow.getModel().getMultiPartitionDesc();
        if (this.groupbyContainMultiPartitions(multiPartitionDesc) && this.groupbyContainSegmentPartition(partitionDesc)) {
            OlapRel.logger.info("Find partition column. skip agg");
            return true;
        }
        return dataflow.getQueryableSegments().size() == 1 && ((NDataSegment)dataflow.getQueryableSegments().get(0)).getMultiPartitions().size() <= 1;
    }

    private boolean checkAggCall() {
        for (AggregateCall call : this.getRewriteAggCalls()) {
            String aggFuncName = OlapAggregateRel.getAggrFuncName(call);
            if (!SUPPORTED_FUNCTIONS.contains(aggFuncName)) {
                return false;
            }
            if (aggFuncName.equals("BITMAP_UUID") || aggFuncName.equals("BITMAP_BUILD")) continue;
            if (call instanceof KylinAggregateCall) {
                FunctionDesc func = ((KylinAggregateCall)call).getFunc();
                boolean hasBitmap = func.getReturnDataType() != null && func.getReturnDataType().getName().equals("bitmap");
                if (!hasBitmap) continue;
                this.getContext().setHasBitmapMeasure(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private boolean groupbyContainSegmentPartition(PartitionDesc partitionDesc) {
        return partitionDesc != null && partitionDesc.getPartitionDateColumnRef() != null && this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()).contains(partitionDesc.getPartitionDateColumnRef().getIdentity());
    }

    private boolean groupbyContainMultiPartitions(MultiPartitionDesc multiPartitionDesc) {
        if (multiPartitionDesc == null || CollectionUtils.isEmpty((Collection)multiPartitionDesc.getPartitions())) {
            return true;
        }
        return this.getGroups().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()).containsAll(multiPartitionDesc.getColumnRefs().stream().map(TblColRef::getIdentity).collect(Collectors.toSet()));
    }

    private boolean isDimExactlyMatch(Set<String> groupByCols, Set<String> cuboidDimSet) {
        return groupByCols.equals(cuboidDimSet) && this.isSimpleGroupType() && (this.context.getInnerGroupByColumns().isEmpty() || !this.context.getGroupCCColRewriteMapping().isEmpty());
    }

    private AggregateCall rewriteAggCall(AggregateCall aggCall, FunctionDesc cubeFunc) {
        if (!this.noPrecaculatedFieldsAvailable() || !cubeFunc.needRewriteField()) {
            if (cubeFunc.needRewrite()) {
                aggCall = this.rewriteAggregateCall(aggCall, cubeFunc);
            }
            if (cubeFunc.getMeasureType() != null && cubeFunc.getMeasureType().needRewriteField()) {
                aggCall = new KylinAggregateCall(aggCall, cubeFunc);
            }
        } else {
            logger.info("{} skip rewriteAggregateCall because no pre-aggregated field available", (Object)aggCall);
        }
        return aggCall;
    }

    private void translateAggregation() {
        if (this.noPrecaculatedFieldsAvailable()) {
            return;
        }
        List measures = this.context.getRealization().getMeasures();
        ArrayList newAggrs = Lists.newArrayList();
        for (FunctionDesc aggFunc : this.aggregations) {
            if (aggFunc.isDimensionAsMetric()) {
                newAggrs.add(aggFunc);
                continue;
            }
            FunctionDesc newAgg = this.findInMeasures(aggFunc, measures);
            if (newAgg == null && aggFunc.isCountOnColumn() && this.context.getRealization().getConfig().isReplaceColCountWithCountStar()) {
                newAgg = FunctionDesc.newCountOne();
            }
            if (newAgg == null) {
                newAgg = aggFunc;
            }
            newAggrs.add(newAgg);
        }
        this.aggregations.clear();
        this.aggregations.addAll(newAggrs);
        this.context.getAggregations().clear();
        this.aggregations.stream().filter(agg -> !agg.isAggregateOnConstant()).forEach(agg -> this.context.getAggregations().add((FunctionDesc)agg));
    }

    private FunctionDesc findInMeasures(FunctionDesc aggFunc, List<MeasureDesc> measures) {
        for (MeasureDesc m : measures) {
            if (!aggFunc.equals((Object)m.getFunction())) continue;
            return m.getFunction();
        }
        for (MeasureDesc m : measures) {
            FunctionDesc internalTopn;
            if (m.getFunction().getMeasureType() instanceof BasicMeasureType) continue;
            if (m.getFunction().getMeasureType() instanceof TopNMeasureType && aggFunc.equals((Object)(internalTopn = TopNMeasureType.getTopnInternalMeasure((FunctionDesc)m.getFunction())))) {
                return internalTopn;
            }
            if (!OlapAggregateRel.isBitmapFunction(aggFunc.getExpression()) || !m.getFunction().getReturnType().equals("bitmap") || !((ParameterDesc)aggFunc.getParameters().get(0)).equals(m.getFunction().getParameters().get(0))) continue;
            return m.getFunction();
        }
        return null;
    }

    private static boolean isBitmapFunction(String function) {
        return "INTERSECT_COUNT".equalsIgnoreCase(function) || "BITMAP_UUID".equalsIgnoreCase(function) || "BITMAP_BUILD".equalsIgnoreCase(function);
    }

    private void buildRewriteFieldsAndMetricsColumns() {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        for (int i = 0; i < this.aggregations.size(); ++i) {
            AggregateCall aggCall;
            FunctionDesc aggFunc = this.aggregations.get(i);
            if (aggFunc.isDimensionAsMetric()) continue;
            if (aggFunc.needRewriteField()) {
                String rewriteFieldName = aggFunc.getRewriteFieldName();
                RelDataType rewriteFieldType = OlapTable.createSqlType(typeFactory, aggFunc.getRewriteFieldType(), true);
                this.context.getRewriteFields().put(rewriteFieldName, rewriteFieldType);
                TblColRef column = this.buildRewriteColumn(aggFunc);
                this.context.getMetricsColumns().add(column);
            }
            if ((aggCall = this.rewriteAggCalls.get(i)).getArgList().isEmpty()) continue;
            for (Integer index : aggCall.getArgList()) {
                TblColRef column = inputColumnRowType.getColumnByIndex(index);
                if (column.isInnerColumn() || !this.context.belongToContextTables(column)) continue;
                this.context.getMetricsColumns().add(column);
            }
        }
    }

    public void optimizeContextCut() {
        if (this.context == null) {
            for (OlapContext subContext : this.subContexts) {
                if (!subContext.getAggregations().isEmpty() || !ContextUtil.qualifiedForAggInfoPushDown(this, subContext)) continue;
                subContext.setTopNode(this);
                this.pushRelInfoToContext(subContext);
            }
        }
    }

    private void addSourceColsToContext() {
        if (this.context == null) {
            return;
        }
        this.context.getGroupByColumns().stream().filter(this::isSuitableForContextColumn).forEach(colRef -> this.context.getAllColumns().add((TblColRef)colRef));
        RelNode input = this.getInput();
        if (!(input instanceof OlapProjectRel)) {
            if (!(input instanceof OlapFilterRel) && CollectionUtils.isEmpty((Collection)this.columnRowType.getAllColumns().stream().filter(this::isSuitableForContextColumn).collect(Collectors.toList()))) {
                this.context.getAllColumns().clear();
                return;
            }
            for (TblColRef colRef2 : ((OlapRel)input).getColumnRowType().getAllColumns()) {
                if (!this.isSuitableForContextColumn(colRef2)) continue;
                this.context.getAllColumns().add(colRef2);
            }
            return;
        }
        if (this.getGroupCount() == 0 && this.aggregations.size() == 1 && this.aggregations.get(0).isCountConstant()) {
            return;
        }
        for (Set<TblColRef> colRefs : ((OlapProjectRel)this.getInput()).getColumnRowType().getSourceColumns()) {
            for (TblColRef colRef3 : colRefs) {
                if (!this.isSuitableForContextColumn(colRef3)) continue;
                this.context.getAllColumns().add(colRef3);
            }
        }
    }

    private boolean isSuitableForContextColumn(TblColRef colRef) {
        return !colRef.getName().startsWith("_KY_") && this.context.belongToContextTables(colRef);
    }

    private void checkAggCallAfterAggRel() {
        for (AggregateCall aggCall : this.aggregateCalls) {
            if (!aggCall.isDistinct()) continue;
            throw new IllegalStateException("Distinct count is only allowed in innermost sub-query.");
        }
    }

    public boolean noPrecaculatedFieldsAvailable() {
        return !this.context.hasPrecalculatedFields() || !OlapRel.RewriteImpl.needRewrite(this.context);
    }

    private AggregateCall rewriteAggregateCall(AggregateCall aggCall, FunctionDesc func) {
        String callName = OlapAggregateRel.getSqlFuncName(aggCall);
        RelDataType fieldType = aggCall.getType();
        SqlAggFunction newAgg = aggCall.getAggregation();
        Map udafMap = func.getMeasureType().getRewriteCalciteAggrFunctions();
        if (func.isCount()) {
            newAgg = SqlStdOperatorTable.SUM0;
        } else if (udafMap != null && udafMap.containsKey(callName)) {
            newAgg = this.createCustomAggFunction(callName, (Class)udafMap.get(callName));
        }
        List<Object> newArgList = Lists.newArrayList((Iterable)aggCall.getArgList());
        if (udafMap != null && udafMap.containsKey(callName)) {
            newArgList = this.truncArgList((List<Integer>)newArgList, (Class)udafMap.get(callName));
        }
        if (func.needRewriteField()) {
            RelDataTypeField field = this.getInput().getRowType().getField(func.getRewriteFieldName(), true, false);
            if (newArgList.isEmpty()) {
                newArgList.add(field.getIndex());
            } else {
                newArgList.set(0, field.getIndex());
            }
        }
        return AggregateCall.create((SqlAggFunction)newAgg, (boolean)false, (boolean)false, (boolean)false, (List)newArgList, (int)-1, null, (RelCollation)RelCollations.EMPTY, (RelDataType)fieldType, (String)callName);
    }

    private List<Integer> truncArgList(List<Integer> argList, Class<?> udafClazz) {
        int argListLength = argList.size();
        for (Method method : udafClazz.getMethods()) {
            if (!method.getName().equals("add")) continue;
            argListLength = Math.min(method.getParameterTypes().length - 1, argListLength);
        }
        return argList.subList(0, argListLength);
    }

    private SqlAggFunction createCustomAggFunction(String funcName, Class<?> customAggFuncClz) {
        SqlIdentifier sqlIdentifier = new SqlIdentifier(funcName, new SqlParserPos(1, 1));
        AggregateFunctionImpl aggFunction = AggregateFunctionImpl.create(customAggFuncClz);
        return (SqlAggFunction)OlapAggregateRel.toOp(sqlIdentifier, (Function)aggFunction);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        try {
            return new EnumerableAggregate(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)OlapAggregateRel.sole(inputs), this.groupSet, (List)this.groupSets, this.rewriteAggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create EnumerableAggregate!", e);
        }
    }

    @Override
    public boolean hasSubQuery() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        pw.input("input", this.getInput());
        pw.item("group-set", this.rewriteGroupKeys).itemIf("group-sets", this.rewriteGroupSets, this.getGroupType() != Aggregate.Group.SIMPLE).item("groups", this.groups).itemIf("aggs", this.rewriteAggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip(this.rewriteAggCalls)) {
                pw.item((String)Util.first((Object)((AggregateCall)ord.e).name, (Object)("agg#" + ord.i)), ord.e);
            }
        }
        pw.item("ctx", (Object)this.displayCtxId(this.context));
        return pw;
    }

    public boolean isSimpleGroupType() {
        return this.getGroupType() == Aggregate.Group.SIMPLE;
    }

    public boolean isContainCountDistinct() {
        return this.aggregateCalls.stream().anyMatch(agg -> agg.getAggregation().getKind() == SqlKind.COUNT && agg.isDistinct());
    }

    private static SqlOperator toOp(SqlIdentifier name, Function function) {
        java.util.function.Function<RelDataTypeFactory, List> argTypesFactory = typeFactory -> (ImmutableList)function.getParameters().stream().map(o -> o.getType(typeFactory)).collect(Util.toImmutableList());
        java.util.function.Function<RelDataTypeFactory, List> typeFamiliesFactory = typeFactory -> (ImmutableList)((List)argTypesFactory.apply((RelDataTypeFactory)typeFactory)).stream().map(type -> (SqlTypeFamily)Util.first((Object)type.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY)).collect(Util.toImmutableList());
        java.util.function.Function<RelDataTypeFactory, List> paramTypesFactory = typeFactory -> (ImmutableList)((List)argTypesFactory.apply((RelDataTypeFactory)typeFactory)).stream().map(type -> OlapAggregateRel.toSql(typeFactory, type)).collect(Util.toImmutableList());
        JavaTypeFactoryImpl dummyTypeFactory = new JavaTypeFactoryImpl();
        List argTypes = argTypesFactory.apply((RelDataTypeFactory)dummyTypeFactory);
        List typeFamilies = typeFamiliesFactory.apply((RelDataTypeFactory)dummyTypeFactory);
        SqlOperandTypeInference operandTypeInference = InferTypes.explicit((List)argTypes);
        SqlOperandMetadata operandMetadata = OperandTypes.operandMetadata((List)typeFamilies, paramTypesFactory, i -> ((FunctionParameter)function.getParameters().get(i)).getName(), i -> ((FunctionParameter)function.getParameters().get((int)i)).isOptional());
        SqlKind kind = OlapAggregateRel.kind(function);
        if (function instanceof ScalarFunction) {
            SqlReturnTypeInference returnTypeInference = OlapAggregateRel.infer((ScalarFunction)function);
            return new SqlUserDefinedFunction(name, kind, returnTypeInference, operandTypeInference, operandMetadata, function);
        }
        if (function instanceof AggregateFunction) {
            SqlReturnTypeInference returnTypeInference = OlapAggregateRel.infer((AggregateFunction)function);
            return new SqlUserDefinedAggFunction(name, kind, returnTypeInference, operandTypeInference, operandMetadata, (AggregateFunction)function, false, false, Optionality.FORBIDDEN);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, kind, ReturnTypes.CURSOR, operandTypeInference, operandMetadata, (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, kind, ReturnTypes.CURSOR, operandTypeInference, operandMetadata, (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private static SqlKind kind(Function function) {
        Hints hints;
        if (function instanceof ScalarFunctionImpl && (hints = ((ScalarFunctionImpl)function).method.getAnnotation(Hints.class)) != null) {
            for (String hint : hints.value()) {
                if (!hint.startsWith("SqlKind:")) continue;
                return SqlKind.valueOf((String)hint.substring("SqlKind:".length()));
            }
        }
        return SqlKind.OTHER_FUNCTION;
    }

    private static SqlReturnTypeInference infer(ScalarFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function instanceof ScalarFunctionImpl ? ((ScalarFunctionImpl)function).getReturnType(typeFactory, opBinding) : function.getReturnType(typeFactory);
            return OlapAggregateRel.toSql(typeFactory, type);
        };
    }

    private static SqlReturnTypeInference infer(AggregateFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function.getReturnType(typeFactory);
            return OlapAggregateRel.toSql(typeFactory, type);
        };
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql((RelDataTypeFactory)typeFactory, (RelDataType)type);
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    public List<TblColRef> getGroups() {
        return this.groups;
    }

    @Generated
    public ImmutableList<Integer> getRewriteGroupKeys() {
        return this.rewriteGroupKeys;
    }

    @Generated
    public List<ImmutableBitSet> getRewriteGroupSets() {
        return this.rewriteGroupSets;
    }

    @Generated
    public List<AggregateCall> getAggregateCalls() {
        return this.aggregateCalls;
    }

    @Generated
    public List<AggregateCall> getRewriteAggCalls() {
        return this.rewriteAggCalls;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }

    @Generated
    public void setGroups(List<TblColRef> groups) {
        this.groups = groups;
    }

    @Generated
    private Set<TblColRef> getGroupByInnerColumns() {
        return this.groupByInnerColumns;
    }

    @Generated
    private List<FunctionDesc> getAggregations() {
        return this.aggregations;
    }

    @Generated
    private boolean isAfterAggregate() {
        return this.afterAggregate;
    }

    static {
        AGGR_FUNC_MAP.put("SUM", "SUM");
        AGGR_FUNC_MAP.put("$SUM0", "SUM");
        AGGR_FUNC_MAP.put("COUNT", "COUNT");
        AGGR_FUNC_MAP.put("COUNT_DISTINCT", "COUNT_DISTINCT");
        AGGR_FUNC_MAP.put("MAX", "MAX");
        AGGR_FUNC_MAP.put("MIN", "MIN");
        AGGR_FUNC_MAP.put("GROUPING", "GROUPING");
        Map udafFactories = MeasureTypeFactory.getUDAFFactories();
        for (Map.Entry entry : udafFactories.entrySet()) {
            AGGR_FUNC_MAP.put((String)entry.getKey(), ((MeasureTypeFactory)entry.getValue()).getAggrFunctionName());
        }
        AGGR_FUNC_MAP.put("BITMAP_UUID", "BITMAP_UUID");
        AGGR_FUNC_MAP.put("BITMAP_BUILD", "BITMAP_BUILD");
        AGGR_FUNC_MAP.put("INTERSECT_BITMAP_UUID_DISTINCT", "INTERSECT_BITMAP_UUID_DISTINCT");
        AGGR_FUNC_MAP.put("INTERSECT_BITMAP_UUID_COUNT", "INTERSECT_BITMAP_UUID_COUNT");
        AGGR_FUNC_MAP.put("INTERSECT_BITMAP_UUID_VALUE", "INTERSECT_BITMAP_UUID_VALUE");
        AGGR_FUNC_MAP.put("INTERSECT_BITMAP_UUID_VALUE_ALL", "INTERSECT_BITMAP_UUID_VALUE_ALL");
        AGGR_FUNC_MAP.put("UNION_BITMAP_UUID_DISTINCT", "UNION_BITMAP_UUID_DISTINCT");
        AGGR_FUNC_MAP.put("UNION_BITMAP_UUID_COUNT", "UNION_BITMAP_UUID_COUNT");
        AGGR_FUNC_MAP.put("UNION_BITMAP_UUID_VALUE", "UNION_BITMAP_UUID_VALUE");
        AGGR_FUNC_MAP.put("UNION_BITMAP_UUID_VALUE_ALL", "UNION_BITMAP_UUID_VALUE_ALL");
    }
}

