/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.kylin.metadata.query.StructField;

public class RelColumnMetaDataExtractor {
    private RelColumnMetaDataExtractor() {
    }

    public static List<StructField> getColumnMetadata(RelDataType rowType) {
        return rowType.getFieldList().stream().map(type -> RelColumnMetaDataExtractor.relDataTypeToStructField((String)type.getKey(), (RelDataType)type.getValue())).collect(Collectors.toList());
    }

    public static List<StructField> getColumnMetadata(RelNode rel) {
        return RelColumnMetaDataExtractor.getColumnMetadata(rel.getRowType());
    }

    private static StructField relDataTypeToStructField(String fieldName, RelDataType relDataType) {
        return new StructField(fieldName, relDataType.getSqlTypeName().getJdbcOrdinal(), relDataType.getSqlTypeName().getName(), RelColumnMetaDataExtractor.getPrecision(relDataType), RelColumnMetaDataExtractor.getScale(relDataType), relDataType.isNullable());
    }

    private static int getScale(RelDataType type) {
        return type.getScale() == Integer.MIN_VALUE ? 0 : type.getScale();
    }

    private static int getPrecision(RelDataType type) {
        return type.getPrecision() == -1 ? 0 : type.getPrecision();
    }
}

