/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.shaded.parquet.org.apache.thrift.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedelta.shaded.parquet.org.apache.thrift.transport.TTransport;
import shadedelta.shaded.parquet.org.apache.thrift.transport.TTransportException;

public class TIOStreamTransport
extends TTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TIOStreamTransport.class.getName());
    protected InputStream inputStream_ = null;
    protected OutputStream outputStream_ = null;

    protected TIOStreamTransport() {
    }

    public TIOStreamTransport(InputStream is) {
        this.inputStream_ = is;
    }

    public TIOStreamTransport(OutputStream os) {
        this.outputStream_ = os;
    }

    public TIOStreamTransport(InputStream is, OutputStream os) {
        this.inputStream_ = is;
        this.outputStream_ = os;
    }

    @Override
    public boolean isOpen() {
        return this.inputStream_ != null && this.outputStream_ != null;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public void close() {
        if (this.inputStream_ != null) {
            try {
                this.inputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Error closing input stream.", (Throwable)iox);
            }
            this.inputStream_ = null;
        }
        if (this.outputStream_ != null) {
            try {
                this.outputStream_.close();
            }
            catch (IOException iox) {
                LOGGER.warn("Error closing output stream.", (Throwable)iox);
            }
            this.outputStream_ = null;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        int bytesRead;
        if (this.inputStream_ == null) {
            throw new TTransportException(1, "Cannot read from null inputStream");
        }
        try {
            bytesRead = this.inputStream_.read(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
        if (bytesRead < 0) {
            throw new TTransportException(4, "Socket is closed by peer.");
        }
        return bytesRead;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot write to null outputStream");
        }
        try {
            this.outputStream_.write(buf, off, len);
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }

    @Override
    public void flush() throws TTransportException {
        if (this.outputStream_ == null) {
            throw new TTransportException(1, "Cannot flush null outputStream");
        }
        try {
            this.outputStream_.flush();
        }
        catch (IOException iox) {
            throw new TTransportException(0, (Throwable)iox);
        }
    }
}

