/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class DocumentationContextBuilder {
    private final List<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
    private final Set<Class> ignorableParameterTypes = new HashSet<Class>();
    private final Map<RequestMethod, List<ResponseMessage>> responseMessageOverrides = new TreeMap<RequestMethod, List<ResponseMessage>>();
    private final Map<HttpMethod, List<Response>> responseOverrides = new TreeMap<HttpMethod, List<Response>>();
    private final List<Parameter> globalOperationParameters = new ArrayList<Parameter>();
    private final List<AlternateTypeRule> rules = new ArrayList<AlternateTypeRule>();
    private final Map<RequestMethod, List<ResponseMessage>> defaultResponseMessages = new HashMap<RequestMethod, List<ResponseMessage>>();
    private final Map<HttpMethod, List<Response>> defaultResponses = new HashMap<HttpMethod, List<Response>>();
    private final Set<String> protocols = new HashSet<String>();
    private final Set<String> produces = new LinkedHashSet<String>();
    private final Set<String> consumes = new LinkedHashSet<String>();
    private final Set<ResolvedType> additionalModels = new HashSet<ResolvedType>();
    private final Set<Tag> tags = new TreeSet<Tag>(Tags.tagComparator());
    private final List<SecurityScheme> securitySchemes = new ArrayList<SecurityScheme>();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private TypeResolver typeResolver;
    private List<RequestHandler> handlerMappings;
    private ApiInfo apiInfo;
    private String groupName;
    private PathProvider pathProvider;
    private Comparator<ApiListingReference> listingReferenceOrdering;
    private Comparator<ApiDescription> apiDescriptionOrdering;
    private DocumentationType documentationType;
    private Comparator<Operation> operationOrdering;
    private boolean applyDefaultResponseMessages;
    private ApiSelector apiSelector = ApiSelector.DEFAULT;
    private String host;
    private GenericTypeNamingStrategy genericsNamingStrategy;
    private Optional<String> pathMapping;
    private boolean isUrlTemplatesEnabled;
    private final List<RequestParameter> globalRequestParameters = new ArrayList<RequestParameter>();
    private final List<Server> servers = new ArrayList<Server>();

    public DocumentationContextBuilder(DocumentationType documentationType) {
        this.documentationType = documentationType;
    }

    public DocumentationContextBuilder requestHandlers(List<RequestHandler> handlerMappings) {
        this.handlerMappings = handlerMappings;
        return this;
    }

    public DocumentationContextBuilder apiInfo(ApiInfo apiInfo) {
        this.apiInfo = (ApiInfo)BuilderDefaults.defaultIfAbsent((Object)apiInfo, (Object)this.apiInfo);
        return this;
    }

    public DocumentationContextBuilder groupName(String groupName) {
        this.groupName = (String)BuilderDefaults.defaultIfAbsent((Object)groupName, (Object)this.groupName);
        return this;
    }

    public DocumentationContextBuilder additionalIgnorableTypes(Set<Class> ignorableParameterTypes) {
        this.ignorableParameterTypes.addAll(ignorableParameterTypes);
        return this;
    }

    public DocumentationContextBuilder additionalResponseMessages(Map<RequestMethod, List<ResponseMessage>> additionalResponseMessages) {
        this.responseMessageOverrides.putAll(additionalResponseMessages);
        return this;
    }

    public DocumentationContextBuilder additionalResponses(Map<HttpMethod, List<Response>> additionalResponses) {
        this.responseOverrides.putAll(additionalResponses);
        return this;
    }

    public DocumentationContextBuilder additionalOperationParameters(List<Parameter> globalRequestParameters) {
        this.globalOperationParameters.addAll(BuilderDefaults.nullToEmptyList(globalRequestParameters));
        return this;
    }

    public DocumentationContextBuilder pathProvider(PathProvider pathProvider) {
        this.pathProvider = (PathProvider)BuilderDefaults.defaultIfAbsent((Object)pathProvider, (Object)this.pathProvider);
        return this;
    }

    public DocumentationContextBuilder securityContexts(List<SecurityContext> securityContext) {
        this.securityContexts.addAll(BuilderDefaults.nullToEmptyList(securityContext));
        return this;
    }

    public DocumentationContextBuilder securitySchemes(List<SecurityScheme> securitySchemes) {
        this.securitySchemes.addAll(BuilderDefaults.nullToEmptyList(securitySchemes));
        return this;
    }

    public DocumentationContextBuilder apiListingReferenceOrdering(Comparator<ApiListingReference> listingReferenceOrdering) {
        this.listingReferenceOrdering = (Comparator)BuilderDefaults.defaultIfAbsent(listingReferenceOrdering, this.listingReferenceOrdering);
        return this;
    }

    public DocumentationContextBuilder apiDescriptionOrdering(Comparator<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = (Comparator)BuilderDefaults.defaultIfAbsent(apiDescriptionOrdering, this.apiDescriptionOrdering);
        return this;
    }

    private Map<RequestMethod, List<ResponseMessage>> aggregateResponseMessages() {
        HashMap<RequestMethod, List<ResponseMessage>> responseMessages = new HashMap<RequestMethod, List<ResponseMessage>>();
        if (this.applyDefaultResponseMessages) {
            responseMessages.putAll(this.defaultResponseMessages);
        }
        responseMessages.putAll(this.responseMessageOverrides);
        return responseMessages;
    }

    private Map<HttpMethod, List<Response>> aggregateResponses() {
        HashMap<HttpMethod, List<Response>> responseMessages = new HashMap<HttpMethod, List<Response>>();
        if (this.applyDefaultResponseMessages) {
            responseMessages.putAll(BuilderDefaults.nullToEmptyMap(this.defaultResponses));
        }
        responseMessages.putAll(this.responseOverrides);
        return responseMessages;
    }

    public DocumentationContextBuilder applyDefaultResponseMessages(boolean applyDefaultResponseMessages) {
        this.applyDefaultResponseMessages = applyDefaultResponseMessages;
        return this;
    }

    public DocumentationContextBuilder ruleBuilders(List<Function<TypeResolver, AlternateTypeRule>> ruleBuilders) {
        this.rules.addAll(ruleBuilders.stream().map(this.evaluator(this.typeResolver)).collect(Collectors.toList()));
        return this;
    }

    public DocumentationContextBuilder typeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
        return this;
    }

    public DocumentationContextBuilder operationOrdering(Comparator<Operation> operationOrdering) {
        this.operationOrdering = (Comparator)BuilderDefaults.defaultIfAbsent(operationOrdering, this.operationOrdering);
        return this;
    }

    public DocumentationContextBuilder rules(List<AlternateTypeRule> rules) {
        this.rules.addAll(rules);
        return this;
    }

    @Deprecated
    public DocumentationContextBuilder defaultResponseMessages(Map<RequestMethod, List<ResponseMessage>> defaultResponseMessages) {
        this.defaultResponseMessages.putAll(defaultResponseMessages);
        return this;
    }

    public DocumentationContextBuilder defaultResponses(Map<HttpMethod, List<Response>> defaultResponses) {
        this.defaultResponses.putAll(defaultResponses);
        return this;
    }

    public DocumentationContextBuilder produces(Set<String> produces) {
        this.produces.addAll(produces);
        return this;
    }

    public DocumentationContextBuilder consumes(Set<String> consumes) {
        this.consumes.addAll(consumes);
        return this;
    }

    public DocumentationContextBuilder genericsNaming(GenericTypeNamingStrategy genericsNamingStrategy) {
        this.genericsNamingStrategy = genericsNamingStrategy;
        return this;
    }

    public DocumentationContextBuilder host(String host) {
        this.host = (String)BuilderDefaults.defaultIfAbsent((Object)host, (Object)this.host);
        return this;
    }

    public DocumentationContextBuilder protocols(Set<String> protocols) {
        this.protocols.addAll(protocols);
        return this;
    }

    public DocumentationContextBuilder selector(ApiSelector apiSelector) {
        this.apiSelector = apiSelector;
        return this;
    }

    public DocumentationContextBuilder pathMapping(Optional<String> pathMapping) {
        this.pathMapping = pathMapping;
        return this;
    }

    public DocumentationContextBuilder enableUrlTemplating(boolean isUrlTemplatesEnabled) {
        this.isUrlTemplatesEnabled = isUrlTemplatesEnabled;
        return this;
    }

    public DocumentationContextBuilder additionalModels(Set<ResolvedType> additionalModels) {
        this.additionalModels.addAll(additionalModels);
        return this;
    }

    public DocumentationContextBuilder tags(Set<Tag> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public DocumentationContextBuilder vendorExtentions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public DocumentationContextBuilder additionalRequestParameters(List<RequestParameter> globalRequestParameters) {
        this.globalRequestParameters.addAll(globalRequestParameters);
        return this;
    }

    public DocumentationContext build() {
        Map<RequestMethod, List<ResponseMessage>> responseMessages = this.aggregateResponseMessages();
        Map<HttpMethod, List<Response>> responses = this.aggregateResponses();
        OrderComparator.sort(this.rules);
        return new DocumentationContext(this.documentationType, this.handlerMappings, this.apiInfo, this.groupName, this.apiSelector, this.ignorableParameterTypes, responseMessages, this.globalOperationParameters, this.globalRequestParameters, responses, this.pathProvider, this.securityContexts, this.securitySchemes, this.rules, this.listingReferenceOrdering, this.apiDescriptionOrdering, this.operationOrdering, this.produces, this.consumes, this.host, this.protocols, this.genericsNamingStrategy, this.pathMapping, this.isUrlTemplatesEnabled, this.additionalModels, this.tags, this.vendorExtensions, this.servers);
    }

    private Function<Function<TypeResolver, AlternateTypeRule>, AlternateTypeRule> evaluator(TypeResolver typeResolver) {
        return input -> (AlternateTypeRule)input.apply(typeResolver);
    }

    public DocumentationContextBuilder servers(List<Server> servers) {
        this.servers.addAll(BuilderDefaults.nullToEmptyList(servers));
        return this;
    }
}

