/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.rest.response.IndexResponse;

public class IndexStatResponse {
    @JsonProperty(value="max_data_size")
    private long maxDataSize;
    @JsonProperty(value="max_usage")
    private long maxUsage;
    @JsonProperty(value="need_create_base_table_index")
    private boolean needCreateBaseTableIndex;
    @JsonProperty(value="need_create_base_agg_index")
    private boolean needCreateBaseAggIndex;

    public static IndexStatResponse from(List<IndexResponse> results) {
        IndexStatResponse response = new IndexStatResponse();
        long maxUsage = 0L;
        long maxDataSize = 0L;
        for (IndexResponse index : results) {
            maxDataSize = Math.max(maxDataSize, index.getDataSize());
            maxUsage = Math.max(maxUsage, index.getUsage());
        }
        response.setMaxDataSize(maxDataSize);
        response.setMaxUsage(maxUsage);
        return response;
    }

    @Generated
    public IndexStatResponse() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexStatResponse)) {
            return false;
        }
        IndexStatResponse other = (IndexStatResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxDataSize() != other.getMaxDataSize()) {
            return false;
        }
        if (this.getMaxUsage() != other.getMaxUsage()) {
            return false;
        }
        if (this.isNeedCreateBaseTableIndex() != other.isNeedCreateBaseTableIndex()) {
            return false;
        }
        return this.isNeedCreateBaseAggIndex() == other.isNeedCreateBaseAggIndex();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexStatResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxDataSize = this.getMaxDataSize();
        result = result * 59 + (int)($maxDataSize >>> 32 ^ $maxDataSize);
        long $maxUsage = this.getMaxUsage();
        result = result * 59 + (int)($maxUsage >>> 32 ^ $maxUsage);
        result = result * 59 + (this.isNeedCreateBaseTableIndex() ? 79 : 97);
        result = result * 59 + (this.isNeedCreateBaseAggIndex() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "IndexStatResponse(maxDataSize=" + this.getMaxDataSize() + ", maxUsage=" + this.getMaxUsage() + ", needCreateBaseTableIndex=" + this.isNeedCreateBaseTableIndex() + ", needCreateBaseAggIndex=" + this.isNeedCreateBaseAggIndex() + ")";
    }

    @Generated
    public void setMaxDataSize(long maxDataSize) {
        this.maxDataSize = maxDataSize;
    }

    @Generated
    public void setMaxUsage(long maxUsage) {
        this.maxUsage = maxUsage;
    }

    @Generated
    public void setNeedCreateBaseTableIndex(boolean needCreateBaseTableIndex) {
        this.needCreateBaseTableIndex = needCreateBaseTableIndex;
    }

    @Generated
    public void setNeedCreateBaseAggIndex(boolean needCreateBaseAggIndex) {
        this.needCreateBaseAggIndex = needCreateBaseAggIndex;
    }

    @Generated
    public long getMaxDataSize() {
        return this.maxDataSize;
    }

    @Generated
    public long getMaxUsage() {
        return this.maxUsage;
    }

    @Generated
    public boolean isNeedCreateBaseTableIndex() {
        return this.needCreateBaseTableIndex;
    }

    @Generated
    public boolean isNeedCreateBaseAggIndex() {
        return this.needCreateBaseAggIndex;
    }
}

