/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.domain;

import java.io.Serializable;
import org.springframework.cache.Cache;
import org.springframework.security.acls.domain.AclAuthorizationStrategy;
import org.springframework.security.acls.domain.AclImpl;
import org.springframework.security.acls.model.AclCache;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.util.FieldUtils;
import org.springframework.util.Assert;

public class SpringCacheBasedAclCache
implements AclCache {
    private final Cache cache;
    private PermissionGrantingStrategy permissionGrantingStrategy;
    private AclAuthorizationStrategy aclAuthorizationStrategy;

    public SpringCacheBasedAclCache(Cache cache, PermissionGrantingStrategy permissionGrantingStrategy, AclAuthorizationStrategy aclAuthorizationStrategy) {
        Assert.notNull((Object)cache, (String)"Cache required");
        Assert.notNull((Object)permissionGrantingStrategy, (String)"PermissionGrantingStrategy required");
        Assert.notNull((Object)aclAuthorizationStrategy, (String)"AclAuthorizationStrategy required");
        this.cache = cache;
        this.permissionGrantingStrategy = permissionGrantingStrategy;
        this.aclAuthorizationStrategy = aclAuthorizationStrategy;
    }

    @Override
    public void evictFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        MutableAcl acl = this.getFromCache(pk);
        if (acl != null) {
            this.cache.evict((Object)acl.getId());
            this.cache.evict((Object)acl.getObjectIdentity());
        }
    }

    @Override
    public void evictFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        MutableAcl acl = this.getFromCache(objectIdentity);
        if (acl != null) {
            this.cache.evict((Object)acl.getId());
            this.cache.evict((Object)acl.getObjectIdentity());
        }
    }

    @Override
    public MutableAcl getFromCache(ObjectIdentity objectIdentity) {
        Assert.notNull((Object)objectIdentity, (String)"ObjectIdentity required");
        return this.getFromCache((Object)objectIdentity);
    }

    @Override
    public MutableAcl getFromCache(Serializable pk) {
        Assert.notNull((Object)pk, (String)"Primary key (identifier) required");
        return this.getFromCache((Object)pk);
    }

    @Override
    public void putInCache(MutableAcl acl) {
        Assert.notNull((Object)acl, (String)"Acl required");
        Assert.notNull((Object)acl.getObjectIdentity(), (String)"ObjectIdentity required");
        Assert.notNull((Object)acl.getId(), (String)"ID required");
        if (acl.getParentAcl() != null && acl.getParentAcl() instanceof MutableAcl) {
            this.putInCache((MutableAcl)acl.getParentAcl());
        }
        this.cache.put((Object)acl.getObjectIdentity(), (Object)acl);
        this.cache.put((Object)acl.getId(), (Object)acl);
    }

    private MutableAcl getFromCache(Object key) {
        Cache.ValueWrapper element = this.cache.get(key);
        if (element == null) {
            return null;
        }
        return this.initializeTransientFields((MutableAcl)element.get());
    }

    private MutableAcl initializeTransientFields(MutableAcl value) {
        if (value instanceof AclImpl) {
            FieldUtils.setProtectedFieldValue((String)"aclAuthorizationStrategy", (Object)value, (Object)this.aclAuthorizationStrategy);
            FieldUtils.setProtectedFieldValue((String)"permissionGrantingStrategy", (Object)value, (Object)this.permissionGrantingStrategy);
        }
        if (value.getParentAcl() != null) {
            this.initializeTransientFields((MutableAcl)value.getParentAcl());
        }
        return value;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

