/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.VendorExtension;

public abstract class SecurityScheme {
    private final String name;
    private final String type;
    private final String description;
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    protected SecurityScheme(String name, String type) {
        this(name, type, "", new ArrayList<VendorExtension>());
    }

    public SecurityScheme(String name, String type, String description, List<VendorExtension> extensions) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.extensions.addAll(extensions);
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<VendorExtension> getVendorExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    protected void addValidVendorExtensions(List<VendorExtension> vendorExtensions) {
        this.extensions.addAll(BuilderDefaults.nullToEmptyList(vendorExtensions).stream().filter(input -> input.getName().toLowerCase().startsWith("x-")).collect(Collectors.toList()));
    }
}

