/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.common;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class Either<L, R> {
    private final L left;
    private final R right;

    public Either(L left) {
        this(left, null);
    }

    public Either(L left, R right) {
        this.ensureOnlyOneIsNonNull(left, right);
        this.left = left;
        this.right = right;
    }

    public Optional<L> getLeft() {
        return Optional.ofNullable(this.left);
    }

    public Optional<R> getRight() {
        return Optional.ofNullable(this.right);
    }

    private void ensureOnlyOneIsNonNull(Object ... specs) {
        long specCount = Arrays.stream(specs).filter(Objects::nonNull).count();
        if (specCount != 1L) {
            throw new IllegalArgumentException("Only one of the values should be non null");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Either either = (Either)o;
        return Objects.equals(this.left, either.left) && Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

