/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import springfox.documentation.builders.CollectionElementFacetBuilder;
import springfox.documentation.builders.ElementFacetBuilder;
import springfox.documentation.builders.ElementFacets;
import springfox.documentation.builders.EnumerationElementFacetBuilder;
import springfox.documentation.builders.StringElementFacetBuilder;
import springfox.documentation.common.ExternalDocumentation;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.NumericElementFacetBuilder;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.VendorExtension;

public class ModelFacetsBuilder {
    private String title;
    private String description;
    private Boolean nullable;
    private Boolean deprecated;
    private ExternalDocumentation externalDocumentation;
    private final List<Example> examples = new ArrayList<Example>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();
    private final Map<Class<?>, ElementFacetBuilder> facetBuilders = new HashMap();
    private Xml xml;

    public ModelFacetsBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ModelFacetsBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ModelFacetsBuilder nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public ModelFacetsBuilder deprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public ModelFacetsBuilder externalDocumentation(ExternalDocumentation externalDocumentation) {
        this.externalDocumentation = externalDocumentation;
        return this;
    }

    public ModelFacetsBuilder examples(List<Example> examples) {
        this.examples.addAll(examples);
        return this;
    }

    public ModelFacetsBuilder extensions(List<VendorExtension> extensions) {
        this.extensions.addAll(extensions);
        return this;
    }

    private <T extends ElementFacetBuilder> T facetBuilder(Class<T> clazz) {
        this.facetBuilders.computeIfAbsent(clazz, ElementFacets.builderFactory(clazz));
        return (T)this.facetBuilders.get(clazz);
    }

    public ModelFacetsBuilder collectionFacet(@NonNull Consumer<CollectionElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(CollectionElementFacetBuilder.class));
        return this;
    }

    public ModelFacetsBuilder stringFacet(@NonNull Consumer<StringElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(StringElementFacetBuilder.class));
        return this;
    }

    public ModelFacetsBuilder numericFacet(@NonNull Consumer<NumericElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(NumericElementFacetBuilder.class));
        return this;
    }

    public ModelFacetsBuilder enumerationFacet(@NonNull Consumer<EnumerationElementFacetBuilder> facet) {
        facet.accept(this.facetBuilder(EnumerationElementFacetBuilder.class));
        return this;
    }

    public ModelFacetsBuilder xml(Xml xml) {
        this.xml = xml;
        return this;
    }

    public ModelFacets build() {
        List<ElementFacet> facets = this.facetBuilders.values().stream().filter(Objects::nonNull).map(ElementFacetBuilder::build).filter(Objects::nonNull).collect(Collectors.toList());
        if (this.isBuilderUntouched(facets)) {
            return null;
        }
        return new ModelFacets(this.title, this.description, this.nullable, this.deprecated, facets, this.xml, this.externalDocumentation, this.examples, this.extensions);
    }

    private boolean isBuilderUntouched(List<ElementFacet> facets) {
        return this.title == null && facets.isEmpty() && this.nullable == null && this.description == null && this.deprecated == null && this.xml == null && this.externalDocumentation == null && this.extensions.isEmpty() && this.examples.isEmpty();
    }

    public ModelFacetsBuilder copyOf(ModelFacets other) {
        if (other == null) {
            return this;
        }
        for (ElementFacet each : other.getFacets()) {
            this.facetBuilder(each.facetBuilder()).copyOf(each);
        }
        return this.title(other.getTitle()).description(other.getDescription()).nullable(other.getNullable()).deprecated(other.getDeprecated()).extensions(other.getExtensions()).externalDocumentation(other.getExternalDocumentation()).examples(other.getExamples()).xml(other.getXml());
    }
}

