/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.Encoding;
import springfox.documentation.service.Header;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.VendorExtension;

public class EncodingBuilder {
    private String propertyRef;
    private String contentType;
    private ParameterStyle style;
    private Boolean explode;
    private Boolean allowReserved;
    private final Set<Header> headers = new HashSet<Header>();
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    EncodingBuilder propertyRef(String propertyRef) {
        this.propertyRef = propertyRef;
        return this;
    }

    public EncodingBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public EncodingBuilder style(ParameterStyle style) {
        this.style = style;
        return this;
    }

    public EncodingBuilder explode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public EncodingBuilder allowReserved(Boolean allowReserved) {
        this.allowReserved = allowReserved;
        return this;
    }

    public EncodingBuilder headers(Collection<Header> headers) {
        this.headers.addAll(BuilderDefaults.nullToEmptyList(headers));
        return this;
    }

    public EncodingBuilder vendorExtensions(Collection<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public Encoding build() {
        if (this.hasOnlyPropertyRef()) {
            return null;
        }
        return new Encoding(this.propertyRef, this.contentType, this.style, this.explode, this.allowReserved, this.headers, this.vendorExtensions);
    }

    private boolean hasOnlyPropertyRef() {
        return this.contentType == null && this.style == null && this.explode == null && this.allowReserved == null && this.headers.isEmpty() && this.vendorExtensions.isEmpty();
    }

    public EncodingBuilder copyOf(Encoding other) {
        if (other != null) {
            this.propertyRef(other.getPropertyRef()).contentType(other.getContentType()).allowReserved(other.getAllowReserved()).explode(other.getExplode()).headers(other.getHeaders()).style(other.getStyle()).vendorExtensions(other.getExtensions());
        }
        return this;
    }
}

