/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class CancelFlag {
    public final AtomicBoolean atomicBoolean;
    private static final ThreadLocal<CancelFlag> CONTEXT_CANCEL_FLAG = ThreadLocal.withInitial(new Supplier<CancelFlag>(){

        @Override
        public CancelFlag get() {
            return new CancelFlag(new AtomicBoolean(false));
        }
    });

    public CancelFlag(AtomicBoolean atomicBoolean) {
        this.atomicBoolean = Objects.requireNonNull(atomicBoolean, "atomicBoolean");
    }

    public static CancelFlag getContextCancelFlag() {
        return CONTEXT_CANCEL_FLAG.get();
    }

    public boolean isCancelRequested() {
        return this.atomicBoolean.get();
    }

    public void requestCancel() {
        this.atomicBoolean.compareAndSet(false, true);
    }

    public void clearCancel() {
        this.atomicBoolean.compareAndSet(true, false);
    }
}

