/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.CharLiteralStyle;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.calcite.sql.validate.SqlConformance;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SqlParser", generator="Immutables")
final class ImmutableSqlParser {
    private ImmutableSqlParser() {
    }

    @CheckReturnValue
    @Generated(from="SqlParser.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements SqlParser.Config {
        private final int identifierMaxLength;
        private final Casing quotedCasing;
        private final Casing unquotedCasing;
        private final Quoting quoting;
        private final boolean caseSensitive;
        private final SqlConformance conformance;
        private final boolean allowBangEqual;
        private final ImmutableSet<CharLiteralStyle> charLiteralStyles;
        private final SqlParserImplFactory parserFactory;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();
        private static final Config INSTANCE = Config.validate(new Config());

        private Config() {
            this.identifierMaxLength = this.initShim.identifierMaxLength();
            this.quotedCasing = this.initShim.quotedCasing();
            this.unquotedCasing = this.initShim.unquotedCasing();
            this.quoting = this.initShim.quoting();
            this.caseSensitive = this.initShim.caseSensitive();
            this.conformance = this.initShim.conformance();
            this.allowBangEqual = this.initShim.allowBangEqual();
            this.charLiteralStyles = this.initShim.charLiteralStyles();
            this.parserFactory = this.initShim.parserFactory();
            this.initShim = null;
        }

        private Config(Builder builder) {
            if (builder.identifierMaxLengthIsSet()) {
                this.initShim.withIdentifierMaxLength(builder.identifierMaxLength);
            }
            if (builder.quotedCasing != null) {
                this.initShim.withQuotedCasing(builder.quotedCasing);
            }
            if (builder.unquotedCasing != null) {
                this.initShim.withUnquotedCasing(builder.unquotedCasing);
            }
            if (builder.quoting != null) {
                this.initShim.withQuoting(builder.quoting);
            }
            if (builder.caseSensitiveIsSet()) {
                this.initShim.withCaseSensitive(builder.caseSensitive);
            }
            if (builder.conformance != null) {
                this.initShim.withConformance(builder.conformance);
            }
            if (builder.allowBangEqualIsSet()) {
                this.initShim.withAllowBangEqual(builder.allowBangEqual);
            }
            if (builder.charLiteralStylesIsSet()) {
                this.initShim.withCharLiteralStyles((ImmutableSet<CharLiteralStyle>)Sets.immutableEnumSet((Iterable)builder.charLiteralStyles.build()));
            }
            if (builder.parserFactory != null) {
                this.initShim.withParserFactory(builder.parserFactory);
            }
            this.identifierMaxLength = this.initShim.identifierMaxLength();
            this.quotedCasing = this.initShim.quotedCasing();
            this.unquotedCasing = this.initShim.unquotedCasing();
            this.quoting = this.initShim.quoting();
            this.caseSensitive = this.initShim.caseSensitive();
            this.conformance = this.initShim.conformance();
            this.allowBangEqual = this.initShim.allowBangEqual();
            this.charLiteralStyles = this.initShim.charLiteralStyles();
            this.parserFactory = this.initShim.parserFactory();
            this.initShim = null;
        }

        private Config(int identifierMaxLength, Casing quotedCasing, Casing unquotedCasing, Quoting quoting, boolean caseSensitive, SqlConformance conformance, boolean allowBangEqual, ImmutableSet<CharLiteralStyle> charLiteralStyles, SqlParserImplFactory parserFactory) {
            this.identifierMaxLength = identifierMaxLength;
            this.quotedCasing = quotedCasing;
            this.unquotedCasing = unquotedCasing;
            this.quoting = quoting;
            this.caseSensitive = caseSensitive;
            this.conformance = conformance;
            this.allowBangEqual = allowBangEqual;
            this.charLiteralStyles = charLiteralStyles;
            this.parserFactory = parserFactory;
            this.initShim = null;
        }

        private int identifierMaxLengthInitialize() {
            return SqlParser.Config.super.identifierMaxLength();
        }

        private Casing quotedCasingInitialize() {
            return SqlParser.Config.super.quotedCasing();
        }

        private Casing unquotedCasingInitialize() {
            return SqlParser.Config.super.unquotedCasing();
        }

        private Quoting quotingInitialize() {
            return SqlParser.Config.super.quoting();
        }

        private boolean caseSensitiveInitialize() {
            return SqlParser.Config.super.caseSensitive();
        }

        private SqlConformance conformanceInitialize() {
            return SqlParser.Config.super.conformance();
        }

        private boolean allowBangEqualInitialize() {
            return SqlParser.Config.super.allowBangEqual();
        }

        private Set<CharLiteralStyle> charLiteralStylesInitialize() {
            return SqlParser.Config.super.charLiteralStyles();
        }

        private SqlParserImplFactory parserFactoryInitialize() {
            return SqlParser.Config.super.parserFactory();
        }

        @Override
        public int identifierMaxLength() {
            InitShim shim = this.initShim;
            return shim != null ? shim.identifierMaxLength() : this.identifierMaxLength;
        }

        @Override
        public Casing quotedCasing() {
            InitShim shim = this.initShim;
            return shim != null ? shim.quotedCasing() : this.quotedCasing;
        }

        @Override
        public Casing unquotedCasing() {
            InitShim shim = this.initShim;
            return shim != null ? shim.unquotedCasing() : this.unquotedCasing;
        }

        @Override
        public Quoting quoting() {
            InitShim shim = this.initShim;
            return shim != null ? shim.quoting() : this.quoting;
        }

        @Override
        public boolean caseSensitive() {
            InitShim shim = this.initShim;
            return shim != null ? shim.caseSensitive() : this.caseSensitive;
        }

        @Override
        public SqlConformance conformance() {
            InitShim shim = this.initShim;
            return shim != null ? shim.conformance() : this.conformance;
        }

        @Override
        @Deprecated
        public boolean allowBangEqual() {
            InitShim shim = this.initShim;
            return shim != null ? shim.allowBangEqual() : this.allowBangEqual;
        }

        public ImmutableSet<CharLiteralStyle> charLiteralStyles() {
            InitShim shim = this.initShim;
            return shim != null ? shim.charLiteralStyles() : this.charLiteralStyles;
        }

        @Override
        public SqlParserImplFactory parserFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.parserFactory() : this.parserFactory;
        }

        @Override
        public final Config withIdentifierMaxLength(int value) {
            if (this.identifierMaxLength == value) {
                return this;
            }
            return Config.validate(new Config(value, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Override
        public final Config withQuotedCasing(Casing value) {
            if (this.quotedCasing == value) {
                return this;
            }
            Casing newValue = Objects.requireNonNull(value, "quotedCasing");
            if (this.quotedCasing.equals((Object)newValue)) {
                return this;
            }
            return Config.validate(new Config(this.identifierMaxLength, newValue, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Override
        public final Config withUnquotedCasing(Casing value) {
            if (this.unquotedCasing == value) {
                return this;
            }
            Casing newValue = Objects.requireNonNull(value, "unquotedCasing");
            if (this.unquotedCasing.equals((Object)newValue)) {
                return this;
            }
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, newValue, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Override
        public final Config withQuoting(Quoting value) {
            if (this.quoting == value) {
                return this;
            }
            Quoting newValue = Objects.requireNonNull(value, "quoting");
            if (this.quoting.equals((Object)newValue)) {
                return this;
            }
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, newValue, this.caseSensitive, this.conformance, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Override
        public final Config withCaseSensitive(boolean value) {
            if (this.caseSensitive == value) {
                return this;
            }
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, value, this.conformance, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Override
        public final Config withConformance(SqlConformance value) {
            if (this.conformance == value) {
                return this;
            }
            SqlConformance newValue = Objects.requireNonNull(value, "conformance");
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, newValue, this.allowBangEqual, this.charLiteralStyles, this.parserFactory));
        }

        @Deprecated
        public final Config withAllowBangEqual(boolean value) {
            if (this.allowBangEqual == value) {
                return this;
            }
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, value, this.charLiteralStyles, this.parserFactory));
        }

        public final Config withCharLiteralStyles(CharLiteralStyle ... elements) {
            ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, (ImmutableSet<CharLiteralStyle>)newValue, this.parserFactory));
        }

        @Override
        public final Config withCharLiteralStyles(Iterable<CharLiteralStyle> elements) {
            if (this.charLiteralStyles == elements) {
                return this;
            }
            ImmutableSet newValue = Sets.immutableEnumSet(elements);
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, (ImmutableSet<CharLiteralStyle>)newValue, this.parserFactory));
        }

        @Override
        public final Config withParserFactory(SqlParserImplFactory value) {
            if (this.parserFactory == value) {
                return this;
            }
            SqlParserImplFactory newValue = Objects.requireNonNull(value, "parserFactory");
            return Config.validate(new Config(this.identifierMaxLength, this.quotedCasing, this.unquotedCasing, this.quoting, this.caseSensitive, this.conformance, this.allowBangEqual, this.charLiteralStyles, newValue));
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.identifierMaxLength == another.identifierMaxLength && this.quotedCasing.equals((Object)another.quotedCasing) && this.unquotedCasing.equals((Object)another.unquotedCasing) && this.quoting.equals((Object)another.quoting) && this.caseSensitive == another.caseSensitive && this.conformance.equals(another.conformance) && this.allowBangEqual == another.allowBangEqual && this.charLiteralStyles.equals(another.charLiteralStyles) && this.parserFactory.equals(another.parserFactory);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.identifierMaxLength;
            h += (h << 5) + this.quotedCasing.hashCode();
            h += (h << 5) + this.unquotedCasing.hashCode();
            h += (h << 5) + this.quoting.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.caseSensitive);
            h += (h << 5) + this.conformance.hashCode();
            h += (h << 5) + Booleans.hashCode((boolean)this.allowBangEqual);
            h += (h << 5) + this.charLiteralStyles.hashCode();
            h += (h << 5) + this.parserFactory.hashCode();
            return h;
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((String)"Config").omitNullValues().add("identifierMaxLength", this.identifierMaxLength).add("quotedCasing", (Object)this.quotedCasing).add("unquotedCasing", (Object)this.unquotedCasing).add("quoting", (Object)this.quoting).add("caseSensitive", this.caseSensitive).add("conformance", (Object)this.conformance).add("allowBangEqual", this.allowBangEqual).add("charLiteralStyles", this.charLiteralStyles).add("parserFactory", (Object)this.parserFactory).toString();
        }

        public static Config of() {
            return INSTANCE;
        }

        private static Config validate(Config instance) {
            return INSTANCE != null && INSTANCE.equalTo(instance) ? INSTANCE : instance;
        }

        public static Config copyOf(SqlParser.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="SqlParser.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long OPT_BIT_IDENTIFIER_MAX_LENGTH = 1L;
            private static final long OPT_BIT_CASE_SENSITIVE = 2L;
            private static final long OPT_BIT_ALLOW_BANG_EQUAL = 4L;
            private static final long OPT_BIT_CHAR_LITERAL_STYLES = 8L;
            private long optBits;
            private int identifierMaxLength;
            @Nullable
            private Casing quotedCasing;
            @Nullable
            private Casing unquotedCasing;
            @Nullable
            private Quoting quoting;
            private boolean caseSensitive;
            @Nullable
            private SqlConformance conformance;
            private boolean allowBangEqual;
            private ImmutableSet.Builder<CharLiteralStyle> charLiteralStyles = ImmutableSet.builder();
            @Nullable
            private SqlParserImplFactory parserFactory;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(SqlParser.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.withIdentifierMaxLength(instance.identifierMaxLength());
                this.withQuotedCasing(instance.quotedCasing());
                this.withUnquotedCasing(instance.unquotedCasing());
                this.withQuoting(instance.quoting());
                this.withCaseSensitive(instance.caseSensitive());
                this.withConformance(instance.conformance());
                this.withAllowBangEqual(instance.allowBangEqual());
                this.addAllCharLiteralStyles(instance.charLiteralStyles());
                this.withParserFactory(instance.parserFactory());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withIdentifierMaxLength(int identifierMaxLength) {
                this.identifierMaxLength = identifierMaxLength;
                this.optBits |= 1L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withQuotedCasing(Casing quotedCasing) {
                this.quotedCasing = Objects.requireNonNull(quotedCasing, "quotedCasing");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withUnquotedCasing(Casing unquotedCasing) {
                this.unquotedCasing = Objects.requireNonNull(unquotedCasing, "unquotedCasing");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withQuoting(Quoting quoting) {
                this.quoting = Objects.requireNonNull(quoting, "quoting");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCaseSensitive(boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                this.optBits |= 2L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withConformance(SqlConformance conformance) {
                this.conformance = Objects.requireNonNull(conformance, "conformance");
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            public final Builder withAllowBangEqual(boolean allowBangEqual) {
                this.allowBangEqual = allowBangEqual;
                this.optBits |= 4L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addCharLiteralStyles(CharLiteralStyle element) {
                this.charLiteralStyles.add((Object)element);
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder addCharLiteralStyles(CharLiteralStyle ... elements) {
                this.charLiteralStyles.addAll(Arrays.asList(elements));
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withCharLiteralStyles(Iterable<CharLiteralStyle> elements) {
                this.charLiteralStyles = ImmutableSet.builder();
                return this.addAllCharLiteralStyles(elements);
            }

            @CanIgnoreReturnValue
            public final Builder addAllCharLiteralStyles(Iterable<CharLiteralStyle> elements) {
                this.charLiteralStyles.addAll(elements);
                this.optBits |= 8L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withParserFactory(SqlParserImplFactory parserFactory) {
                this.parserFactory = Objects.requireNonNull(parserFactory, "parserFactory");
                return this;
            }

            public Config build() {
                return Config.validate(new Config(this));
            }

            private boolean identifierMaxLengthIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private boolean caseSensitiveIsSet() {
                return (this.optBits & 2L) != 0L;
            }

            private boolean allowBangEqualIsSet() {
                return (this.optBits & 4L) != 0L;
            }

            private boolean charLiteralStylesIsSet() {
                return (this.optBits & 8L) != 0L;
            }
        }

        @Generated(from="SqlParser.Config", generator="Immutables")
        private final class InitShim {
            private byte identifierMaxLengthBuildStage = 0;
            private int identifierMaxLength;
            private byte quotedCasingBuildStage = 0;
            private Casing quotedCasing;
            private byte unquotedCasingBuildStage = 0;
            private Casing unquotedCasing;
            private byte quotingBuildStage = 0;
            private Quoting quoting;
            private byte caseSensitiveBuildStage = 0;
            private boolean caseSensitive;
            private byte conformanceBuildStage = 0;
            private SqlConformance conformance;
            private byte allowBangEqualBuildStage = 0;
            private boolean allowBangEqual;
            private byte charLiteralStylesBuildStage = 0;
            private ImmutableSet<CharLiteralStyle> charLiteralStyles;
            private byte parserFactoryBuildStage = 0;
            private SqlParserImplFactory parserFactory;

            private InitShim() {
            }

            int identifierMaxLength() {
                if (this.identifierMaxLengthBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.identifierMaxLengthBuildStage == 0) {
                    this.identifierMaxLengthBuildStage = (byte)-1;
                    this.identifierMaxLength = Config.this.identifierMaxLengthInitialize();
                    this.identifierMaxLengthBuildStage = 1;
                }
                return this.identifierMaxLength;
            }

            void withIdentifierMaxLength(int identifierMaxLength) {
                this.identifierMaxLength = identifierMaxLength;
                this.identifierMaxLengthBuildStage = 1;
            }

            Casing quotedCasing() {
                if (this.quotedCasingBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.quotedCasingBuildStage == 0) {
                    this.quotedCasingBuildStage = (byte)-1;
                    this.quotedCasing = Objects.requireNonNull(Config.this.quotedCasingInitialize(), "quotedCasing");
                    this.quotedCasingBuildStage = 1;
                }
                return this.quotedCasing;
            }

            void withQuotedCasing(Casing quotedCasing) {
                this.quotedCasing = quotedCasing;
                this.quotedCasingBuildStage = 1;
            }

            Casing unquotedCasing() {
                if (this.unquotedCasingBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.unquotedCasingBuildStage == 0) {
                    this.unquotedCasingBuildStage = (byte)-1;
                    this.unquotedCasing = Objects.requireNonNull(Config.this.unquotedCasingInitialize(), "unquotedCasing");
                    this.unquotedCasingBuildStage = 1;
                }
                return this.unquotedCasing;
            }

            void withUnquotedCasing(Casing unquotedCasing) {
                this.unquotedCasing = unquotedCasing;
                this.unquotedCasingBuildStage = 1;
            }

            Quoting quoting() {
                if (this.quotingBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.quotingBuildStage == 0) {
                    this.quotingBuildStage = (byte)-1;
                    this.quoting = Objects.requireNonNull(Config.this.quotingInitialize(), "quoting");
                    this.quotingBuildStage = 1;
                }
                return this.quoting;
            }

            void withQuoting(Quoting quoting) {
                this.quoting = quoting;
                this.quotingBuildStage = 1;
            }

            boolean caseSensitive() {
                if (this.caseSensitiveBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.caseSensitiveBuildStage == 0) {
                    this.caseSensitiveBuildStage = (byte)-1;
                    this.caseSensitive = Config.this.caseSensitiveInitialize();
                    this.caseSensitiveBuildStage = 1;
                }
                return this.caseSensitive;
            }

            void withCaseSensitive(boolean caseSensitive) {
                this.caseSensitive = caseSensitive;
                this.caseSensitiveBuildStage = 1;
            }

            SqlConformance conformance() {
                if (this.conformanceBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.conformanceBuildStage == 0) {
                    this.conformanceBuildStage = (byte)-1;
                    this.conformance = Objects.requireNonNull(Config.this.conformanceInitialize(), "conformance");
                    this.conformanceBuildStage = 1;
                }
                return this.conformance;
            }

            void withConformance(SqlConformance conformance) {
                this.conformance = conformance;
                this.conformanceBuildStage = 1;
            }

            boolean allowBangEqual() {
                if (this.allowBangEqualBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.allowBangEqualBuildStage == 0) {
                    this.allowBangEqualBuildStage = (byte)-1;
                    this.allowBangEqual = Config.this.allowBangEqualInitialize();
                    this.allowBangEqualBuildStage = 1;
                }
                return this.allowBangEqual;
            }

            void withAllowBangEqual(boolean allowBangEqual) {
                this.allowBangEqual = allowBangEqual;
                this.allowBangEqualBuildStage = 1;
            }

            ImmutableSet<CharLiteralStyle> charLiteralStyles() {
                if (this.charLiteralStylesBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.charLiteralStylesBuildStage == 0) {
                    this.charLiteralStylesBuildStage = (byte)-1;
                    this.charLiteralStyles = Sets.immutableEnumSet((Iterable)Config.this.charLiteralStylesInitialize());
                    this.charLiteralStylesBuildStage = 1;
                }
                return this.charLiteralStyles;
            }

            void withCharLiteralStyles(ImmutableSet<CharLiteralStyle> charLiteralStyles) {
                this.charLiteralStyles = charLiteralStyles;
                this.charLiteralStylesBuildStage = 1;
            }

            SqlParserImplFactory parserFactory() {
                if (this.parserFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.parserFactoryBuildStage == 0) {
                    this.parserFactoryBuildStage = (byte)-1;
                    this.parserFactory = Objects.requireNonNull(Config.this.parserFactoryInitialize(), "parserFactory");
                    this.parserFactoryBuildStage = 1;
                }
                return this.parserFactory;
            }

            void withParserFactory(SqlParserImplFactory parserFactory) {
                this.parserFactory = parserFactory;
                this.parserFactoryBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.identifierMaxLengthBuildStage == -1) {
                    attributes.add("identifierMaxLength");
                }
                if (this.quotedCasingBuildStage == -1) {
                    attributes.add("quotedCasing");
                }
                if (this.unquotedCasingBuildStage == -1) {
                    attributes.add("unquotedCasing");
                }
                if (this.quotingBuildStage == -1) {
                    attributes.add("quoting");
                }
                if (this.caseSensitiveBuildStage == -1) {
                    attributes.add("caseSensitive");
                }
                if (this.conformanceBuildStage == -1) {
                    attributes.add("conformance");
                }
                if (this.allowBangEqualBuildStage == -1) {
                    attributes.add("allowBangEqual");
                }
                if (this.charLiteralStylesBuildStage == -1) {
                    attributes.add("charLiteralStyles");
                }
                if (this.parserFactoryBuildStage == -1) {
                    attributes.add("parserFactory");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

