/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.rules.ImmutableFilterDateRangeRuleConfig;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.BoundType;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableRangeSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedSet;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.guava30.shaded.common.collect.RangeSet;
import org.apache.kylin.guava30.shaded.common.collect.TreeRangeSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public abstract class DateRangeRules {
    public static final RelOptRule FILTER_INSTANCE = FilterDateRangeRule.FilterDateRangeRuleConfig.DEFAULT.as(FilterDateRangeRule.FilterDateRangeRuleConfig.class).toRule();
    private static final Map<TimeUnitRange, Integer> TIME_UNIT_CODES = ImmutableMap.builder().put((Object)TimeUnitRange.YEAR, (Object)1).put((Object)TimeUnitRange.MONTH, (Object)2).put((Object)TimeUnitRange.DAY, (Object)5).put((Object)TimeUnitRange.HOUR, (Object)10).put((Object)TimeUnitRange.MINUTE, (Object)12).put((Object)TimeUnitRange.SECOND, (Object)13).put((Object)TimeUnitRange.MILLISECOND, (Object)14).build();
    private static final Map<TimeUnitRange, TimeUnitRange> TIME_UNIT_PARENTS = ImmutableMap.builder().put((Object)TimeUnitRange.MONTH, (Object)TimeUnitRange.YEAR).put((Object)TimeUnitRange.DAY, (Object)TimeUnitRange.MONTH).put((Object)TimeUnitRange.HOUR, (Object)TimeUnitRange.DAY).put((Object)TimeUnitRange.MINUTE, (Object)TimeUnitRange.HOUR).put((Object)TimeUnitRange.SECOND, (Object)TimeUnitRange.MINUTE).put((Object)TimeUnitRange.MILLISECOND, (Object)TimeUnitRange.SECOND).put((Object)TimeUnitRange.MICROSECOND, (Object)TimeUnitRange.SECOND).build();

    private DateRangeRules() {
    }

    private static int calendarUnitFor(TimeUnitRange timeUnitRange) {
        return Objects.requireNonNull(TIME_UNIT_CODES.get(timeUnitRange), () -> "unexpected timeUnitRange: " + timeUnitRange + ", the following are supported: " + TIME_UNIT_CODES);
    }

    static ImmutableSortedSet<TimeUnitRange> extractTimeUnits(RexNode e) {
        try (ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();){
            assert (Objects.requireNonNull(finder, "finder").timeUnits.isEmpty() && finder.opKinds.isEmpty()) : "previous user did not clean up";
            e.accept(finder);
            ImmutableSortedSet immutableSortedSet = ImmutableSortedSet.copyOf((Collection)finder.timeUnits);
            return immutableSortedSet;
        }
    }

    @VisibleForTesting
    public static RexNode replaceTimeUnits(RexBuilder rexBuilder, RexNode e, String timeZone) {
        ImmutableSortedSet timeUnits = DateRangeRules.extractTimeUnits(e);
        if (!timeUnits.contains((Object)TimeUnitRange.YEAR)) {
            timeUnits = ImmutableSortedSet.naturalOrder().addAll(timeUnits).add((Object)TimeUnitRange.YEAR).build();
        }
        HashMap<RexNode, RangeSet<Calendar>> operandRanges = new HashMap<RexNode, RangeSet<Calendar>>();
        for (TimeUnitRange timeUnit : timeUnits) {
            e = e.accept(new ExtractShuttle(rexBuilder, timeUnit, operandRanges, (ImmutableSortedSet<TimeUnitRange>)timeUnits, timeZone));
        }
        return e;
    }

    @VisibleForTesting
    static class ExtractShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final TimeUnitRange timeUnit;
        private final Map<RexNode, RangeSet<Calendar>> operandRanges;
        private final Deque<RexCall> calls = new ArrayDeque<RexCall>();
        private final ImmutableSortedSet<TimeUnitRange> timeUnitRanges;
        private final String timeZone;

        @VisibleForTesting
        ExtractShuttle(RexBuilder rexBuilder, TimeUnitRange timeUnit, Map<RexNode, RangeSet<Calendar>> operandRanges, ImmutableSortedSet<TimeUnitRange> timeUnitRanges, String timeZone) {
            this.rexBuilder = Objects.requireNonNull(rexBuilder, "rexBuilder");
            this.timeUnit = Objects.requireNonNull(timeUnit, "timeUnit");
            this.operandRanges = Objects.requireNonNull(operandRanges, "operandRanges");
            this.timeUnitRanges = Objects.requireNonNull(timeUnitRanges, "timeUnitRanges");
            this.timeZone = timeZone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RexNode visitCall(RexCall call) {
            switch (call.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    RexLiteral flag;
                    RexNode operand;
                    RexCall subCall;
                    RexNode op0 = (RexNode)call.operands.get(0);
                    RexNode op1 = (RexNode)call.operands.get(1);
                    switch (op0.getKind()) {
                        case LITERAL: {
                            boolean bl;
                            assert (op0 instanceof RexLiteral);
                            if (this.isExtractCall(op1)) {
                                assert (op1 instanceof RexCall);
                                subCall = (RexCall)op1;
                                operand = subCall.getOperands().get(1);
                                if (this.canRewriteExtract(operand)) {
                                    return this.compareExtract(call.getKind().reverse(), operand, (RexLiteral)op0);
                                }
                            }
                            if (!this.isFloorCeilCall(op1)) break;
                            assert (op1 instanceof RexCall);
                            subCall = (RexCall)op1;
                            flag = (RexLiteral)subCall.operands.get(1);
                            TimeUnitRange timeUnit = (TimeUnitRange)Objects.requireNonNull(flag.getValue(), () -> "timeUnit is null for " + subCall);
                            SqlKind sqlKind = call.getKind().reverse();
                            RexLiteral rexLiteral = (RexLiteral)op0;
                            if (op1.getKind() == SqlKind.FLOOR) {
                                bl = true;
                                return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                            }
                            bl = false;
                            return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                        }
                    }
                    switch (op1.getKind()) {
                        case LITERAL: {
                            boolean bl;
                            assert (op1 instanceof RexLiteral);
                            if (this.isExtractCall(op0)) {
                                assert (op0 instanceof RexCall);
                                subCall = (RexCall)op0;
                                operand = (RexNode)subCall.operands.get(1);
                                if (this.canRewriteExtract(operand)) {
                                    return this.compareExtract(call.getKind(), (RexNode)subCall.operands.get(1), (RexLiteral)op1);
                                }
                            }
                            if (!this.isFloorCeilCall(op0)) break;
                            subCall = (RexCall)op0;
                            flag = (RexLiteral)subCall.operands.get(1);
                            TimeUnitRange timeUnit = (TimeUnitRange)Objects.requireNonNull(flag.getValue(), () -> "timeUnit is null for " + subCall);
                            SqlKind sqlKind = call.getKind();
                            RexLiteral rexLiteral = (RexLiteral)op1;
                            if (op0.getKind() == SqlKind.FLOOR) {
                                bl = true;
                                return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                            }
                            bl = false;
                            return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                        }
                    }
                    break;
                }
            }
            this.calls.push(call);
            try {
                RexNode rexNode = super.visitCall(call);
                return rexNode;
            }
            finally {
                this.calls.pop();
            }
        }

        private boolean canRewriteExtract(RexNode operand) {
            if (this.timeUnit == TimeUnitRange.YEAR) {
                return true;
            }
            RangeSet<Calendar> calendarRangeSet = this.operandRanges.get(operand);
            if (calendarRangeSet == null || calendarRangeSet.isEmpty()) {
                return false;
            }
            for (Range range : calendarRangeSet.asRanges()) {
                if (range.hasUpperBound() && range.hasLowerBound()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean @Nullable [] update) {
            if (exprs.isEmpty()) {
                return ImmutableList.of();
            }
            switch (this.calls.getFirst().getKind()) {
                case AND: {
                    return super.visitList(exprs, update);
                }
            }
            if (this.timeUnit != TimeUnitRange.YEAR) {
                return exprs;
            }
            ImmutableMap save = ImmutableMap.copyOf(this.operandRanges);
            ImmutableList.Builder clonedOperands = ImmutableList.builder();
            Iterator<RexNode> iterator = exprs.iterator();
            while (iterator.hasNext()) {
                RexNode operand;
                RexNode clonedOperand = operand = iterator.next();
                for (TimeUnitRange timeUnit : this.timeUnitRanges) {
                    clonedOperand = clonedOperand.accept(new ExtractShuttle(this.rexBuilder, timeUnit, this.operandRanges, this.timeUnitRanges, this.timeZone));
                }
                if (clonedOperand != operand && update != null) {
                    update[0] = true;
                }
                clonedOperands.add((Object)clonedOperand);
                this.operandRanges.clear();
                this.operandRanges.putAll((Map<RexNode, RangeSet<Calendar>>)save);
            }
            return clonedOperands.build();
        }

        boolean isExtractCall(RexNode e) {
            switch (e.getKind()) {
                case EXTRACT: {
                    RexCall call = (RexCall)e;
                    RexLiteral flag = (RexLiteral)call.operands.get(0);
                    TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
                    return timeUnit == this.timeUnit;
                }
            }
            return false;
        }

        RexNode compareExtract(SqlKind comparison, RexNode operand, RexLiteral literal) {
            ImmutableRangeSet rangeSet = this.operandRanges.get(operand);
            if (rangeSet == null) {
                rangeSet = ImmutableRangeSet.of().complement();
            }
            TreeRangeSet s2 = TreeRangeSet.create();
            int v = RexLiteral.intValue(literal) - (this.timeUnit == TimeUnitRange.MONTH ? 1 : 0);
            if (!ExtractShuttle.isValid(v, this.timeUnit)) {
                return this.rexBuilder.makeLiteral(false);
            }
            block4: for (Range r : rangeSet.asRanges()) {
                switch (this.timeUnit) {
                    case YEAR: {
                        Calendar c = Util.calendar();
                        c.clear();
                        c.set(v, 0, 1);
                        s2.add(ExtractShuttle.extractRange(this.timeUnit, comparison, c));
                        break;
                    }
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        if (!r.hasLowerBound() || !r.hasUpperBound()) break;
                        Calendar c = (Calendar)((Calendar)r.lowerEndpoint()).clone();
                        int i = 0;
                        while (ExtractShuttle.next(c, this.timeUnit, v, (Range<Calendar>)r, i++ > 0)) {
                            s2.add(ExtractShuttle.extractRange(this.timeUnit, comparison, c));
                        }
                        continue block4;
                    }
                }
            }
            s2.removeAll(rangeSet.complement());
            this.operandRanges.put(operand, (RangeSet<Calendar>)ImmutableRangeSet.copyOf((RangeSet)s2));
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (Range r : s2.asRanges()) {
                nodes.add(this.toRex(operand, (Range<Calendar>)r));
            }
            return RexUtil.composeDisjunction(this.rexBuilder, nodes);
        }

        private static boolean next(Calendar c, TimeUnitRange timeUnit, int v, Range<Calendar> r, boolean strict) {
            Calendar original = (Calendar)c.clone();
            int code = DateRangeRules.calendarUnitFor(timeUnit);
            while (true) {
                c.set(code, v);
                int v2 = c.get(code);
                if (v2 < v) continue;
                if (!strict || original.compareTo(c) != 0) break;
                c.add(DateRangeRules.calendarUnitFor((TimeUnitRange)Objects.requireNonNull(TIME_UNIT_PARENTS.get(timeUnit), () -> "TIME_UNIT_PARENTS.get(timeUnit) is null for " + timeUnit)), 1);
            }
            return r.contains((Comparable)c);
        }

        private static boolean isValid(int v, TimeUnitRange timeUnit) {
            switch (timeUnit) {
                case YEAR: {
                    return v > 0;
                }
                case MONTH: {
                    return v >= 0 && v <= 11;
                }
                case DAY: {
                    return v > 0 && v <= 31;
                }
                case HOUR: {
                    return v >= 0 && v <= 24;
                }
                case MINUTE: 
                case SECOND: {
                    return v >= 0 && v <= 60;
                }
            }
            return false;
        }

        private RexNode toRex(RexNode operand, Range<Calendar> r) {
            SqlBinaryOperator op;
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            if (r.hasLowerBound()) {
                op = r.lowerBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.GREATER_THAN_OR_EQUAL : SqlStdOperatorTable.GREATER_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.dateTimeLiteral(this.rexBuilder, (Calendar)r.lowerEndpoint(), operand)));
            }
            if (r.hasUpperBound()) {
                op = r.upperBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.dateTimeLiteral(this.rexBuilder, (Calendar)r.upperEndpoint(), operand)));
            }
            return RexUtil.composeConjunction(this.rexBuilder, nodes);
        }

        private RexLiteral dateTimeLiteral(RexBuilder rexBuilder, Calendar calendar, RexNode operand) {
            switch (operand.getType().getSqlTypeName()) {
                case TIMESTAMP: {
                    TimestampString ts = TimestampString.fromCalendarFields(calendar);
                    int p = operand.getType().getPrecision();
                    return rexBuilder.makeTimestampLiteral(ts, p);
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    TimestampString ts = TimestampString.fromCalendarFields(calendar);
                    TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                    TimestampString localTs = new TimestampWithTimeZoneString(ts, tz).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    int p = operand.getType().getPrecision();
                    return rexBuilder.makeTimestampWithLocalTimeZoneLiteral(localTs, p);
                }
                case DATE: {
                    DateString d = DateString.fromCalendarFields(calendar);
                    return rexBuilder.makeDateLiteral(d);
                }
            }
            throw Util.unexpected(operand.getType().getSqlTypeName());
        }

        private static Range<Calendar> extractRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            switch (comparison) {
                case EQUALS: {
                    return Range.closedOpen((Comparable)ExtractShuttle.round(c, timeUnit, true), (Comparable)ExtractShuttle.round(c, timeUnit, false));
                }
                case LESS_THAN: {
                    return Range.lessThan((Comparable)ExtractShuttle.round(c, timeUnit, true));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Range.lessThan((Comparable)ExtractShuttle.round(c, timeUnit, false));
                }
                case GREATER_THAN: {
                    return Range.atLeast((Comparable)ExtractShuttle.round(c, timeUnit, false));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Range.atLeast((Comparable)ExtractShuttle.round(c, timeUnit, true));
                }
            }
            throw new AssertionError((Object)comparison);
        }

        private static Calendar round(Calendar c, TimeUnitRange timeUnit, boolean down) {
            c = (Calendar)c.clone();
            if (!down) {
                Integer code = DateRangeRules.calendarUnitFor(timeUnit);
                int v = c.get(code);
                c.set(code, v + 1);
            }
            return c;
        }

        private RexNode compareFloorCeil(SqlKind comparison, RexNode operand, RexLiteral timeLiteral, TimeUnitRange timeUnit, boolean floor) {
            ImmutableRangeSet rangeSet = this.operandRanges.get(operand);
            if (rangeSet == null) {
                rangeSet = ImmutableRangeSet.of().complement();
            }
            TreeRangeSet s2 = TreeRangeSet.create();
            Calendar c = this.timestampValue(timeLiteral);
            Range<Calendar> range = floor ? ExtractShuttle.floorRange(timeUnit, comparison, c) : ExtractShuttle.ceilRange(timeUnit, comparison, c);
            s2.add(range);
            s2.removeAll(rangeSet.complement());
            this.operandRanges.put(operand, (RangeSet<Calendar>)ImmutableRangeSet.copyOf((RangeSet)s2));
            if (range.isEmpty()) {
                return this.rexBuilder.makeLiteral(false);
            }
            return this.toRex(operand, range);
        }

        private Calendar timestampValue(RexLiteral timeLiteral) {
            switch (timeLiteral.getTypeName()) {
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                    return Util.calendar(SqlFunctions.timestampWithLocalTimeZoneToTimestamp(Objects.requireNonNull(timeLiteral.getValueAs(Long.class), "timeLiteral.getValueAs(Long.class)"), tz));
                }
                case TIMESTAMP: {
                    return Util.calendar(Objects.requireNonNull(timeLiteral.getValueAs(Long.class), "timeLiteral.getValueAs(Long.class)"));
                }
                case DATE: {
                    DateString d = Objects.requireNonNull(timeLiteral.getValueAs(DateString.class), "timeLiteral.getValueAs(DateString.class)");
                    return Util.calendar(d.getMillisSinceEpoch());
                }
            }
            throw Util.unexpected(timeLiteral.getTypeName());
        }

        private static Range<Calendar> floorRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            Calendar floor = ExtractShuttle.floor(c, timeUnit);
            boolean boundary = floor.equals(c);
            switch (comparison) {
                case EQUALS: {
                    return Range.closedOpen((Comparable)floor, (Comparable)(boundary ? ExtractShuttle.increment(floor, timeUnit) : floor));
                }
                case LESS_THAN: {
                    return boundary ? Range.lessThan((Comparable)floor) : Range.lessThan((Comparable)ExtractShuttle.increment(floor, timeUnit));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Range.lessThan((Comparable)ExtractShuttle.increment(floor, timeUnit));
                }
                case GREATER_THAN: {
                    return Range.atLeast((Comparable)ExtractShuttle.increment(floor, timeUnit));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return boundary ? Range.atLeast((Comparable)floor) : Range.atLeast((Comparable)ExtractShuttle.increment(floor, timeUnit));
                }
            }
            throw Util.unexpected(comparison);
        }

        private static Range<Calendar> ceilRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            Calendar ceil = ExtractShuttle.ceil(c, timeUnit);
            boolean boundary = ceil.equals(c);
            switch (comparison) {
                case EQUALS: {
                    return Range.openClosed((Comparable)(boundary ? ExtractShuttle.decrement(ceil, timeUnit) : ceil), (Comparable)ceil);
                }
                case LESS_THAN: {
                    return Range.atMost((Comparable)ExtractShuttle.decrement(ceil, timeUnit));
                }
                case LESS_THAN_OR_EQUAL: {
                    return boundary ? Range.atMost((Comparable)ceil) : Range.atMost((Comparable)ExtractShuttle.decrement(ceil, timeUnit));
                }
                case GREATER_THAN: {
                    return boundary ? Range.greaterThan((Comparable)ceil) : Range.greaterThan((Comparable)ExtractShuttle.decrement(ceil, timeUnit));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Range.greaterThan((Comparable)ExtractShuttle.decrement(ceil, timeUnit));
                }
            }
            throw Util.unexpected(comparison);
        }

        boolean isFloorCeilCall(RexNode e) {
            switch (e.getKind()) {
                case FLOOR: 
                case CEIL: {
                    RexCall call = (RexCall)e;
                    return call.getOperands().size() == 2;
                }
            }
            return false;
        }

        private static Calendar increment(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            c.add(DateRangeRules.calendarUnitFor(timeUnit), 1);
            return c;
        }

        private static Calendar decrement(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            c.add(DateRangeRules.calendarUnitFor(timeUnit), -1);
            return c;
        }

        private static Calendar ceil(Calendar c, TimeUnitRange timeUnit) {
            Calendar floor = ExtractShuttle.floor(c, timeUnit);
            return floor.equals(c) ? floor : ExtractShuttle.increment(floor, timeUnit);
        }

        private static Calendar floor(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            switch (timeUnit) {
                case YEAR: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.MONTH), 0);
                }
                case MONTH: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.DAY), 1);
                }
                case DAY: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.HOUR), 0);
                }
                case HOUR: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.MINUTE), 0);
                }
                case MINUTE: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.SECOND), 0);
                }
                case SECOND: {
                    c.set(DateRangeRules.calendarUnitFor(TimeUnitRange.MILLISECOND), 0);
                    break;
                }
            }
            return c;
        }
    }

    private static class ExtractFinder
    extends RexVisitorImpl<Void>
    implements AutoCloseable {
        private final Set<TimeUnitRange> timeUnits = EnumSet.noneOf(TimeUnitRange.class);
        private final Set<SqlKind> opKinds = EnumSet.noneOf(SqlKind.class);
        private static final ThreadLocal<@Nullable ExtractFinder> THREAD_INSTANCES = ThreadLocal.withInitial(ExtractFinder::new);

        private ExtractFinder() {
            super(true);
        }

        @Override
        public Void visitCall(RexCall call) {
            switch (call.getKind()) {
                case EXTRACT: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(0);
                    this.timeUnits.add((TimeUnitRange)Objects.requireNonNull(operand.getValue(), () -> "timeUnitRange is null for " + call));
                    break;
                }
                case FLOOR: 
                case CEIL: {
                    if (call.getOperands().size() != 2) break;
                    this.opKinds.add(call.getKind());
                    break;
                }
            }
            return (Void)super.visitCall(call);
        }

        @Override
        public void close() {
            this.timeUnits.clear();
            this.opKinds.clear();
        }
    }

    public static class FilterDateRangeRule
    extends RelRule<FilterDateRangeRuleConfig>
    implements TransformationRule {
        protected FilterDateRangeRule(FilterDateRangeRuleConfig config) {
            super(config);
        }

        @Deprecated
        public FilterDateRangeRule(RelBuilderFactory relBuilderFactory) {
            this(FilterDateRangeRuleConfig.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(FilterDateRangeRuleConfig.class));
        }

        private static boolean containsRoundingExpression(Filter filter) {
            try (ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();){
                assert (Objects.requireNonNull(finder, "finder").timeUnits.isEmpty() && finder.opKinds.isEmpty()) : "previous user did not clean up";
                filter.getCondition().accept(finder);
                boolean bl = finder.timeUnits.contains(TimeUnitRange.YEAR) || finder.opKinds.contains((Object)SqlKind.FLOOR) || finder.opKinds.contains((Object)SqlKind.CEIL);
                return bl;
            }
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            String timeZone = filter.getCluster().getPlanner().getContext().unwrapOrThrow(CalciteConnectionConfig.class).timeZone();
            RexNode condition = DateRangeRules.replaceTimeUnits(rexBuilder, filter.getCondition(), timeZone);
            if (condition.equals(filter.getCondition())) {
                return;
            }
            RelBuilder relBuilder = this.relBuilderFactory.create(filter.getCluster(), null);
            relBuilder.push(filter.getInput()).filter(condition);
            call.transformTo(relBuilder.build());
        }

        @Value.Immutable
        public static interface FilterDateRangeRuleConfig
        extends RelRule.Config {
            public static final FilterDateRangeRuleConfig DEFAULT = ImmutableFilterDateRangeRuleConfig.of().withOperandSupplier(b -> b.operand(Filter.class).predicate(x$0 -> FilterDateRangeRule.containsRoundingExpression(x$0)).anyInputs());

            @Override
            default public FilterDateRangeRule toRule() {
                return new FilterDateRangeRule(this);
            }
        }
    }
}

