/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Alias;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Distinct;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Function;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.FunctionFactory;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.RawText;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.SelectCoreImpl;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Selection;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.Where;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.WithInto;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.FromClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.OperationClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.SelectRegexClause;
import org.apache.kylin.shaded.influxdb.org.influxdb.querybuilder.clauses.SimpleClause;

class SelectionCoreImpl
implements Selection,
WithInto {
    protected List<Object> columns;
    protected boolean isDistinct;
    private String intoMeasurement;
    private static final List<Object> COUNT_ALL = Collections.singletonList(new Function("COUNT", new RawText("*")));
    private Object currentSelection;

    SelectionCoreImpl() {
    }

    SelectionCoreImpl(Object[] columns) {
        for (Object column : columns) {
            this.addToCurrentColumn(column);
        }
    }

    @Override
    public Selection distinct() {
        this.assertColumnIsSelected();
        this.isDistinct = true;
        Distinct distinct = new Distinct(this.currentSelection);
        this.currentSelection = null;
        return this.moveToColumns(distinct);
    }

    @Override
    public Selection as(String aliasName) {
        this.assertColumnIsSelected();
        Alias alias = new Alias(this.currentSelection, aliasName);
        this.currentSelection = null;
        return this.moveToColumns(alias);
    }

    private void assertColumnIsSelected() {
        if (this.currentSelection == null) {
            throw new IllegalStateException("You need to select a column prior to calling distinct");
        }
    }

    private SelectionCoreImpl moveToColumns(Object name) {
        if (this.columns == null) {
            this.columns = new ArrayList<Object>();
        }
        this.columns.add(name);
        return this;
    }

    private SelectionCoreImpl addToCurrentColumn(Object name) {
        if (this.currentSelection != null) {
            this.moveToColumns(this.currentSelection);
        }
        this.currentSelection = name;
        return this;
    }

    @Override
    public SelectionCoreImpl all() {
        if (this.isDistinct) {
            throw new IllegalStateException("DISTINCT function can only be used with one column");
        }
        if (this.columns != null) {
            throw new IllegalStateException("Can't select all columns over columns selected previously");
        }
        if (this.currentSelection != null) {
            throw new IllegalStateException("Can't select all columns over columns selected previously");
        }
        return this;
    }

    @Override
    public SelectionCoreImpl countAll() {
        if (this.columns != null) {
            throw new IllegalStateException("Can't select all columns over columns selected previously");
        }
        if (this.currentSelection != null) {
            throw new IllegalStateException("Can't select all columns over columns selected previously");
        }
        this.columns = COUNT_ALL;
        return this;
    }

    @Override
    public SelectionCoreImpl column(String name) {
        return this.addToCurrentColumn(name);
    }

    @Override
    public SelectionCoreImpl regex(String clause) {
        return this.addToCurrentColumn(new SelectRegexClause(clause));
    }

    @Override
    public SelectionCoreImpl function(String name, Object ... parameters) {
        return this.addToCurrentColumn(FunctionFactory.function(name, parameters));
    }

    @Override
    public SelectionCoreImpl raw(String text) {
        return this.addToCurrentColumn(new RawText(text));
    }

    @Override
    public SelectionCoreImpl count(Object column) {
        return this.addToCurrentColumn(FunctionFactory.count(column));
    }

    @Override
    public SelectionCoreImpl max(Object column) {
        return this.addToCurrentColumn(FunctionFactory.max(column));
    }

    @Override
    public SelectionCoreImpl min(Object column) {
        return this.addToCurrentColumn(FunctionFactory.min(column));
    }

    @Override
    public SelectionCoreImpl sum(Object column) {
        return this.addToCurrentColumn(FunctionFactory.sum(column));
    }

    @Override
    public SelectionCoreImpl mean(Object column) {
        return this.addToCurrentColumn(FunctionFactory.mean(column));
    }

    @Override
    public SelectionCoreImpl into(String measurement) {
        this.intoMeasurement = measurement;
        return this;
    }

    @Override
    public Selection op(OperationClause operationClause) {
        return this.addToCurrentColumn(operationClause);
    }

    @Override
    public Selection op(Object arg1, String op, Object arg2) {
        return this.addToCurrentColumn(new OperationClause(arg1, op, arg2));
    }

    @Override
    public Selection cop(SimpleClause simpleClause) {
        return this.addToCurrentColumn(simpleClause);
    }

    @Override
    public Selection cop(String column, String op, Object arg2) {
        return this.addToCurrentColumn(new SimpleClause(column, op, arg2));
    }

    <E extends Where> SelectCoreImpl<E> from(FromClause fromClause, E where) {
        this.clearSelection();
        return new SelectCoreImpl<E>(fromClause, this.columns, this.isDistinct, where, this.intoMeasurement);
    }

    <E extends Where> SelectCoreImpl<E> from(E where) {
        this.clearSelection();
        return new SelectCoreImpl<E>(this.columns, this.isDistinct, where, this.intoMeasurement);
    }

    protected SelectionCoreImpl clearSelection() {
        if (this.currentSelection != null) {
            this.moveToColumns(this.currentSelection);
        }
        this.currentSelection = null;
        return this;
    }
}

