/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.JdbcType;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.config.JobMybatisConfig;
import org.apache.kylin.job.config.JobTableInterceptor;
import org.apache.kylin.job.dao.JobInfoDao;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.mapper.JobInfoMapper;
import org.apache.kylin.job.mapper.JobLockMapper;
import org.apache.kylin.rest.util.SpringContext;
import org.apache.kylin.tool.restclient.RestClient;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class JobContextUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobContextUtil.class);
    private static volatile JobInfoMapper jobInfoMapper;
    private static volatile JobLockMapper jobLockMapper;
    private static volatile JobInfoDao jobInfoDao;
    private static volatile JobContext jobContext;
    private static volatile SqlSessionTemplate sqlSessionTemplate;
    private static volatile DataSourceTransactionManager transactionManager;
    private static final JobTableInterceptor jobTableInterceptor;
    private static final JobMybatisConfig jobMybatisConfig;

    private static synchronized JobInfoDao getJobInfoDaoForTestOrTool(KylinConfig config) {
        JobContextUtil.initMappers(config);
        if (null == jobInfoDao) {
            jobInfoDao = new JobInfoDao();
            jobInfoDao.setJobInfoMapper(jobInfoMapper);
            jobInfoDao.setJobLockMapper(jobLockMapper);
        }
        return jobInfoDao;
    }

    private static synchronized JobContext getJobContextForTestOrTool(KylinConfig config) {
        JobContextUtil.initMappers(config);
        if (config.isUTEnv()) {
            config.setProperty("kylin.job.master-poll-interval-second", "1");
            config.setProperty("kylin.job.scheduler.poll-interval-second", "1");
            config.setProperty("kylin.job.slave-lock-renew-sec", "5");
            config.setProperty("kylin.job.slave-lock-renew-ratio", "0.4");
        }
        if (null == jobContext) {
            jobContext = new JobContext();
            jobContext.setKylinConfig(config);
            jobContext.setJobInfoMapper(jobInfoMapper);
            jobContext.setJobLockMapper(jobLockMapper);
            jobContext.setTransactionManager(transactionManager);
            jobContext.init();
        }
        return jobContext;
    }

    private static synchronized void initMappers(KylinConfig config) {
        if (null != jobInfoMapper && null != jobLockMapper) {
            return;
        }
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        try {
            DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
            transactionManager = JdbcDataSource.getTransactionManager((DataSource)dataSource);
            SqlSessionFactory sqlSessionFactory = JobContextUtil.getSqlSessionFactory(dataSource);
            JobContextUtil.addPluginForSqlSessionManager(dataSource, sqlSessionFactory);
            sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
            jobInfoMapper = (JobInfoMapper)sqlSessionTemplate.getMapper(JobInfoMapper.class);
            jobLockMapper = (JobLockMapper)sqlSessionTemplate.getMapper(JobLockMapper.class);
        }
        catch (Exception e) {
            throw new RuntimeException("initialize mybatis mappers failed", e);
        }
    }

    private static void addPluginForSqlSessionManager(DataSource dataSource, SqlSessionFactory sqlSessionFactory) throws Exception {
        jobMybatisConfig.setDataSource(dataSource);
        jobMybatisConfig.setupJobTables();
        jobTableInterceptor.setJobMybatisConfig(jobMybatisConfig);
        List interceptors = sqlSessionFactory.getConfiguration().getInterceptors();
        if (!interceptors.contains(jobTableInterceptor)) {
            sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)jobTableInterceptor);
        }
    }

    public static SqlSessionFactory getSqlSessionFactory(DataSource dataSource) throws SQLException, IOException {
        log.info("Start to build data loading SqlSessionFactory");
        SpringManagedTransactionFactory transactionFactory = new SpringManagedTransactionFactory();
        Environment environment = new Environment("data loading", (TransactionFactory)transactionFactory, dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.setUseGeneratedKeys(true);
        configuration.setJdbcTypeForNull(JdbcType.NULL);
        configuration.addMapper(JobInfoMapper.class);
        configuration.addMapper(JobLockMapper.class);
        configuration.setCacheEnabled(false);
        JobContextUtil.setMapperXML(configuration);
        return new SqlSessionFactoryBuilder().build(configuration);
    }

    private static void setMapperXML(Configuration configuration) throws IOException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : resources = resourceResolver.getResources("classpath:/mybatis-mapper/*Mapper.xml")) {
            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resource.getInputStream(), configuration, resource.toString(), configuration.getSqlFragments());
            xmlMapperBuilder.parse();
        }
    }

    public static JobInfoDao getJobInfoDao(KylinConfig config) {
        if (config.isUTEnv() || JobContextUtil.isNoSpringContext()) {
            return JobContextUtil.getJobInfoDaoForTestOrTool(config);
        }
        return (JobInfoDao)SpringContext.getBean(JobInfoDao.class);
    }

    public static JobContext getJobContext(KylinConfig config) {
        if (config.isUTEnv() || JobContextUtil.isNoSpringContext()) {
            return JobContextUtil.getJobContextForTestOrTool(config);
        }
        return (JobContext)SpringContext.getBean(JobContext.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSourceTransactionManager getTransactionManager(KylinConfig config) throws Exception {
        if (config.isUTEnv() || JobContextUtil.isNoSpringContext()) {
            Class<JobContextUtil> clazz = JobContextUtil.class;
            synchronized (JobContextUtil.class) {
                JobContextUtil.initMappers(config);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return transactionManager;
            }
        }
        StorageURL url = config.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        return JdbcDataSource.getTransactionManager((Properties)props);
    }

    private static boolean isNoSpringContext() {
        return null == SpringContext.getApplicationContext();
    }

    public static synchronized void cleanUp() {
        JobContextUtil.stopScheduler();
        JobContextUtil.dropUTJobTable();
        jobInfoMapper = null;
        jobLockMapper = null;
        jobInfoDao = null;
        jobContext = null;
        sqlSessionTemplate = null;
        transactionManager = null;
    }

    public static void stopScheduler() {
        if (null != jobContext) {
            try {
                jobContext.destroy();
                jobContext = null;
            }
            catch (Exception e) {
                log.error("JobContextUtil clean up failed.");
                throw new RuntimeException("JobContextUtil clean up failed.", e);
            }
        }
    }

    private static void dropUTJobTable() {
        try {
            if (null != transactionManager) {
                JdbcTemplate jdbcTemplate = new JdbcTemplate(transactionManager.getDataSource());
                jdbcTemplate.execute("SHUTDOWN;");
            }
        }
        catch (Exception e) {
            log.error("Drop UT job table failed.", (Throwable)e);
        }
    }

    public static boolean hasStarted() {
        return jobContext != null;
    }

    public static Map<String, List<String>> splitJobIdsByScheduleInstance(List<String> ids) {
        HashMap<String, List<String>> nodeWithJobs = new HashMap<String, List<String>>();
        for (String jobId : ids) {
            String host = JobContextUtil.getJobSchedulerHost(jobId);
            List jobIds = nodeWithJobs.getOrDefault(host, new ArrayList());
            jobIds.add(jobId);
            nodeWithJobs.put(host, jobIds);
        }
        return nodeWithJobs;
    }

    public static String getJobSchedulerHost(String jobId) {
        JobContext jobContext = JobContextUtil.getJobContext(KylinConfig.getInstanceFromEnv());
        String jobNode = jobContext.getJobLockMapper().findNodeByLockId(jobId);
        if (Objects.isNull(jobNode)) {
            return jobContext.getServerNode();
        }
        return jobNode;
    }

    public static void remoteDiscardJob(String project, List<String> jobIdList) {
        Map<String, List<String>> nodeWithJobs = JobContextUtil.splitJobIdsByScheduleInstance(jobIdList);
        String local = AddressUtil.getLocalInstance();
        for (Map.Entry<String, List<String>> entry : nodeWithJobs.entrySet()) {
            log.info("Discarding jobs {} on node {}", entry.getValue(), (Object)entry.getKey());
            if (local.equals(entry.getKey())) {
                ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
                entry.getValue().forEach(executableManager::discardJob);
                continue;
            }
            HashMap form = Maps.newHashMap();
            form.put("project", project);
            form.put("jobId", StringUtils.join((Iterable)entry.getValue(), (String)","));
            RestClient client = new RestClient(entry.getKey());
            client.forwardPostWithUrlEncodedForm("/job_delegate/discard_job", null, (Map)form);
        }
    }

    public static <T> T withTxAndRetry(JdbcUtil.Callback<T> consumer) {
        return JobContextUtil.withTxAndRetry(consumer, KylinConfig.getInstanceFromEnv().getMaxTransactionRetry());
    }

    public static <T> T withTxAndRetry(JdbcUtil.Callback<T> consumer, int retryLimit) {
        return (T)JdbcUtil.withTxAndRetry((DataSourceTransactionManager)JobContextUtil.getTransactionManager(KylinConfig.getInstanceFromEnv()), consumer, (int)retryLimit);
    }

    static {
        jobTableInterceptor = new JobTableInterceptor();
        jobMybatisConfig = new JobMybatisConfig();
    }
}

