/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.mail;

import freemarker.template.Template;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.mail.MailNotificationCreator;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobMailUtil {
    private static final Logger logger = LoggerFactory.getLogger(JobMailUtil.class);
    private static final String NA = "NA";

    private JobMailUtil() {
        throw new IllegalStateException("Utility class");
    }

    private static Map<String, Object> getCommonMailData(AbstractExecutable executable) {
        HashMap data = Maps.newHashMap();
        data.put("job_name", executable.getName());
        data.put("submitter", executable.getSubmitter());
        data.put("project_name", executable.getProject());
        data.put("object", Optional.ofNullable(executable.getTargetModelAlias()).orElse(executable.getTargetSubject()));
        data.put("start_time", DateFormat.formatToDateStr((long)executable.getStartTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        data.put("end_time", DateFormat.formatToDateStr((long)executable.getLastModified(), (String)"yyyy-MM-dd HH:mm:ss"));
        return data;
    }

    private static void addErrorMsg(AbstractExecutable executable, Map<String, Object> mailData) {
        ExecutableManager executableManager = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv(), executable.getProject());
        Output jobOutput = executableManager.getOutput(executable.getId());
        List<AbstractExecutable> tasks = ((DefaultExecutable)executable).getTasks();
        AbstractExecutable errorTask = null;
        Output errorTaskOutput = null;
        for (AbstractExecutable task : tasks) {
            errorTaskOutput = executableManager.getOutput(task.getId());
            if (errorTaskOutput.getState() != ExecutableState.ERROR && errorTaskOutput.getState() != ExecutableState.SUICIDAL) continue;
            errorTask = task;
            break;
        }
        Objects.requireNonNull(errorTask);
        Objects.requireNonNull(errorTaskOutput);
        mailData.put("error_step", errorTask.getName());
        if (errorTask.getOutput().getExtra().containsKey("yarn_application_id")) {
            String yarnApplicationId = errorTaskOutput.getExtra().get("yarn_application_id");
            mailData.put("yarn_application_id", StringUtils.defaultIfBlank((CharSequence)yarnApplicationId, (CharSequence)NA));
        } else {
            mailData.put("yarn_application_id", NA);
        }
        mailData.put("error_log", Matcher.quoteReplacement((String)StringUtils.defaultIfBlank((CharSequence)jobOutput.getFailedStack(), (CharSequence)"no error message")));
    }

    private static Map<String, Object> createMailContent(MailNotificationType notificationType, AbstractExecutable executable) {
        Map<String, Object> mailData = JobMailUtil.getCommonMailData(executable);
        if (MailNotificationType.JOB_ERROR == notificationType) {
            JobMailUtil.addErrorMsg(executable, mailData);
        }
        return mailData;
    }

    public static Pair<String, String> createMail(MailNotificationType notificationType, AbstractExecutable job) {
        try {
            String mailTitle = MailNotificationCreator.createTitle((MailNotificationType)notificationType);
            Map<String, Object> mailData = JobMailUtil.createMailContent(notificationType, job);
            Template mailTemplate = MailNotificationCreator.MailTemplate.getTemplate((String)notificationType.getCorrespondingTemplateName());
            String mailContent = MailNotificationCreator.createContent((Template)mailTemplate, mailData);
            return new Pair((Object)mailTitle, (Object)mailContent);
        }
        catch (Exception e) {
            logger.error("create mail [{}] failed!", (Object)notificationType.getDisplayName(), (Object)e);
            return null;
        }
    }
}

