/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.util.ExecutableParaUtil;

public class MergerInfo {
    private String project;
    private String toBeDeleteLayoutIdsStr;
    private String modelId;
    private String jobId;
    private int errorOrPausedJobCount;
    private ExecutableHandler.HandlerType handlerType;
    private List<TaskMergeInfo> taskMergeInfoList = new ArrayList<TaskMergeInfo>();

    public MergerInfo(String project, String toBeDeleteLayoutIdsStr, String modelId, String jobId, int errorOrPausedJobCount, ExecutableHandler.HandlerType handlerType) {
        this(project, modelId, jobId, errorOrPausedJobCount, handlerType);
        this.toBeDeleteLayoutIdsStr = toBeDeleteLayoutIdsStr;
    }

    public MergerInfo(String project, String modelId, String jobId, int errorOrPausedJobCount, ExecutableHandler.HandlerType handlerType) {
        this(project, handlerType);
        this.modelId = modelId;
        this.jobId = jobId;
        this.errorOrPausedJobCount = errorOrPausedJobCount;
    }

    public MergerInfo(String project, ExecutableHandler.HandlerType handlerType) {
        this.project = project;
        this.handlerType = handlerType;
    }

    public void addTaskMergeInfo(AbstractExecutable job, boolean needBuildSnapshots) {
        this.taskMergeInfoList.add(new TaskMergeInfo(job, needBuildSnapshots));
    }

    public void addTaskMergeInfo(AbstractExecutable job) {
        this.taskMergeInfoList.add(new TaskMergeInfo(job));
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getToBeDeleteLayoutIdsStr() {
        return this.toBeDeleteLayoutIdsStr;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getErrorOrPausedJobCount() {
        return this.errorOrPausedJobCount;
    }

    @Generated
    public ExecutableHandler.HandlerType getHandlerType() {
        return this.handlerType;
    }

    @Generated
    public List<TaskMergeInfo> getTaskMergeInfoList() {
        return this.taskMergeInfoList;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setToBeDeleteLayoutIdsStr(String toBeDeleteLayoutIdsStr) {
        this.toBeDeleteLayoutIdsStr = toBeDeleteLayoutIdsStr;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setErrorOrPausedJobCount(int errorOrPausedJobCount) {
        this.errorOrPausedJobCount = errorOrPausedJobCount;
    }

    @Generated
    public void setHandlerType(ExecutableHandler.HandlerType handlerType) {
        this.handlerType = handlerType;
    }

    @Generated
    public void setTaskMergeInfoList(List<TaskMergeInfo> taskMergeInfoList) {
        this.taskMergeInfoList = taskMergeInfoList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergerInfo)) {
            return false;
        }
        MergerInfo other = (MergerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$toBeDeleteLayoutIdsStr = this.getToBeDeleteLayoutIdsStr();
        String other$toBeDeleteLayoutIdsStr = other.getToBeDeleteLayoutIdsStr();
        if (this$toBeDeleteLayoutIdsStr == null ? other$toBeDeleteLayoutIdsStr != null : !this$toBeDeleteLayoutIdsStr.equals(other$toBeDeleteLayoutIdsStr)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        String this$jobId = this.getJobId();
        String other$jobId = other.getJobId();
        if (this$jobId == null ? other$jobId != null : !this$jobId.equals(other$jobId)) {
            return false;
        }
        if (this.getErrorOrPausedJobCount() != other.getErrorOrPausedJobCount()) {
            return false;
        }
        ExecutableHandler.HandlerType this$handlerType = this.getHandlerType();
        ExecutableHandler.HandlerType other$handlerType = other.getHandlerType();
        if (this$handlerType == null ? other$handlerType != null : !((Object)((Object)this$handlerType)).equals((Object)other$handlerType)) {
            return false;
        }
        List<TaskMergeInfo> this$taskMergeInfoList = this.getTaskMergeInfoList();
        List<TaskMergeInfo> other$taskMergeInfoList = other.getTaskMergeInfoList();
        return !(this$taskMergeInfoList == null ? other$taskMergeInfoList != null : !((Object)this$taskMergeInfoList).equals(other$taskMergeInfoList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MergerInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $toBeDeleteLayoutIdsStr = this.getToBeDeleteLayoutIdsStr();
        result = result * 59 + ($toBeDeleteLayoutIdsStr == null ? 43 : $toBeDeleteLayoutIdsStr.hashCode());
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        String $jobId = this.getJobId();
        result = result * 59 + ($jobId == null ? 43 : $jobId.hashCode());
        result = result * 59 + this.getErrorOrPausedJobCount();
        ExecutableHandler.HandlerType $handlerType = this.getHandlerType();
        result = result * 59 + ($handlerType == null ? 43 : ((Object)((Object)$handlerType)).hashCode());
        List<TaskMergeInfo> $taskMergeInfoList = this.getTaskMergeInfoList();
        result = result * 59 + ($taskMergeInfoList == null ? 43 : ((Object)$taskMergeInfoList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MergerInfo(project=" + this.getProject() + ", toBeDeleteLayoutIdsStr=" + this.getToBeDeleteLayoutIdsStr() + ", modelId=" + this.getModelId() + ", jobId=" + this.getJobId() + ", errorOrPausedJobCount=" + this.getErrorOrPausedJobCount() + ", handlerType=" + (Object)((Object)this.getHandlerType()) + ", taskMergeInfoList=" + this.getTaskMergeInfoList() + ")";
    }

    @Generated
    public MergerInfo(String project, String toBeDeleteLayoutIdsStr, String modelId, String jobId, int errorOrPausedJobCount, ExecutableHandler.HandlerType handlerType, List<TaskMergeInfo> taskMergeInfoList) {
        this.project = project;
        this.toBeDeleteLayoutIdsStr = toBeDeleteLayoutIdsStr;
        this.modelId = modelId;
        this.jobId = jobId;
        this.errorOrPausedJobCount = errorOrPausedJobCount;
        this.handlerType = handlerType;
        this.taskMergeInfoList = taskMergeInfoList;
    }

    @Generated
    public MergerInfo() {
    }

    public static class TaskMergeInfo {
        private String outputMetaUrl;
        private String dataFlowId;
        private Set<String> segmentIds;
        private Set<Long> layoutIds;
        private Set<Long> partitionIds;
        private JobTypeEnum jobType;
        private boolean needBuildSnapshots;
        private String tableIdentity;
        private long createTime;
        private String selectPartCol;
        private boolean incrementBuild;

        public TaskMergeInfo(AbstractExecutable job, boolean needBuildSnapshots) {
            this.outputMetaUrl = ExecutableParaUtil.getOutputMetaUrl(job);
            this.dataFlowId = ExecutableParaUtil.getDataflowId(job);
            this.segmentIds = ExecutableParaUtil.getSegmentIds(job);
            this.layoutIds = ExecutableParaUtil.getLayoutIds(job);
            this.partitionIds = ExecutableParaUtil.getPartitionIds(job);
            this.jobType = job.getJobType();
            this.needBuildSnapshots = needBuildSnapshots;
        }

        public TaskMergeInfo(AbstractExecutable job) {
            this.outputMetaUrl = ExecutableParaUtil.getOutputMetaUrl(job);
            this.tableIdentity = ExecutableParaUtil.getTableIdentity(job);
            this.createTime = job.getCreateTime();
            this.selectPartCol = ExecutableParaUtil.getSelectPartCol(job);
            this.incrementBuild = ExecutableParaUtil.isIncrementBuild(job);
        }

        @Generated
        public String getOutputMetaUrl() {
            return this.outputMetaUrl;
        }

        @Generated
        public String getDataFlowId() {
            return this.dataFlowId;
        }

        @Generated
        public Set<String> getSegmentIds() {
            return this.segmentIds;
        }

        @Generated
        public Set<Long> getLayoutIds() {
            return this.layoutIds;
        }

        @Generated
        public Set<Long> getPartitionIds() {
            return this.partitionIds;
        }

        @Generated
        public JobTypeEnum getJobType() {
            return this.jobType;
        }

        @Generated
        public boolean isNeedBuildSnapshots() {
            return this.needBuildSnapshots;
        }

        @Generated
        public String getTableIdentity() {
            return this.tableIdentity;
        }

        @Generated
        public long getCreateTime() {
            return this.createTime;
        }

        @Generated
        public String getSelectPartCol() {
            return this.selectPartCol;
        }

        @Generated
        public boolean isIncrementBuild() {
            return this.incrementBuild;
        }

        @Generated
        public void setOutputMetaUrl(String outputMetaUrl) {
            this.outputMetaUrl = outputMetaUrl;
        }

        @Generated
        public void setDataFlowId(String dataFlowId) {
            this.dataFlowId = dataFlowId;
        }

        @Generated
        public void setSegmentIds(Set<String> segmentIds) {
            this.segmentIds = segmentIds;
        }

        @Generated
        public void setLayoutIds(Set<Long> layoutIds) {
            this.layoutIds = layoutIds;
        }

        @Generated
        public void setPartitionIds(Set<Long> partitionIds) {
            this.partitionIds = partitionIds;
        }

        @Generated
        public void setJobType(JobTypeEnum jobType) {
            this.jobType = jobType;
        }

        @Generated
        public void setNeedBuildSnapshots(boolean needBuildSnapshots) {
            this.needBuildSnapshots = needBuildSnapshots;
        }

        @Generated
        public void setTableIdentity(String tableIdentity) {
            this.tableIdentity = tableIdentity;
        }

        @Generated
        public void setCreateTime(long createTime) {
            this.createTime = createTime;
        }

        @Generated
        public void setSelectPartCol(String selectPartCol) {
            this.selectPartCol = selectPartCol;
        }

        @Generated
        public void setIncrementBuild(boolean incrementBuild) {
            this.incrementBuild = incrementBuild;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskMergeInfo)) {
                return false;
            }
            TaskMergeInfo other = (TaskMergeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$outputMetaUrl = this.getOutputMetaUrl();
            String other$outputMetaUrl = other.getOutputMetaUrl();
            if (this$outputMetaUrl == null ? other$outputMetaUrl != null : !this$outputMetaUrl.equals(other$outputMetaUrl)) {
                return false;
            }
            String this$dataFlowId = this.getDataFlowId();
            String other$dataFlowId = other.getDataFlowId();
            if (this$dataFlowId == null ? other$dataFlowId != null : !this$dataFlowId.equals(other$dataFlowId)) {
                return false;
            }
            Set<String> this$segmentIds = this.getSegmentIds();
            Set<String> other$segmentIds = other.getSegmentIds();
            if (this$segmentIds == null ? other$segmentIds != null : !((Object)this$segmentIds).equals(other$segmentIds)) {
                return false;
            }
            Set<Long> this$layoutIds = this.getLayoutIds();
            Set<Long> other$layoutIds = other.getLayoutIds();
            if (this$layoutIds == null ? other$layoutIds != null : !((Object)this$layoutIds).equals(other$layoutIds)) {
                return false;
            }
            Set<Long> this$partitionIds = this.getPartitionIds();
            Set<Long> other$partitionIds = other.getPartitionIds();
            if (this$partitionIds == null ? other$partitionIds != null : !((Object)this$partitionIds).equals(other$partitionIds)) {
                return false;
            }
            JobTypeEnum this$jobType = this.getJobType();
            JobTypeEnum other$jobType = other.getJobType();
            if (this$jobType == null ? other$jobType != null : !((Object)((Object)this$jobType)).equals((Object)other$jobType)) {
                return false;
            }
            if (this.isNeedBuildSnapshots() != other.isNeedBuildSnapshots()) {
                return false;
            }
            String this$tableIdentity = this.getTableIdentity();
            String other$tableIdentity = other.getTableIdentity();
            if (this$tableIdentity == null ? other$tableIdentity != null : !this$tableIdentity.equals(other$tableIdentity)) {
                return false;
            }
            if (this.getCreateTime() != other.getCreateTime()) {
                return false;
            }
            String this$selectPartCol = this.getSelectPartCol();
            String other$selectPartCol = other.getSelectPartCol();
            if (this$selectPartCol == null ? other$selectPartCol != null : !this$selectPartCol.equals(other$selectPartCol)) {
                return false;
            }
            return this.isIncrementBuild() == other.isIncrementBuild();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaskMergeInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $outputMetaUrl = this.getOutputMetaUrl();
            result = result * 59 + ($outputMetaUrl == null ? 43 : $outputMetaUrl.hashCode());
            String $dataFlowId = this.getDataFlowId();
            result = result * 59 + ($dataFlowId == null ? 43 : $dataFlowId.hashCode());
            Set<String> $segmentIds = this.getSegmentIds();
            result = result * 59 + ($segmentIds == null ? 43 : ((Object)$segmentIds).hashCode());
            Set<Long> $layoutIds = this.getLayoutIds();
            result = result * 59 + ($layoutIds == null ? 43 : ((Object)$layoutIds).hashCode());
            Set<Long> $partitionIds = this.getPartitionIds();
            result = result * 59 + ($partitionIds == null ? 43 : ((Object)$partitionIds).hashCode());
            JobTypeEnum $jobType = this.getJobType();
            result = result * 59 + ($jobType == null ? 43 : ((Object)((Object)$jobType)).hashCode());
            result = result * 59 + (this.isNeedBuildSnapshots() ? 79 : 97);
            String $tableIdentity = this.getTableIdentity();
            result = result * 59 + ($tableIdentity == null ? 43 : $tableIdentity.hashCode());
            long $createTime = this.getCreateTime();
            result = result * 59 + (int)($createTime >>> 32 ^ $createTime);
            String $selectPartCol = this.getSelectPartCol();
            result = result * 59 + ($selectPartCol == null ? 43 : $selectPartCol.hashCode());
            result = result * 59 + (this.isIncrementBuild() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "MergerInfo.TaskMergeInfo(outputMetaUrl=" + this.getOutputMetaUrl() + ", dataFlowId=" + this.getDataFlowId() + ", segmentIds=" + this.getSegmentIds() + ", layoutIds=" + this.getLayoutIds() + ", partitionIds=" + this.getPartitionIds() + ", jobType=" + (Object)((Object)this.getJobType()) + ", needBuildSnapshots=" + this.isNeedBuildSnapshots() + ", tableIdentity=" + this.getTableIdentity() + ", createTime=" + this.getCreateTime() + ", selectPartCol=" + this.getSelectPartCol() + ", incrementBuild=" + this.isIncrementBuild() + ")";
        }

        @Generated
        public TaskMergeInfo(String outputMetaUrl, String dataFlowId, Set<String> segmentIds, Set<Long> layoutIds, Set<Long> partitionIds, JobTypeEnum jobType, boolean needBuildSnapshots, String tableIdentity, long createTime, String selectPartCol, boolean incrementBuild) {
            this.outputMetaUrl = outputMetaUrl;
            this.dataFlowId = dataFlowId;
            this.segmentIds = segmentIds;
            this.layoutIds = layoutIds;
            this.partitionIds = partitionIds;
            this.jobType = jobType;
            this.needBuildSnapshots = needBuildSnapshots;
            this.tableIdentity = tableIdentity;
            this.createTime = createTime;
            this.selectPartCol = selectPartCol;
            this.incrementBuild = incrementBuild;
        }

        @Generated
        public TaskMergeInfo() {
        }
    }
}

