/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Maps;

public final class ExecuteResult {
    private final State state;
    private final String output;
    private final Throwable throwable;
    private Map<String, String> extraInfo = Maps.newHashMap();

    private ExecuteResult(State state, String output, Throwable throwable) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        switch (state) {
            case SUCCEED: 
            case SKIP: {
                Preconditions.checkNotNull((Object)output);
                Preconditions.checkState((throwable == null ? 1 : 0) != 0);
                break;
            }
            case ERROR: {
                Preconditions.checkNotNull((Object)throwable);
                Preconditions.checkState((output == null ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.state = state;
        this.output = output;
        this.throwable = throwable;
    }

    public static ExecuteResult createSucceed() {
        return new ExecuteResult(State.SUCCEED, "succeed", null);
    }

    public static ExecuteResult createSucceed(String output) {
        return new ExecuteResult(State.SUCCEED, output, null);
    }

    public static ExecuteResult createSkip() {
        return new ExecuteResult(State.SKIP, "skip", null);
    }

    public static ExecuteResult createSkip(String output) {
        return new ExecuteResult(State.SKIP, output, null);
    }

    public static ExecuteResult createError(Throwable throwable) {
        Preconditions.checkArgument((throwable != null ? 1 : 0) != 0, (Object)"throwable cannot be null");
        return new ExecuteResult(State.ERROR, null, throwable);
    }

    public State state() {
        return this.state;
    }

    public boolean succeed() {
        return this.state == State.SUCCEED;
    }

    public boolean skip() {
        return this.state == State.SKIP;
    }

    public String output() {
        return this.output;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String getErrorMsg() {
        if (this.succeed()) {
            return null;
        }
        if (this.throwable != null) {
            return Throwables.getStackTraceAsString((Throwable)this.throwable);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.output)) {
            return this.output;
        }
        return "error";
    }

    public String getShortErrMsg() {
        if (this.succeed()) {
            return null;
        }
        if (this.throwable != null) {
            String msg = Throwables.getRootCause((Throwable)this.throwable).getMessage();
            if (msg != null && msg.length() > 1000) {
                return msg.substring(0, 997) + "...";
            }
            return msg;
        }
        return null;
    }

    @Generated
    public Map<String, String> getExtraInfo() {
        return this.extraInfo;
    }

    public static enum State {
        SUCCEED,
        ERROR,
        SKIP;

    }
}

