/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.execution;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecutableContext.class);
    private volatile boolean reachQuotaLimit = false;
    private volatile boolean isLicenseOverCapacity = false;
    private final ConcurrentMap<String, Thread> runningJobThreads = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Executable> runningJobs;
    private final ConcurrentMap<String, Long> runningJobInfos;
    private final KylinConfig kylinConfig;

    public ExecutableContext(ConcurrentMap<String, Executable> runningJobs, ConcurrentMap<String, Long> runningJobInfos, KylinConfig kylinConfig) {
        this.runningJobs = runningJobs;
        this.runningJobInfos = runningJobInfos;
        this.kylinConfig = kylinConfig;
    }

    public KylinConfig getConfig() {
        return this.kylinConfig;
    }

    public void addRunningJob(Executable executable) {
        this.runningJobThreads.put(executable.getId(), Thread.currentThread());
        this.runningJobs.put(executable.getId(), executable);
        this.runningJobInfos.put(executable.getId(), System.currentTimeMillis());
    }

    public void removeRunningJob(Executable executable) {
        this.runningJobThreads.remove(executable.getId());
        this.runningJobs.remove(executable.getId());
        this.runningJobInfos.remove(executable.getId());
    }

    public Thread getRunningJobThread(Executable executable) {
        return (Thread)this.runningJobThreads.get(executable.getId());
    }

    public Map<String, Executable> getRunningJobs() {
        return Collections.unmodifiableMap(this.runningJobs);
    }

    public Map<String, Long> getRunningJobInfos() {
        return Collections.unmodifiableMap(this.runningJobInfos);
    }

    @Generated
    public boolean isReachQuotaLimit() {
        return this.reachQuotaLimit;
    }

    @Generated
    public void setReachQuotaLimit(boolean reachQuotaLimit) {
        this.reachQuotaLimit = reachQuotaLimit;
    }

    @Generated
    public boolean isLicenseOverCapacity() {
        return this.isLicenseOverCapacity;
    }

    @Generated
    public void setLicenseOverCapacity(boolean isLicenseOverCapacity) {
        this.isLicenseOverCapacity = isLicenseOverCapacity;
    }
}

