/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.core.lock;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.job.core.lock.JdbcLockClient;
import org.apache.kylin.job.core.lock.JobLock;
import org.apache.kylin.job.core.lock.LockAcquireListener;
import org.apache.kylin.job.core.lock.LockException;

public class JdbcJobLock
implements JobLock {
    private final String lockId;
    private final String lockNode;
    private final long renewalSec;
    private final long renewalDelaySec;
    private final JdbcLockClient lockClient;
    private final LockAcquireListener acquireListener;
    private boolean isLocked = false;

    public JdbcJobLock(String lockId, String lockNode, long renewalSec, double renewalRatio, JdbcLockClient lockClient, LockAcquireListener acquireListener) {
        this.lockId = lockId;
        this.lockNode = lockNode;
        this.renewalSec = renewalSec;
        this.renewalDelaySec = (int)(renewalRatio * (double)renewalSec);
        this.lockClient = lockClient;
        this.acquireListener = acquireListener;
    }

    @Override
    public boolean tryAcquire() throws LockException {
        return this.lockClient.tryAcquire(this);
    }

    @Override
    public boolean tryAcquire(long time, TimeUnit unit) throws LockException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean tryRelease() throws LockException {
        return this.lockClient.tryRelease(this);
    }

    @Override
    public void stopRenew() {
        this.lockClient.stopRenew(this.lockId);
    }

    public String toString() {
        return "JdbcJobLock{lockId='" + this.lockId + '\'' + ", lockNode='" + this.lockNode + '\'' + '}';
    }

    public String getLockId() {
        return this.lockId;
    }

    public String getLockNode() {
        return this.lockNode;
    }

    public long getRenewalSec() {
        return this.renewalSec;
    }

    public long getRenewalDelaySec() {
        return this.renewalDelaySec;
    }

    public LockAcquireListener getAcquireListener() {
        return this.acquireListener;
    }

    @Generated
    public boolean isLocked() {
        return this.isLocked;
    }

    @Generated
    public void setLocked(boolean isLocked) {
        this.isLocked = isLocked;
    }
}

