/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.constant;

public enum JobStepStatusEnum {
    NEW(0),
    PENDING(1),
    RUNNING(2),
    FINISHED(4),
    ERROR(8),
    DISCARDED(16),
    WAITING(32),
    KILLED(64),
    STOPPED(128);

    private final int code;

    private JobStepStatusEnum(int statusCode) {
        this.code = statusCode;
    }

    public static JobStepStatusEnum getByCode(int statusCode) {
        for (JobStepStatusEnum status : JobStepStatusEnum.values()) {
            if (status.getCode() != statusCode) continue;
            return status;
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isComplete() {
        return this.code == FINISHED.getCode() || this.code == ERROR.getCode() || this.code == DISCARDED.getCode();
    }

    public boolean isRunable() {
        return this.code == PENDING.getCode() || this.code == ERROR.getCode();
    }
}

