/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeJobUtil
extends ExecutableUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MergeJobUtil.class);

    @Override
    public void computeLayout(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        NDataSegment newSeg = df.getSegment(jobParam.getSegment());
        HashSet layouts = Sets.newHashSet();
        List oldSegs = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING}).stream().filter(seg -> seg.getSegRange().overlaps(newSeg.getSegRange())).collect(Collectors.toList());
        if (oldSegs.isEmpty()) {
            log.warn("JobParam {} is no longer valid because no old segment ready", (Object)jobParam);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_EXCEPTION, new Object[0]);
        }
        for (Map.Entry cuboid : ((NDataSegment)oldSegs.get(0)).getLayoutsMap().entrySet()) {
            layouts.add(((NDataLayout)cuboid.getValue()).getLayout());
        }
        if (layouts.isEmpty() && !KylinConfig.getInstanceFromEnv().isUTEnv()) {
            log.warn("JobParam {} is no longer valid because no layout awaits building", (Object)jobParam);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_EXCEPTION, new Object[0]);
        }
        jobParam.setProcessLayouts(layouts);
    }

    @Override
    public void computePartitions(JobParam jobParam) {
        NDataflow df = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)jobParam.getProject()).getDataflow(jobParam.getModel());
        NDataSegment newSeg = df.getSegment(jobParam.getSegment());
        jobParam.setTargetPartitions(newSeg.getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet()));
    }

    static {
        MergeJobUtil.registerImplementation(JobTypeEnum.INDEX_MERGE, new MergeJobUtil());
    }
}

