/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.constant.JobActionEnum;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.dao.JobInfoDao;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.rest.JobMapperFilter;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.job.util.JobInfoUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.service.JobInfoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JobResourceService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobResourceService.class);
    @Resource
    private JobInfoService jobInfoService;

    public JobResource adjustJobResource(JobResource resource) throws IOException {
        if (resource.cores >= 0 && resource.memory >= 0L) {
            return resource;
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ArrayList statuses = Lists.newArrayList((Object[])new ExecutableState[]{ExecutableState.RUNNING});
        List executablePOList = JobContextUtil.getJobInfoDao((KylinConfig)config).getExecutablePoByStatus(null, null, (List)statuses);
        int cores = 0;
        long memory = 0L;
        ArrayList jobs = Lists.newArrayList();
        for (ExecutablePO po : executablePOList) {
            Optional<ExecutablePO> subExecutablePO = po.getTasks().stream().filter(p -> ExecutableState.RUNNING.name().equals(p.getOutput().getStatus())).findFirst();
            if (!subExecutablePO.isPresent() || !resource.getQueue().equals(subExecutablePO.get().getOutput().getInfo().get("queue_name"))) continue;
            Map info = subExecutablePO.get().getOutput().getInfo();
            int jobCore = Integer.parseInt(info.getOrDefault("cores", "0"));
            long jobMemory = Long.parseLong(info.getOrDefault("memory", "0"));
            if (jobCore <= 0) continue;
            jobs.add(po.getId());
            if (resource.getCores() + (cores += jobCore) < 0 || resource.getMemory() + (memory += jobMemory) < 0L) continue;
            break;
        }
        if (!jobs.isEmpty()) {
            log.info("adjustJobResource jobs={}", (Object)StringUtils.join((Iterable)jobs, (String)","));
            this.jobInfoService.batchUpdateJobStatus(jobs, null, JobActionEnum.PAUSE.name(), Lists.newArrayList());
            this.jobInfoService.batchUpdateJobStatus(jobs, null, JobActionEnum.RESUME.name(), Lists.newArrayList());
        }
        return new JobResource(resource.getQueue(), cores * -1, memory * -1L);
    }

    public Set<String> getQueueNames() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        JobInfoDao jobInfoDao = JobContextUtil.getJobInfoDao((KylinConfig)config);
        HashSet queues = Sets.newHashSet();
        projects.forEach(projectInstance -> {
            JobMapperFilter jobMapperFilter = new JobMapperFilter();
            jobMapperFilter.setProject(projectInstance.getName());
            jobMapperFilter.setStatuses(new ExecutableState[]{ExecutableState.SUCCEED});
            jobMapperFilter.setLimit(10);
            List jobs = jobInfoDao.getJobInfoListByFilter(jobMapperFilter);
            if (CollectionUtils.isNotEmpty((Collection)jobs)) {
                for (JobInfo jobInfo : jobs) {
                    ExecutablePO po = JobInfoUtil.deserializeExecutablePO((JobInfo)jobInfo);
                    if (!CollectionUtils.isNotEmpty((Collection)po.getTasks())) continue;
                    Set taskQueues = po.getTasks().stream().map(p -> (String)p.getOutput().getInfo().get("queue_name")).filter(Objects::nonNull).collect(Collectors.toSet());
                    queues.addAll(taskQueues);
                }
            }
        });
        return queues;
    }

    public static class JobResource {
        private String queue;
        private int cores;
        private long memory;

        @Generated
        public String getQueue() {
            return this.queue;
        }

        @Generated
        public int getCores() {
            return this.cores;
        }

        @Generated
        public long getMemory() {
            return this.memory;
        }

        @Generated
        public void setQueue(String queue) {
            this.queue = queue;
        }

        @Generated
        public void setCores(int cores) {
            this.cores = cores;
        }

        @Generated
        public void setMemory(long memory) {
            this.memory = memory;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobResource)) {
                return false;
            }
            JobResource other = (JobResource)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$queue = this.getQueue();
            String other$queue = other.getQueue();
            if (this$queue == null ? other$queue != null : !this$queue.equals(other$queue)) {
                return false;
            }
            if (this.getCores() != other.getCores()) {
                return false;
            }
            return this.getMemory() == other.getMemory();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JobResource;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $queue = this.getQueue();
            result = result * 59 + ($queue == null ? 43 : $queue.hashCode());
            result = result * 59 + this.getCores();
            long $memory = this.getMemory();
            result = result * 59 + (int)($memory >>> 32 ^ $memory);
            return result;
        }

        @Generated
        public String toString() {
            return "JobResourceService.JobResource(queue=" + this.getQueue() + ", cores=" + this.getCores() + ", memory=" + this.getMemory() + ")";
        }

        @Generated
        public JobResource(String queue, int cores, long memory) {
            this.queue = queue;
            this.cores = cores;
            this.memory = memory;
        }

        @Generated
        public JobResource() {
        }
    }
}

