/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.system;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.system.NodeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeRegistryManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NodeRegistryManager.class);
    private final KylinConfig config;
    private final CachedCrudAssist<NodeRegistry> crud;
    private final String host;
    private final int port;
    private final ClusterConstant.ServerModeEnum serverMode;

    public static NodeRegistryManager getInstance(KylinConfig config) {
        return (NodeRegistryManager)config.getManager(NodeRegistryManager.class);
    }

    static NodeRegistryManager newInstance(KylinConfig config) {
        return new NodeRegistryManager(config);
    }

    public NodeRegistryManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            log.info("Initializing DiscoveryManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<NodeRegistry>(this.getStore(), MetadataType.SYSTEM, null, NodeRegistry.class){

            @Override
            protected NodeRegistry initEntityAfterReload(NodeRegistry entity, String projectName) {
                return entity;
            }
        };
        this.host = AddressUtil.getLocalHostExactAddress();
        this.port = Integer.parseInt(config.getServerPort());
        this.serverMode = ClusterConstant.ServerModeEnum.of((String)config.getServerMode());
    }

    public NodeRegistry getNodeRegistry() {
        return this.crud.get("node_registry");
    }

    public List<NodeRegistry.NodeInstance> getNodeInstances(ClusterConstant.ServerModeEnum mode) {
        return this.getNodeRegistry().getNodeInstances(mode);
    }

    public NodeRegistry.NodeInstance getLocalNodeInstance() {
        return new NodeRegistry.NodeInstance(this.host, this.port, this.serverMode);
    }

    public void createNodeRegistryIfNotExists() {
        NodeRegistry nodeRegistry = this.getNodeRegistry();
        if (nodeRegistry != null) {
            this.renew();
        } else {
            NodeRegistry newNodeRegistry = this.copyForWrite(new NodeRegistry());
            newNodeRegistry.registerOrUpdate(this.newNodeInstance());
            this.crud.save(newNodeRegistry);
        }
    }

    public void renew() {
        NodeRegistry nodeRegistry = this.copyForWrite(this.getNodeRegistry());
        nodeRegistry.registerOrUpdate(this.newNodeInstance());
        this.crud.save(nodeRegistry);
    }

    public void checkAndClean() {
        NodeRegistry nodeRegistry = this.getNodeRegistry();
        if (nodeRegistry == null) {
            return;
        }
        nodeRegistry = this.copyForWrite(nodeRegistry);
        nodeRegistry.removeExpiredRegistrations();
        this.crud.save(nodeRegistry);
    }

    public void cleanup() {
        NodeRegistry nodeRegistry = this.getNodeRegistry();
        if (nodeRegistry == null) {
            return;
        }
        nodeRegistry = this.copyForWrite(nodeRegistry);
        nodeRegistry.deregister(this.newNodeInstance());
        if (nodeRegistry.isEmpty()) {
            this.crud.delete(nodeRegistry);
        } else {
            this.crud.save(nodeRegistry);
        }
    }

    public NodeRegistry copyForWrite(NodeRegistry nodeRegistry) {
        Preconditions.checkNotNull((Object)((Object)nodeRegistry));
        return this.crud.copyForWrite(nodeRegistry);
    }

    ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    private NodeRegistry.NodeInstance newNodeInstance() {
        return new NodeRegistry.NodeInstance(this.host, this.port, this.serverMode);
    }
}

