/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.streaming.ConsumptionRateStats;
import org.apache.kylin.metadata.streaming.RowCountDetailByTime;
import org.apache.kylin.metadata.streaming.RowCountDetailByTimeMapper;
import org.apache.kylin.metadata.streaming.StreamingJobStats;
import org.apache.kylin.metadata.streaming.StreamingJobStatsMapper;
import org.apache.kylin.metadata.streaming.StreamingJobStatsTable;
import org.apache.kylin.metadata.streaming.util.StreamingJobStatsStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStreamingJobStatsStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcStreamingJobStatsStore.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String TOTAL_ROW_COUNT = "count";
    public static final String MIN_RATE = "min_rate";
    public static final String MAX_RATE = "max_rate";
    private final StreamingJobStatsTable streamingJobStatsTable;
    @VisibleForTesting
    private final SqlSessionFactory sqlSessionFactory;
    private final DataSource dataSource;
    String tableName;

    public JdbcStreamingJobStatsStore(KylinConfig config) throws Exception {
        StorageURL url = config.getStreamingStatsUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        this.dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.tableName = StorageURL.replaceUrl((StorageURL)url) + "_" + "streaming_job_stats";
        this.streamingJobStatsTable = new StreamingJobStatsTable(this.tableName);
        this.sqlSessionFactory = StreamingJobStatsStoreUtil.getSqlSessionFactory(this.dataSource, this.tableName);
    }

    public void dropTable() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, "drop table %s;", this.tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
    }

    public int insert(StreamingJobStats streamingJobStats) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper sjsMapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            InsertStatementProvider<StreamingJobStats> insertStatement = this.getInsertSJSProvider(streamingJobStats);
            int rows = sjsMapper.insert(insertStatement);
            if (rows > 0) {
                log.debug("Insert one streaming job stats(job id:{}, time:{}) into database.", (Object)streamingJobStats.getJobId(), (Object)streamingJobStats.getCreateTime());
            }
            session.commit();
            int n = rows;
            return n;
        }
    }

    public void insert(List<StreamingJobStats> statsList) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            ArrayList providers = Lists.newArrayList();
            statsList.forEach(stats -> providers.add(this.getInsertSJSProvider((StreamingJobStats)stats)));
            providers.forEach(mapper::insert);
            session.commit();
            if (statsList.size() > 0) {
                log.info("Insert {} streaming job stats into database takes {} ms", (Object)statsList.size(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    public StreamingJobStats getLatestOneByJobId(String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            SelectStatementProvider statementProvider = this.getSelectByJobIdStatementProvider(-1L, jobId);
            StreamingJobStats streamingJobStats = mapper.selectOne(statementProvider);
            return streamingJobStats;
        }
    }

    public Map<String, Long> queryDataLatenciesByJobIds(List<String> jobIds) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            SelectStatementProvider statementProvider = this.queryLatestJobIdProvider(jobIds);
            List<Long> idList = mapper.selectLatestJobId(statementProvider).stream().map(item -> (Long)item.getValue()).collect(Collectors.toList());
            List<StreamingJobStats> list = mapper.selectMany(this.getSelectByIdsStatementProvider(idList));
            HashMap<String, Long> resultMap = new HashMap<String, Long>();
            list.stream().forEach(item -> resultMap.put(item.getJobId(), item.getMinDataLatency()));
            HashMap<String, Long> hashMap = resultMap;
            return hashMap;
        }
    }

    public List<StreamingJobStats> queryByJobId(long startTime, String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            SelectStatementProvider statementProvider = this.getSelectByJobIdStatementProvider(startTime, jobId);
            List<StreamingJobStats> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public ConsumptionRateStats queryAvgConsumptionRate(long startTime, String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            SelectStatementProvider statementProvider = this.queryAllTimeAvgConsumerRate(startTime, jobId);
            ConsumptionRateStats consumptionRateStats = mapper.selectStreamingStatistics(statementProvider);
            return consumptionRateStats;
        }
    }

    public List<RowCountDetailByTime> queryRowCountDetailByTime(long startTime, String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            RowCountDetailByTimeMapper mapper = (RowCountDetailByTimeMapper)session.getMapper(RowCountDetailByTimeMapper.class);
            SelectStatementProvider statementProvider = this.queryAvgConsumerRateByTime(jobId, startTime);
            List<RowCountDetailByTime> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public void deleteStreamingJobStats(long timeline) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobStatsMapper mapper = (StreamingJobStatsMapper)session.getMapper(StreamingJobStatsMapper.class);
            DeleteStatementProvider deleteStatement = timeline < 0L ? ((DeleteModel)SqlBuilder.deleteFrom((SqlTable)this.streamingJobStatsTable).build()).render(RenderingStrategies.MYBATIS3) : ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.createTime, (VisitableCondition)SqlBuilder.isLessThan((Object)timeline), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row streaming job stats takes {} ms", (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    InsertStatementProvider<StreamingJobStats> getInsertSJSProvider(StreamingJobStats stats) {
        return SqlBuilder.insert((Object)stats).into((SqlTable)this.streamingJobStatsTable).map(this.streamingJobStatsTable.jobId).toPropertyWhenPresent("jobId", stats::getJobId).map(this.streamingJobStatsTable.projectName).toPropertyWhenPresent("projectName", stats::getProjectName).map(this.streamingJobStatsTable.batchRowNum).toPropertyWhenPresent("batchRowNum", stats::getBatchRowNum).map(this.streamingJobStatsTable.rowsPerSecond).toPropertyWhenPresent("rowsPerSecond", stats::getRowsPerSecond).map(this.streamingJobStatsTable.createTime).toPropertyWhenPresent("createTime", stats::getCreateTime).map(this.streamingJobStatsTable.processingTime).toPropertyWhenPresent("processingTime", stats::getProcessingTime).map(this.streamingJobStatsTable.minDataLatency).toPropertyWhenPresent("minDataLatency", stats::getMinDataLatency).map(this.streamingJobStatsTable.maxDataLatency).toPropertyWhenPresent("maxDataLatency", stats::getMaxDataLatency).build().render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryAllTimeAvgConsumerRate(long startTime, String jobId) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.min(this.streamingJobStatsTable.rowsPerSecond).as(MIN_RATE), SqlBuilder.max(this.streamingJobStatsTable.rowsPerSecond).as(MAX_RATE), SqlBuilder.sum(this.streamingJobStatsTable.batchRowNum).as(TOTAL_ROW_COUNT)}).from((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.createTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.streamingJobStatsTable.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryAvgConsumerRateByTime(String jobId, long startTime) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.streamingJobStatsTable)).from((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.createTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)this.getLastHourRetainTime()), new AndOrCriteriaGroup[0])).and(this.streamingJobStatsTable.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0])).and(this.streamingJobStatsTable.batchRowNum, (VisitableCondition)SqlBuilder.isGreaterThan((Object)0L), new AndOrCriteriaGroup[0])).and(this.streamingJobStatsTable.createTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.streamingJobStatsTable.createTime.descending()}).build()).render(RenderingStrategies.MYBATIS3);
    }

    private long getLastHourRetainTime() {
        return new Date(System.currentTimeMillis() - 3600000L).getTime();
    }

    SelectStatementProvider queryLatestJobIdProvider(List<String> jobIds) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.streamingJobStatsTable.jobId, SqlBuilder.max(this.streamingJobStatsTable.id).as("id")}).from((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.jobId, (VisitableCondition)SqlBuilder.isIn(jobIds), new AndOrCriteriaGroup[0])).groupBy(BasicColumn.columnList((BasicColumn[])new BasicColumn[]{this.streamingJobStatsTable.jobId})).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByJobIdStatementProvider(long startTime, String jobId) {
        QueryExpressionDSL.QueryExpressionWhereBuilder builder = (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectAllFields(this.streamingJobStatsTable)).from((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0]);
        if (startTime > 0L) {
            builder = (QueryExpressionDSL.QueryExpressionWhereBuilder)builder.and(this.streamingJobStatsTable.createTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0]);
            return ((SelectModel)builder.orderBy(new SortSpecification[]{this.streamingJobStatsTable.createTime.descending()}).build()).render(RenderingStrategies.MYBATIS3);
        }
        return ((SelectModel)builder.orderBy(new SortSpecification[]{this.streamingJobStatsTable.createTime.descending()}).limit(1L).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByIdsStatementProvider(List<Long> ids) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectAllFields(this.streamingJobStatsTable)).from((SqlTable)this.streamingJobStatsTable).where(this.streamingJobStatsTable.id, (VisitableCondition)SqlBuilder.isIn(ids), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.streamingJobStatsTable.createTime.descending()}).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectAllFields(StreamingJobStatsTable statsTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{statsTable.id, statsTable.jobId, statsTable.projectName, statsTable.batchRowNum, statsTable.rowsPerSecond, statsTable.processingTime, statsTable.minDataLatency, statsTable.maxDataLatency, statsTable.createTime});
    }

    private BasicColumn[] getSelectFields(StreamingJobStatsTable streamingJobStatsTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{streamingJobStatsTable.createTime, streamingJobStatsTable.batchRowNum});
    }

    @Generated
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

