/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.apache.kylin.metadata.streaming.StreamingJobRecordMapper;
import org.apache.kylin.metadata.streaming.StreamingJobRecordTable;
import org.apache.kylin.metadata.streaming.util.StreamingJobRecordStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStreamingJobRecordStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcStreamingJobRecordStore.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String TOTAL_ROW_COUNT = "count";
    private final StreamingJobRecordTable table;
    @VisibleForTesting
    private final SqlSessionFactory sqlSessionFactory;
    private final DataSource dataSource;
    String tableName;

    public JdbcStreamingJobRecordStore(KylinConfig config) throws Exception {
        StorageURL url = config.getStreamingStatsUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        this.dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.tableName = StorageURL.replaceUrl((StorageURL)url) + "_" + "streaming_job_record";
        this.table = new StreamingJobRecordTable(this.tableName);
        this.sqlSessionFactory = StreamingJobRecordStoreUtil.getSqlSessionFactory(this.dataSource, this.tableName);
    }

    public List<StreamingJobRecord> queryByJobId(String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobRecordMapper mapper = (StreamingJobRecordMapper)session.getMapper(StreamingJobRecordMapper.class);
            SelectStatementProvider statementProvider = this.getSelectByJobIdStatementProvider(-1, jobId);
            List<StreamingJobRecord> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public StreamingJobRecord getLatestOneByJobId(String jobId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobRecordMapper mapper = (StreamingJobRecordMapper)session.getMapper(StreamingJobRecordMapper.class);
            SelectStatementProvider statementProvider = this.getSelectByJobIdStatementProvider(1, jobId);
            StreamingJobRecord streamingJobRecord = mapper.selectOne(statementProvider);
            return streamingJobRecord;
        }
    }

    public void dropTable() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, "drop table %s;", this.tableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
    }

    public int insert(StreamingJobRecord streamingJobRecord) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobRecordMapper mapper = (StreamingJobRecordMapper)session.getMapper(StreamingJobRecordMapper.class);
            InsertStatementProvider<StreamingJobRecord> insertStatement = this.getInsertProvider(streamingJobRecord);
            int rows = mapper.insert(insertStatement);
            if (rows > 0) {
                log.debug("Insert one streaming job record(job id:{}, time:{}) into database.", (Object)streamingJobRecord.getJobId(), (Object)streamingJobRecord.getCreateTime());
            }
            session.commit();
            int n = rows;
            return n;
        }
    }

    public void deleteStreamingJobRecord(long timeline) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            StreamingJobRecordMapper mapper = (StreamingJobRecordMapper)session.getMapper(StreamingJobRecordMapper.class);
            DeleteStatementProvider deleteStatement = timeline < 0L ? ((DeleteModel)SqlBuilder.deleteFrom((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3) : ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.createTime, (VisitableCondition)SqlBuilder.isLessThan((Object)timeline), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row streaming job stats takes {} ms", (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    SelectStatementProvider getSelectByJobIdStatementProvider(int limitSize, String jobId) {
        QueryExpressionDSL.QueryExpressionWhereBuilder builder = (QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.jobId, (VisitableCondition)SqlBuilder.isEqualTo((Object)jobId), new AndOrCriteriaGroup[0]);
        if (limitSize > 0) {
            return ((SelectModel)builder.orderBy(new SortSpecification[]{this.table.createTime.descending()}).limit((long)limitSize).build()).render(RenderingStrategies.MYBATIS3);
        }
        return ((SelectModel)builder.orderBy(new SortSpecification[]{this.table.createTime.descending()}).build()).render(RenderingStrategies.MYBATIS3);
    }

    InsertStatementProvider<StreamingJobRecord> getInsertProvider(StreamingJobRecord record) {
        return SqlBuilder.insert((Object)record).into((SqlTable)this.table).map(this.table.id).toPropertyWhenPresent("id", record::getId).map(this.table.jobId).toPropertyWhenPresent("jobId", record::getJobId).map(this.table.project).toPropertyWhenPresent("project", record::getProject).map(this.table.action).toPropertyWhenPresent("action", record::getAction).map(this.table.createTime).toPropertyWhenPresent("createTime", record::getCreateTime).map(this.table.updateTime).toPropertyWhenPresent("updateTime", record::getUpdateTime).build().render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(StreamingJobRecordTable recordTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{recordTable.id, recordTable.jobId, recordTable.project, recordTable.action, recordTable.createTime, recordTable.updateTime});
    }

    @Generated
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

