/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.streaming.DataParserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataParserManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataParserManager.class);
    private String project;
    private KylinConfig kylinConfig;
    private CachedCrudAssist<DataParserInfo> crud;
    private static final String DEFAULT_JAR_NAME = "default";
    private static final String DEFAULT_PARSER_NAME = "org.apache.kylin.parser.TimedJsonStreamParser";

    public static DataParserManager getInstance(KylinConfig kylinConfig, String project) {
        return (DataParserManager)kylinConfig.getManager(project, DataParserManager.class);
    }

    static DataParserManager newInstance(KylinConfig kylinConfig, String project) {
        return new DataParserManager(kylinConfig, project);
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
    }

    private DataParserManager(KylinConfig kylinConfig, String project) {
        this.project = project;
        this.kylinConfig = kylinConfig;
        this.crud = new CachedCrudAssist<DataParserInfo>(this.getStore(), MetadataType.DATA_PARSER, project, DataParserInfo.class){

            @Override
            protected DataParserInfo initEntityAfterReload(DataParserInfo entity, String resourceName) {
                return entity;
            }
        };
        this.crud.reloadAll();
    }

    public void initDefault() {
        if (this.isInitialized()) {
            return;
        }
        this.createDataParserInfo(new DataParserInfo(this.project, DEFAULT_PARSER_NAME, DEFAULT_JAR_NAME));
    }

    public boolean isInitialized() {
        return this.crud.contains(DataParserInfo.generateResourcePath(this.project, DEFAULT_PARSER_NAME));
    }

    public DataParserInfo getDataParserInfo(String className) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        return this.crud.get(DataParserInfo.generateResourcePath(this.project, className));
    }

    public DataParserInfo createDataParserInfo(DataParserInfo parserInfo) {
        if (parserInfo == null || StringUtils.isEmpty((CharSequence)parserInfo.getClassName())) {
            throw new IllegalArgumentException("data parser info is null or class name is null");
        }
        DataParserInfo copy = this.copyForWrite(parserInfo);
        if (this.crud.contains(copy.resourceName())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_ALREADY_EXISTS_PARSER, new Object[]{copy.getClassName()});
        }
        copy.updateRandomUuid();
        return this.crud.save(copy);
    }

    public DataParserInfo updateDataParserInfo(DataParserInfo parserInfo) {
        DataParserInfo copy = this.copyForWrite(parserInfo);
        if (!this.crud.contains(copy.resourceName())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_EXISTS_PARSER, new Object[]{copy.getClassName()});
        }
        parserInfo.copyPropertiesTo(copy);
        return this.crud.save(copy);
    }

    public DataParserInfo removeParser(String className) {
        if (StringUtils.equals((CharSequence)className, (CharSequence)DEFAULT_PARSER_NAME)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_CANNOT_DELETE_DEFAULT_PARSER, new Object[0]);
        }
        DataParserInfo dataParserInfo = this.getDataParserInfo(className);
        if (Objects.isNull(dataParserInfo)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_EXISTS_PARSER, new Object[]{className});
        }
        if (!dataParserInfo.getStreamingTables().isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_TABLES_USE_PARSER, new Object[]{StringUtils.join(dataParserInfo.getStreamingTables(), (String)", ")});
        }
        this.crud.delete(dataParserInfo);
        log.info("Removing DataParserClass '{}' success", (Object)className);
        return dataParserInfo;
    }

    public void removeJar(String jarName) {
        if (StringUtils.equals((CharSequence)jarName, (CharSequence)DEFAULT_JAR_NAME)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_CANNOT_DELETE_DEFAULT_PARSER, new Object[0]);
        }
        if (this.isJarParserUsed(jarName)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_TABLES_USE_JAR, new Object[]{StringUtils.join(this.getJarParserUsedTables(jarName), (String)",")});
        }
        log.info("start to remove jar [{}]", (Object)jarName);
        List<DataParserInfo> dataParserWithJar = this.getDataParserByJar(jarName);
        dataParserWithJar.forEach(dataParserInfo -> this.removeParser(dataParserInfo.getClassName()));
    }

    public DataParserInfo removeUsingTable(String table, String className) {
        DataParserInfo dataParserInfo = this.getDataParserInfo(className);
        if (Objects.isNull(dataParserInfo)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.CUSTOM_PARSER_NOT_EXISTS_PARSER, new Object[]{className});
        }
        DataParserInfo copy = this.copyForWrite(dataParserInfo);
        copy.getStreamingTables().remove(table);
        log.info("class [{}], remove using table [{}]", (Object)className, (Object)table);
        return this.updateDataParserInfo(copy);
    }

    public List<DataParserInfo> listDataParserInfo() {
        return Lists.newArrayList(this.crud.listAll());
    }

    public List<DataParserInfo> getDataParserByJar(String jarName) {
        return this.listDataParserInfo().stream().filter(info -> StringUtils.equals((CharSequence)info.getJarName(), (CharSequence)jarName)).collect(Collectors.toList());
    }

    public boolean isJarParserUsed(String jarName) {
        return this.listDataParserInfo().stream().filter(info -> StringUtils.equals((CharSequence)info.getJarName(), (CharSequence)jarName)).anyMatch(info -> !info.getStreamingTables().isEmpty());
    }

    public List<String> getJarParserUsedTables(String jarName) {
        ArrayList tableList = Lists.newArrayList();
        this.listDataParserInfo().stream().filter(info -> StringUtils.equals((CharSequence)info.getJarName(), (CharSequence)jarName)).map(DataParserInfo::getStreamingTables).filter(streamingTables -> !streamingTables.isEmpty()).forEach(tableList::addAll);
        return tableList;
    }

    public boolean jarHasParser(String jarName) {
        return this.listDataParserInfo().stream().map(DataParserInfo::getJarName).anyMatch(name -> StringUtils.equals((CharSequence)name, (CharSequence)jarName));
    }

    public DataParserInfo copyForWrite(DataParserInfo dataParserInfo) {
        return this.crud.copyForWrite(dataParserInfo);
    }
}

