/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.logging.LogOutputStream;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.query.QueryDailyStatistic;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryHistoryMapper;
import org.apache.kylin.metadata.query.QueryHistoryProjectInfo;
import org.apache.kylin.metadata.query.QueryHistoryRealizationMapper;
import org.apache.kylin.metadata.query.QueryHistoryRealizationTable;
import org.apache.kylin.metadata.query.QueryHistoryRequest;
import org.apache.kylin.metadata.query.QueryHistoryTable;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.QueryStatistics;
import org.apache.kylin.metadata.query.QueryStatisticsMapper;
import org.apache.kylin.metadata.query.util.QueryHisStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.aggregate.Count;
import org.mybatis.dynamic.sql.select.join.EqualTo;
import org.mybatis.dynamic.sql.select.join.JoinCondition;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.Buildable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcQueryHistoryStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcQueryHistoryStore.class);
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    public static final String MONTH = "month";
    public static final String WEEK = "week";
    public static final String DAY = "day";
    public static final String COUNT = "count";
    public static final String ID_TABLE_ALIAS = "idTable";
    public static final String DELETE_REALIZATION_LOG = "Delete {} row query history realization takes {} ms";
    public static final String UNSUPPORTED_MESSAGE = "Unsupported time window!";
    private final QueryHistoryTable queryHistoryTable;
    private final QueryHistoryRealizationTable queryHistoryRealizationTable;
    @VisibleForTesting
    private final SqlSessionFactory sqlSessionFactory;
    private final DataSource dataSource;
    String qhTableName;
    String qhRealizationTableName;

    public JdbcQueryHistoryStore(KylinConfig config) throws Exception {
        StorageURL url = config.getQueryHistoryUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        this.dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.qhTableName = StorageURL.replaceUrl((StorageURL)url) + "_" + "query_history";
        this.qhRealizationTableName = StorageURL.replaceUrl((StorageURL)url) + "_" + "query_history_realization";
        this.queryHistoryTable = new QueryHistoryTable(this.qhTableName);
        this.queryHistoryRealizationTable = new QueryHistoryRealizationTable(this.qhRealizationTableName);
        this.sqlSessionFactory = QueryHisStoreUtil.getSqlSessionFactory(this.dataSource, this.qhTableName, this.qhRealizationTableName);
    }

    JdbcQueryHistoryStore() {
        this.queryHistoryTable = null;
        this.queryHistoryRealizationTable = null;
        this.sqlSessionFactory = null;
        this.dataSource = null;
    }

    public void dropQueryHistoryTable() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            ScriptRunner sr = new ScriptRunner(connection);
            sr.setLogWriter(new PrintWriter(new OutputStreamWriter((OutputStream)new LogOutputStream(log), DEFAULT_CHARSET)));
            sr.runScript((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(String.format(Locale.ROOT, "drop table %s;", this.qhTableName).getBytes(DEFAULT_CHARSET)), DEFAULT_CHARSET));
        }
    }

    public int insert(QueryMetrics queryMetrics) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper qhMapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            InsertStatementProvider<QueryMetrics> insertStatement = this.getInsertQhProvider(queryMetrics);
            int rows = qhMapper.insert(insertStatement);
            QueryHistoryRealizationMapper qhRealizationMapper = (QueryHistoryRealizationMapper)session.getMapper(QueryHistoryRealizationMapper.class);
            ArrayList insertQhRealProviderList = Lists.newArrayList();
            queryMetrics.getRealizationMetrics().forEach(realizationMetrics -> insertQhRealProviderList.add(this.getInsertQhRealizationProvider((QueryMetrics.RealizationMetrics)realizationMetrics)));
            insertQhRealProviderList.forEach(qhRealizationMapper::insert);
            if (rows > 0) {
                log.debug("Insert one query history(query id:{}) into database.", (Object)queryMetrics.getQueryId());
            }
            session.commit();
            int n = rows;
            return n;
        }
    }

    public void insert(List<QueryMetrics> queryMetricsList) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            ArrayList providers = Lists.newArrayList();
            queryMetricsList.forEach(queryMetrics -> providers.add(this.getInsertQhProvider((QueryMetrics)((Object)queryMetrics))));
            providers.forEach(mapper::insert);
            QueryHistoryRealizationMapper qhRealizationMapper = (QueryHistoryRealizationMapper)session.getMapper(QueryHistoryRealizationMapper.class);
            ArrayList insertQhRealProviderList = Lists.newArrayList();
            queryMetricsList.forEach(queryMetrics -> queryMetrics.getRealizationMetrics().forEach(realizationMetrics -> insertQhRealProviderList.add(this.getInsertQhRealizationProvider((QueryMetrics.RealizationMetrics)realizationMetrics))));
            insertQhRealProviderList.forEach(qhRealizationMapper::insert);
            session.commit();
            if (queryMetricsList.size() > 0) {
                log.info("Insert {} query history into database takes {} ms", (Object)queryMetricsList.size(), (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    public List<QueryHistory> queryQueryHistoriesByConditions(QueryHistoryRequest request, int limit, int offset) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = this.queryQueryHistoriesByConditionsProvider(request, limit, offset);
            List<QueryHistory> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public QueryStatistics queryQueryHistoriesSize(QueryHistoryRequest request) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryQueryHistoriesSizeProvider(request);
            QueryStatistics queryStatistics = mapper.selectOne(statementProvider);
            return queryStatistics;
        }
    }

    public List<QueryDailyStatistic> queryHistoryDailyStatistic(long startTime, long endTime) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            List<QueryDailyStatistic> list = mapper.selectDaily(this.qhTableName, startTime, endTime);
            return list;
        }
    }

    public List<QueryHistory> queryQueryHistoriesSubmitters(QueryHistoryRequest request, int size) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = this.querySubmittersByConditionsProvider(request, size);
            List<QueryHistory> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    private List<String> queryQueryHistoriesIds(List<String> modelIds) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryId}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.model, (VisitableCondition)SqlBuilder.isIn(modelIds), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<String> list = mapper.selectMany(statementProvider).stream().map(QueryHistory::getQueryId).collect(Collectors.toList());
            return list;
        }
    }

    public List<QueryStatistics> queryQueryHistoriesModelIds(QueryHistoryRequest request) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider1 = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.engineType}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.engineType, (VisitableCondition)SqlBuilder.isNotEqualTo((Object)"NATIVE"), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)request.getProject()), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryStatistics> list = mapper.selectMany(statementProvider1);
            return list;
        }
    }

    public QueryHistory getOldestQueryHistory(long index) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).orderBy(new SortSpecification[]{this.queryHistoryTable.id}).limit(1L).offset(index - 1L).build()).render(RenderingStrategies.MYBATIS3);
            QueryHistory queryHistory = mapper.selectOne(statementProvider);
            return queryHistory;
        }
    }

    public QueryHistory getOldestQueryHistory(String project, long index) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.queryHistoryTable.id}).limit(1L).offset(index - 1L).build()).render(RenderingStrategies.MYBATIS3);
            QueryHistory queryHistory = mapper.selectOne(statementProvider);
            return queryHistory;
        }
    }

    public Long getCountOnQueryHistory() {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])new BasicColumn[]{Count.of(this.queryHistoryTable.id)}).from((SqlTable)this.queryHistoryTable).build()).render(RenderingStrategies.MYBATIS3);
            Long l = mapper.selectAsLong(statementProvider);
            return l;
        }
    }

    public Long getCountOnQueryHistory(long retainTime) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{Count.of(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)retainTime), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            Long l = mapper.selectAsLong(statementProvider);
            return l;
        }
    }

    public Map<String, Long> getCountGroupByProject() {
        List<QueryHistoryProjectInfo> projectInfos;
        HashMap<String, Long> projectCounts = new HashMap<String, Long>();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.projectName, SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).groupBy(new BasicColumn[]{this.queryHistoryTable.projectName}).build()).render(RenderingStrategies.MYBATIS3);
            projectInfos = mapper.selectByProject(statementProvider);
        }
        projectInfos.forEach(projectInfo -> projectCounts.put(projectInfo.getProjectName(), projectInfo.getCount()));
        return projectCounts;
    }

    public QueryHistory queryByQueryId(String queryId) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isEqualTo((Object)queryId), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            QueryHistory queryHistory = mapper.selectOne(statementProvider);
            return queryHistory;
        }
    }

    public List<QueryHistory> queryByQueryIds(List<String> queryIds) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isIn(queryIds), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryHistory> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryHistory> queryAllQueryHistories() {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryHistory> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryHistory> queryQueryHistoriesByIdOffset(long id, int batchSize, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).join((Buildable)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])BasicColumn.columnList((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.id})).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isGreaterThan((Object)id), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).orderBy(new SortSpecification[]{this.queryHistoryTable.id}).limit((long)batchSize), ID_TABLE_ALIAS).on((BasicColumn)this.queryHistoryTable.id.qualifiedWith(this.queryHistoryTable.tableNameAtRuntime()), (JoinCondition)new EqualTo((BasicColumn)this.queryHistoryTable.id.qualifiedWith(ID_TABLE_ALIAS))).orderBy(new SortSpecification[]{this.queryHistoryTable.id}).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryHistory> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryCountAndAvgDuration(long startTime, long endTime, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.queryHistoryTable.queryId).as(COUNT), SqlBuilder.avg(this.queryHistoryTable.duration).as("mean")}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryCountAndAvgDurationRealization(long startTime, long endTime, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.queryHistoryRealizationTable.queryId).as(COUNT), SqlBuilder.avg(this.queryHistoryRealizationTable.duration).as("mean")}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryCountByModel(long startTime, long endTime, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.model, SqlBuilder.count(this.queryHistoryRealizationTable.queryId).as(COUNT)}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.model}).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public long queryQueryHistoryCountBeyondOffset(long offset, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.queryHistoryTable.id)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isGreaterThan((Object)offset), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            long l = mapper.selectAsLong(statementProvider);
            return l;
        }
    }

    public long queryQueryHistoryMaxId(String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.max(this.queryHistoryTable.id)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            Long maxId = mapper.selectAsLong(statementProvider);
            long l = maxId == null ? 0L : maxId;
            return l;
        }
    }

    protected Long queryQueryHistoryMinQueryTime() {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryTime}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isEqualTo((Buildable)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.min(this.queryHistoryTable.id)}).from((SqlTable)this.queryHistoryTable)), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            Long l = mapper.selectAsLong(statementProvider);
            return l;
        }
    }

    public QueryStatistics queryRecentQueryCount(long startTime, long endTime, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryCountByTimeProvider(startTime, endTime, project);
            QueryStatistics queryStatistics = mapper.selectOne(statementProvider);
            return queryStatistics;
        }
    }

    public List<QueryStatistics> queryCountByTime(long startTime, long endTime, String timeDimension, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryCountByTimeProvider(startTime, endTime, timeDimension, project);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryAvgDurationByModel(long startTime, long endTime, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.model, SqlBuilder.avg(this.queryHistoryRealizationTable.duration).as("mean")}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.model}).build()).render(RenderingStrategies.MYBATIS3);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryAvgDurationByTime(long startTime, long endTime, String timeDimension, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryAvgDurationByTimeProvider(startTime, endTime, timeDimension, project);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryAvgDurationRealizationByTime(long startTime, long endTime, String timeDimension, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryAvgDurationRealizationByTimeProvider(startTime, endTime, timeDimension, project);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public List<QueryStatistics> queryCountRealizationByTime(long startTime, long endTime, String timeDimension, String project) {
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryStatisticsMapper mapper = (QueryStatisticsMapper)session.getMapper(QueryStatisticsMapper.class);
            SelectStatementProvider statementProvider = this.queryCountRealizationByTimeProvider(startTime, endTime, timeDimension, project);
            List<QueryStatistics> list = mapper.selectMany(statementProvider);
            return list;
        }
    }

    public void deleteQueryHistory() {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryTable).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row query history takes {} ms", (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    public int deleteQueryHistory(long id) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)id), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row query history takes {} ms", (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
            int n = deleteRows;
            return n;
        }
    }

    public int deleteQueryHistory(String project, long id) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isLessThanOrEqualTo((Object)id), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row query history for project [{}] takes {} ms", new Object[]{deleteRows, project, System.currentTimeMillis() - startTime});
            }
            int n = deleteRows;
            return n;
        }
    }

    public void deleteQueryHistory(String project) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info("Delete {} row query history for project [{}] takes {} ms", new Object[]{deleteRows, project, System.currentTimeMillis() - startTime});
            }
        }
        catch (Exception e) {
            log.error("Fail to delete query history for project [{}]", (Object)project, (Object)e);
        }
    }

    public void deleteQueryHistoryRealization(long queryTime) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)queryTime), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info(DELETE_REALIZATION_LOG, (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    public void deleteQueryHistoryRealization(String project, long queryTime) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)queryTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info(DELETE_REALIZATION_LOG, (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
    }

    public void deleteQueryHistoryRealization(String project) {
        long startTime = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession();){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
            int deleteRows = mapper.delete(deleteStatement);
            session.commit();
            if (deleteRows > 0) {
                log.info(DELETE_REALIZATION_LOG, (Object)deleteRows, (Object)(System.currentTimeMillis() - startTime));
            }
        }
        catch (Exception e) {
            log.error("Fail to delete query history realization for project [{}]", (Object)project, (Object)e);
        }
    }

    public void updateQueryHistoryInfo(List<Pair<Long, QueryHistoryInfo>> idToQHInfoList) {
        long start = System.currentTimeMillis();
        try (SqlSession session = this.sqlSessionFactory.openSession(ExecutorType.BATCH);){
            QueryHistoryMapper mapper = (QueryHistoryMapper)session.getMapper(QueryHistoryMapper.class);
            ArrayList providers = Lists.newArrayList();
            idToQHInfoList.forEach(pair -> providers.add(this.changeQHInfoProvider((Long)pair.getFirst(), (QueryHistoryInfo)pair.getSecond())));
            providers.forEach(mapper::update);
            session.commit();
            if (idToQHInfoList.size() > 0) {
                log.info("Update {} query history info takes {} ms", (Object)idToQHInfoList.size(), (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    InsertStatementProvider<QueryMetrics> getInsertQhProvider(QueryMetrics queryMetrics) {
        SqlColumn<String> monthColumn = KylinConfig.getInstanceFromEnv().isUTEnv() ? this.queryHistoryTable.month_h2 : this.queryHistoryTable.month;
        return SqlBuilder.insert((Object)((Object)queryMetrics)).into((SqlTable)this.queryHistoryTable).map(this.queryHistoryTable.queryId).toPropertyWhenPresent("queryId", queryMetrics::getQueryId).map(this.queryHistoryTable.sql).toPropertyWhenPresent("sql", queryMetrics::getSql).map(this.queryHistoryTable.sqlPattern).toPropertyWhenPresent("sqlPattern", queryMetrics::getSqlPattern).map(this.queryHistoryTable.duration).toPropertyWhenPresent("queryDuration", queryMetrics::getQueryDuration).map(this.queryHistoryTable.totalScanBytes).toPropertyWhenPresent("totalScanBytes", queryMetrics::getTotalScanBytes).map(this.queryHistoryTable.totalScanCount).toPropertyWhenPresent("totalScanCount", queryMetrics::getTotalScanCount).map(this.queryHistoryTable.resultRowCount).toPropertyWhenPresent("resultRowCount", queryMetrics::getResultRowCount).map(this.queryHistoryTable.querySubmitter).toPropertyWhenPresent("submitter", queryMetrics::getSubmitter).map(this.queryHistoryTable.hostName).toPropertyWhenPresent("server", queryMetrics::getServer).map(this.queryHistoryTable.errorType).toPropertyWhenPresent("errorType", queryMetrics::getErrorType).map(this.queryHistoryTable.engineType).toPropertyWhenPresent("engineType", queryMetrics::getEngineType).map(this.queryHistoryTable.cacheHit).toPropertyWhenPresent("cacheHit", queryMetrics::isCacheHit).map(this.queryHistoryTable.queryStatus).toPropertyWhenPresent("queryStatus", queryMetrics::getQueryStatus).map(this.queryHistoryTable.indexHit).toPropertyWhenPresent("indexHit", queryMetrics::isIndexHit).map(this.queryHistoryTable.queryTime).toPropertyWhenPresent("queryTime", queryMetrics::getQueryTime).map(monthColumn).toPropertyWhenPresent(MONTH, queryMetrics::getMonth).map(this.queryHistoryTable.queryFirstDayOfMonth).toPropertyWhenPresent("queryFirstDayOfMonth", queryMetrics::getQueryFirstDayOfMonth).map(this.queryHistoryTable.queryFirstDayOfWeek).toPropertyWhenPresent("queryFirstDayOfWeek", queryMetrics::getQueryFirstDayOfWeek).map(this.queryHistoryTable.queryDay).toPropertyWhenPresent("queryDay", queryMetrics::getQueryDay).map(this.queryHistoryTable.projectName).toPropertyWhenPresent("projectName", queryMetrics::getProjectName).map(this.queryHistoryTable.queryHistoryInfo).toProperty("queryHistoryInfo").build().render(RenderingStrategies.MYBATIS3);
    }

    InsertStatementProvider<QueryMetrics.RealizationMetrics> getInsertQhRealizationProvider(QueryMetrics.RealizationMetrics realizationMetrics) {
        return SqlBuilder.insert((Object)realizationMetrics).into((SqlTable)this.queryHistoryRealizationTable).map(this.queryHistoryRealizationTable.model).toPropertyWhenPresent("modelId", realizationMetrics::getModelId).map(this.queryHistoryRealizationTable.layoutId).toPropertyWhenPresent("layoutId", realizationMetrics::getLayoutId).map(this.queryHistoryRealizationTable.indexType).toPropertyWhenPresent("indexType", realizationMetrics::getIndexType).map(this.queryHistoryRealizationTable.queryId).toPropertyWhenPresent("queryId", realizationMetrics::getQueryId).map(this.queryHistoryRealizationTable.duration).toPropertyWhenPresent("duration", realizationMetrics::getDuration).map(this.queryHistoryRealizationTable.queryTime).toPropertyWhenPresent("queryTime", realizationMetrics::getQueryTime).map(this.queryHistoryRealizationTable.projectName).toPropertyWhenPresent("projectName", realizationMetrics::getProjectName).map(this.queryHistoryRealizationTable.queryDay).toPropertyWhenPresent("queryDay", realizationMetrics::getQueryDay).map(this.queryHistoryRealizationTable.queryFirstDayOfWeek).toPropertyWhenPresent("queryFirstDayOfWeek", realizationMetrics::getQueryFirstDayOfWeek).map(this.queryHistoryRealizationTable.queryFirstDayOfMonth).toPropertyWhenPresent("queryFirstDayOfMonth", realizationMetrics::getQueryFirstDayOfMonth).build().render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryQueryHistoriesByConditionsProvider(QueryHistoryRequest request, int limit, int offset) {
        return ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.queryHistoryTable)).from((SqlTable)this.queryHistoryTable).join((Buildable)this.filterByConditions((QueryExpressionDSL<SelectModel>)SqlBuilder.select((BasicColumn[])BasicColumn.columnList((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.id})).from((SqlTable)this.queryHistoryTable), request).orderBy(new SortSpecification[]{this.queryHistoryTable.queryTime.descending()}).limit((long)limit).offset((long)offset), ID_TABLE_ALIAS).on((BasicColumn)this.queryHistoryTable.id.qualifiedWith(this.queryHistoryTable.tableNameAtRuntime()), (JoinCondition)new EqualTo((BasicColumn)this.queryHistoryTable.id.qualifiedWith(ID_TABLE_ALIAS))).orderBy(new SortSpecification[]{this.queryHistoryTable.queryTime.descending()}).build()).render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider querySubmittersByConditionsProvider(QueryHistoryRequest request, int size) {
        return ((SelectModel)this.filterByConditions((QueryExpressionDSL<SelectModel>)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.querySubmitter}).from((SqlTable)this.queryHistoryTable), request).limit((long)size).build()).render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryQueryHistoriesSizeProvider(QueryHistoryRequest request) {
        return ((SelectModel)this.filterByConditions((QueryExpressionDSL<SelectModel>)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable), request).build()).render(RenderingStrategies.MYBATIS3);
    }

    private QueryExpressionDSL.QueryExpressionWhereBuilder filterByConditions(QueryExpressionDSL<SelectModel> selectSql, QueryHistoryRequest request) {
        QueryExpressionDSL.QueryExpressionWhereBuilder filterSql = selectSql.where();
        if (StringUtils.isNotEmpty((CharSequence)request.getStartTimeFrom()) && StringUtils.isNotEmpty((CharSequence)request.getStartTimeTo())) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)Long.parseLong(request.getStartTimeFrom())), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)Long.parseLong(request.getStartTimeTo())), new AndOrCriteriaGroup[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getLatencyFrom()) && StringUtils.isNotEmpty((CharSequence)request.getLatencyTo())) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.duration, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)(Long.parseLong(request.getLatencyFrom()) * 1000L)), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.duration, (VisitableCondition)SqlBuilder.isLessThan((Object)(Long.parseLong(request.getLatencyTo()) * 1000L)), new AndOrCriteriaGroup[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServer())) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.hostName, (VisitableCondition)SqlBuilder.isEqualTo((Object)request.getServer()), new AndOrCriteriaGroup[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getSql())) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.sql, (VisitableCondition)SqlBuilder.isLike((Object)("%" + request.getSql() + "%")), new AndOrCriteriaGroup[]{SqlBuilder.or(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isLike((Object)("%" + request.getSql() + "%")), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0])});
        }
        if (request.getRealizations() != null && !request.getRealizations().isEmpty()) {
            filterSql = this.filterQueryHistoryRealization(filterSql, request);
        }
        if (request.getQueryStatus() != null && request.getQueryStatus().size() == 1) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.queryStatus, (VisitableCondition)SqlBuilder.isEqualTo((Object)request.getQueryStatus().get(0)), new AndOrCriteriaGroup[0]);
        }
        filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)request.getProject()), new AndOrCriteriaGroup[0]);
        if (!request.isAdmin()) {
            filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.querySubmitter, (VisitableCondition)SqlBuilder.isEqualTo((Object)request.getUsername()), new AndOrCriteriaGroup[0]);
        }
        if (request.getFilterSubmitter() != null && !request.getFilterSubmitter().isEmpty()) {
            if (request.isSubmitterExactlyMatch()) {
                filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.querySubmitter, (VisitableCondition)SqlBuilder.isIn(request.getFilterSubmitter()), new AndOrCriteriaGroup[0]);
            } else if (request.getFilterSubmitter().size() == 1) {
                filterSql = (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.querySubmitter, (VisitableCondition)SqlBuilder.isLikeCaseInsensitive((String)("%" + request.getFilterSubmitter().get(0) + "%")), new AndOrCriteriaGroup[0]);
            }
        }
        return filterSql;
    }

    private QueryExpressionDSL.QueryExpressionWhereBuilder filterQueryHistoryRealization(QueryExpressionDSL.QueryExpressionWhereBuilder filterSql, QueryHistoryRequest request) {
        List<String> realizations = request.realizations;
        boolean pushdown = realizations.contains("pushdown");
        boolean selectAllModels = realizations.contains("modelName");
        if (pushdown && selectAllModels) {
            return filterSql;
        }
        filterSql = pushdown ? (request.getFilterModelIds() != null && !request.getFilterModelIds().isEmpty() ? (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.indexHit, (VisitableCondition)SqlBuilder.isEqualTo((Object)false), new AndOrCriteriaGroup[]{SqlBuilder.or(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isIn((Buildable)((Buildable)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryId}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.model, (VisitableCondition)SqlBuilder.isIn(request.getFilterModelIds()), new AndOrCriteriaGroup[0]))), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0])}) : (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.indexHit, (VisitableCondition)SqlBuilder.isEqualTo((Object)false), new AndOrCriteriaGroup[0])) : (selectAllModels ? (!CollectionUtils.isEmpty(request.getExcludeFilterModelIds()) ? (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.engineType, (VisitableCondition)SqlBuilder.isIn(realizations), new AndOrCriteriaGroup[]{SqlBuilder.or(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isIn((Buildable)((Buildable)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryId}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.model, (VisitableCondition)SqlBuilder.isNotIn(request.getExcludeFilterModelIds()), new AndOrCriteriaGroup[0]))), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0])}) : (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.engineType, (VisitableCondition)SqlBuilder.isIn(realizations), new AndOrCriteriaGroup[]{SqlBuilder.or(this.queryHistoryTable.indexHit, (VisitableCondition)SqlBuilder.isEqualTo((Object)true), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0])})) : (request.getFilterModelIds() != null && !request.getFilterModelIds().isEmpty() ? (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.engineType, (VisitableCondition)SqlBuilder.isIn(realizations), new AndOrCriteriaGroup[]{SqlBuilder.or(this.queryHistoryTable.queryId, (VisitableCondition)SqlBuilder.isIn((Buildable)((Buildable)SqlBuilder.selectDistinct((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryId}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.model, (VisitableCondition)SqlBuilder.isIn(request.getFilterModelIds()), new AndOrCriteriaGroup[0]))), (AndOrCriteriaGroup[])new AndOrCriteriaGroup[0])}) : (QueryExpressionDSL.QueryExpressionWhereBuilder)filterSql.and(this.queryHistoryTable.engineType, (VisitableCondition)SqlBuilder.isIn(realizations), new AndOrCriteriaGroup[0])));
        return filterSql;
    }

    QueryExpressionDSL.QueryExpressionWhereBuilder filterModelsByConditions(QueryExpressionDSL<SelectModel> selectSql, List<String> modelIds) {
        return (QueryExpressionDSL.QueryExpressionWhereBuilder)selectSql.where().and(this.queryHistoryRealizationTable.model, (VisitableCondition)SqlBuilder.isIn(modelIds), new AndOrCriteriaGroup[0]);
    }

    private UpdateStatementProvider changeQHInfoProvider(long id, QueryHistoryInfo queryHistoryInfo) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.queryHistoryTable).set(this.queryHistoryTable.queryHistoryInfo).equalTo((Object)queryHistoryInfo).where(this.queryHistoryTable.id, (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryCountByTimeProvider(long startTime, long endTime, String project) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private SelectStatementProvider queryCountByTimeProvider(long startTime, long endTime, String timeDimension, String project) {
        if (timeDimension.equalsIgnoreCase(MONTH)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfMonth.as("time"), SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfMonth}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(WEEK)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfWeek.as("time"), SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfWeek}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(DAY)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryDay.as("time"), SqlBuilder.count(this.queryHistoryTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryDay}).build()).render(RenderingStrategies.MYBATIS3);
        }
        throw new IllegalStateException(UNSUPPORTED_MESSAGE);
    }

    private SelectStatementProvider queryAvgDurationByTimeProvider(long startTime, long endTime, String timeDimension, String project) {
        if (timeDimension.equalsIgnoreCase(MONTH)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfMonth.as("time"), SqlBuilder.avg(this.queryHistoryTable.duration).as("mean")}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfMonth}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(WEEK)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfWeek.as("time"), SqlBuilder.avg(this.queryHistoryTable.duration).as("mean")}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryFirstDayOfWeek}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(DAY)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryTable.queryDay.as("time"), SqlBuilder.avg(this.queryHistoryTable.duration).as("mean")}).from((SqlTable)this.queryHistoryTable).where(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryTable.queryDay}).build()).render(RenderingStrategies.MYBATIS3);
        }
        throw new IllegalStateException(UNSUPPORTED_MESSAGE);
    }

    private SelectStatementProvider queryAvgDurationRealizationByTimeProvider(long startTime, long endTime, String timeDimension, String project) {
        if (timeDimension.equalsIgnoreCase(MONTH)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfMonth.as("time"), SqlBuilder.avg(this.queryHistoryRealizationTable.duration).as("mean")}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfMonth}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(WEEK)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfWeek.as("time"), SqlBuilder.avg(this.queryHistoryRealizationTable.duration).as("mean")}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfWeek}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(DAY)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryDay.as("time"), SqlBuilder.avg(this.queryHistoryRealizationTable.duration).as("mean")}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryDay}).build()).render(RenderingStrategies.MYBATIS3);
        }
        throw new IllegalStateException(UNSUPPORTED_MESSAGE);
    }

    private SelectStatementProvider queryCountRealizationByTimeProvider(long startTime, long endTime, String timeDimension, String project) {
        if (timeDimension.equalsIgnoreCase(MONTH)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfMonth.as("time"), SqlBuilder.count(this.queryHistoryRealizationTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfMonth}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(WEEK)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfWeek.as("time"), SqlBuilder.count(this.queryHistoryRealizationTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryFirstDayOfWeek}).build()).render(RenderingStrategies.MYBATIS3);
        }
        if (timeDimension.equalsIgnoreCase(DAY)) {
            return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])new BasicColumn[]{this.queryHistoryRealizationTable.queryDay.as("time"), SqlBuilder.count(this.queryHistoryRealizationTable.id).as(COUNT)}).from((SqlTable)this.queryHistoryRealizationTable).where(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isGreaterThanOrEqualTo((Object)startTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.queryTime, (VisitableCondition)SqlBuilder.isLessThan((Object)endTime), new AndOrCriteriaGroup[0])).and(this.queryHistoryRealizationTable.projectName, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).groupBy(new BasicColumn[]{this.queryHistoryRealizationTable.queryDay}).build()).render(RenderingStrategies.MYBATIS3);
        }
        throw new IllegalStateException(UNSUPPORTED_MESSAGE);
    }

    private BasicColumn[] getSelectFields(QueryHistoryTable queryHistoryTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{queryHistoryTable.id.qualifiedWith(queryHistoryTable.tableNameAtRuntime()), queryHistoryTable.cacheHit, queryHistoryTable.duration, queryHistoryTable.engineType, queryHistoryTable.errorType, queryHistoryTable.hostName, queryHistoryTable.indexHit, queryHistoryTable.projectName, queryHistoryTable.queryHistoryInfo, queryHistoryTable.queryId, queryHistoryTable.queryRealizations, queryHistoryTable.queryStatus, queryHistoryTable.querySubmitter, queryHistoryTable.queryTime, queryHistoryTable.resultRowCount, queryHistoryTable.sql, queryHistoryTable.sqlPattern, queryHistoryTable.totalScanBytes, queryHistoryTable.totalScanCount});
    }

    @Generated
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

