/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;

public class UnOverWritableStrategy
implements SchemaChangeStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Arrays.asList(SchemaNodeType.MODEL_FACT, SchemaNodeType.MODEL_DIM, SchemaNodeType.MODEL_FILTER, SchemaNodeType.MODEL_JOIN, SchemaNodeType.MODEL_PARTITION);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> newItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = entry.getValue().getSubject();
        return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createCreatableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
    }

    @Override
    public List<SchemaChangeCheckResult.UpdatedItem> updateItemFunction(SchemaUtil.SchemaDifference difference, MapDifference.ValueDifference<SchemaNode> diff, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = ((SchemaNode)diff.rightValue()).getSubject();
        SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels), true, true, false);
        return Collections.singletonList(SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, parameter));
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> reduceItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = entry.getValue().getSubject();
        return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createCreatableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
    }
}

