/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.MapDifference;
import org.apache.kylin.guava30.shaded.common.graph.Graphs;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;

public class TableColumnStrategy
implements SchemaChangeStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Collections.singletonList(SchemaNodeType.TABLE_COLUMN);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> missingItems(SchemaUtil.SchemaDifference difference, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return difference.getNodeDiff().entriesOnlyOnRight().entrySet().stream().filter(pair -> this.supportedSchemaNodeTypes().contains((Object)((SchemaNode.SchemaNodeIdentifier)pair.getKey()).getType())).map(pair -> this.missingItemFunction(difference, (Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode>)pair, importModels, originalModels, originalBrokenModels)).flatMap(Collection::stream).filter(schemaChange -> importModels.contains(schemaChange.getModelAlias())).collect(Collectors.toList());
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> missingItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return this.reachableModel(difference.getTargetGraph(), entry.getValue()).stream().map(modelAlias -> SchemaChangeCheckResult.ChangedItem.createUnImportableSchemaNode(((SchemaNode.SchemaNodeIdentifier)entry.getKey()).getType(), (SchemaNode)entry.getValue(), modelAlias, SchemaChangeCheckResult.UN_IMPORT_REASON.USED_UNLOADED_TABLE, ((SchemaNode)entry.getValue()).getDetail(), this.hasSameName((String)modelAlias, originalModels), this.hasSameWithBroken((String)modelAlias, originalBrokenModels))).collect(Collectors.toList());
    }

    @Override
    public List<SchemaChangeCheckResult.UpdatedItem> updateItemFunction(SchemaUtil.SchemaDifference difference, MapDifference.ValueDifference<SchemaNode> diff, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Graphs.reachableNodes(difference.getTargetGraph(), (Object)diff.rightValue()).stream().filter(SchemaNode::isModelNode).map(SchemaNode::getSubject).distinct().map(modelAlias -> {
            SchemaChangeCheckResult.BaseItemParameter parameter = new SchemaChangeCheckResult.BaseItemParameter(this.hasSameName((String)modelAlias, originalModels), this.hasSameWithBroken((String)modelAlias, originalBrokenModels), false, false, false);
            return SchemaChangeCheckResult.UpdatedItem.getSchemaUpdate((SchemaNode)diff.leftValue(), (SchemaNode)diff.rightValue(), modelAlias, SchemaChangeCheckResult.UN_IMPORT_REASON.TABLE_COLUMN_DATATYPE_CHANGED, ((SchemaNode)diff.rightValue()).getDetail(), parameter);
        }).collect(Collectors.toList());
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> reduceItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return Graphs.reachableNodes(difference.getSourceGraph(), (Object)entry.getValue()).stream().filter(SchemaNode::isModelNode).map(SchemaNode::getSubject).distinct().map(modelAlias -> SchemaChangeCheckResult.ChangedItem.createOverwritableSchemaNode(((SchemaNode.SchemaNodeIdentifier)entry.getKey()).getType(), (SchemaNode)entry.getValue(), modelAlias, this.hasSameName((String)modelAlias, originalModels), this.hasSameWithBroken((String)modelAlias, originalBrokenModels))).collect(Collectors.toList());
    }
}

