/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.graph.DefaultJoinEdgeMatcher;
import org.apache.kylin.metadata.model.graph.IJoinEdgeMatcher;

public class Edge
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final JoinDesc join;
    public final ColumnDesc[] leftCols;
    public final ColumnDesc[] rightCols;
    public final NonEquiJoinCondition nonEquiJoinCondition;
    private IJoinEdgeMatcher joinEdgeMatcher = new DefaultJoinEdgeMatcher();
    private boolean swapJoin;

    public Edge(JoinDesc join) {
        this(join, false);
    }

    public Edge(JoinDesc join, boolean swapJoin) {
        this.join = join;
        int i = 0;
        this.leftCols = new ColumnDesc[join.getForeignKeyColumns().length];
        for (TblColRef colRef : join.getForeignKeyColumns()) {
            this.leftCols[i++] = colRef.getColumnDesc();
        }
        i = 0;
        this.rightCols = new ColumnDesc[join.getPrimaryKeyColumns().length];
        for (TblColRef colRef : join.getPrimaryKeyColumns()) {
            this.rightCols[i++] = colRef.getColumnDesc();
        }
        this.nonEquiJoinCondition = join.getNonEquiJoinCondition();
        this.swapJoin = swapJoin;
    }

    public boolean isJoinMatched(JoinDesc other) {
        return this.join.equals(other);
    }

    public boolean isNonEquiJoin() {
        return this.nonEquiJoinCondition != null;
    }

    public boolean isLeftJoin() {
        return !this.join.isLeftOrInnerJoin() && this.join.isLeftJoin();
    }

    public boolean isLeftOrInnerJoin() {
        return this.join.isLeftOrInnerJoin();
    }

    public TableRef pkSide() {
        return this.join.getPKSide();
    }

    public TableRef fkSide() {
        return this.join.getFKSide();
    }

    public boolean isFkSide(TableRef tableRef) {
        return this.fkSide().equals(tableRef);
    }

    public boolean isPkSide(TableRef tableRef) {
        return this.pkSide().equals(tableRef);
    }

    public TableRef otherSide(TableRef tableRef) {
        if (this.isFkSide(tableRef)) {
            return this.pkSide();
        }
        if (this.isPkSide(tableRef)) {
            return this.fkSide();
        }
        throw new IllegalArgumentException("table " + tableRef + " is not on the edge: " + this);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.joinEdgeMatcher.matches(this, (Edge)other);
    }

    public int hashCode() {
        if (this.isLeftJoin()) {
            return Objects.hash(this.isLeftJoin(), this.leftCols, this.rightCols);
        }
        if (Arrays.hashCode(this.leftCols) < Arrays.hashCode(this.rightCols)) {
            return Objects.hash(this.isLeftJoin(), this.leftCols, this.rightCols);
        }
        return Objects.hash(this.isLeftJoin(), this.rightCols, this.leftCols);
    }

    public String toString() {
        return this.toString(false, false);
    }

    public String toString(boolean needSortJoinKeys, boolean useTableIdentity) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.leftCols.length; ++i) {
            indices.add(i);
        }
        if (needSortJoinKeys) {
            indices.sort((i1, i2) -> this.leftCols[i1].getName().compareTo(this.leftCols[i2].getName()));
        }
        return "Edge: " + (useTableIdentity ? this.join.getFKSide().getTableIdentity() : this.join.getFKSide()) + this.getJoinTypeStr() + (useTableIdentity ? this.join.getPKSide().getTableIdentity() : this.join.getPKSide()) + " ON " + Arrays.toString(indices.stream().map(idx -> this.leftCols[idx].getName()).toArray()) + " = " + Arrays.toString(indices.stream().map(idx -> this.rightCols[idx].getName()).toArray());
    }

    private String getJoinTypeStr() {
        if (this.isLeftJoin()) {
            return " LEFT JOIN ";
        }
        return this.isLeftOrInnerJoin() ? " LEFT OR INNER JOIN " : " INNER JOIN ";
    }

    @Generated
    public void setJoinEdgeMatcher(IJoinEdgeMatcher joinEdgeMatcher) {
        this.joinEdgeMatcher = joinEdgeMatcher;
    }

    @Generated
    public void setSwapJoin(boolean swapJoin) {
        this.swapJoin = swapJoin;
    }

    @Generated
    public boolean isSwapJoin() {
        return this.swapJoin;
    }
}

