/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.AutoMergeTimeEnum;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISegmentAdvisor;
import org.apache.kylin.metadata.model.RetentionRange;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.VolatileRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Segments<T extends ISegment>
extends ArrayList<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Segments.class);

    public static ISegmentAdvisor newSegmentAdvisor(ISegment seg) {
        try {
            Class clz = ClassUtil.forName((String)seg.getConfig().getSegmentAdvisor(), ISegmentAdvisor.class);
            return (ISegmentAdvisor)clz.getConstructor(ISegment.class).newInstance(seg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Segments() {
    }

    public Segments(List<T> copy) {
        super(copy);
    }

    public static List<SegmentRange> getSplitedSegRanges(SegmentRange rangeToSplit, List<AutoMergeTimeEnum> autoMergeTimeRanges, VolatileRange volatileRange) {
        ArrayList result = Lists.newArrayList();
        if (rangeToSplit == null) {
            return null;
        }
        Pair<SegmentRange, List<SegmentRange>> volatileResult = Segments.splitVolatileRanges(rangeToSplit, volatileRange);
        if (volatileResult != null) {
            result.addAll((Collection)volatileResult.getSecond());
            rangeToSplit = (SegmentRange)volatileResult.getFirst();
        }
        List<AutoMergeTimeEnum> sortedTimeRanges = Segments.sortTimeRangesDesc(autoMergeTimeRanges);
        for (int i = 0; i < sortedTimeRanges.size(); ++i) {
            List<SegmentRange> splitedRanges = Segments.splitSegRange(rangeToSplit, sortedTimeRanges.get(i));
            int size = splitedRanges.size();
            SegmentRange lastRange = splitedRanges.get(size - 1);
            if (i == sortedTimeRanges.size() - 1) {
                result.addAll(splitedRanges);
                break;
            }
            if (splitedRanges.size() > 1) {
                if (Long.parseLong(rangeToSplit.end.toString()) == Segments.getMergeEnd(Long.parseLong(lastRange.start.toString()), sortedTimeRanges.get(i))) {
                    result.addAll(splitedRanges);
                    break;
                }
                result.addAll(splitedRanges.subList(0, size - 1));
            }
            rangeToSplit = lastRange;
        }
        Collections.sort(result);
        return result;
    }

    private static List<SegmentRange> splitSegRange(SegmentRange range, AutoMergeTimeEnum autoMergeTimeRange) {
        long mergeEnd;
        ArrayList result = Lists.newArrayList();
        long start = Long.parseLong(range.start.toString());
        long end = Long.parseLong(range.end.toString());
        do {
            mergeEnd = Segments.getMergeEnd(start, autoMergeTimeRange);
            result.add(new SegmentRange.TimePartitionedSegmentRange(start, Long.min(end, mergeEnd)));
        } while ((start = mergeEnd) < end);
        return result;
    }

    @VisibleForTesting
    public static Pair<SegmentRange, List<SegmentRange>> splitVolatileRanges(SegmentRange rangeToSplit, VolatileRange volatileRange) {
        Pair result = new Pair();
        ArrayList volatileRanges = Lists.newArrayList();
        if (!volatileRange.isVolatileRangeEnabled() || volatileRange.getVolatileRangeNumber() <= 0L) {
            return null;
        }
        int i = 0;
        while ((long)i < volatileRange.getVolatileRangeNumber()) {
            long ms = Segments.getMillisecondByType(Long.parseLong(rangeToSplit.getEnd().toString()), volatileRange.getVolatileRangeType(), -1L);
            long rangeLength = Long.parseLong(rangeToSplit.getEnd().toString()) - Long.parseLong(rangeToSplit.getStart().toString());
            if (rangeLength <= ms) {
                volatileRanges.add(rangeToSplit);
                break;
            }
            long end = Long.parseLong(rangeToSplit.getEnd().toString());
            long start = Long.parseLong(rangeToSplit.getStart().toString());
            volatileRanges.add(new SegmentRange.TimePartitionedSegmentRange(end - ms, end));
            rangeToSplit = new SegmentRange.TimePartitionedSegmentRange(start, end - ms);
            ++i;
        }
        result.setFirst((Object)rangeToSplit);
        result.setSecond((Object)volatileRanges);
        return result;
    }

    public static Segments<NDataSegment> empty() {
        return new Segments<NDataSegment>();
    }

    public T getFirstSegment() {
        if (this.size() == 0) {
            return null;
        }
        return (T)((ISegment)this.get(0));
    }

    public T getLastSegment() {
        if (this.size() == 0) {
            return null;
        }
        return (T)((ISegment)this.get(this.size() - 1));
    }

    public long getTSStart() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        long startTime = Long.MAX_VALUE;
        for (ISegment seg : readySegs) {
            startTime = Math.min(startTime, seg.getTSRange().start);
        }
        return startTime;
    }

    public long getTSEnd() {
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        long endTime = Long.MIN_VALUE;
        for (ISegment seg : readySegs) {
            endTime = Math.max(endTime, seg.getTSRange().end);
        }
        return endTime;
    }

    public T getLatestReadySegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getStatus() != SegmentStatusEnum.READY && seg.getStatus() != SegmentStatusEnum.WARNING) continue;
            if (seg.getSegRange() instanceof SegmentRange.TimePartitionedSegmentRange) {
                if (latest != null && latest.getTSRange().end >= seg.getTSRange().end) continue;
                latest = seg;
                continue;
            }
            if (!seg.isOffsetCube() || latest != null && (Long)latest.getKSRange().end >= (Long)seg.getKSRange().end) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public T getLatestBuiltSegment() {
        ISegment latest = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            ISegment seg = (ISegment)this.get(i);
            if (seg.getLastBuildTime() <= 0L || latest != null && seg.getLastBuildTime() <= latest.getLastBuildTime()) continue;
            latest = seg;
        }
        return (T)latest;
    }

    public Segments<T> getSegments(SegmentStatusEnum ... statuslst) {
        Segments<T> result = new Segments<T>();
        block0: for (ISegment segment : this) {
            for (SegmentStatusEnum status : statuslst) {
                if (segment.getStatus() != status) continue;
                result.add(segment);
                continue block0;
            }
        }
        return result;
    }

    public T getSegment(String name, SegmentStatusEnum status) {
        for (ISegment segment : this) {
            if (null == segment.getName() || !segment.getName().equals(name) || status != null && segment.getStatus() != status) continue;
            return (T)segment;
        }
        return null;
    }

    public Segments<T> getBuildingSegments() {
        Segments<T> buildingSegments = new Segments<T>();
        for (ISegment segment : this) {
            if (SegmentStatusEnum.NEW != segment.getStatus()) continue;
            buildingSegments.add(segment);
        }
        return buildingSegments;
    }

    public Segments<T> getMergingSegments(T mergedSegment) {
        Segments<T> result = new Segments<T>();
        if (mergedSegment == null) {
            return result;
        }
        for (ISegment seg : this) {
            if (seg.getStatus() != SegmentStatusEnum.READY && seg.getStatus() != SegmentStatusEnum.WARNING || seg == mergedSegment || !mergedSegment.getSegRange().contains(seg.getSegRange())) continue;
            result.add(seg);
        }
        return result;
    }

    public SegmentRange autoMergeSegments(SegmentConfig segmentConfig) {
        VolatileRange volatileRange = segmentConfig.getVolatileRange();
        RetentionRange retentionRange = segmentConfig.getRetentionRange();
        List<AutoMergeTimeEnum> autoMergeTimeEnums = segmentConfig.getAutoMergeTimeRanges();
        if (segmentConfig.canSkipAutoMerge()) {
            return null;
        }
        Segments<T> readySegs = this.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        if (retentionRange.isRetentionRangeEnabled() && retentionRange.getRetentionRangeNumber() > 0L && retentionRange.getRetentionRangeType() != null) {
            this.removeSegmentsByRetention(readySegs, retentionRange);
        }
        if (volatileRange.isVolatileRangeEnabled()) {
            this.removeSegmentsByVolatileRange(readySegs, volatileRange);
        }
        Segments<T> segsOverlapsWithBuilding = new Segments<T>();
        for (ISegment buildingSeg : this.getBuildingSegments()) {
            for (ISegment readySeg : readySegs) {
                if (!buildingSeg.getSegRange().overlaps(readySeg.getSegRange())) continue;
                segsOverlapsWithBuilding.add(readySeg);
            }
        }
        readySegs.removeAll(segsOverlapsWithBuilding);
        if (readySegs.size() < 2) {
            return null;
        }
        List<AutoMergeTimeEnum> sortedAutoMergeTimeEnums = Segments.sortTimeRangesDesc(autoMergeTimeEnums);
        for (int i = 0; i < sortedAutoMergeTimeEnums.size(); ++i) {
            AutoMergeTimeEnum autoMergeTimeEnum = sortedAutoMergeTimeEnums.get(i);
            SegmentRange segmentRangeToMerge = readySegs.findMergeSegmentsRange(autoMergeTimeEnum);
            if (segmentRangeToMerge == null) continue;
            return segmentRangeToMerge;
        }
        return null;
    }

    private void removeSegmentsByRetention(Segments<T> readySegs, RetentionRange retentionRange) {
        SegmentRange range = this.getSegmentRangeToRemove(retentionRange.getRetentionRangeType(), retentionRange.getRetentionRangeNumber());
        if (range == null) {
            return;
        }
        Segments<T> segsToRemove = readySegs.getSegmentsByRange(range);
        readySegs.removeAll(segsToRemove);
    }

    public static long getMergeEnd(long start, AutoMergeTimeEnum autoMergeTimeEnum) {
        TimeZone zone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(zone, Locale.getDefault());
        calendar.setTimeZone(zone);
        calendar.setTimeInMillis(start);
        int month = calendar.get(2);
        String weekFirstDay = KylinConfig.getInstanceFromEnv().getFirstDayOfWeek();
        switch (autoMergeTimeEnum) {
            case HOUR: {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.add(11, 1);
                break;
            }
            case DAY: {
                calendar.add(5, 1);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(11, 0);
                break;
            }
            case WEEK: {
                if (weekFirstDay.equalsIgnoreCase("monday")) {
                    if (calendar.get(7) != 1) {
                        calendar.add(4, 1);
                    }
                    calendar.set(7, 2);
                } else {
                    calendar.add(4, 1);
                    calendar.set(7, 1);
                }
                if (calendar.get(2) > month) {
                    calendar.set(5, 1);
                }
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(11, 0);
                break;
            }
            case MONTH: {
                calendar.set(5, 1);
                calendar.add(2, 1);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(11, 0);
                break;
            }
            case QUARTER: {
                calendar.set(5, 1);
                calendar.set(2, month / 3 * 3);
                calendar.add(2, 3);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(11, 0);
                break;
            }
            case YEAR: {
                calendar.set(5, 1);
                calendar.set(2, 0);
                calendar.add(1, 1);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(11, 0);
                break;
            }
        }
        return calendar.getTimeInMillis();
    }

    private static List<AutoMergeTimeEnum> sortTimeRangesDesc(List<AutoMergeTimeEnum> autoMergeTimeEnums) {
        return autoMergeTimeEnums.stream().sorted(new Comparator<AutoMergeTimeEnum>(){

            @Override
            public int compare(AutoMergeTimeEnum o1, AutoMergeTimeEnum o2) {
                return o1.getCode() < o2.getCode() ? 1 : -1;
            }
        }).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static long getMillisecondByType(long latestSegEnd, AutoMergeTimeEnum autoMergeTimeEnum, long offset) {
        TimeZone zone = TimeZone.getDefault();
        Calendar calendar = Calendar.getInstance(zone, Locale.getDefault());
        calendar.setTimeZone(zone);
        calendar.setTimeInMillis(latestSegEnd);
        int plusNum = (int)offset;
        switch (autoMergeTimeEnum) {
            case HOUR: {
                calendar.add(11, plusNum);
                break;
            }
            case DAY: {
                calendar.add(5, plusNum);
                break;
            }
            case WEEK: {
                calendar.add(4, plusNum);
                break;
            }
            case MONTH: {
                calendar.add(2, plusNum);
                break;
            }
            case YEAR: {
                calendar.add(1, plusNum);
                break;
            }
        }
        return latestSegEnd - calendar.getTimeInMillis() > 0L ? latestSegEnd - calendar.getTimeInMillis() : 0L;
    }

    public void removeSegmentsByVolatileRange(Segments<T> segs, VolatileRange volatileRange) {
        if (volatileRange.getVolatileRangeNumber() <= 0L || volatileRange.getVolatileRangeType() == null) {
            return;
        }
        Long latestSegEnd = Long.parseLong(super.getLast().getSegRange().getEnd().toString());
        Segments<T> volatileSegs = new Segments<T>();
        long volatileTime = Segments.getMillisecondByType(latestSegEnd, volatileRange.getVolatileRangeType(), 0L - volatileRange.getVolatileRangeNumber());
        if (volatileTime > 0L) {
            for (ISegment seg : segs) {
                if (Long.parseLong(seg.getSegRange().getEnd().toString()) + volatileTime <= latestSegEnd) continue;
                volatileSegs.add(seg);
            }
        }
        segs.removeAll(volatileSegs);
    }

    public void replace(Comparator<T> comparator, T seg) {
        for (int i = 0; i < this.size(); ++i) {
            if (comparator.compare(this.get(i), seg) != 0) continue;
            this.set(i, seg);
            break;
        }
    }

    public SegmentRange findMergeSegmentsRange(AutoMergeTimeEnum autoMergeTimeEnum) {
        SegmentRange rangeToMerge = null;
        Segments<T> segmentsToMerge = new Segments<T>();
        for (ISegment seg : this) {
            SegmentRange segmentRange = seg.getSegRange();
            if (rangeToMerge != null && segmentRange.getEnd().compareTo(rangeToMerge.getEnd()) > 0) {
                if (segmentsToMerge.size() > 1 && (super.getLast().getSegRange().connects(segmentRange) || super.getLast().getSegRange().getEnd().compareTo(rangeToMerge.getEnd()) == 0)) break;
                rangeToMerge = null;
                segmentsToMerge.clear();
            }
            if (rangeToMerge == null) {
                long mergeStart = Long.parseLong(segmentRange.start.toString());
                rangeToMerge = new SegmentRange.TimePartitionedSegmentRange(mergeStart, Segments.getMergeEnd(mergeStart, autoMergeTimeEnum));
            }
            if (this.getLast().getSegRange().getEnd().compareTo(rangeToMerge.getEnd()) < 0) {
                return null;
            }
            if (segmentRange.getEnd().compareTo(rangeToMerge.getEnd()) <= 0 && (segmentsToMerge.isEmpty() || super.getLast().getSegRange().connects(segmentRange))) {
                segmentsToMerge.add(seg);
                continue;
            }
            rangeToMerge = null;
            segmentsToMerge.clear();
        }
        if (segmentsToMerge.size() < 2) {
            return null;
        }
        return super.getFirst().getSegRange().coverWith(super.getLast().getSegRange());
    }

    public Segments<T> calculateToBeSegments(T newSegment) {
        Segments tobe = (Segments)this.clone();
        if (newSegment != null && !tobe.contains(newSegment)) {
            tobe.add(newSegment);
        }
        if (tobe.size() == 0) {
            return tobe;
        }
        Collections.sort(tobe);
        T firstSeg = tobe.getFirst();
        firstSeg.validate();
        int i = 0;
        int j = 1;
        while (j < tobe.size()) {
            ISegment is = (ISegment)tobe.get(i);
            ISegment js = (ISegment)tobe.get(j);
            js.validate();
            if (!(this.isNew(is) || this.isReady(is) || this.isWarning(is))) {
                tobe.remove(i);
                continue;
            }
            if (!(this.isNew(js) || this.isReady(js) || this.isWarning(js))) {
                tobe.remove(j);
                continue;
            }
            if (is.getSegRange().start.compareTo(js.getSegRange().start) == 0) {
                if (this.isReady(is) && this.isReady(js) || this.isNew(is) && this.isNew(js) || this.isWarning(is) && this.isWarning(js)) {
                    if (is.getSegRange().end.compareTo(js.getSegRange().end) <= 0) {
                        tobe.remove(i);
                        continue;
                    }
                    tobe.remove(j);
                    continue;
                }
                if (this.isNew(is) && is.equals(newSegment)) {
                    tobe.remove(j);
                    continue;
                }
                if (js.equals(newSegment)) {
                    tobe.remove(i);
                    continue;
                }
            }
            if (is.getSegRange().end.compareTo(js.getSegRange().start) <= 0) {
                ++i;
                ++j;
                continue;
            }
            if (is.equals(newSegment)) {
                tobe.remove(j);
                continue;
            }
            ++i;
            ++j;
        }
        return tobe;
    }

    private boolean isWarning(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.WARNING;
    }

    private boolean isReady(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.READY;
    }

    private boolean isNew(ISegment seg) {
        return seg.getStatus() == SegmentStatusEnum.NEW;
    }

    @Override
    private T getLast() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(this.size() - 1));
    }

    @Override
    private T getFirst() {
        assert (this.size() != 0);
        return (T)((ISegment)this.get(0));
    }

    private Segments<T> getSubList(int from, int to) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this.subList(from, to)) {
            result.add(seg);
        }
        return result;
    }

    public void validate() {
        if (this.isEmpty()) {
            return;
        }
        Segments<T> all = new Segments<T>(this);
        Collections.sort(all);
        boolean isOffsetCube = ((ISegment)all.get(0)).isOffsetCube();
        for (ISegment seg : all) {
            seg.validate();
            if (seg.isOffsetCube() == isOffsetCube) continue;
            throw new IllegalStateException("Inconsistent isOffsetsOn for segment " + seg);
        }
        Segments<T> ready = all.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        Segments<T> news = all.getSegments(SegmentStatusEnum.NEW);
        this.validateReadySegs(ready);
        this.validateNewSegs(ready, news);
    }

    private void validateReadySegs(Segments<T> ready) {
        ISegment pre = null;
        for (ISegment seg : ready) {
            if (seg.isOffsetCube()) continue;
            if (pre != null) {
                if (pre.getSegRange().overlaps(seg.getSegRange())) {
                    throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
                }
                if (pre.getSegRange().apartBefore(seg.getSegRange())) {
                    logger.info("Hole between adjacent READY segments " + pre + " and " + seg);
                }
            }
            pre = seg;
        }
    }

    private void validateNewSegs(Segments<T> ready, Segments<T> news) {
        ISegment pre = null;
        for (ISegment seg : news) {
            if (pre != null && !pre.isOffsetCube() && pre.getSegRange().overlaps(seg.getSegRange())) {
                throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
            }
            pre = seg;
            for (ISegment aReady : ready) {
                if (!seg.getSegRange().overlaps(aReady.getSegRange()) || seg.getSegRange().contains(aReady.getSegRange())) continue;
                throw new IllegalStateException("Segments overlap: " + aReady + " and " + seg);
            }
        }
    }

    private Pair<Boolean, Boolean> fitInSegments(ISegment newOne) {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        ISegment first = (ISegment)this.get(0);
        ISegment last = (ISegment)this.get(this.size() - 1);
        boolean startFit = false;
        boolean endFit = false;
        for (ISegment sss : this) {
            if (sss == newOne) continue;
            startFit = startFit || newOne.getSegRange().startStartMatch(sss.getSegRange()) || newOne.getSegRange().startEndMatch(sss.getSegRange());
            endFit = endFit || newOne.getSegRange().endEndMatch(sss.getSegRange()) || sss.getSegRange().startEndMatch(newOne.getSegRange());
        }
        if (!startFit && endFit && newOne == first) {
            startFit = true;
        }
        if (!endFit && startFit && newOne == last) {
            endFit = true;
        }
        return Pair.newPair((Object)startFit, (Object)endFit);
    }

    public boolean isOperative(ISegment seg) {
        if (seg.getStatus() != SegmentStatusEnum.READY) {
            return false;
        }
        for (ISegment other : this) {
            if (other == seg || !other.getSegRange().overlaps(seg.getSegRange())) continue;
            return false;
        }
        return true;
    }

    public static String makeSegmentName(SegmentRange segRange) {
        if (segRange == null || segRange.isInfinite()) {
            return "FULL_BUILD";
        }
        String proposedName = segRange.proposeSegmentName();
        if (proposedName != null) {
            return proposedName;
        }
        if (segRange instanceof SegmentRange.TimePartitionedSegmentRange) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault(Locale.Category.FORMAT));
            dateFormat.setTimeZone(TimeZone.getDefault());
            return dateFormat.format(segRange.getStart()) + "_" + dateFormat.format(segRange.getEnd());
        }
        return segRange.getStart() + "_" + segRange.getEnd();
    }

    public Segments<T> getSegmentsByRange(SegmentRange range) {
        Segments<T> result = new Segments<T>();
        for (ISegment seg : this) {
            if (!seg.getSegRange().overlaps(range)) continue;
            result.add(seg);
        }
        return result;
    }

    public Segments<T> getFlatSegments() {
        Segments<T> result = new Segments<T>(this);
        Segments<T> buildingSegs = result.getBuildingSegments();
        Segments<T> readySegs = result.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        block0: for (ISegment segment : readySegs) {
            for (ISegment buildingSeg : buildingSegs) {
                if (!segment.getSegRange().overlaps(buildingSeg.getSegRange())) continue;
                result.remove(segment);
                continue block0;
            }
        }
        return result;
    }

    public List<SegmentRange> getSegRanges() {
        ArrayList result = Lists.newArrayList();
        for (ISegment seg : this) {
            result.add(seg.getSegRange());
        }
        return result;
    }

    public Segments getSegmentsToRemoveByRetention(AutoMergeTimeEnum retentionRangeType, long retentionRangeNumber) {
        SegmentRange range = this.getSegmentRangeToRemove(retentionRangeType, retentionRangeNumber);
        if (range == null) {
            return null;
        }
        return this.getSegmentsByRangeContains(range);
    }

    public SegmentRange getSegmentRangeToRemove(AutoMergeTimeEnum retentionRangeType, long retentionRangeNumber) {
        long firstSegStart;
        long lastSegEnd = Long.parseLong(this.getLastSegment().getSegRange().getEnd().toString());
        long retentionEnd = Segments.getRetentionEnd(lastSegEnd, retentionRangeType, 0L - retentionRangeNumber);
        if (retentionEnd <= (firstSegStart = Long.parseLong(this.getFirstSegment().getSegRange().getStart().toString()))) {
            return null;
        }
        return new SegmentRange.TimePartitionedSegmentRange(firstSegStart, retentionEnd);
    }

    public static long getRetentionEnd(long time, AutoMergeTimeEnum autoMergeTimeEnum, long offset) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        calendar.setTimeInMillis(time);
        int plusNum = (int)offset;
        switch (autoMergeTimeEnum) {
            case HOUR: {
                calendar.add(11, plusNum);
                break;
            }
            case DAY: {
                calendar.add(5, plusNum);
                break;
            }
            case WEEK: {
                calendar.add(4, plusNum);
                break;
            }
            case MONTH: {
                calendar.add(2, plusNum);
                break;
            }
            case YEAR: {
                calendar.add(1, plusNum);
                break;
            }
        }
        return calendar.getTimeInMillis();
    }

    public Segments getSegmentsByRangeContains(SegmentRange range) {
        Segments<T> result = new Segments<T>();
        if (range != null) {
            for (ISegment seg : this) {
                if (!range.contains(seg.getSegRange())) continue;
                result.add(seg);
            }
        }
        return result;
    }
}

