/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.MissingRootPersistentEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.BadModelException;
import org.apache.kylin.metadata.model.BrokenReasonFilter;
import org.apache.kylin.metadata.model.Canvas;
import org.apache.kylin.metadata.model.ColumnStatusFilter;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnManager;
import org.apache.kylin.metadata.model.DataCheckDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.MultiPartitionKeyMappingImpl;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.NonEquiJoinCondition;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.graph.JoinsGraph;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataModel
extends RootPersistentEntity {
    private static final Logger logger = LoggerFactory.getLogger(NDataModel.class);
    public static final int MEASURE_ID_BASE = 100000;
    @VisibleForTesting
    private KylinConfig config;
    @JsonProperty(value="alias")
    private String alias;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="config_last_modifier")
    private String configLastModifier;
    @JsonProperty(value="config_last_modified")
    private long configLastModified;
    @JsonProperty(value="description")
    private String description = "";
    @JsonProperty(value="fact_table")
    private String rootFactTableName;
    @JsonProperty(value="fact_table_alias")
    private String rootFactTableAlias;
    @JsonProperty(value="management_type")
    private ManagementType managementType = ManagementType.MODEL_BASED;
    @JsonProperty(value="join_tables")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<JoinTableDesc> joinTables;
    @JsonProperty(value="filter_condition")
    private String filterCondition;
    @JsonProperty(value="partition_desc")
    private PartitionDesc partitionDesc;
    @JsonProperty(value="capacity")
    private RealizationCapacity capacity = RealizationCapacity.MEDIUM;
    @JsonProperty(value="segment_config")
    private SegmentConfig segmentConfig = new SegmentConfig();
    @JsonProperty(value="data_check_desc")
    private DataCheckDesc dataCheckDesc;
    @JsonProperty(value="semantic_version")
    private int semanticVersion;
    @JsonProperty(value="storage_type")
    private int storageType;
    @JsonProperty(value="model_type")
    private ModelType modelType;
    @JsonProperty(value="all_named_columns")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<NamedColumn> allNamedColumns = new ArrayList<NamedColumn>();
    @JsonProperty(value="all_measures")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<Measure> allMeasures = new ArrayList<Measure>();
    @JsonProperty(value="recommendations_count")
    private int recommendationsCount;
    @JsonProperty(value="computed_column_uuids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> computedColumnUuids = Lists.newArrayList();
    @JsonProperty(value="canvas")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Canvas canvas;
    @JsonProperty(value="broken_reason")
    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=BrokenReasonFilter.class)
    private BrokenReason brokenReason = BrokenReason.NULL;
    @JsonProperty(value="handled_after_broken")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean handledAfterBroken = false;
    @JsonProperty(value="multi_partition_desc")
    private MultiPartitionDesc multiPartitionDesc;
    @JsonProperty(value="multi_partition_key_mapping")
    private MultiPartitionKeyMappingImpl multiPartitionKeyMapping;
    @JsonProperty(value="fusion_id")
    private String fusionId;
    private ImmutableBiMap<Integer, TblColRef> effectiveCols;
    private ImmutableBiMap<Integer, TblColRef> effectiveDimensions;
    private ImmutableBiMap<Integer, Measure> effectiveMeasures;
    private Map<Integer, Collection<Integer>> effectiveExpandedMeasures;
    private List<TblColRef> mpCols;
    protected List<ComputedColumnDesc> computedColumnDescs = new ArrayList<ComputedColumnDesc>();
    private TableRef rootFactTableRef;
    private Set<TableRef> factTableRefs = Sets.newLinkedHashSet();
    private Set<TableRef> lookupTableRefs = Sets.newLinkedHashSet();
    private Set<TableRef> queryDerivedDisabledRefs = Sets.newLinkedHashSet();
    private Set<TableRef> allTableRefs = Sets.newLinkedHashSet();
    private Map<String, TableRef> aliasMap = Maps.newHashMap();
    private Map<String, TableRef> tableNameMap = Maps.newHashMap();
    private JoinsGraph joinsGraph;
    private boolean isSeekingCCAdvice = false;
    private boolean saveCheck = false;
    private DataStorageType dataStorageType;

    public NDataModel() {
    }

    public NDataModel(NDataModel other) {
        this.uuid = other.uuid;
        this.createTime = other.createTime;
        this.lastModified = other.lastModified;
        this.version = other.version;
        this.alias = other.alias;
        this.owner = other.owner;
        this.description = other.description;
        this.rootFactTableName = other.rootFactTableName;
        this.joinTables = other.joinTables;
        this.filterCondition = other.filterCondition;
        this.partitionDesc = other.partitionDesc;
        this.capacity = other.capacity;
        this.allNamedColumns = other.allNamedColumns;
        this.allMeasures = other.allMeasures;
        this.computedColumnUuids = other.computedColumnUuids;
        this.computedColumnDescs = other.computedColumnDescs;
        this.managementType = other.managementType;
        this.segmentConfig = other.segmentConfig;
        this.dataCheckDesc = other.dataCheckDesc;
        this.canvas = other.canvas;
        this.brokenReason = other.brokenReason;
        this.configLastModifier = other.configLastModifier;
        this.configLastModified = other.configLastModified;
        this.semanticVersion = other.semanticVersion;
        this.multiPartitionDesc = other.multiPartitionDesc;
        this.multiPartitionKeyMapping = other.multiPartitionKeyMapping;
        this.recommendationsCount = other.recommendationsCount;
        this.modelType = other.modelType;
        this.fusionId = other.fusionId;
        this.allTableRefs = other.allTableRefs;
        this.storageType = other.storageType;
        this.dataStorageType = other.dataStorageType;
    }

    public KylinConfig getConfig() {
        return this.config == null ? KylinConfig.getInstanceFromEnv() : this.config;
    }

    public String resourceName() {
        return this.uuid;
    }

    public MetadataType resourceType() {
        return MetadataType.MODEL;
    }

    public ManagementType getManagementType() {
        return this.managementType;
    }

    public void setManagementType(ManagementType managementType) {
        this.managementType = managementType;
    }

    public TableRef getRootFactTable() {
        return this.rootFactTableRef;
    }

    public ModelType getModelType() {
        if (this.modelType != null) {
            return this.modelType;
        }
        return this.getModelTypeFromTable();
    }

    public ModelType getModelTypeFromTable() {
        if (this.rootFactTableRef == null) {
            return ModelType.UNKNOWN;
        }
        KafkaConfig kafkaConfig = this.rootFactTableRef.getTableDesc().getKafkaConfig();
        if (kafkaConfig != null) {
            if (kafkaConfig.hasBatchTable()) {
                return ModelType.HYBRID;
            }
            return ModelType.STREAMING;
        }
        return ModelType.BATCH;
    }

    public Set<TableRef> getAllTables() {
        return this.allTableRefs;
    }

    public Set<TableRef> getFactTables() {
        return this.factTableRefs;
    }

    public Map<String, TableRef> getAliasMap() {
        return Collections.unmodifiableMap(this.aliasMap);
    }

    public void setAliasMap(Map<String, TableRef> aliasMap) {
        this.aliasMap.clear();
        this.aliasMap.putAll(aliasMap);
    }

    public Set<TableRef> getLookupTables() {
        return this.lookupTableRefs;
    }

    public List<JoinTableDesc> getJoinTables() {
        return this.joinTables;
    }

    public void setJoinTables(List<JoinTableDesc> joinTables) {
        this.joinTables = joinTables;
    }

    public JoinDesc getJoinByPKSide(Integer columnId) {
        return this.getJoinByPKSide(((TblColRef)this.effectiveCols.get((Object)columnId)).getTableRef());
    }

    public JoinDesc getJoinByPKSide(TableRef table) {
        return this.joinsGraph.getJoinByPKSide(table);
    }

    public JoinsGraph getJoinsGraph() {
        return this.joinsGraph;
    }

    public DataCheckDesc getDataCheckDesc() {
        if (this.dataCheckDesc == null) {
            return new DataCheckDesc();
        }
        return this.dataCheckDesc;
    }

    public void setDataCheckDesc(DataCheckDesc dataCheckDesc) {
        this.dataCheckDesc = dataCheckDesc;
    }

    public boolean isLookupTable(int columnId) {
        return this.isLookupTable(((TblColRef)this.effectiveCols.get((Object)columnId)).getTableRef());
    }

    public boolean isLookupTable(TableRef t) {
        if (t == null) {
            return false;
        }
        return this.lookupTableRefs.contains(t);
    }

    public boolean isQueryDerivedEnabled(int columnId) {
        TblColRef ref = (TblColRef)this.effectiveCols.get((Object)columnId);
        if (ref == null) {
            return false;
        }
        return !this.queryDerivedDisabledRefs.contains(ref.getTableRef());
    }

    public boolean isJoinTable(String fullTableName) {
        if (this.joinTables == null) {
            return false;
        }
        for (JoinTableDesc table : this.joinTables) {
            if (!table.getTable().equals(fullTableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isLookupTable(String fullTableName) {
        for (TableRef t : this.lookupTableRefs) {
            if (!t.getTableIdentity().equals(fullTableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isLookupTable(TableDesc tableDesc) {
        return this.isLookupTable(tableDesc.getIdentity());
    }

    public boolean isFactTable(TableRef t) {
        if (t == null) {
            return false;
        }
        return this.factTableRefs.contains(t);
    }

    public boolean isFactTable(String fullTableName) {
        for (TableRef t : this.factTableRefs) {
            if (!t.getTableIdentity().equals(fullTableName)) continue;
            return true;
        }
        return false;
    }

    public boolean isRootFactTable(TableDesc table) {
        if (table == null || StringUtils.isBlank((CharSequence)table.getIdentity()) || StringUtils.isBlank((CharSequence)table.getProject())) {
            return false;
        }
        return this.rootFactTableRef.getTableIdentity().equals(table.getIdentity()) && this.rootFactTableRef.getTableDesc().getProject().equals(table.getProject());
    }

    public boolean containsTable(TableDesc table) {
        if (table == null) {
            return false;
        }
        for (TableRef t : this.allTableRefs) {
            if (!t.getTableIdentity().equals(table.getIdentity()) || !StringUtils.equals((CharSequence)t.getTableDesc().getProject(), (CharSequence)table.getProject())) continue;
            return true;
        }
        return false;
    }

    public TblColRef findColumn(String table, String column) throws IllegalArgumentException {
        TableRef tableRef = this.findTable(table);
        TblColRef result = tableRef.getColumn(column.toUpperCase(Locale.ROOT));
        if (result == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getBadSqlColumnNotFoundReason(), table + "." + column));
        }
        return result;
    }

    public TblColRef findColumn(String column) throws IllegalArgumentException {
        TblColRef result = null;
        String input = column;
        int cut = (column = column.toUpperCase(Locale.ROOT)).lastIndexOf(46);
        if (cut > 0) {
            result = this.findColumn(column.substring(0, cut), column.substring(cut + 1));
        } else {
            TableRef tableRef;
            Iterator<TableRef> iterator = this.allTableRefs.iterator();
            while (iterator.hasNext() && (result = (tableRef = iterator.next()).getColumn(column)) == null) {
            }
        }
        if (result == null) {
            String msg = String.format(Locale.ROOT, MsgPicker.getMsg().getBadSqlColumnNotFoundReason(), input);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    public TblColRef findColumnByAlias(String column) {
        TblColRef result = null;
        column = column.toUpperCase(Locale.ROOT);
        int cut = column.lastIndexOf(46);
        String table = column.substring(0, cut);
        String col = column.substring(cut + 1);
        for (TableRef tableRef : this.allTableRefs) {
            if (tableRef.getAlias().equals(table)) {
                result = tableRef.getColumn(col);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public TableRef findTable(String table) {
        TableRef result = this.tableNameMap.get(table.toUpperCase(Locale.ROOT));
        if (result == null) {
            int endOfDatabaseName = table.indexOf(".");
            if (endOfDatabaseName > -1) {
                result = this.tableNameMap.get(table.substring(endOfDatabaseName + 1));
            }
            if (result == null) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), table));
            }
        }
        return result;
    }

    public TableRef findFirstTable(String tableIdentity) throws IllegalArgumentException {
        if (this.rootFactTableRef.getTableIdentity().equals(tableIdentity)) {
            return this.rootFactTableRef;
        }
        for (TableRef fact : this.factTableRefs) {
            if (!fact.getTableIdentity().equals(tableIdentity)) continue;
            return fact;
        }
        for (TableRef lookup : this.lookupTableRefs) {
            if (!lookup.getTableIdentity().equals(tableIdentity)) continue;
            return lookup;
        }
        throw new IllegalArgumentException("Table not found by " + tableIdentity + " in model " + this.uuid);
    }

    public void initJoinDesc(KylinConfig config, Map<String, TableDesc> tables) {
        this.config = config;
        this.initJoinTablesForUpgrade();
        this.initTableAlias(tables);
        this.initJoinColumns();
    }

    public void init(KylinConfig config) {
        this.config = config;
        this.bindComputedColumns();
        Map<String, TableDesc> tables = this.getExtendedTables(NDataModelManager.getRelatedTables(this, this.project));
        this.initJoinTablesForUpgrade();
        this.initTableAlias(tables);
        this.initJoinColumns();
        this.reorderJoins(tables);
        this.initJoinsGraph();
        this.initPartitionDesc();
        this.initMultiPartition();
        this.initMultiPartitionKeyMapping();
        this.initFilterCondition();
        if (StringUtils.isEmpty((CharSequence)this.alias)) {
            this.alias = this.uuid;
        }
        this.dataStorageType = DataStorageType.fromValue(this.storageType);
        this.checkModelType();
    }

    private void initJoinTablesForUpgrade() {
        if (this.joinTables == null) {
            this.joinTables = Lists.newArrayList();
        }
    }

    private void initTableAlias(Map<String, TableDesc> tables) {
        this.factTableRefs.clear();
        this.lookupTableRefs.clear();
        this.allTableRefs.clear();
        this.queryDerivedDisabledRefs.clear();
        this.aliasMap.clear();
        this.tableNameMap.clear();
        if (StringUtils.isEmpty((CharSequence)this.rootFactTableName)) {
            throw new IllegalStateException("root fact table should not be empty");
        }
        this.rootFactTableName = this.rootFactTableName.toUpperCase(Locale.ROOT);
        if (!tables.containsKey(this.rootFactTableName)) {
            throw new IllegalStateException("Root fact table does not exist:" + this.rootFactTableName);
        }
        TableDesc rootDesc = tables.get(this.rootFactTableName);
        this.rootFactTableRef = new TableRef(this, rootDesc.getName(), rootDesc, false);
        this.addAlias(this.rootFactTableRef);
        this.factTableRefs.add(this.rootFactTableRef);
        for (JoinTableDesc join : this.joinTables) {
            join.setTable(join.getTable().toUpperCase(Locale.ROOT));
            if (!tables.containsKey(join.getTable())) {
                throw new IllegalStateException("Join table does not exist:" + join.getTable());
            }
            TableDesc tableDesc = tables.get(join.getTable());
            String joinAlias = join.getAlias();
            if (joinAlias == null) {
                joinAlias = tableDesc.getName();
            }
            joinAlias = joinAlias.toUpperCase(Locale.ROOT);
            join.setAlias(joinAlias);
            boolean isLookup = join.getKind() == TableKind.LOOKUP;
            TableRef ref = new TableRef(this, joinAlias, tableDesc, isLookup);
            if (join.isDerivedForbidden()) {
                this.queryDerivedDisabledRefs.add(ref);
            }
            join.setTableRef(ref);
            this.addAlias(ref);
            (isLookup ? this.lookupTableRefs : this.factTableRefs).add(ref);
        }
        this.tableNameMap.putAll(this.aliasMap);
        this.allTableRefs.addAll(this.factTableRefs);
        this.allTableRefs.addAll(this.lookupTableRefs);
    }

    private void addAlias(TableRef ref) {
        String tableAlias = ref.getAlias();
        if (this.aliasMap.containsKey(tableAlias)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Alias '%s' ref to multiple tables: %s, %s", tableAlias, ref.getTableIdentity(), this.aliasMap.get(tableAlias).getTableIdentity()));
        }
        this.aliasMap.put(tableAlias, ref);
        TableDesc table = ref.getTableDesc();
        this.addTableName(table.getName(), ref);
        this.addTableName(table.getIdentity(), ref);
    }

    private void addTableName(String name, TableRef ref) {
        if (this.tableNameMap.containsKey(name)) {
            this.tableNameMap.put(name, null);
        } else {
            this.tableNameMap.put(name, ref);
        }
    }

    private void initPartitionDesc() {
        if (this.partitionDesc != null) {
            this.partitionDesc.init(this);
        }
    }

    private void initMultiPartition() {
        if (this.multiPartitionDesc != null) {
            this.multiPartitionDesc.init(this);
        }
    }

    private void initMultiPartitionKeyMapping() {
        if (this.multiPartitionKeyMapping != null) {
            this.multiPartitionKeyMapping.init(this);
        }
    }

    private void initFilterCondition() {
        if (null == this.filterCondition) {
            return;
        }
        int quotationType = 0;
        int len = this.filterCondition.length();
        for (int i = 0; i < len; ++i) {
            if (';' == this.filterCondition.charAt(i) && 0 == quotationType) {
                throw new IllegalStateException("Filter Condition is Illegal. Please check it and make sure it's an appropriate expression for WHERE clause");
            }
            if ('\'' == this.filterCondition.charAt(i)) {
                if (quotationType > 0) {
                    if (1 == quotationType) {
                        quotationType = 0;
                        continue;
                    }
                } else {
                    quotationType = 1;
                    continue;
                }
            }
            if ('\"' != this.filterCondition.charAt(i)) continue;
            if (quotationType > 0) {
                if (2 != quotationType) continue;
                quotationType = 0;
                continue;
            }
            quotationType = 2;
        }
    }

    private void initJoinColumns() {
        for (JoinTableDesc joinTable : this.joinTables) {
            int i;
            TableRef dimTable = joinTable.getTableRef();
            JoinDesc join = joinTable.getJoin();
            if (join == null) {
                throw new IllegalStateException("Missing join conditions on table " + dimTable);
            }
            StringHelper.toUpperCaseArray((String[])join.getForeignKey(), (String[])join.getForeignKey());
            StringHelper.toUpperCaseArray((String[])join.getPrimaryKey(), (String[])join.getPrimaryKey());
            Object[] pks = join.getPrimaryKey();
            TblColRef[] pkCols = new TblColRef[pks.length];
            for (int i2 = 0; i2 < pks.length; ++i2) {
                TblColRef col = dimTable.getColumn(pks[i2]);
                if (col == null) {
                    col = this.findColumn(pks[i2]);
                }
                if (col == null || !col.getTableRef().equals(dimTable)) {
                    throw new IllegalStateException("Can't find PK column " + pks[i2] + " in table " + dimTable);
                }
                pks[i2] = col.getIdentity();
                pkCols[i2] = col;
            }
            join.setPrimaryKeyColumns(pkCols);
            join.setPrimaryTableRef(dimTable);
            Object[] fks = join.getForeignKey();
            TblColRef[] fkCols = new TblColRef[fks.length];
            for (i = 0; i < fks.length; ++i) {
                TblColRef col = this.findColumn(fks[i]);
                if (col == null) {
                    throw new IllegalStateException("Can't find FK column " + fks[i]);
                }
                fks[i] = col.getIdentity();
                fkCols[i] = col;
            }
            join.setForeignKeyColumns(fkCols);
            if (join.getForeignTable() != null && this.findTable(join.getForeignTable()) != null) {
                join.setForeignTableRef(this.findTable(join.getForeignTable()));
            }
            this.initNonEquiCondition(join.getNonEquiJoinCondition());
            join.sortByFK();
            if (pkCols.length != fkCols.length) {
                throw new IllegalStateException("Primary keys(" + dimTable + ")" + Arrays.toString(pks) + " are not consistent with Foreign keys(" + join.getFKSide().getTableIdentity() + ") " + Arrays.toString(fks));
            }
            for (i = 0; i < fkCols.length; ++i) {
                if (fkCols[i].getDatatype().equals(pkCols[i].getDatatype())) continue;
                logger.warn("PK {}.{}.{} are not consistent with FK {}.{}.{}", new Object[]{dimTable, pkCols[i].getName(), pkCols[i].getDatatype(), join.getFKSide().getTableIdentity(), fkCols[i].getName(), fkCols[i].getDatatype()});
            }
        }
    }

    private void initNonEquiCondition(NonEquiJoinCondition cond) {
        if (cond == null) {
            return;
        }
        if (cond.getType() == NonEquiJoinCondition.Type.COLUMN) {
            cond.setColRef(this.findColumn(cond.getValue()));
        }
        if (cond.getOperands().length > 0) {
            for (NonEquiJoinCondition childInput : cond.getOperands()) {
                this.initNonEquiCondition(childInput);
            }
        }
    }

    private void initJoinsGraph() {
        ArrayList<JoinDesc> joins = new ArrayList<JoinDesc>();
        for (JoinTableDesc joinTable : this.joinTables) {
            joins.add(joinTable.getJoin());
        }
        this.joinsGraph = new JoinsGraph(this.rootFactTableRef, joins);
    }

    private void reorderJoins(Map<String, TableDesc> tables) {
        if (CollectionUtils.isEmpty(this.joinTables)) {
            return;
        }
        HashMap fkMap = Maps.newHashMap();
        for (JoinTableDesc joinTable : this.joinTables) {
            JoinDesc join = joinTable.getJoin();
            String fkSideName = join.getFKSide().getAlias();
            if (fkMap.containsKey(fkSideName)) {
                ((List)fkMap.get(fkSideName)).add(joinTable);
                continue;
            }
            ArrayList joinTableList = Lists.newArrayList();
            joinTableList.add(joinTable);
            fkMap.put(fkSideName, joinTableList);
        }
        List<JoinTableDesc> orderedJoinTables = Arrays.asList(new JoinTableDesc[this.joinTables.size()]);
        int orderedIndex = 0;
        ArrayDeque joinTableBuff = new ArrayDeque();
        TableDesc rootDesc = tables.get(this.rootFactTableName);
        joinTableBuff.addAll((Collection)fkMap.get(rootDesc.getName()));
        while (!joinTableBuff.isEmpty()) {
            JoinTableDesc head = (JoinTableDesc)joinTableBuff.poll();
            orderedJoinTables.set(orderedIndex++, head);
            String headAlias = head.getJoin().getPKSide().getAlias();
            if (!fkMap.containsKey(headAlias)) continue;
            joinTableBuff.addAll((Collection)fkMap.get(headAlias));
        }
        this.joinTables = orderedJoinTables;
    }

    private void checkModelType() {
        ModelType modelTypeFromTable = this.getModelTypeFromTable();
        if (this.modelType != null && this.modelType != modelTypeFromTable) {
            throw new IllegalStateException("Model Type is inconsistent.");
        }
    }

    public String toString() {
        return "NDataModel [" + this.getAlias() + "]";
    }

    public ProjectInstance getProjectInstance() {
        return NProjectManager.getInstance(this.getConfig()).getProject(this.project);
    }

    public String getProject() {
        return this.project;
    }

    public Map<String, TableDesc> getExtendedTables(Map<String, TableDesc> originalTables) {
        HashMap tables = Maps.newHashMap();
        for (Map.Entry<String, TableDesc> entry : originalTables.entrySet()) {
            String s = entry.getKey();
            TableDesc tableDesc = entry.getValue();
            if (tableDesc == null) continue;
            TableDesc extendedTableDesc = tableDesc.appendColumns(ComputedColumnUtil.createComputedColumns(this.computedColumnDescs, tableDesc), true);
            tables.put(s, extendedTableDesc);
        }
        return tables;
    }

    public void init(KylinConfig config, String project, List<NDataModel> ccRelatedModels) {
        this.init(config, project, ccRelatedModels, false);
    }

    public void init(KylinConfig config, String project, List<NDataModel> ccRelatedModels, boolean saveCheck) {
        this.project = project;
        this.saveCheck = saveCheck;
        this.init(config);
        this.initComputedColumnsFailFast(ccRelatedModels);
        this.effectiveCols = this.initAllNamedColumns(NamedColumn::isExist);
        this.effectiveDimensions = this.initAllNamedColumns(NamedColumn::isDimension);
        this.initAllMeasures();
        this.checkSingleIncrementingLoadingTable();
        this.setDependencies(this.calcDependencies());
        this.keepColumnOrder();
        this.keepMeasureOrder();
        Set lookups = this.getJoinTables().stream().filter(joinTableDesc -> joinTableDesc.getKind() == TableKind.LOOKUP).map(JoinTableDesc::getTable).collect(Collectors.toSet());
        if (lookups.contains(this.getRootFactTableName())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_JOIN_RELATIONSHIP_ERROR, MsgPicker.getMsg().getDimensionTableUsedInThisModel());
        }
    }

    public ComputedColumnUtil.CCConflictInfo checkCCFailAtEnd(KylinConfig config, String project, List<NDataModel> ccRelatedModels, boolean saveCheck) {
        this.project = project;
        this.saveCheck = saveCheck;
        this.init(config);
        return this.initComputedColumnsFailAtEnd(ccRelatedModels);
    }

    public void keepColumnOrder() {
        this.allNamedColumns.sort(Comparator.comparing(NamedColumn::getId));
    }

    public void keepMeasureOrder() {
        this.allMeasures.sort(Comparator.comparing(Measure::getId));
    }

    public List<RootPersistentEntity> calcDependencies() {
        HashSet dependTables = Sets.newHashSet();
        dependTables.add(this.getRootFactTableName());
        dependTables.addAll(this.getJoinTables().stream().map(JoinTableDesc::getTable).collect(Collectors.toList()));
        return dependTables.stream().filter(Objects::nonNull).map(t -> {
            TableDesc tableDesc = NTableMetadataManager.getInstance(this.config, this.project).getTableDesc((String)t);
            return tableDesc != null ? tableDesc : new MissingRootPersistentEntity(MetadataType.mergeKeyWithType((String)TableDesc.generateResourceName(this.project, t), (MetadataType)MetadataType.TABLE_INFO));
        }).collect(Collectors.toList());
    }

    public boolean isIncrementBuildOnExpertMode() {
        return !PartitionDesc.isEmptyPartitionDesc(this.getPartitionDesc()) && !StringUtils.isEmpty((CharSequence)this.partitionDesc.getPartitionDateFormat());
    }

    public void checkSingleIncrementingLoadingTable() {
        if (this.getJoinTables() == null) {
            return;
        }
        for (JoinTableDesc table : this.getJoinTables()) {
            if (table.getTableRef() == null || !table.getTableRef().getTableDesc().isIncrementLoading()) continue;
            throw new IllegalStateException("Only one incremental loading table can be set in model!");
        }
    }

    private ImmutableBiMap<Integer, TblColRef> initAllNamedColumns(Predicate<NamedColumn> filter) {
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (NamedColumn d : this.allNamedColumns) {
            if (!d.isExist()) continue;
            TblColRef col = this.findColumn(d.aliasDotColumn);
            d.aliasDotColumn = col.getIdentity();
            if (!filter.test(d)) continue;
            mapBuilder.put((Object)d.id, (Object)col);
        }
        ImmutableBiMap cols = mapBuilder.build();
        this.checkNoDup(cols);
        return cols;
    }

    private <T> void checkNoDup(ImmutableBiMap<Integer, T> idMap) {
        HashMap reverseMap = new HashMap();
        for (Map.Entry e : idMap.entrySet()) {
            int id = (Integer)e.getKey();
            Object value = e.getValue();
            if (reverseMap.containsKey(value)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Illegal model '%d', %s has duplicated ID: %s and %d", id, value, reverseMap.get(value), id));
            }
            reverseMap.put(value, id);
        }
    }

    private void initAllMeasures() {
        this.effectiveExpandedMeasures = new HashMap<Integer, Collection<Integer>>();
        ImmutableBiMap.Builder mapBuilder = ImmutableBiMap.builder();
        for (Measure measure : this.allMeasures) {
            try {
                measure.setName(measure.getName());
                if (measure.tomb) continue;
                mapBuilder.put((Object)measure.id, (Object)measure);
                FunctionDesc func = measure.getFunction();
                func.init(this);
                if (measure.getType() != MeasureType.EXPANDABLE) continue;
                this.effectiveExpandedMeasures.put(measure.getId(), measure.getInternalIds());
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_UPDATE_MODEL, MsgPicker.getMsg().getInitMeasureFailed(), (Throwable)e);
            }
        }
        this.effectiveMeasures = mapBuilder.build();
        this.checkNoDupAndEffective(this.effectiveMeasures);
    }

    private void checkNoDupAndEffective(ImmutableBiMap<Integer, Measure> effectiveMeasures) {
        this.checkNoDup(effectiveMeasures);
        int countNum = 0;
        for (MeasureDesc m : effectiveMeasures.values()) {
            if (!m.getFunction().isCountConstant()) continue;
            ++countNum;
        }
        if (countNum != 1) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Illegal model '%s', should have one and only one COUNT() measure but there are %d", this.uuid, countNum));
        }
        for (MeasureDesc m : effectiveMeasures.values()) {
            List<TblColRef> mCols = m.getFunction().getColRefs();
            if (this.effectiveCols.values().containsAll(mCols)) continue;
            ArrayList<TblColRef> notEffective = new ArrayList<TblColRef>(mCols);
            notEffective.removeAll((Collection<?>)this.effectiveCols.values());
            throw new IllegalStateException(String.format(Locale.ROOT, "Illegal model '%s', some columns referenced in %s is not on model: %s", this.uuid, m, notEffective));
        }
    }

    public TblColRef getColRef(Integer colId) {
        return (TblColRef)this.effectiveCols.get((Object)colId);
    }

    public TblColRef getColRef(String columnName) {
        return this.getColRef(this.getColumnIdByColumnName(columnName));
    }

    public void initComputedColumnsFailFast(List<NDataModel> ccRelatedModels) {
        this.initComputedColumns(ccRelatedModels);
        this.checkCCConflict(ccRelatedModels, new ComputedColumnUtil.DefaultCCConflictHandler());
    }

    public void bindComputedColumns() {
        if (this.computedColumnDescs.isEmpty() && !this.computedColumnUuids.isEmpty()) {
            ComputedColumnManager ccManager = (ComputedColumnManager)this.getConfig().getManager(this.project, ComputedColumnManager.class);
            this.computedColumnDescs = this.computedColumnUuids.stream().map(ccUuid -> (ComputedColumnDesc)ccManager.get((String)ccUuid).orElseThrow(() -> new IllegalStateException("CC " + ccUuid + " lost for model: " + this.alias))).collect(Collectors.toList());
        }
    }

    public ComputedColumnUtil.CCConflictInfo initComputedColumnsFailAtEnd(List<NDataModel> ccRelatedModels) {
        this.initComputedColumns(ccRelatedModels);
        ComputedColumnUtil.CCConflictInfo ccConflictInfo = new ComputedColumnUtil.CCConflictInfo();
        ComputedColumnUtil.AdjustCCConflictHandler handler = new ComputedColumnUtil.AdjustCCConflictHandler(ccConflictInfo);
        this.checkCCConflict(ccRelatedModels, handler);
        return ccConflictInfo;
    }

    private void initComputedColumns(List<NDataModel> ccRelatedModels) {
        Preconditions.checkNotNull(ccRelatedModels);
        for (ComputedColumnDesc newCC : this.computedColumnDescs) {
            newCC.init(this, this.getRootFactTable().getAlias());
        }
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)System.getProperty("needCheckCC"))) {
            return;
        }
        for (ComputedColumnDesc newCC : this.computedColumnDescs) {
            Set<String> usedAliasSet = CalciteParser.getUsedAliasSet(newCC.getExpression());
            if (this.isSeekingCCAdvice() || usedAliasSet.contains(newCC.getTableAlias()) || newCC.getTableAlias().equals(this.getRootFactTable().getAlias())) continue;
            throw new BadModelException("A computed column should be defined on root fact table if its expression is not referring its hosting alias table, cc: " + newCC.getFullName(), BadModelException.CauseType.LOOKUP_CC_NOT_REFERENCING_ITSELF, null, null, newCC.getFullName());
        }
        this.checkCCExprHealth();
    }

    private void checkCCConflict(List<NDataModel> ccRelatedModels, ComputedColumnUtil.CCConflictHandler handler) {
        if (!StringUtils.equals((CharSequence)"true", (CharSequence)System.getProperty("needCheckCC"))) {
            return;
        }
        if (this.config.validateComputedColumn()) {
            this.selfCCConflictCheck(handler);
            this.crossCCConflictCheck(ccRelatedModels, handler);
        }
    }

    private void checkCCExprHealth() {
        for (ComputedColumnDesc ccDesc : this.computedColumnDescs) {
            Set<String> ccUsedCols = ComputedColumnUtil.getCCUsedColsWithModel(this, ccDesc);
            for (String tblCol : ccUsedCols) {
                String table = tblCol.substring(0, tblCol.lastIndexOf("."));
                String column = tblCol.substring(tblCol.lastIndexOf(".") + 1);
                TableRef tableRef = this.findFirstTable(table);
                TblColRef col = tableRef.getColumn(column);
                if (col != null) continue;
                throw new IllegalArgumentException("Computed Column " + ccDesc.getColumnName() + " use nonexistent column(s): " + tblCol);
            }
        }
    }

    private void selfCCConflictCheck(ComputedColumnUtil.CCConflictHandler handler) {
        int ccCount = this.computedColumnDescs.size();
        for (int i = 1; i < ccCount; ++i) {
            for (int j = 0; j < i; ++j) {
                ComputedColumnDesc a = this.computedColumnDescs.get(i);
                ComputedColumnDesc b = this.computedColumnDescs.get(j);
                ComputedColumnUtil.singleCCConflictCheck(this, this, b, a, handler);
            }
        }
    }

    private void crossCCConflictCheck(List<NDataModel> ccRelatedModels, ComputedColumnUtil.CCConflictHandler handler) {
        ArrayList existingCCs = Lists.newArrayList();
        for (NDataModel otherModel : ccRelatedModels) {
            if (StringUtils.equals((CharSequence)otherModel.getUuid(), (CharSequence)this.getUuid())) continue;
            for (ComputedColumnDesc cc : otherModel.getComputedColumnDescs()) {
                existingCCs.add(Pair.newPair((Object)cc, (Object)((Object)otherModel)));
            }
        }
        for (ComputedColumnDesc newCC : this.computedColumnDescs) {
            for (Pair pair : existingCCs) {
                NDataModel existingModel = (NDataModel)((Object)pair.getSecond());
                ComputedColumnDesc existingCC = (ComputedColumnDesc)pair.getFirst();
                ComputedColumnUtil.singleCCConflictCheck(existingModel, this, existingCC, newCC, handler);
            }
        }
    }

    public ComputedColumnDesc findCCByCCColumnName(String columnName) {
        return this.computedColumnDescs.stream().filter(input -> {
            Preconditions.checkNotNull((Object)input);
            return columnName.equals(input.getColumnName());
        }).findFirst().orElse(null);
    }

    public String getAlias() {
        if (StringUtils.isEmpty((CharSequence)this.alias)) {
            return this.uuid;
        }
        return this.alias;
    }

    public String getRawAlias() {
        return this.alias;
    }

    public Set<String> getComputedColumnNames() {
        HashSet ccColumnNames = Sets.newHashSet();
        for (ComputedColumnDesc cc : this.getComputedColumnDescs()) {
            ccColumnNames.add(cc.getColumnName());
        }
        return Collections.unmodifiableSet(ccColumnNames);
    }

    public Map<String, ComputedColumnDesc> getCcMap() {
        HashMap ccMap = Maps.newHashMap();
        this.getComputedColumnDescs().forEach(cc -> {
            String aliasDotName = cc.getTableAlias() + "." + cc.getColumnName();
            ccMap.putIfAbsent(aliasDotName, cc);
        });
        return ccMap;
    }

    public int getMaxColumnId() {
        return this.getAllNamedColumns().stream().mapToInt(NamedColumn::getId).max().orElse(0);
    }

    public int getMaxMeasureId() {
        return this.getAllMeasures().stream().mapToInt(Measure::getId).max().orElse(0);
    }

    public void setSeekingCCAdvice(boolean seekingCCAdvice) {
        this.isSeekingCCAdvice = seekingCCAdvice;
    }

    public void setAllNamedColumns(List<NamedColumn> allNamedColumns) {
        this.allNamedColumns = allNamedColumns;
    }

    public void setAllMeasures(List<Measure> allMeasures) {
        this.allMeasures = allMeasures;
    }

    public Map<Integer, NamedColumn> getEffectiveNamedColumns() {
        return this.allNamedColumns.stream().filter(NamedColumn::isExist).collect(Collectors.toMap(NamedColumn::getId, Function.identity()));
    }

    public Map<String, Integer> getDimensionNameIdMap() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(NamedColumn::isDimension).collect(Collectors.toMap(NamedColumn::getAliasDotColumn, NamedColumn::getId));
    }

    public int getColumnIdByColumnName(String aliasDotName) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(col -> col.aliasDotColumn.equalsIgnoreCase(aliasDotName) && col.isExist()).map(NamedColumn::getId).findAny().orElse(-1);
    }

    public int getPartitionColumnId() {
        return this.getColumnIdByColumnName(this.partitionDesc.getPartitionDateColumnRef().getAliasDotName());
    }

    public NamedColumn getColumnByColumnNameInModel(String name) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(col -> col.name.equalsIgnoreCase(name) && col.isExist()).findFirst().orElse(null);
    }

    public String getColumnNameByColumnId(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.effectiveCols));
        return this.effectiveCols.containsKey((Object)id) ? ((TblColRef)this.effectiveCols.get((Object)id)).getAliasDotName() : null;
    }

    public String getNonDimensionNameById(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(col -> col.getId() == id && !col.isDimension()).map(NamedColumn::getAliasDotColumn).findAny().orElse(null);
    }

    public String getTombColumnNameById(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(col -> col.getId() == id && !col.isExist()).map(NamedColumn::getAliasDotColumn).findAny().orElse(null);
    }

    public Measure getTombMeasureById(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allMeasures));
        return this.allMeasures.stream().filter(measure -> Objects.equals(measure.getId(), id) && measure.isTomb()).findAny().orElse(null);
    }

    public String getNameByColumnId(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.allNamedColumns));
        return this.allNamedColumns.stream().filter(col -> Objects.equals(col.getId(), id) && col.isExist()).map(NamedColumn::getName).findAny().orElse(null);
    }

    public String getMeasureNameByMeasureId(int id) {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.effectiveMeasures));
        return this.effectiveMeasures.containsKey((Object)id) ? ((Measure)this.effectiveMeasures.get((Object)id)).getName() : null;
    }

    public Collection<NamedColumn> getAllSelectedColumns() {
        HashSet<NamedColumn> selectedColumns = new HashSet<NamedColumn>();
        for (NamedColumn namedColumn : this.allNamedColumns) {
            if (namedColumn.getStatus() != ColumnStatus.DIMENSION) continue;
            selectedColumns.add(namedColumn);
        }
        Map<String, NamedColumn> aliasDotColumnToCols = this.allNamedColumns.stream().filter(NamedColumn::isExist).collect(Collectors.toMap(entry -> entry.getAliasDotColumn().toUpperCase(Locale.ROOT), pair -> pair));
        for (Measure measure : this.allMeasures) {
            if (measure.tomb) continue;
            measure.getFunction().getColRefs().stream().filter(Objects::nonNull).map(tblColRef -> tblColRef.getAliasDotName().toUpperCase(Locale.ROOT)).filter(aliasDotColumnToCols::containsKey).map(aliasDotColumnToCols::get).forEach(selectedColumns::add);
        }
        ArrayList<NamedColumn> arrayList = new ArrayList<NamedColumn>(selectedColumns);
        arrayList.sort(Comparator.comparingInt(NamedColumn::getId));
        return arrayList;
    }

    public static void checkDuplicateMeasure(List<Measure> measures) {
        NDataModel.checkDuplicate(measures, MeasureDesc::getName, measure -> {
            throw new IllegalStateException("Duplicate measure name occurs: " + measure.getName());
        });
    }

    public static void checkDuplicateColumn(List<NamedColumn> namedColumns) {
        NDataModel.checkDuplicate(namedColumns, NamedColumn::getName, column -> {
            throw new IllegalStateException("Duplicate column name occurs: " + column.getName());
        });
    }

    public static void checkDuplicateCC(List<ComputedColumnDesc> ccList) {
        NDataModel.checkDuplicate(ccList, ComputedColumnDesc::getColumnName, cc -> {
            throw new IllegalStateException("Duplicate computed column name occurs: " + cc.getColumnName());
        });
    }

    private static <T> void checkDuplicate(List<T> targets, Function<T, String> nameGetter, Consumer<T> whenError) {
        HashSet set = Sets.newHashSet();
        targets.forEach(target -> {
            if (set.contains(nameGetter.apply(target))) {
                whenError.accept(target);
            }
            set.add(nameGetter.apply(target));
        });
    }

    public static void changeNameIfDup(List<NamedColumn> namedColumns) {
        Map<String, List<NamedColumn>> colByName = namedColumns.stream().collect(Collectors.groupingBy(NamedColumn::getName));
        colByName.forEach((key, dupCols) -> {
            if (dupCols.size() > 1) {
                dupCols.forEach(col -> col.setName(col.getColTableName()));
            }
        });
    }

    public boolean isMultiPartitionModel() {
        return this.partitionDesc != null && this.multiPartitionDesc != null && CollectionUtils.isNotEmpty(this.multiPartitionDesc.getColumns());
    }

    public boolean isEmptyMultiPartitionKeyMapping() {
        return this.multiPartitionKeyMapping == null || CollectionUtils.isEmpty(this.multiPartitionKeyMapping.getMultiPartitionCols());
    }

    public List<Integer> getMeasureRelatedCols() {
        HashSet colIds = Sets.newHashSet();
        for (Measure measure : this.getEffectiveMeasures().values()) {
            colIds.addAll(measure.getFunction().getParameters().stream().filter(ParameterDesc::isColumnType).map(parameterDesc -> this.getColumnIdByColumnName(parameterDesc.getValue())).collect(Collectors.toList()));
        }
        return Lists.newArrayList((Iterable)colIds);
    }

    public boolean fusionModelBatchPart() {
        return StringUtils.isNotEmpty((CharSequence)this.fusionId) && ModelType.BATCH == this.getModelType();
    }

    public String getFusionModelAlias() {
        if (this.fusionModelBatchPart()) {
            return this.getAlias().substring(0, this.alias.length() - 9);
        }
        return this.getAlias();
    }

    public boolean fusionModelStreamingPart() {
        return StringUtils.isNotEmpty((CharSequence)this.fusionId) && ModelType.HYBRID == this.getModelType();
    }

    public boolean isFusionModel() {
        return StringUtils.isNotEmpty((CharSequence)this.fusionId);
    }

    public boolean isStreaming() {
        return this.getModelType() == ModelType.STREAMING || this.getModelType() == ModelType.HYBRID;
    }

    public String getQueryCompatibleFactTable(String factTableOfQuery) {
        String rootFactTable = this.getRootFactTableName();
        if (!rootFactTable.equals(factTableOfQuery) && this.isFusionModel() && !this.isStreaming()) {
            NDataModel streamingModel = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), this.getProject()).getDataModelDesc(this.getFusionId());
            rootFactTable = streamingModel.getRootFactTableName();
        }
        return rootFactTable;
    }

    public boolean isAccessible(boolean turnOnStreaming) {
        return turnOnStreaming || !this.isStreaming();
    }

    public Set<Integer> getEffectiveInternalMeasureIds() {
        return this.getEffectiveMeasures().values().stream().filter(m -> m.getType() == MeasureType.INTERNAL).map(Measure::getId).collect(Collectors.toSet());
    }

    public boolean isFilePartitioned() {
        return this.partitionDesc != null && this.partitionDesc.getCubePartitionType() == PartitionDesc.PartitionType.FILE;
    }

    public DataStorageType getStorageType() {
        return this.dataStorageType;
    }

    public int getStorageTypeValue() {
        return this.storageType;
    }

    public void setStorageType(int storageType) {
        this.dataStorageType = DataStorageType.fromValue(storageType);
        this.storageType = storageType;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getConfigLastModifier() {
        return this.configLastModifier;
    }

    @Generated
    public long getConfigLastModified() {
        return this.configLastModified;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getRootFactTableName() {
        return this.rootFactTableName;
    }

    @Generated
    public String getRootFactTableAlias() {
        return this.rootFactTableAlias;
    }

    @Generated
    public String getFilterCondition() {
        return this.filterCondition;
    }

    @Generated
    public PartitionDesc getPartitionDesc() {
        return this.partitionDesc;
    }

    @Generated
    public RealizationCapacity getCapacity() {
        return this.capacity;
    }

    @Generated
    public SegmentConfig getSegmentConfig() {
        return this.segmentConfig;
    }

    @Generated
    public int getSemanticVersion() {
        return this.semanticVersion;
    }

    @Generated
    public List<NamedColumn> getAllNamedColumns() {
        return this.allNamedColumns;
    }

    @Generated
    public List<Measure> getAllMeasures() {
        return this.allMeasures;
    }

    @Generated
    public int getRecommendationsCount() {
        return this.recommendationsCount;
    }

    @Generated
    public List<String> getComputedColumnUuids() {
        return this.computedColumnUuids;
    }

    @Generated
    public Canvas getCanvas() {
        return this.canvas;
    }

    @Generated
    public BrokenReason getBrokenReason() {
        return this.brokenReason;
    }

    @Generated
    public boolean isHandledAfterBroken() {
        return this.handledAfterBroken;
    }

    @Generated
    public MultiPartitionDesc getMultiPartitionDesc() {
        return this.multiPartitionDesc;
    }

    @Generated
    public MultiPartitionKeyMappingImpl getMultiPartitionKeyMapping() {
        return this.multiPartitionKeyMapping;
    }

    @Generated
    public String getFusionId() {
        return this.fusionId;
    }

    @Generated
    public ImmutableBiMap<Integer, TblColRef> getEffectiveCols() {
        return this.effectiveCols;
    }

    @Generated
    public ImmutableBiMap<Integer, TblColRef> getEffectiveDimensions() {
        return this.effectiveDimensions;
    }

    @Generated
    public ImmutableBiMap<Integer, Measure> getEffectiveMeasures() {
        return this.effectiveMeasures;
    }

    @Generated
    public List<TblColRef> getMpCols() {
        return this.mpCols;
    }

    @Generated
    public List<ComputedColumnDesc> getComputedColumnDescs() {
        return this.computedColumnDescs;
    }

    @Generated
    public TableRef getRootFactTableRef() {
        return this.rootFactTableRef;
    }

    @Generated
    public Set<TableRef> getFactTableRefs() {
        return this.factTableRefs;
    }

    @Generated
    public Set<TableRef> getLookupTableRefs() {
        return this.lookupTableRefs;
    }

    @Generated
    public Set<TableRef> getQueryDerivedDisabledRefs() {
        return this.queryDerivedDisabledRefs;
    }

    @Generated
    public Set<TableRef> getAllTableRefs() {
        return this.allTableRefs;
    }

    @Generated
    public Map<String, TableRef> getTableNameMap() {
        return this.tableNameMap;
    }

    @Generated
    public boolean isSeekingCCAdvice() {
        return this.isSeekingCCAdvice;
    }

    @Generated
    public boolean isSaveCheck() {
        return this.saveCheck;
    }

    @Generated
    public DataStorageType getDataStorageType() {
        return this.dataStorageType;
    }

    @Generated
    public void setConfig(KylinConfig config) {
        this.config = config;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setConfigLastModifier(String configLastModifier) {
        this.configLastModifier = configLastModifier;
    }

    @Generated
    public void setConfigLastModified(long configLastModified) {
        this.configLastModified = configLastModified;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setRootFactTableName(String rootFactTableName) {
        this.rootFactTableName = rootFactTableName;
    }

    @Generated
    public void setRootFactTableAlias(String rootFactTableAlias) {
        this.rootFactTableAlias = rootFactTableAlias;
    }

    @Generated
    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    @Generated
    public void setPartitionDesc(PartitionDesc partitionDesc) {
        this.partitionDesc = partitionDesc;
    }

    @Generated
    public void setCapacity(RealizationCapacity capacity) {
        this.capacity = capacity;
    }

    @Generated
    public void setSegmentConfig(SegmentConfig segmentConfig) {
        this.segmentConfig = segmentConfig;
    }

    @Generated
    public void setSemanticVersion(int semanticVersion) {
        this.semanticVersion = semanticVersion;
    }

    @Generated
    public void setModelType(ModelType modelType) {
        this.modelType = modelType;
    }

    @Generated
    public void setRecommendationsCount(int recommendationsCount) {
        this.recommendationsCount = recommendationsCount;
    }

    @Generated
    public void setComputedColumnUuids(List<String> computedColumnUuids) {
        this.computedColumnUuids = computedColumnUuids;
    }

    @Generated
    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    @Generated
    public void setBrokenReason(BrokenReason brokenReason) {
        this.brokenReason = brokenReason;
    }

    @Generated
    public void setHandledAfterBroken(boolean handledAfterBroken) {
        this.handledAfterBroken = handledAfterBroken;
    }

    @Generated
    public void setMultiPartitionDesc(MultiPartitionDesc multiPartitionDesc) {
        this.multiPartitionDesc = multiPartitionDesc;
    }

    @Generated
    public void setMultiPartitionKeyMapping(MultiPartitionKeyMappingImpl multiPartitionKeyMapping) {
        this.multiPartitionKeyMapping = multiPartitionKeyMapping;
    }

    @Generated
    public void setFusionId(String fusionId) {
        this.fusionId = fusionId;
    }

    @Generated
    public void setEffectiveCols(ImmutableBiMap<Integer, TblColRef> effectiveCols) {
        this.effectiveCols = effectiveCols;
    }

    @Generated
    public void setEffectiveDimensions(ImmutableBiMap<Integer, TblColRef> effectiveDimensions) {
        this.effectiveDimensions = effectiveDimensions;
    }

    @Generated
    public void setEffectiveMeasures(ImmutableBiMap<Integer, Measure> effectiveMeasures) {
        this.effectiveMeasures = effectiveMeasures;
    }

    @Generated
    public void setEffectiveExpandedMeasures(Map<Integer, Collection<Integer>> effectiveExpandedMeasures) {
        this.effectiveExpandedMeasures = effectiveExpandedMeasures;
    }

    @Generated
    public void setMpCols(List<TblColRef> mpCols) {
        this.mpCols = mpCols;
    }

    @Generated
    public void setComputedColumnDescs(List<ComputedColumnDesc> computedColumnDescs) {
        this.computedColumnDescs = computedColumnDescs;
    }

    @Generated
    public void setRootFactTableRef(TableRef rootFactTableRef) {
        this.rootFactTableRef = rootFactTableRef;
    }

    @Generated
    public void setFactTableRefs(Set<TableRef> factTableRefs) {
        this.factTableRefs = factTableRefs;
    }

    @Generated
    public void setLookupTableRefs(Set<TableRef> lookupTableRefs) {
        this.lookupTableRefs = lookupTableRefs;
    }

    @Generated
    public void setQueryDerivedDisabledRefs(Set<TableRef> queryDerivedDisabledRefs) {
        this.queryDerivedDisabledRefs = queryDerivedDisabledRefs;
    }

    @Generated
    public void setAllTableRefs(Set<TableRef> allTableRefs) {
        this.allTableRefs = allTableRefs;
    }

    @Generated
    public void setTableNameMap(Map<String, TableRef> tableNameMap) {
        this.tableNameMap = tableNameMap;
    }

    @Generated
    public void setJoinsGraph(JoinsGraph joinsGraph) {
        this.joinsGraph = joinsGraph;
    }

    @Generated
    public void setSaveCheck(boolean saveCheck) {
        this.saveCheck = saveCheck;
    }

    @Generated
    public void setDataStorageType(DataStorageType dataStorageType) {
        this.dataStorageType = dataStorageType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDataModel)) {
            return false;
        }
        NDataModel other = (NDataModel)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$rootFactTableName = this.getRootFactTableName();
        String other$rootFactTableName = other.getRootFactTableName();
        if (this$rootFactTableName == null ? other$rootFactTableName != null : !this$rootFactTableName.equals(other$rootFactTableName)) {
            return false;
        }
        String this$rootFactTableAlias = this.getRootFactTableAlias();
        String other$rootFactTableAlias = other.getRootFactTableAlias();
        if (this$rootFactTableAlias == null ? other$rootFactTableAlias != null : !this$rootFactTableAlias.equals(other$rootFactTableAlias)) {
            return false;
        }
        ManagementType this$managementType = this.getManagementType();
        ManagementType other$managementType = other.getManagementType();
        if (this$managementType == null ? other$managementType != null : !((Object)((Object)this$managementType)).equals((Object)other$managementType)) {
            return false;
        }
        String this$filterCondition = this.getFilterCondition();
        String other$filterCondition = other.getFilterCondition();
        if (this$filterCondition == null ? other$filterCondition != null : !this$filterCondition.equals(other$filterCondition)) {
            return false;
        }
        PartitionDesc this$partitionDesc = this.getPartitionDesc();
        PartitionDesc other$partitionDesc = other.getPartitionDesc();
        if (this$partitionDesc == null ? other$partitionDesc != null : !((Object)this$partitionDesc).equals(other$partitionDesc)) {
            return false;
        }
        RealizationCapacity this$capacity = this.getCapacity();
        RealizationCapacity other$capacity = other.getCapacity();
        if (this$capacity == null ? other$capacity != null : !this$capacity.equals(other$capacity)) {
            return false;
        }
        List<NamedColumn> this$allNamedColumns = this.getAllNamedColumns();
        List<NamedColumn> other$allNamedColumns = other.getAllNamedColumns();
        if (this$allNamedColumns == null ? other$allNamedColumns != null : !((Object)this$allNamedColumns).equals(other$allNamedColumns)) {
            return false;
        }
        List<Measure> this$allMeasures = this.getAllMeasures();
        List<Measure> other$allMeasures = other.getAllMeasures();
        if (this$allMeasures == null ? other$allMeasures != null : !((Object)this$allMeasures).equals(other$allMeasures)) {
            return false;
        }
        List<String> this$computedColumnUuids = this.getComputedColumnUuids();
        List<String> other$computedColumnUuids = other.getComputedColumnUuids();
        if (this$computedColumnUuids == null ? other$computedColumnUuids != null : !((Object)this$computedColumnUuids).equals(other$computedColumnUuids)) {
            return false;
        }
        MultiPartitionDesc this$multiPartitionDesc = this.getMultiPartitionDesc();
        MultiPartitionDesc other$multiPartitionDesc = other.getMultiPartitionDesc();
        return !(this$multiPartitionDesc == null ? other$multiPartitionDesc != null : !this$multiPartitionDesc.equals(other$multiPartitionDesc));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NDataModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $rootFactTableName = this.getRootFactTableName();
        result = result * 59 + ($rootFactTableName == null ? 43 : $rootFactTableName.hashCode());
        String $rootFactTableAlias = this.getRootFactTableAlias();
        result = result * 59 + ($rootFactTableAlias == null ? 43 : $rootFactTableAlias.hashCode());
        ManagementType $managementType = this.getManagementType();
        result = result * 59 + ($managementType == null ? 43 : ((Object)((Object)$managementType)).hashCode());
        String $filterCondition = this.getFilterCondition();
        result = result * 59 + ($filterCondition == null ? 43 : $filterCondition.hashCode());
        PartitionDesc $partitionDesc = this.getPartitionDesc();
        result = result * 59 + ($partitionDesc == null ? 43 : ((Object)$partitionDesc).hashCode());
        RealizationCapacity $capacity = this.getCapacity();
        result = result * 59 + ($capacity == null ? 43 : $capacity.hashCode());
        List<NamedColumn> $allNamedColumns = this.getAllNamedColumns();
        result = result * 59 + ($allNamedColumns == null ? 43 : ((Object)$allNamedColumns).hashCode());
        List<Measure> $allMeasures = this.getAllMeasures();
        result = result * 59 + ($allMeasures == null ? 43 : ((Object)$allMeasures).hashCode());
        List<String> $computedColumnUuids = this.getComputedColumnUuids();
        result = result * 59 + ($computedColumnUuids == null ? 43 : ((Object)$computedColumnUuids).hashCode());
        MultiPartitionDesc $multiPartitionDesc = this.getMultiPartitionDesc();
        result = result * 59 + ($multiPartitionDesc == null ? 43 : $multiPartitionDesc.hashCode());
        return result;
    }

    @Generated
    public Map<Integer, Collection<Integer>> getEffectiveExpandedMeasures() {
        return this.effectiveExpandedMeasures;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class ColumnCorrelation
    implements Serializable {
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="correlation_type")
        public String corrType;
        @JsonProperty(value="columns")
        public String[] aliasDotColumns;
        public TblColRef[] cols;

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnCorrelation)) {
                return false;
            }
            ColumnCorrelation other = (ColumnCorrelation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$corrType = this.corrType;
            String other$corrType = other.corrType;
            if (this$corrType == null ? other$corrType != null : !this$corrType.equals(other$corrType)) {
                return false;
            }
            if (!Arrays.deepEquals(this.aliasDotColumns, other.aliasDotColumns)) {
                return false;
            }
            return Arrays.deepEquals(this.cols, other.cols);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnCorrelation;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $corrType = this.corrType;
            result = result * 59 + ($corrType == null ? 43 : $corrType.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.aliasDotColumns);
            result = result * 59 + Arrays.deepHashCode(this.cols);
            return result;
        }
    }

    public static class Measure
    extends MeasureDesc {
        @JsonProperty(value="id")
        private int id;
        @JsonProperty(value="tomb")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        private boolean tomb = false;
        @JsonProperty(value="type")
        private MeasureType type = MeasureType.NORMAL;
        @JsonProperty(value="internal_ids")
        private List<Integer> internalIds = new ArrayList<Integer>();

        public void changeTableAlias(String oldAlias, String newAlias) {
            for (ParameterDesc parameter : this.getFunction().getParameters()) {
                String table = parameter.getValue().split("\\.")[0];
                if (!oldAlias.equalsIgnoreCase(table)) continue;
                String column = parameter.getValue().split("\\.")[1];
                parameter.setValue(newAlias + "." + column);
            }
        }

        @Generated
        public Measure() {
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public void setId(int id) {
            this.id = id;
        }

        @Override
        @Generated
        public String toString() {
            return "NDataModel.Measure(id=" + this.getId() + ", tomb=" + this.isTomb() + ", type=" + this.getType() + ", internalIds=" + this.getInternalIds() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Measure)) {
                return false;
            }
            Measure other = (Measure)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.isTomb() != other.isTomb()) {
                return false;
            }
            MeasureType this$type = this.getType();
            MeasureType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<Integer> this$internalIds = this.getInternalIds();
            List<Integer> other$internalIds = other.getInternalIds();
            return !(this$internalIds == null ? other$internalIds != null : !((Object)this$internalIds).equals(other$internalIds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Measure;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + (this.isTomb() ? 79 : 97);
            MeasureType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<Integer> $internalIds = this.getInternalIds();
            result = result * 59 + ($internalIds == null ? 43 : ((Object)$internalIds).hashCode());
            return result;
        }

        @Generated
        public boolean isTomb() {
            return this.tomb;
        }

        @Generated
        public void setTomb(boolean tomb) {
            this.tomb = tomb;
        }

        @Generated
        public MeasureType getType() {
            return this.type;
        }

        @Generated
        public void setType(MeasureType type) {
            this.type = type;
        }

        @Generated
        public List<Integer> getInternalIds() {
            return this.internalIds;
        }

        @Generated
        public void setInternalIds(List<Integer> internalIds) {
            this.internalIds = internalIds;
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    public static class NamedColumn
    implements Serializable {
        @JsonProperty(value="id")
        protected int id;
        @JsonProperty(value="name")
        protected String name;
        @JsonProperty(value="column")
        protected String aliasDotColumn;
        @JsonProperty(value="status")
        @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=ColumnStatusFilter.class)
        protected ColumnStatus status = ColumnStatus.EXIST;

        public static NamedColumn copy(NamedColumn col) {
            NamedColumn copy = new NamedColumn();
            copy.setId(col.getId());
            copy.setName(col.getName());
            copy.setAliasDotColumn(col.getAliasDotColumn());
            copy.setStatus(col.getStatus());
            return copy;
        }

        public boolean isExist() {
            return this.status != ColumnStatus.TOMB;
        }

        public boolean isDimension() {
            return this.status == ColumnStatus.DIMENSION;
        }

        public void changeTableAlias(String oldAlias, String newAlias) {
            String table = this.aliasDotColumn.split("\\.")[0];
            String column = this.aliasDotColumn.split("\\.")[1];
            if (table.equalsIgnoreCase(oldAlias)) {
                this.aliasDotColumn = newAlias + "." + column;
            }
        }

        public String getColTableName() {
            String table = this.aliasDotColumn.split("\\.")[0];
            String column = this.aliasDotColumn.split("\\.")[1];
            return column + "_" + table;
        }

        @Generated
        public NamedColumn() {
        }

        @Generated
        public int getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getAliasDotColumn() {
            return this.aliasDotColumn;
        }

        @Generated
        public ColumnStatus getStatus() {
            return this.status;
        }

        @Generated
        public void setId(int id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setAliasDotColumn(String aliasDotColumn) {
            this.aliasDotColumn = aliasDotColumn;
        }

        @Generated
        public void setStatus(ColumnStatus status) {
            this.status = status;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedColumn)) {
                return false;
            }
            NamedColumn other = (NamedColumn)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$aliasDotColumn = this.getAliasDotColumn();
            String other$aliasDotColumn = other.getAliasDotColumn();
            if (this$aliasDotColumn == null ? other$aliasDotColumn != null : !this$aliasDotColumn.equals(other$aliasDotColumn)) {
                return false;
            }
            ColumnStatus this$status = this.getStatus();
            ColumnStatus other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NamedColumn;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $aliasDotColumn = this.getAliasDotColumn();
            result = result * 59 + ($aliasDotColumn == null ? 43 : $aliasDotColumn.hashCode());
            ColumnStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "NDataModel.NamedColumn(id=" + this.getId() + ", name=" + this.getName() + ", aliasDotColumn=" + this.getAliasDotColumn() + ", status=" + (Object)((Object)this.getStatus()) + ")";
        }
    }

    public static enum BrokenReason {
        SCHEMA,
        NULL,
        EVENT,
        SEGMENT_OVERLAP;

    }

    public static enum ColumnStatus {
        TOMB,
        EXIST,
        DIMENSION;

    }

    public static class ModelRepairEvent
    extends SchedulerEventNotifier {
        public ModelRepairEvent(String project, String subject) {
            this.project = project;
            this.subject = subject;
        }

        @Generated
        public ModelRepairEvent() {
        }
    }

    public static class ModelBrokenEvent
    extends SchedulerEventNotifier {
        public ModelBrokenEvent(String project, String subject) {
            this.project = project;
            this.subject = subject;
        }

        @Generated
        public ModelBrokenEvent() {
        }
    }

    public static class ModelRenameEvent
    extends SchedulerEventNotifier {
        private String newName;

        public ModelRenameEvent(String project, String subject, String newName) {
            this.project = project;
            this.subject = subject;
            this.newName = newName;
        }

        @Generated
        public String getNewName() {
            return this.newName;
        }

        @Generated
        public void setNewName(String newName) {
            this.newName = newName;
        }

        @Generated
        public ModelRenameEvent(String newName) {
            this.newName = newName;
        }
    }

    public static enum DataStorageType implements Serializable
    {
        V1,
        DELTA,
        ICEBERG,
        INVALID;

        private static final Map<Integer, DataStorageType> typeValueMap;

        public boolean isV1Storage() {
            return this == V1;
        }

        public boolean isV3Storage() {
            return this == DELTA || this == ICEBERG;
        }

        public boolean isDeltaStorage() {
            return this == DELTA;
        }

        public boolean isIcebergStorage() {
            return this == ICEBERG;
        }

        public boolean isInvalidStorage() {
            return this == INVALID;
        }

        public static DataStorageType fromValue(int value) {
            return typeValueMap.getOrDefault(value, INVALID);
        }

        static {
            typeValueMap = new HashMap<Integer, DataStorageType>();
            typeValueMap.put(0, V1);
            typeValueMap.put(1, V1);
            typeValueMap.put(3, DELTA);
            typeValueMap.put(4, ICEBERG);
        }
    }

    public static enum MeasureType implements Serializable
    {
        NORMAL,
        EXPANDABLE,
        INTERNAL;

    }

    public static enum RealizationCapacity implements Serializable
    {
        SMALL,
        MEDIUM,
        LARGE;

    }

    public static enum TableKind implements Serializable
    {
        FACT,
        LOOKUP;

    }

    public static enum ModelType implements Serializable
    {
        BATCH,
        STREAMING,
        HYBRID,
        UNKNOWN;

    }
}

