/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.BaseRuleManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.ModelFavoriteRuleStore;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class ModelFavoriteRuleManager
extends BaseRuleManager {
    private final ModelFavoriteRuleStore favoriteRuleStore;
    private final String project;
    private final String modelId;

    private ModelFavoriteRuleManager(String project, String modelId) throws Exception {
        this.project = project;
        this.modelId = modelId;
        this.favoriteRuleStore = new ModelFavoriteRuleStore(KylinConfig.getInstanceFromEnv());
    }

    public static ModelFavoriteRuleManager getInstance(String project) {
        return (ModelFavoriteRuleManager)Singletons.getInstance((String)(project + "-null"), ModelFavoriteRuleManager.class, clz -> new ModelFavoriteRuleManager(project, null));
    }

    public static ModelFavoriteRuleManager getInstance(String project, String modelId) {
        return (ModelFavoriteRuleManager)Singletons.getInstance((String)(project + "-" + modelId), ModelFavoriteRuleManager.class, clz -> new ModelFavoriteRuleManager(project, modelId));
    }

    @Override
    public DataSourceTransactionManager getTransactionManager() {
        return this.favoriteRuleStore.getTransactionManager();
    }

    public List<FavoriteRule> getAllOfModel() {
        return this.favoriteRuleStore.queryByModel(this.modelId);
    }

    public List<FavoriteRule> getAllOfProject() {
        return this.favoriteRuleStore.queryByProject(this.project);
    }

    public List<FavoriteRule> listAll() {
        return FavoriteRule.FAVORITE_RULE_NAMES.stream().map(this::getOrDefaultByName).collect(Collectors.toList());
    }

    public FavoriteRule getByName(String name) {
        return this.favoriteRuleStore.queryByName(this.modelId, name);
    }

    public String getValue(String ruleName) {
        FavoriteRule rule = this.getOrDefaultByName(ruleName);
        FavoriteRule.Condition condition = (FavoriteRule.Condition)rule.getConds().get(0);
        return condition.getRightThreshold();
    }

    @Override
    public FavoriteRule getOrDefaultByName(String ruleName) {
        return FavoriteRule.getDefaultRuleIfNull(this.getByName(ruleName), ruleName);
    }

    @Override
    protected FavoriteRule copyForWrite(FavoriteRule rule) {
        return rule;
    }

    @Override
    public void updateRule(FavoriteRule rule) {
        this.updateRule(rule.getConds(), rule.isEnabled(), rule.getName());
    }

    @Override
    public void updateRule(List<FavoriteRule.AbstractCondition> conditions, boolean isEnabled, String ruleName) {
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)this.getTransactionManager(), () -> {
            FavoriteRule copy = this.copyForWrite(this.getOrDefaultByName(ruleName));
            copy.setEnabled(isEnabled);
            ArrayList newConditions = Lists.newArrayList();
            if (!conditions.isEmpty()) {
                newConditions.addAll(conditions);
            }
            copy.setConds(newConditions);
            this.saveOrUpdate(copy);
            return null;
        });
    }

    @Override
    protected void saveOrUpdate(FavoriteRule rule) {
        if (rule.getId() == 0) {
            rule.setProject(this.project);
            rule.setModel(this.modelId);
            rule.setCreateTime(System.currentTimeMillis());
            rule.setUpdateTime(rule.getCreateTime());
            this.favoriteRuleStore.save(rule);
        } else {
            rule.setUpdateTime(System.currentTimeMillis());
            this.favoriteRuleStore.update(rule);
        }
    }

    public void delete(FavoriteRule favoriteRule) {
        this.favoriteRuleStore.deleteByName(this.modelId, favoriteRule.getName());
    }

    public void deleteByModel() {
        this.favoriteRuleStore.deleteByModel(this.modelId);
    }

    public void deleteByProject() {
        this.favoriteRuleStore.deleteByProject(this.project);
    }
}

