/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm;

import java.math.BigInteger;

public class CuboidBenefitModel {
    private CuboidModel cuboidModel;
    private BenefitModel benefitModel;

    public CuboidBenefitModel(CuboidModel cuboidModel, BenefitModel benefitModel) {
        this.cuboidModel = cuboidModel;
        this.benefitModel = benefitModel;
    }

    public void reset(CuboidModel cuboidModel, BenefitModel benefitModel) {
        this.cuboidModel = cuboidModel;
        this.benefitModel = benefitModel;
    }

    public BigInteger getCuboidId() {
        return this.cuboidModel == null ? null : this.cuboidModel.cuboidId;
    }

    public Double getBenefit() {
        return this.benefitModel == null ? null : Double.valueOf(this.benefitModel.benefit);
    }

    public String toString() {
        return "CuboidBenefitModel [cuboidModel=" + this.cuboidModel + ", benefitModel=" + this.benefitModel + "]";
    }

    public static class BenefitModel {
        public final double benefit;
        public final int benefitCount;

        public BenefitModel(double benefit, int benefitCount) {
            this.benefit = benefit;
            this.benefitCount = benefitCount;
        }

        public String toString() {
            return "BenefitModel [benefit=" + this.benefit + ", benefitCount=" + this.benefitCount + "]";
        }
    }

    public static class CuboidModel {
        public final BigInteger cuboidId;
        public final long recordCount;
        public final double spaceSize;
        public final double hitProbability;
        public final long scanCount;

        public CuboidModel(BigInteger cuboId, long recordCount, double spaceSize, double hitProbability, long scanCount) {
            this.cuboidId = cuboId;
            this.recordCount = recordCount;
            this.spaceSize = spaceSize;
            this.hitProbability = hitProbability;
            this.scanCount = scanCount;
        }

        public String toString() {
            return "CuboidModel [cuboidId=" + this.cuboidId + ", recordCount=" + this.recordCount + ", spaceSize=" + this.spaceSize + ", hitProbability=" + this.hitProbability + ", scanCount=" + this.scanCount + "]";
        }
    }
}

