/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.optimization;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.optimization.AbstractOptStrategy;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedLayoutOptStrategy
extends AbstractOptStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncludedLayoutOptStrategy.class);

    public IncludedLayoutOptStrategy() {
        this.setType(GarbageLayoutType.INCLUDED);
    }

    @Override
    public Set<Long> doCollect(List<LayoutEntity> inputLayouts, NDataflow dataflow, boolean needLog) {
        HashSet garbageLayouts = Sets.newHashSet();
        Map<LayoutEntity, LayoutEntity> fromGarbageToAliveMap = IndexPlanReduceUtil.collectIncludedLayouts(inputLayouts, true);
        fromGarbageToAliveMap.forEach((redundant, reserved) -> garbageLayouts.add(redundant.getId()));
        this.shiftLayoutHitCount(fromGarbageToAliveMap, dataflow);
        if (needLog) {
            log.info("In dataflow({}), IncludedLayoutGcStrategy found garbage laoyouts: {}", (Object)dataflow.getId(), fromGarbageToAliveMap);
        }
        return garbageLayouts;
    }

    @Override
    protected void skipOptimizeIndex(List<LayoutEntity> inputLayouts) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isIncludedStrategyConsiderTableIndex()) {
            inputLayouts.removeIf(layout -> IndexEntity.isTableIndex(layout.getId()));
        }
    }

    private void shiftLayoutHitCount(Map<LayoutEntity, LayoutEntity> removedToReservedMap, NDataflow dataflow) {
        Map<Long, FrequencyMap> layoutHitCount = dataflow.getLayoutHitCount();
        removedToReservedMap.forEach((removedLayout, reservedLayout) -> {
            FrequencyMap removedFreqMap = (FrequencyMap)layoutHitCount.get(removedLayout.getId());
            if (removedFreqMap == null) {
                return;
            }
            layoutHitCount.putIfAbsent(reservedLayout.getId(), new FrequencyMap());
            ((FrequencyMap)layoutHitCount.get(reservedLayout.getId())).merge(removedFreqMap);
        });
        dataflow.setLayoutHitCount(layoutHitCount);
    }
}

