/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;

public class NSegmentConfigHelper {
    static final ObjectMapper mapper = new ObjectMapper();

    public static SegmentConfig getModelSegmentConfig(String project, String model) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NDataModel dataModel = NDataModelManager.getInstance(kylinConfig, project).getDataModelDesc(model);
        SegmentConfig segmentConfigInModel = dataModel.getSegmentConfig();
        SegmentConfig segmentConfigInProject = NSegmentConfigHelper.getFromProject(project, kylinConfig);
        ManagementType managementType = dataModel.getManagementType();
        switch (managementType) {
            case MODEL_BASED: {
                return NSegmentConfigHelper.mergeConfig(segmentConfigInModel, segmentConfigInProject);
            }
        }
        return null;
    }

    private static SegmentConfig mergeConfig(SegmentConfig firstSegmentConfig, SegmentConfig secondSegmentConfig) {
        if (firstSegmentConfig == null && secondSegmentConfig == null) {
            return null;
        }
        if (firstSegmentConfig == null) {
            return secondSegmentConfig;
        }
        if (secondSegmentConfig == null) {
            return firstSegmentConfig;
        }
        Map firstSegmentConfigMap = (Map)mapper.convertValue((Object)firstSegmentConfig, Map.class);
        Map secondSegmentConfigMap = (Map)mapper.convertValue((Object)secondSegmentConfig, Map.class);
        secondSegmentConfigMap.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (firstSegmentConfigMap.get(key) == null) {
                firstSegmentConfigMap.put(key, value);
            }
        });
        return (SegmentConfig)mapper.convertValue((Object)firstSegmentConfigMap, SegmentConfig.class);
    }

    private static SegmentConfig getFromProject(String project, KylinConfig kylinConfig) {
        ProjectInstance projectInstance = NProjectManager.getInstance(kylinConfig).getProject(project);
        Preconditions.checkState((projectInstance != null ? 1 : 0) != 0);
        return projectInstance.getSegmentConfig();
    }
}

