/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.SegmentMergeStorageChecker;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataSegDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataSegmentManager;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TimeRange;
import org.apache.kylin.metadata.model.util.scd2.SCD2CondChecker;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.IRealizationProvider;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NDataflowManager
implements IRealizationProvider {
    private static final Logger logger = LoggerFactory.getLogger(NDataflowManager.class);
    private KylinConfig config;
    private String project;
    private CachedCrudAssist<NDataflow> crud;

    public static NDataflowManager getInstance(KylinConfig config, String project) {
        return (NDataflowManager)config.getManager(project, NDataflowManager.class);
    }

    static NDataflowManager newInstance(KylinConfig config, String project) {
        return new NDataflowManager(config, project);
    }

    private NDataflowManager(KylinConfig cfg, final String project) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NDataflowManager with KylinConfig Id: {} for project {}", (Object)System.identityHashCode(cfg), (Object)project);
        }
        this.config = cfg;
        this.project = project;
        this.crud = new CachedCrudAssist<NDataflow>(this.getStore(), MetadataType.DATAFLOW, project, NDataflow.class){

            @Override
            protected NDataflow initEntityAfterReload(NDataflow df, String resourceName) {
                IndexPlan plan = NIndexPlanManager.getInstance(NDataflowManager.this.config, project).getIndexPlan(df.getUuid());
                df.initAfterReload((KylinConfigExt)plan.getConfig(), project);
                return df;
            }

            @Override
            protected NDataflow initBrokenEntity(NDataflow entity, String resourceName) {
                NDataflow dataflow = super.initBrokenEntity(entity, resourceName);
                IndexPlan plan = NIndexPlanManager.getInstance(NDataflowManager.this.config, project).getIndexPlan(resourceName);
                if (plan != null) {
                    dataflow.setConfig((KylinConfigExt)plan.getConfig());
                } else {
                    dataflow.setConfig((KylinConfigExt)KylinConfig.getInstanceFromEnv());
                }
                dataflow.setProject(project);
                dataflow.setDependencies(dataflow.calcDependencies());
                return dataflow;
            }
        };
        this.crud.setCheckCopyOnWrite(true);
    }

    public NDataflow removeLayouts(NDataflow df, Collection<Long> tobeRemoveCuboidLayoutIds) {
        ArrayList tobeRemoveCuboidLayout = Lists.newArrayList();
        Segments<NDataSegment> segments = df.getSegments();
        for (NDataSegment segment : segments) {
            for (Long tobeRemoveCuboidLayoutId : tobeRemoveCuboidLayoutIds) {
                NDataLayout dataCuboid = segment.getLayout(tobeRemoveCuboidLayoutId);
                if (dataCuboid == null) continue;
                tobeRemoveCuboidLayout.add(dataCuboid);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)tobeRemoveCuboidLayout)) {
            NDataflowUpdate update = new NDataflowUpdate(df.getUuid());
            update.setToRemoveLayouts(tobeRemoveCuboidLayout.toArray(new NDataLayout[0]));
            return this.updateDataflow(update);
        }
        return df;
    }

    @Override
    public String getRealizationType() {
        return "NCUBE";
    }

    @Override
    public IRealization getRealization(String id) {
        NDataflow df = this.getDataflow(id);
        if (df == null || df.checkBrokenWithRelatedInfo()) {
            return null;
        }
        return df;
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public List<NDataflow> listAllDataflows() {
        return this.listAllDataflows(false);
    }

    public List<NDataflow> listAllDataflows(boolean includeBroken) {
        return this.crud.listAll().stream().filter(df -> includeBroken || !df.checkBrokenWithRelatedInfo()).collect(Collectors.toList());
    }

    public List<NDataModel> listUnderliningDataModels() {
        return this.listUnderliningDataModels(false);
    }

    public List<NDataModel> listDataModelsByStatus(RealizationStatusEnum status) {
        List<NDataflow> dataflows = this.listAllDataflows();
        ArrayList onlineModels = Lists.newArrayList();
        for (NDataflow dataflow : dataflows) {
            if (status != dataflow.getStatus()) continue;
            onlineModels.add(dataflow.getModel());
        }
        return onlineModels;
    }

    public NDataflow updateDataflowStatus(String uuid, RealizationStatusEnum status) {
        return this.updateDataflow(uuid, copyForWrite -> copyForWrite.setStatus(status));
    }

    public List<NDataModel> listUnderliningDataModels(boolean includeBroken) {
        if (KylinConfig.getInstanceFromEnv().checkModelDependencyHealthy()) {
            List<NDataflow> dataflows = this.listAllDataflows(includeBroken);
            return dataflows.stream().map(NDataflow::getModel).collect(Collectors.toList());
        }
        List<NDataModel> models = NDataModelManager.getInstance(this.config, this.project).listAllModels();
        return includeBroken ? models : models.stream().filter(dataModel -> !dataModel.isBroken()).collect(Collectors.toList());
    }

    public List<NDataModel> listOnlineDataModels() {
        return this.listAllDataflows(false).stream().filter(d -> d.getStatus() == RealizationStatusEnum.ONLINE).map(NDataflow::getModel).collect(Collectors.toList());
    }

    public Map<String, List<NDataModel>> getModelsGroupbyTable() {
        return this.listUnderliningDataModels().stream().collect(Collectors.groupingBy(NDataModel::getRootFactTableName));
    }

    public List<NDataModel> getModelsUsingTable(TableDesc table) {
        ArrayList<NDataModel> models = new ArrayList<NDataModel>();
        for (NDataModel modelDesc : this.listUnderliningDataModels()) {
            if (!modelDesc.containsTable(table)) continue;
            models.add(modelDesc);
        }
        return models;
    }

    public List<NDataModel> getModelsUsingRootTable(TableDesc table) {
        ArrayList<NDataModel> models = new ArrayList<NDataModel>();
        for (NDataModel modelDesc : this.listUnderliningDataModels()) {
            if (!modelDesc.isRootFactTable(table)) continue;
            models.add(modelDesc);
        }
        return models;
    }

    public NDataflow getDataflow(String id) {
        return this.getDataflow(id, false);
    }

    public NDataflow getDataflowByModelAlias(String name) {
        return this.listAllDataflows(true).stream().filter(dataflow -> Objects.equals(dataflow.getModelAlias(), name)).findFirst().orElse(null);
    }

    public void reloadAll() {
        this.crud.reloadAll();
    }

    public NDataflow createDataflow(IndexPlan plan, String owner) {
        return this.createDataflow(plan, owner, RealizationStatusEnum.OFFLINE);
    }

    public NDataflow createDataflow(IndexPlan plan, String owner, RealizationStatusEnum realizationStatusEnum) {
        NDataflow df = NDataflow.create(plan, realizationStatusEnum);
        df.initAfterReload((KylinConfigExt)plan.getConfig(), this.project);
        NDataflow copy = this.copyForWrite(df);
        copy.getSegments().validate();
        this.crud.save(copy);
        return copy;
    }

    public void fillDfWithNewRanges(NDataflow df, List<SegmentRange> segmentRanges) {
        Segments<NDataSegment> segs = new Segments<NDataSegment>();
        segmentRanges.forEach(segRange -> {
            NDataSegment newSegment = this.newSegment(df, (SegmentRange)segRange);
            newSegment.setStatus(SegmentStatusEnum.READY);
            segs.add(newSegment);
        });
        NDataflowUpdate update = new NDataflowUpdate(df.getUuid());
        update.setToAddSegs(segs.toArray(new NDataSegment[0]));
        this.updateDataflow(update);
    }

    public NDataSegment appendSegment(NDataflow df, SegmentRange segRange) {
        return this.appendSegment(df, segRange, SegmentStatusEnum.NEW);
    }

    public NDataSegment appendSegment(NDataflow df, SegmentRange segRange, SegmentStatusEnum status) {
        return this.appendSegment(df, segRange, status, null);
    }

    public NDataSegment appendSegment(NDataflow df, SegmentRange segRange, SegmentStatusEnum status, List<String[]> multiPartitionValues) {
        NDataSegment newSegment = this.newSegment(df, segRange);
        newSegment.setStatus(status);
        this.validateNewSegments(df, newSegment);
        NDataflowUpdate upd = new NDataflowUpdate(df.getUuid());
        upd.setToAddSegs(newSegment);
        df = this.updateDataflow(upd);
        if (CollectionUtils.isNotEmpty(multiPartitionValues)) {
            newSegment = this.appendPartitions(df.getId(), newSegment.getId(), multiPartitionValues);
        }
        return df.getSegment(newSegment.getId()).copy();
    }

    public NDataSegment appendPartitions(String dfId, String segId, List<String[]> partitionValues) {
        NDataSegmentManager segManager = (NDataSegmentManager)this.config.getManager(this.project, NDataSegmentManager.class);
        segManager.update(segId, copyForWrite -> {
            partitionValues.forEach(partitionValue -> {
                if (copyForWrite.isPartitionOverlap((String[])partitionValue)) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Duplicate partition value [%s] found in segment [%s]", Arrays.toString(partitionValue), copyForWrite.getId()));
                }
            });
            NDataModelManager modelManager = NDataModelManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project);
            Set<Long> addPartitions = modelManager.addPartitionsIfAbsent(copyForWrite.getModel(), partitionValues);
            addPartitions.forEach(partition -> copyForWrite.getMultiPartitions().add(new SegmentPartition((long)partition)));
        });
        return this.getDataflow(dfId).getSegment(segId).copy();
    }

    public NDataSegment appendSegmentForStreaming(NDataflow df, SegmentRange segRange) {
        return this.appendSegmentForStreaming(df, segRange, null);
    }

    public NDataSegment appendSegmentForStreaming(NDataflow df, SegmentRange segRange, String newSegId) {
        if (!StringUtils.isEmpty((CharSequence)newSegId) && df.getSegment(newSegId) != null) {
            return df.getSegment(newSegId);
        }
        ArrayList<NDataSegment> removeSegs = new ArrayList<NDataSegment>();
        List segments = df.getSegments().stream().filter(item -> !item.getAdditionalInfo().containsKey("file_layer")).collect(Collectors.toList());
        Collections.sort(segments);
        if (!segments.isEmpty()) {
            NDataSegment lastL0Seg = (NDataSegment)segments.get(segments.size() - 1);
            SegmentRange.KafkaOffsetPartitionedSegmentRange lastL0SegRange = (SegmentRange.KafkaOffsetPartitionedSegmentRange)lastL0Seg.getSegRange();
            SegmentRange.KafkaOffsetPartitionedSegmentRange newSegRange = (SegmentRange.KafkaOffsetPartitionedSegmentRange)segRange;
            if (lastL0SegRange.equals(segRange) || lastL0SegRange.comparePartitionOffset(lastL0SegRange.getSourcePartitionOffsetStart(), newSegRange.getSourcePartitionOffsetEnd()) >= 0) {
                NDataSegment emptySeg = NDataSegment.empty();
                emptySeg.setId("");
                return emptySeg;
            }
            if (newSegRange.contains(lastL0SegRange) || lastL0SegRange.contains(newSegRange)) {
                removeSegs.add(lastL0Seg);
            }
        }
        NDataSegment newSegment = new NDataSegment(df, segRange, newSegId);
        NDataflowUpdate upd = new NDataflowUpdate(df.getUuid());
        upd.setToAddSegs(newSegment);
        upd.setToRemoveSegsWithArray(removeSegs.toArray(new NDataSegment[0]));
        this.updateDataflow(upd);
        return newSegment;
    }

    public NDataSegment refreshSegment(NDataflow df, SegmentRange segRange) {
        NDataSegment newSegment = this.newSegment(df, segRange);
        NDataSegment toRefreshSeg = null;
        for (NDataSegment NDataSegment2 : df.getSegments()) {
            if (!NDataSegment2.getSegRange().equals(segRange)) continue;
            toRefreshSeg = NDataSegment2;
            break;
        }
        if (toRefreshSeg == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "no ready segment with range %s exists on model %s", segRange.toString(), df.getModelAlias()));
        }
        newSegment.setSegmentRange(toRefreshSeg.getSegRange());
        newSegment.setMultiPartitions(toRefreshSeg.getMultiPartitions().stream().map(partition -> new SegmentPartition(partition.getPartitionId())).collect(Collectors.toList()));
        NDataflowUpdate upd = new NDataflowUpdate(df.getUuid());
        upd.setToAddSegs(newSegment);
        this.updateDataflow(upd);
        return newSegment;
    }

    public NDataSegment mergeSegments(NDataflow dataflow, SegmentRange segRange, boolean force) {
        return this.doMergeSegments(dataflow, segRange, force, null, null, null);
    }

    @VisibleForTesting
    public NDataSegment mergeSegmentsWithDimRange(NDataflow dataflow, SegmentRange<Long> segRange, boolean force, Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        return this.doMergeSegments(dataflow, segRange, force, null, null, dimensionRangeInfoMap);
    }

    public NDataSegment mergeSegments(NDataflow dataflow, SegmentRange segRange, boolean force, Integer fileLayer, String newSegId) {
        return this.doMergeSegments(dataflow, segRange, force, fileLayer, newSegId, null);
    }

    public void checkForce(Segments<NDataSegment> mergingSegments, NDataSegDetails firstSegDetails, boolean force) {
        int i;
        for (i = 1; i < mergingSegments.size(); ++i) {
            NDataSegment dataSegment = (NDataSegment)mergingSegments.get(i);
            NDataSegDetails details = dataSegment.getSegDetails();
            if (firstSegDetails.checkLayoutsBeforeMerge(details)) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_CHECK_INDEX_ILLEGAL, new Object[0]);
        }
        if (!force) {
            for (i = 0; i < mergingSegments.size() - 1; ++i) {
                if (((NDataSegment)mergingSegments.get(i)).getSegRange().connects(((NDataSegment)mergingSegments.get(i + 1)).getSegRange())) continue;
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_CONTAINS_GAPS, new Object[0]);
            }
            ArrayList emptySegment = Lists.newArrayList();
            for (NDataSegment seg : mergingSegments) {
                if (seg.getSegDetails().getTotalRowCount() != 0L) continue;
                emptySegment.add(seg.getName());
            }
            if (!emptySegment.isEmpty()) {
                throw new IllegalArgumentException("Empty cube segment found, couldn't merge unless 'forceMergeEmptySegment' set to true: " + emptySegment);
            }
        }
    }

    public void checkFirstSegAndFileLayer(NDataSegment first, NDataSegment last, NDataSegment newSegment, NDataflow dataflowCopy, SegmentRange<Long> segRange, Integer fileLayer) {
        if (first.isOffsetCube()) {
            newSegment.setSegmentRange(segRange);
        } else {
            newSegment.setTimeRange(new TimeRange(first.getTSRange().getStart(), last.getTSRange().getEnd()));
        }
        if (fileLayer != null) {
            newSegment.getAdditionalInfo().put("file_layer", String.valueOf(fileLayer));
        } else {
            this.validateNewSegments(dataflowCopy, newSegment);
        }
    }

    public NDataSegment doMergeSegments(NDataflow dataflow, SegmentRange<Long> segRange, boolean force, Integer fileLayer, String newSegId, Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        NDataflow dataflowCopy = dataflow.copy();
        if (dataflowCopy.getSegments().isEmpty()) {
            throw new IllegalArgumentException(dataflow + " has no segments");
        }
        Preconditions.checkArgument((segRange != null ? 1 : 0) != 0);
        this.checkCubeIsPartitioned(dataflowCopy);
        NDataSegment newSegment = dimensionRangeInfoMap == null ? this.newSegment(dataflowCopy, segRange) : this.newSegment(dataflowCopy, segRange, dimensionRangeInfoMap);
        NDataflowUpdate update = new NDataflowUpdate(dataflowCopy.getUuid());
        if (fileLayer != null) {
            if (!StringUtils.isEmpty((CharSequence)newSegId)) {
                newSegment.setId(newSegId);
                if (dataflowCopy.getSegment(newSegId) != null) {
                    return dataflowCopy.getSegment(newSegment.getId()).copy();
                }
            }
            List segments = dataflow.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING).stream().filter(item -> item.getAdditionalInfo().containsKey("file_layer")).collect(Collectors.toList());
            for (int i = 0; i < segments.size(); ++i) {
                NDataSegment seg = (NDataSegment)segments.get(i);
                if (!seg.getSegRange().equals(segRange)) continue;
                update.setToRemoveSegs(seg);
                break;
            }
        }
        Segments<NDataSegment> mergingSegments = dataflowCopy.getMergingSegments(newSegment);
        if ((mergingSegments = new Segments(mergingSegments.stream().map(NDataSegment::copy).collect(Collectors.toList()))).size() <= 1) {
            throw new IllegalArgumentException("Range " + newSegment.getSegRange() + " must contain at least 2 segments, but there is " + mergingSegments.size());
        }
        NDataSegment first = (NDataSegment)mergingSegments.get(0);
        this.checkForce(mergingSegments, first.getSegDetails(), force);
        NDataSegment last = (NDataSegment)mergingSegments.get(mergingSegments.size() - 1);
        newSegment.setSegmentRange(first.getSegRange().coverWith(last.getSegRange()));
        this.checkFirstSegAndFileLayer(first, last, newSegment, dataflowCopy, segRange, fileLayer);
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)this.config, (String)this.config.getHdfsWorkingDirectory(), (long)mergingSegments.stream().mapToLong(NDataSegment::getStorageBytesSize).sum());
        this.checkAndMergeMultiPartitions(dataflow, newSegment, mergingSegments);
        update.setToAddSegs(newSegment);
        this.updateDataflow(update);
        return newSegment;
    }

    private void checkAndMergeMultiPartitions(NDataflow dataflow, NDataSegment newSegment, Segments<NDataSegment> mergingSegments) {
        if (!dataflow.getModel().isMultiPartitionModel()) {
            return;
        }
        Set<Long> partitions = ((NDataSegment)mergingSegments.get(0)).getMultiPartitions().stream().map(SegmentPartition::getPartitionId).collect(Collectors.toSet());
        mergingSegments.forEach(segment -> {
            if (MapUtils.isEmpty(segment.getLayoutsMap())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_CHECK_INDEX_ILLEGAL, new Object[0]);
            }
            segment.getLayoutsMap().values().forEach(layout -> {
                Set partitionsInLayout = layout.getMultiPartition().stream().map(LayoutPartition::getPartitionId).collect(Collectors.toSet());
                if (!partitionsInLayout.equals(partitions)) {
                    throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_MERGE_CHECK_PARTITION_ILLEGAL, new Object[0]);
                }
            });
        });
        partitions.forEach(partition -> newSegment.getMultiPartitions().add(new SegmentPartition((long)partition)));
    }

    private void checkCubeIsPartitioned(NDataflow dataflow) {
        if (!dataflow.getModel().getPartitionDesc().isPartitioned()) {
            throw new IllegalStateException("there is no partition date column specified, only full build is supported");
        }
    }

    @VisibleForTesting
    NDataSegment newSegment(NDataflow df, SegmentRange segRange) {
        Preconditions.checkNotNull((Object)segRange);
        return new NDataSegment(df, segRange);
    }

    @VisibleForTesting
    NDataSegment newSegment(NDataflow df, SegmentRange<Long> segRange, Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        Preconditions.checkNotNull(segRange);
        return new NDataSegment(df, segRange, dimensionRangeInfoMap);
    }

    private void validateNewSegments(NDataflow df, NDataSegment newSegments) {
        Segments<NDataSegment> tobe = df.calculateToBeSegments(newSegments);
        List<NDataSegment> newList = Arrays.asList(newSegments);
        if (!tobe.containsAll(newList)) {
            throw new IllegalStateException("For NDataflow " + df + ", the new segments " + newList + " do not fit in its current " + df.getSegments() + "; the resulted tobe is " + tobe);
        }
    }

    public List<NDataSegment> getToRemoveSegs(NDataflow dataflow, NDataSegment segment) {
        Segments<NDataSegment> tobe = dataflow.calculateToBeSegments(segment);
        if (!tobe.contains(segment)) {
            throw new IllegalStateException("For NDataflow " + dataflow + ", segment " + segment + " is expected but not in the tobe " + tobe);
        }
        if (segment.getStatus() == SegmentStatusEnum.NEW) {
            segment.setStatus(SegmentStatusEnum.READY);
        }
        ArrayList toRemoveSegs = Lists.newArrayList();
        for (NDataSegment s : dataflow.getSegments()) {
            if (tobe.contains(s)) continue;
            toRemoveSegs.add(s);
        }
        logger.info("promoting new ready segment {} in dataflow {}, segments to removed: {}", new Object[]{segment, dataflow, toRemoveSegs});
        return toRemoveSegs;
    }

    public NDataflow copyForWrite(NDataflow df) {
        return this.crud.copyForWrite(df);
    }

    public NDataflow copy(NDataflow df) {
        return this.crud.copyBySerialization(df);
    }

    public void fillDfManually(NDataflow df, List<SegmentRange> ranges) {
        Preconditions.checkState((df.getModel().getManagementType() == ManagementType.MODEL_BASED ? 1 : 0) != 0);
        if (CollectionUtils.isEmpty(ranges)) {
            return;
        }
        this.fillDfWithNewRanges(df, ranges);
    }

    public NDataflow handleRetention(NDataflow df) {
        Segments segsToRemove = df.getSegmentsToRemoveByRetention();
        if (CollectionUtils.isEmpty((Collection)segsToRemove)) {
            return df;
        }
        NDataflowUpdate update = new NDataflowUpdate(df.getUuid());
        update.setToRemoveSegs(segsToRemove.toArray(new NDataSegment[segsToRemove.size()]));
        return this.updateDataflow(update);
    }

    public NDataflow updateDataflow(String dfId, NDataflowUpdater updater) {
        NDataflow cached = this.getDataflow(dfId);
        Segments<NDataSegment> existingSegments = cached.getSegments();
        NDataflow copy = this.copyForWrite(cached);
        updater.modify(copy);
        Set copySegIdSet = copy.getSegments().stream().map(RootPersistentEntity::getId).collect(Collectors.toSet());
        NDataSegDetailsManager nDataSegDetailsManager = NDataSegDetailsManager.getInstance((KylinConfig)copy.getConfig(), this.project);
        NDataLayoutDetailsManager dataLayoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)copy.getConfig(), this.project);
        for (NDataSegment segment : existingSegments) {
            if (copySegIdSet.contains(segment.getId())) continue;
            nDataSegDetailsManager.removeForSegment(segment.getId());
            if (cached.getModel().isBroken() || !cached.getModel().getStorageType().isV3Storage()) continue;
            dataLayoutDetailsManager.removeFragmentBySegment(copy, segment);
        }
        return this.crud.save(copy);
    }

    public long getDataflowStorageSize(String dataflowId) {
        return this.getDataflow(dataflowId).getStorageBytesSize();
    }

    public long getDataflowSourceSize(String modelId) {
        return this.getDataflow(modelId).getSourceBytesSize();
    }

    public long getDataflowLastBuildTime(String modelId) {
        return this.getDataflow(modelId).getLastBuildTime();
    }

    public void updateDataflowDetailsLayouts(NDataSegment seg, List<Long> toRemoveLayouts, List<Long> toAddLayouts) {
        NDataSegDetailsManager segDetailsManager = NDataSegDetailsManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project);
        segDetailsManager.updateDetails(seg, copyForWrite -> {
            LinkedList<NDataLayout> layouts = new LinkedList<NDataLayout>(copyForWrite.getAllLayouts());
            layouts.removeIf(layout -> toRemoveLayouts.contains(layout.getLayoutId()));
            List existLayouts = layouts.stream().map(NDataLayout::getLayoutId).collect(Collectors.toList());
            for (Long layoutId : toAddLayouts) {
                if (existLayouts.contains(layoutId)) continue;
                layouts.add(NDataLayout.newDataLayout(copyForWrite, layoutId));
            }
            copyForWrite.setLayouts(layouts);
        });
        NDataSegmentManager segManager = (NDataSegmentManager)this.config.getManager(this.project, NDataSegmentManager.class);
        segManager.update(seg.getUuid(), this::updateSegmentStatus);
    }

    public NDataflow updateDataflow(NDataflowUpdate update) {
        NIndexPlanManager indexPlanManager;
        IndexPlan indexPlan;
        this.updateDataflowWithoutIndex(update);
        if (ArrayUtils.isNotEmpty((Object[])update.getToRemoveSegs()) && !(indexPlan = (indexPlanManager = NIndexPlanManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project)).getIndexPlan(update.getDataflowId())).isBroken() && !indexPlan.getAllToBeDeleteLayoutId().isEmpty()) {
            indexPlanManager.updateIndexPlan(update.getDataflowId(), IndexPlan::removeTobeDeleteIndexIfNecessary);
        }
        return this.getDataflow(update.getDataflowId());
    }

    public void updateDataflowWithoutIndex(NDataflowUpdate update) {
        this.updateDataflow(update.getDataflowId(), df -> {
            Segments newSegs = (Segments)df.getSegments().clone();
            NDataSegmentManager segManager = (NDataSegmentManager)this.config.getManager(this.project, NDataSegmentManager.class);
            Arrays.stream((Object[])Optional.ofNullable(update.getToAddSegs()).orElse(new NDataSegment[0])).forEach(seg -> {
                seg.setDataflow(df);
                newSegs.add(seg);
                segManager.createAS(seg);
            });
            Arrays.stream((Object[])Optional.ofNullable(update.getToUpdateSegs()).orElse(new NDataSegment[0])).forEach(seg -> {
                seg.setDataflow(df);
                newSegs.replace(Comparator.comparing(RootPersistentEntity::getId), seg);
                segManager.update(seg.getUuid(), arg_0 -> ((NDataSegment)seg).copyPropertiesTo(arg_0));
            });
            if (update.getToRemoveSegs() != null) {
                Iterator iterator = newSegs.iterator();
                Set toRemoveIds = Arrays.stream(update.getToRemoveSegs()).map(RootPersistentEntity::getId).collect(Collectors.toSet());
                while (iterator.hasNext()) {
                    NDataSegment currentSeg = (NDataSegment)iterator.next();
                    if (!toRemoveIds.contains(currentSeg.getId())) continue;
                    logger.info("Remove segment {}", (Object)currentSeg);
                    iterator.remove();
                    segManager.delete(currentSeg);
                }
            }
            Arrays.stream((Object[])Optional.ofNullable(update.getToRemoveLayouts()).orElse(new NDataLayout[0])).forEach(removeLayout -> df.getLayoutHitCount().remove(removeLayout.getLayoutId()));
            df.setSegmentUuids(newSegs);
            RealizationStatusEnum newStatus = Optional.ofNullable(update.getStatus()).orElse(df.getStatus());
            df.setStatus(newStatus);
            df.setCost(update.getCost() > 0 ? update.getCost() : df.getCost());
            NDataSegDetailsManager.getInstance((KylinConfig)df.getConfig(), this.project).updateDataflow(df, update);
            newSegs.forEach(seg -> {
                if (this.needUpdateSegmentStatus((NDataSegment)seg)) {
                    segManager.update(seg.getUuid(), this::updateSegmentStatus);
                }
            });
        });
    }

    private void updateSegmentStatus(NDataSegment seg) {
        if (this.needUpdateSegmentStatus(seg)) {
            seg.setStatus(SegmentStatusEnum.READY);
        }
    }

    private boolean needUpdateSegmentStatus(NDataSegment seg) {
        NDataSegDetails segDetails = NDataSegDetailsManager.getInstance(seg.getConfig(), this.project).getForSegment(seg);
        return seg.getStatus() == SegmentStatusEnum.WARNING && segDetails != null && segDetails.getAllLayouts().isEmpty();
    }

    public NDataflow dropDataflow(String dfId) {
        NDataflow df = this.getDataflow(dfId);
        String dfInfo = dfId;
        if (df == null) {
            logger.warn("Dropping NDataflow '{}' does not exist", (Object)dfInfo);
            return null;
        }
        dfInfo = df.toString();
        logger.info("Dropping NDataflow '{}'", (Object)dfInfo);
        NDataSegDetailsManager segDetailsManager = NDataSegDetailsManager.getInstance(this.config, this.project);
        segDetailsManager.removeDetails(df);
        NDataSegmentManager dataSegmentManager = (NDataSegmentManager)this.config.getManager(this.project, NDataSegmentManager.class);
        df.getSegments().forEach(dataSegmentManager::delete);
        this.crud.delete(df);
        return df;
    }

    List<NDataSegment> calculateHoles(String dfId) {
        NDataflow df = this.getDataflow(dfId);
        Preconditions.checkNotNull((Object)df);
        return this.calculateHoles(dfId, df.getSegments());
    }

    public List<NDataSegment> calculateHoles(String dfId, List<NDataSegment> segments) {
        ArrayList holes = Lists.newArrayList();
        NDataflow df = this.getDataflow(dfId);
        Preconditions.checkNotNull((Object)df);
        Collections.sort(segments);
        for (int i = 0; i < segments.size() - 1; ++i) {
            NDataSegment first = segments.get(i);
            NDataSegment second = segments.get(i + 1);
            if (first.getSegRange().connects(second.getSegRange()) || !first.getSegRange().apartBefore(second.getSegRange())) continue;
            NDataSegment hole = new NDataSegment(df, first.getSegRange().gapTill(second.getSegRange()));
            hole.setTimeRange(new TimeRange(first.getTSRange().getEnd(), second.getTSRange().getStart()));
            holes.add(hole);
        }
        return holes;
    }

    public List<SegmentRange> calculateSegHoles(String dfId) {
        return this.calculateHoles(dfId).stream().map(NDataSegment::getSegRange).collect(Collectors.toList());
    }

    public List<NDataSegment> checkHoleIfNewSegBuild(String dfId, SegmentRange toBuildSegment) {
        NDataflow df = this.getDataflow(dfId);
        ArrayList segments = Lists.newArrayList(df.getSegments());
        if (toBuildSegment != null) {
            segments.add(new NDataSegment(df, toBuildSegment));
        }
        return this.calculateHoles(dfId, segments);
    }

    public void removeSegmentPartition(String dfId, Set<Long> toBeDeletedPartIds, Set<String> segments) {
        NDataSegmentManager segManager = (NDataSegmentManager)this.config.getManager(this.project, NDataSegmentManager.class);
        this.getDataflow(dfId).getSegmentUuids().forEach(segmentUuid -> {
            if (CollectionUtils.isEmpty((Collection)segments) || segments.contains(segmentUuid)) {
                segManager.update((String)segmentUuid, copyForWrite -> copyForWrite.getMultiPartitions().removeIf(partition -> toBeDeletedPartIds.contains(partition.getPartitionId())));
            }
        });
    }

    public void removeLayoutPartition(String dfId, Set<Long> toBeDeletedPartIds, Set<String> segments) {
        NDataflow dataflow = this.copy(this.getDataflow(dfId));
        ArrayList updateSegments = Lists.newArrayList();
        if (segments == null) {
            updateSegments.addAll(dataflow.getSegments());
        } else {
            updateSegments.addAll(dataflow.getSegments(segments));
        }
        ArrayList affectedLayouts = Lists.newArrayList();
        for (NDataSegment segment : updateSegments) {
            List<NDataLayout> layouts = segment.copy().getSegDetails().getAllLayouts();
            layouts.forEach(dataLayout -> {
                if (dataLayout.removeMultiPartition(toBeDeletedPartIds)) {
                    affectedLayouts.add(dataLayout);
                }
            });
        }
        NDataflowUpdate dfUpdate = new NDataflowUpdate(dfId);
        dfUpdate.setToAddOrUpdateLayouts(affectedLayouts.toArray(new NDataLayout[0]));
        NDataSegDetailsManager detailsManager = NDataSegDetailsManager.getInstance(KylinConfig.getInstanceFromEnv(), this.project);
        detailsManager.updateDataflow(dataflow, dfUpdate);
    }

    public boolean isOfflineModel(NDataflow df) {
        ProjectInstance prjManager = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(df.getProject());
        KylinConfigExt config = prjManager.getConfig();
        boolean offlineManually = df.getIndexPlan().isOfflineManually();
        boolean isOfflineMultiPartitionModel = df.getModel().isMultiPartitionModel() && !config.isMultiPartitionEnabled();
        boolean isOfflineScdModel = SCD2CondChecker.INSTANCE.isScd2Model(df.getModel()) && !config.isQueryNonEquiJoinModelEnabled();
        return offlineManually || isOfflineMultiPartitionModel || isOfflineScdModel;
    }

    public NDataflow getDataflow(String id, boolean loadSegLayoutInfo) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        NDataflow dataflow = this.crud.get(id);
        if (!loadSegLayoutInfo) {
            return dataflow;
        }
        dataflow.initAllSegLayoutInfo();
        return dataflow;
    }

    public NDataflow getDataflow(String id, Set<String> segmentIds) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        NDataflow dataflow = this.getDataflow(id, false);
        if (CollectionUtils.isEmpty(segmentIds)) {
            return dataflow;
        }
        if (Objects.isNull(dataflow)) {
            return null;
        }
        dataflow.initSegLayoutInfoById(segmentIds);
        return dataflow;
    }

    public static interface NDataflowUpdater {
        public void modify(NDataflow var1);
    }
}

