/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.MissingRootPersistentEntity;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDictionaryDesc;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.model.IEngineAware;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;

public class IndexPlan
extends RootPersistentEntity
implements Serializable,
IEngineAware {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="index_plan_override_indexes")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, String> indexPlanOverrideIndexes = Maps.newHashMap();
    @JsonManagedReference
    @JsonProperty(value="rule_based_index")
    private RuleBasedIndex ruleBasedIndex;
    @JsonManagedReference
    @JsonProperty(value="indexes")
    private List<IndexEntity> indexes = Lists.newArrayList();
    @JsonProperty(value="override_properties")
    private LinkedHashMap<String, String> overrideProps = Maps.newLinkedHashMap();
    @JsonProperty(value="to_be_deleted_indexes")
    private final List<IndexEntity> toBeDeletedIndexes = Lists.newArrayList();
    @JsonProperty(value="auto_merge_time_ranges")
    private long[] autoMergeTimeRanges;
    @JsonProperty(value="retention_range")
    private long retentionRange = 0L;
    @JsonProperty(value="engine_type")
    private int engineType = 80;
    @JsonProperty(value="dictionaries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<NDictionaryDesc> dictionaries;
    @JsonProperty(value="next_aggregation_index_id")
    private long nextAggregationIndexId = 0L;
    @JsonProperty(value="next_table_index_id")
    private long nextTableIndexId = 20000000000L;
    @JsonProperty(value="agg_shard_by_columns")
    private List<Integer> aggShardByColumns = Lists.newArrayList();
    @JsonProperty(value="extend_partition_columns")
    private List<Integer> extendPartitionColumns = Lists.newArrayList();
    @JsonProperty(value="layout_bucket_num")
    private Map<Long, Integer> layoutBucketNumMapping = Maps.newHashMap();
    @JsonProperty(value="approved_additional_recs")
    private int approvedAdditionalRecs;
    @JsonProperty(value="approved_removal_recs")
    private int approvedRemovalRecs;
    private KylinConfigExt config = null;
    private long prjMvccWhenConfigInitted = -1L;
    private long indexPlanMvccWhenConfigInitted = -1L;
    private transient BiMap<Integer, TblColRef> effectiveDimCols;
    private transient BiMap<Integer, NDataModel.Measure> effectiveMeasures;
    private final LinkedHashSet<TblColRef> allColumns = Sets.newLinkedHashSet();
    private Set<Integer> allColumnsIndex = new HashSet<Integer>();
    private List<LayoutEntity> ruleBasedLayouts = Lists.newArrayList();
    private LayoutEntity baseAggLayout;
    private LayoutEntity baseTableLayout;
    private final AtomicReference<Object> idMapping = new AtomicReference();
    private final List<String> errors = Lists.newLinkedList();
    @JsonProperty(value="base_agg_index_reduce_high_cardinality_dim")
    private boolean baseAggIndexReduceHighCardinalityDim;
    @JsonProperty(value="planner_white_list")
    private List<Long> plannerWhiteList = new ArrayList<Long>();
    public static final String STORAGE_V3_MODEL_DEFAULT_PARTITION_BY_CONF_KEY = "kylin.model.layout.storage.v3-partition-by-columns";
    public static final String STORAGE_V3_MODEL_DEFAULT_ZORDER_BY_CONF_KEY = "kylin.model.layout.storage.v3-zorder-by-columns";
    public static final String STORAGE_V3_MODEL_DEFAULT_MAX_FILE_SIZE_CONF_KEY = "kylin.model.layout.storage.v3-max-file-size-in-bytes";
    public static final String STORAGE_V3_MODEL_DEFAULT_MIN_FILE_SIZE_CONF_KEY = "kylin.model.layout.storage.v3-min-file-size-in-bytes";
    public static final String STORAGE_V3_CONFIG_COLUMN_SEPARATOR = "\u0001";

    public void initAfterReload(KylinConfig config, String p) {
        this.project = p;
        this.initConfig4IndexPlan(config);
        Preconditions.checkNotNull((Object)((Object)this.getModel()), (String)"NDataModel(%s) not found", (Object)this.uuid);
        this.initAllCuboids();
        this.initDimensionAndMeasures();
        this.initAllColumns();
        this.initDictionaryDesc();
        this.initBaseLayouts();
        this.setDependencies(this.calcDependencies());
    }

    private void initBaseLayouts() {
        for (IndexEntity index : this.indexes) {
            for (LayoutEntity layout : index.getLayouts()) {
                if (layout.isBase() && IndexEntity.isTableIndex(layout.getId())) {
                    this.baseTableLayout = layout;
                }
                if (!layout.isBase() || !IndexEntity.isAggIndex(layout.getId())) continue;
                this.baseAggLayout = layout;
            }
        }
    }

    public List<RootPersistentEntity> calcDependencies() {
        NDataModelManager manager = NDataModelManager.getInstance((KylinConfig)this.config, this.project);
        NDataModel dataModelDesc = manager.getDataModelDesc(this.uuid);
        return Lists.newArrayList((Object[])new RootPersistentEntity[]{dataModelDesc != null ? dataModelDesc : new MissingRootPersistentEntity(MetadataType.mergeKeyWithType((String)this.uuid, (MetadataType)MetadataType.MODEL))});
    }

    private void initConfig4IndexPlan(KylinConfig config) {
        LinkedHashMap newOverrides = Maps.newLinkedHashMap(this.overrideProps);
        ProjectInstance ownerPrj = NProjectManager.getInstance(config).getProject(this.project);
        Map<String, String> prjOverrideProps = ownerPrj.getLegalOverrideKylinProps();
        for (Map.Entry<String, String> entry : prjOverrideProps.entrySet()) {
            if (newOverrides.containsKey(entry.getKey())) continue;
            newOverrides.put(entry.getKey(), entry.getValue());
        }
        this.config = KylinConfigExt.createInstance((KylinConfig)config, (Map)newOverrides);
        this.prjMvccWhenConfigInitted = ownerPrj.getMvcc();
        this.indexPlanMvccWhenConfigInitted = this.getMvcc();
    }

    private void initAllCuboids() {
        if (this.ruleBasedIndex == null) {
            return;
        }
        this.ruleBasedIndex.init();
        if (this.ruleBasedIndex.getBaseLayoutEnabled() == null) {
            this.ruleBasedIndex.setBaseLayoutEnabled(this.getConfig().isBaseCuboidAlwaysValid());
        }
        this.ruleBasedLayouts.addAll(this.ruleBasedIndex.genCuboidLayouts(true));
        if (this.config.base().isSystemConfig() && this.isCachedAndShared) {
            this.ruleBasedIndex.getCuboidScheduler().validateOrder();
        }
    }

    private void initDimensionAndMeasures() {
        List<IndexEntity> indexes = this.getAllIndexes();
        int size1 = 1;
        int size2 = 1;
        for (IndexEntity cuboid : indexes) {
            size1 = Math.max(cuboid.getDimensionBitset().size(), size1);
            size2 = Math.max(cuboid.getMeasureBitset().size(), size2);
        }
        BitSet dimBitSet = new BitSet(size1);
        BitSet measureBitSet = new BitSet(size2);
        for (IndexEntity cuboid : indexes) {
            dimBitSet.or(cuboid.getDimensionBitset().mutable());
            measureBitSet.or(cuboid.getMeasureBitset().mutable());
        }
        this.effectiveDimCols = Maps.filterKeys(this.getModel().getEffectiveCols(), input -> input != null && dimBitSet.get((int)input));
        this.effectiveMeasures = Maps.filterKeys(this.getModel().getEffectiveMeasures(), input -> input != null && measureBitSet.get((int)input));
    }

    private void initAllColumns() {
        this.allColumns.clear();
        this.allColumns.addAll(this.effectiveDimCols.values());
        for (NDataModel.Measure measure : this.effectiveMeasures.values()) {
            this.allColumns.addAll(measure.getFunction().getColRefs());
        }
        for (JoinTableDesc join : this.getModel().getJoinTables()) {
            CollectionUtils.addAll(this.allColumns, (Object[])join.getJoin().getForeignKeyColumns());
            this.allColumns.addAll(join.getTableRef().getColumns());
        }
        this.initAllColumnsIndex();
    }

    private void initAllColumnsIndex() {
        HashMap tblColMap = Maps.newHashMap();
        ImmutableBiMap<Integer, TblColRef> effectiveCols = this.getModel().getEffectiveCols();
        effectiveCols.forEach((key, value) -> tblColMap.put(value, key));
        this.allColumnsIndex = this.allColumns.stream().map(tblColMap::get).collect(Collectors.toSet());
    }

    private void initDictionaryDesc() {
        if (this.dictionaries != null) {
            for (NDictionaryDesc dictDesc : this.dictionaries) {
                dictDesc.init(this.getModel());
                this.allColumns.add(dictDesc.getColumnRef());
                if (dictDesc.getResuseColumnRef() == null) continue;
                this.allColumns.add(dictDesc.getResuseColumnRef());
            }
        }
    }

    public String resourceName() {
        return this.uuid;
    }

    public MetadataType resourceType() {
        return MetadataType.INDEX_PLAN;
    }

    public IndexPlan copy() {
        return NIndexPlanManager.getInstance((KylinConfig)this.config, this.project).copy(this);
    }

    public IndexEntity getIndexEntity(long indexId) {
        return this.getIdMapping().getIndexEntity(indexId);
    }

    public LayoutEntity getLayoutEntity(Long layoutId) {
        return this.getIdMapping().getLayoutEntity(layoutId);
    }

    public KylinConfig getConfig() {
        if (this.config == null) {
            return null;
        }
        ProjectInstance ownerPrj = NProjectManager.getInstance((KylinConfig)this.config).getProject(this.project);
        if (ownerPrj.getMvcc() != this.prjMvccWhenConfigInitted || this.getMvcc() != this.indexPlanMvccWhenConfigInitted) {
            this.initConfig4IndexPlan((KylinConfig)this.config);
        }
        return this.config;
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public List<String> getError() {
        return this.errors;
    }

    String getErrorMsg() {
        return Joiner.on((String)" ").join(this.errors);
    }

    public String getProject() {
        return this.project;
    }

    public NDataModel getModel() {
        return NDataModelManager.getInstance((KylinConfig)this.config, this.project).getDataModelDesc(this.uuid);
    }

    public String getModelAlias() {
        NDataModel model = this.getModel();
        return model == null ? null : model.getAlias();
    }

    public BiMap<Integer, TblColRef> getEffectiveDimCols() {
        return this.effectiveDimCols;
    }

    public BiMap<Integer, NDataModel.Measure> getEffectiveMeasures() {
        return this.effectiveMeasures;
    }

    public Set<TblColRef> listAllTblColRefs() {
        return this.allColumns;
    }

    public Set<Integer> listAllTblColRefsIndex() {
        return this.allColumnsIndex;
    }

    private void addLayout2TargetIndex(LayoutEntity sourceLayout, IndexEntity targetIndex) {
        this.addLayout2TargetIndex(sourceLayout, targetIndex, false);
    }

    private void addLayout2TargetIndex(LayoutEntity sourceLayout, IndexEntity targetIndex, boolean toBeDeleted) {
        Preconditions.checkNotNull((Object)sourceLayout);
        Preconditions.checkNotNull((Object)targetIndex);
        List<LayoutEntity> originLayouts = targetIndex.getLayouts();
        boolean isMatch = originLayouts.stream().filter(originLayout -> originLayout.equals(sourceLayout)).peek(originLayout -> {
            if (!originLayout.isBaseIndex()) {
                originLayout.setManual(true);
            }
        }).count() > 0L;
        LayoutEntity copy = (LayoutEntity)JsonUtil.deepCopyQuietly((Object)sourceLayout, LayoutEntity.class);
        copy.setToBeDeleted(toBeDeleted);
        copy.setIndex(targetIndex);
        if (!isMatch) {
            originLayouts.add(copy);
        }
        targetIndex.setNextLayoutOffset(Math.max(targetIndex.getNextLayoutOffset(), originLayouts.stream().mapToLong(LayoutEntity::getId).max().orElse(0L) % 10000L + 1L));
    }

    public List<IndexEntity> getAllIndexes() {
        return this.getAllIndexes(true);
    }

    public List<IndexEntity> getAllIndexes(boolean withToBeDeletedIndexes) {
        IndexEntity copy;
        HashMap retSubscriptMap = Maps.newHashMap();
        ArrayList mergedIndexes = Lists.newArrayList();
        int retSubscript = 0;
        for (IndexEntity indexEntity : this.indexes) {
            copy = (IndexEntity)JsonUtil.deepCopyQuietly((Object)indexEntity, IndexEntity.class);
            retSubscriptMap.put(indexEntity.getId(), retSubscript);
            mergedIndexes.add(copy);
            HashMap layouts = Maps.newHashMap();
            indexEntity.getLayouts().forEach(layout -> layouts.putIfAbsent(layout.getId(), layout));
            copy.getLayouts().forEach(layout -> layout.setInProposing(((LayoutEntity)layouts.get(layout.getId())).isInProposing()));
            ++retSubscript;
        }
        for (LayoutEntity ruleBasedLayout : this.getRuleBaseLayouts()) {
            IndexEntity ruleRelatedIndex = ruleBasedLayout.getIndex();
            if (!retSubscriptMap.containsKey(ruleRelatedIndex.getId())) {
                IndexEntity copy2 = (IndexEntity)JsonUtil.deepCopyQuietly((Object)ruleRelatedIndex, IndexEntity.class);
                retSubscriptMap.put(ruleRelatedIndex.getId(), retSubscript);
                mergedIndexes.add(copy2);
                ++retSubscript;
            }
            Integer subscript = (Integer)retSubscriptMap.get(ruleRelatedIndex.getId());
            IndexEntity targetIndex = (IndexEntity)mergedIndexes.get(subscript);
            this.addLayout2TargetIndex(ruleBasedLayout, targetIndex);
        }
        if (withToBeDeletedIndexes) {
            for (IndexEntity indexEntity : this.toBeDeletedIndexes) {
                if (!retSubscriptMap.containsKey(indexEntity.getId())) {
                    copy = (IndexEntity)JsonUtil.deepCopyQuietly((Object)indexEntity, IndexEntity.class);
                    retSubscriptMap.put(indexEntity.getId(), retSubscript);
                    mergedIndexes.add(copy);
                    copy.getLayouts().forEach(layoutEntity -> layoutEntity.setToBeDeleted(true));
                    ++retSubscript;
                    continue;
                }
                Integer subscript = (Integer)retSubscriptMap.get(indexEntity.getId());
                IndexEntity targetIndex = (IndexEntity)mergedIndexes.get(subscript);
                for (LayoutEntity layoutEntity2 : indexEntity.getLayouts()) {
                    this.addLayout2TargetIndex(layoutEntity2, targetIndex, true);
                }
            }
        }
        mergedIndexes.forEach(value -> value.setIndexPlan(this));
        return mergedIndexes;
    }

    public List<LayoutEntity> getAllLayouts() {
        ArrayList r = Lists.newArrayList();
        for (IndexEntity cd : this.getAllIndexes()) {
            r.addAll(cd.getLayouts());
        }
        return r;
    }

    public List<ImmutablePair<LayoutEntity, Boolean>> getAllLayoutsReadOnly() {
        HashMap resultMap = Maps.newHashMap();
        for (IndexEntity indexEntity : this.indexes) {
            indexEntity.getLayouts().forEach(layout -> this.classifyByIndexId((LayoutEntity)layout, resultMap, layout.isToBeDeleted()));
        }
        for (LayoutEntity ruleBasedLayout : this.getRuleBaseLayouts()) {
            this.classifyByIndexId(ruleBasedLayout, resultMap, false);
        }
        for (IndexEntity indexEntity : this.toBeDeletedIndexes) {
            indexEntity.getLayouts().forEach(layout -> this.classifyByIndexId((LayoutEntity)layout, resultMap, true));
            ((Map)resultMap.get(indexEntity.getId())).entrySet().forEach(layoutMap -> layoutMap.setValue(true));
        }
        return resultMap.values().stream().flatMap(layoutMap -> layoutMap.entrySet().stream().map(p -> ImmutablePair.of(p.getKey(), p.getValue()))).collect(Collectors.toList());
    }

    private void classifyByIndexId(LayoutEntity layout, Map<Long, Map<LayoutEntity, Boolean>> resultMap, boolean toBeDeleted) {
        resultMap.compute(layout.getIndexId(), (indexId, layoutMap) -> {
            layoutMap = layoutMap == null ? Maps.newHashMap() : layoutMap;
            layoutMap.put(layout, toBeDeleted);
            return layoutMap;
        });
    }

    public Map<Long, LayoutEntity> getAllLayoutsMap() {
        HashMap map = Maps.newHashMap();
        this.getAllLayouts().forEach(layout -> map.putIfAbsent(layout.getId(), layout));
        return map;
    }

    public List<LayoutEntity> getWhitelistLayouts() {
        ArrayList r = Lists.newArrayList();
        for (IndexEntity cd : this.indexes) {
            r.addAll(cd.getLayouts());
        }
        return r;
    }

    public List<LayoutEntity> getRuleBaseLayouts() {
        return this.isCachedAndShared ? ImmutableList.copyOf(this.ruleBasedLayouts) : this.ruleBasedLayouts;
    }

    public void setIndexes(List<IndexEntity> indexes) {
        this.checkIsNotCachedAndShared();
        this.indexes = indexes;
        this.updateNextId();
    }

    private Set<LayoutEntity> layoutsNotIn(Set<LayoutEntity> source, Set<LayoutEntity> target) {
        Preconditions.checkNotNull(source);
        Preconditions.checkNotNull(target);
        return source.stream().filter(layout -> !target.contains(layout)).collect(Collectors.toSet());
    }

    public UpdateRuleImpact diffRuleBasedIndex(RuleBasedIndex ruleBasedIndex) {
        ruleBasedIndex.adjustMeasures();
        if (CollectionUtils.isEmpty(ruleBasedIndex.getMeasures())) {
            ruleBasedIndex.setMeasures(Lists.newArrayList((Iterable)this.getModel().getEffectiveMeasures().keySet()));
        }
        ruleBasedIndex.setIndexStartId(this.nextAggregationIndexId);
        ruleBasedIndex.setIndexPlan(this);
        ruleBasedIndex.init();
        HashSet sourceLayouts = null == this.ruleBasedIndex ? Sets.newHashSet() : this.ruleBasedIndex.genCuboidLayouts();
        HashSet previousDeletedLayouts = null == this.ruleBasedIndex ? Sets.newHashSet() : this.ruleBasedIndex.getBlacklistLayouts();
        ruleBasedIndex.genCuboidLayouts(Sets.newHashSet((Iterable)sourceLayouts), previousDeletedLayouts);
        Set<LayoutEntity> targetLayouts = ruleBasedIndex.genCuboidLayouts();
        return new UpdateRuleImpact(this.layoutsNotIn(sourceLayouts, targetLayouts), this.layoutsNotIn(targetLayouts, sourceLayouts), ruleBasedIndex.getBlacklistLayouts());
    }

    public void setRuleBasedIndex(RuleBasedIndex ruleBasedIndex) {
        this.setRuleBasedIndex(ruleBasedIndex, false);
    }

    public void setRuleBasedIndex(RuleBasedIndex ruleBasedIndex, boolean reuseStartId) {
        this.setRuleBasedIndex(ruleBasedIndex, reuseStartId, false);
    }

    public void setRuleBasedIndex(RuleBasedIndex ruleBasedIndex, boolean reuseStartId, boolean markToBeDeleted) {
        this.setRuleBasedIndex(ruleBasedIndex, Sets.newHashSet(), reuseStartId, markToBeDeleted, false);
    }

    public void setRuleBasedIndex(RuleBasedIndex ruleBasedIndex, Set<LayoutEntity> reloadLayouts, boolean reuseStartId, boolean markToBeDeleted, boolean restoreDeletedIndex) {
        Set<LayoutEntity> toBeDeletedSet;
        if (ruleBasedIndex == null) {
            return;
        }
        this.checkIsNotCachedAndShared();
        ruleBasedIndex.adjustMeasures();
        if (CollectionUtils.isEmpty(ruleBasedIndex.getMeasures())) {
            ruleBasedIndex.setMeasures(Lists.newArrayList((Iterable)this.getModel().getEffectiveMeasures().keySet()));
        }
        ruleBasedIndex.setIndexStartId(reuseStartId ? ruleBasedIndex.getIndexStartId() : this.nextAggregationIndexId);
        ruleBasedIndex.setIndexPlan(this);
        ruleBasedIndex.init();
        HashSet originSet = this.ruleBasedIndex == null ? Sets.newHashSet() : this.ruleBasedIndex.genCuboidLayouts();
        Set<Object> needDelLayouts = Sets.newHashSet();
        if (!restoreDeletedIndex) {
            needDelLayouts = this.getBlacklistLayouts();
            needDelLayouts = needDelLayouts.stream().filter(l -> !reloadLayouts.contains(l)).collect(Collectors.toSet());
        }
        ruleBasedIndex.genCuboidLayouts(Sets.newHashSet((Iterable)originSet), needDelLayouts);
        this.ruleBasedIndex = ruleBasedIndex;
        Set<LayoutEntity> targetSet = this.ruleBasedIndex.genCuboidLayouts();
        this.ruleBasedLayouts = Lists.newArrayList(this.ruleBasedIndex.genCuboidLayouts(true));
        if (markToBeDeleted && CollectionUtils.isNotEmpty(this.layoutsNotIn(targetSet, originSet)) && CollectionUtils.isNotEmpty(toBeDeletedSet = this.layoutsNotIn(originSet, targetSet))) {
            this.markIndexesToBeDeleted(ruleBasedIndex.getIndexPlan().getUuid(), toBeDeletedSet);
        }
        this.updateNextId();
    }

    private Set<LayoutEntity> getBlacklistLayouts() {
        if (this.ruleBasedIndex == null) {
            return Sets.newHashSet();
        }
        return this.ruleBasedIndex.getBlacklistLayouts();
    }

    public void setAggShardByColumns(List<Integer> aggShardByColumns) {
        this.checkIsNotCachedAndShared();
        if (this.ruleBasedIndex != null) {
            Set<LayoutEntity> ruleLayouts = this.ruleBasedIndex.genCuboidLayouts();
            this.aggShardByColumns = aggShardByColumns;
            List<Long> prevLayoutIdList = this.ruleBasedIndex.getLayoutIdMapping();
            this.ruleBasedIndex.setIndexStartId(this.nextAggregationIndexId);
            this.ruleBasedIndex.setLayoutIdMapping(Lists.newArrayList());
            this.ruleBasedIndex.genCuboidLayouts(ruleLayouts);
            List<Long> curRuleLayouts = this.ruleBasedIndex.getLayoutIdMapping();
            Set<Long> layoutBlackList = this.ruleBasedIndex.getLayoutBlackList().stream().map(id -> {
                int position = prevLayoutIdList.indexOf(id);
                return position == -1 ? Long.valueOf(-1L) : (Long)curRuleLayouts.get(position);
            }).collect(Collectors.toSet());
            this.ruleBasedIndex.setLayoutBlackList(layoutBlackList);
            this.ruleBasedLayouts = Lists.newArrayList(this.ruleBasedIndex.genCuboidLayouts(true));
        }
        this.aggShardByColumns = aggShardByColumns;
        this.updateNextId();
    }

    public void setExtendPartitionColumns(List<Integer> extendPartitionColumns) {
        this.checkIsNotCachedAndShared();
        if (this.ruleBasedIndex != null) {
            Set<LayoutEntity> ruleLayouts = this.ruleBasedIndex.genCuboidLayouts();
            this.extendPartitionColumns = extendPartitionColumns;
            this.ruleBasedIndex.setLayoutIdMapping(Lists.newArrayList());
            this.ruleBasedIndex.genCuboidLayouts(ruleLayouts);
            this.ruleBasedLayouts = Lists.newArrayList(this.ruleBasedIndex.genCuboidLayouts(true));
        }
        this.extendPartitionColumns = extendPartitionColumns;
        this.updateNextId();
    }

    private Map<IndexEntity.IndexIdentifier, IndexEntity> getToBeDeletedIndexesMap() {
        return this.getIndexesMap(this.toBeDeletedIndexes);
    }

    public void markIndexesToBeDeleted(String indexPlanId, Set<LayoutEntity> toBeDeletedSet) {
        Preconditions.checkNotNull((Object)indexPlanId);
        Preconditions.checkNotNull(toBeDeletedSet);
        this.checkIsNotCachedAndShared();
        if (CollectionUtils.isEmpty(toBeDeletedSet)) {
            return;
        }
        NDataflow df = NDataflowManager.getInstance((KylinConfig)this.config, this.project).getDataflow(indexPlanId);
        Segments<NDataSegment> readySegs = df.getSegments(SegmentStatusEnum.READY, SegmentStatusEnum.WARNING);
        if (readySegs.isEmpty()) {
            return;
        }
        Set effectiveLayouts = readySegs.stream().flatMap(seg -> seg.getLayoutIds().stream()).collect(Collectors.toSet());
        Map<IndexEntity.IndexIdentifier, IndexEntity> toBeDeletedMap = this.getToBeDeletedIndexesMap();
        for (LayoutEntity layoutEntity : toBeDeletedSet) {
            if (!effectiveLayouts.contains(layoutEntity.getId())) continue;
            IndexEntity.IndexIdentifier identifier = layoutEntity.getIndex().createIndexIdentifier();
            if (!toBeDeletedMap.containsKey(identifier)) {
                IndexEntity newIndexEntity = (IndexEntity)JsonUtil.deepCopyQuietly((Object)layoutEntity.getIndex(), IndexEntity.class);
                newIndexEntity.setLayouts(Lists.newArrayList());
                this.toBeDeletedIndexes.add(newIndexEntity);
                toBeDeletedMap.put(identifier, newIndexEntity);
            }
            LayoutEntity layout = (LayoutEntity)JsonUtil.deepCopyQuietly((Object)layoutEntity, LayoutEntity.class);
            if (toBeDeletedMap.get(identifier).getLayouts().contains(layout)) continue;
            toBeDeletedMap.get(identifier).getLayouts().add(layout);
        }
    }

    public void markWhiteIndexToBeDelete(String indexPlanId, Set<Long> layoutIds) {
        Preconditions.checkNotNull((Object)indexPlanId);
        Preconditions.checkNotNull(layoutIds);
        this.checkIsNotCachedAndShared();
        HashSet toBeDeletedLayouts = Sets.newHashSet();
        for (IndexEntity indexEntity : this.getIndexes()) {
            for (LayoutEntity layoutEntity : indexEntity.getLayouts()) {
                if (!layoutIds.contains(layoutEntity.getId())) continue;
                toBeDeletedLayouts.add(layoutEntity);
            }
        }
        this.markIndexesToBeDeleted(indexPlanId, toBeDeletedLayouts);
        for (LayoutEntity layoutEntity : toBeDeletedLayouts) {
            layoutEntity.getIndex().removeLayouts(Lists.newArrayList((Object[])new LayoutEntity[]{layoutEntity}), null, true, true);
        }
    }

    public void removeTobeDeleteIndexIfNecessary() {
        this.checkIsNotCachedAndShared();
        Set<Long> toBeDeleteIds = this.getAllToBeDeleteLayoutId();
        if (toBeDeleteIds.isEmpty()) {
            return;
        }
        NDataflow dataFlow = NDataflowManager.getInstance((KylinConfig)this.config, this.project).getDataflow(this.getUuid());
        if (null == dataFlow.getLatestReadySegment()) {
            this.toBeDeletedIndexes.clear();
            return;
        }
        boolean existTobeDeleteLayout = false;
        for (NDataSegment seg : dataFlow.getSegments()) {
            if (!CollectionUtils.isNotEmpty((Collection)Sets.intersection(seg.getLayoutsMap().keySet(), toBeDeleteIds))) continue;
            existTobeDeleteLayout = true;
            break;
        }
        if (!existTobeDeleteLayout) {
            this.toBeDeletedIndexes.clear();
        }
    }

    public void addRuleBasedBlackList(Collection<Long> blacklist) {
        this.checkIsNotCachedAndShared();
        if (this.ruleBasedIndex != null) {
            Set<Long> originBlacklist = this.ruleBasedIndex.getLayoutBlackList();
            HashSet newBlacklist = Sets.newHashSet(originBlacklist);
            newBlacklist.addAll(blacklist);
            this.ruleBasedIndex.setLayoutBlackList(newBlacklist);
            this.ruleBasedLayouts = Lists.newArrayList(this.ruleBasedIndex.genCuboidLayouts(true));
        }
        this.updateNextId();
    }

    public void updateNextId() {
        List<IndexEntity> allIndexes = this.getAllIndexes();
        this.nextAggregationIndexId = Math.max(allIndexes.stream().filter(c -> !c.isTableIndex()).mapToLong(IndexEntity::getId).max().orElse(-10000L) + 10000L, this.nextAggregationIndexId);
        if (this.ruleBasedIndex != null) {
            this.nextAggregationIndexId = Math.max(this.ruleBasedIndex.getLayoutIdMapping().stream().mapToLong(id -> id).max().orElse(-10000L) + 10000L, this.nextAggregationIndexId);
            this.nextAggregationIndexId -= this.nextAggregationIndexId % 10000L;
        }
        this.nextTableIndexId = Math.max(allIndexes.stream().filter(IndexEntity::isTableIndex).mapToLong(IndexEntity::getId).max().orElse(19999990000L) + 10000L, this.nextTableIndexId);
        Map<Long, Long> indexNextIdMap = allIndexes.stream().collect(Collectors.toMap(IndexEntity::getId, k -> k.getLayouts().stream().mapToLong(LayoutEntity::getId).max().orElse(0L) % 10000L + 1L));
        for (IndexEntity index : this.indexes) {
            long nextLayoutId = indexNextIdMap.getOrDefault(index.getId(), 1L);
            index.setNextLayoutOffset(Math.max(nextLayoutId, index.getNextLayoutOffset()));
        }
    }

    public void setDescription(String description) {
        this.checkIsNotCachedAndShared();
        this.description = description;
    }

    public ImmutableMap<Integer, String> getIndexPlanOverrideIndexes() {
        return ImmutableMap.copyOf(this.indexPlanOverrideIndexes);
    }

    public void setIndexPlanOverrideIndexes(Map<Integer, String> m) {
        this.checkIsNotCachedAndShared();
        this.indexPlanOverrideIndexes = m;
    }

    public LinkedHashMap<String, String> getOverrideProps() {
        return this.isCachedAndShared ? Maps.newLinkedHashMap(this.overrideProps) : this.overrideProps;
    }

    public void setOverrideProps(Map<String, String> overrideProps) {
        this.checkIsNotCachedAndShared();
        this.overrideProps = KylinConfig.trimKVFromMap(overrideProps);
        this.initConfig4IndexPlan((KylinConfig)this.config);
    }

    public long[] getAutoMergeTimeRanges() {
        return this.isCachedAndShared ? Arrays.copyOf(this.autoMergeTimeRanges, this.autoMergeTimeRanges.length) : this.autoMergeTimeRanges;
    }

    public void setAutoMergeTimeRanges(long[] autoMergeTimeRanges) {
        this.checkIsNotCachedAndShared();
        this.autoMergeTimeRanges = autoMergeTimeRanges;
    }

    public void setRetentionRange(long retentionRange) {
        this.checkIsNotCachedAndShared();
        this.retentionRange = retentionRange;
    }

    public Map<IndexEntity.IndexIdentifier, IndexEntity> getWhiteListIndexesMap() {
        return this.getIndexesMap(this.indexes);
    }

    public Map<IndexEntity.IndexIdentifier, IndexEntity> getAllIndexesMap() {
        return this.getIndexesMap(this.getAllIndexes());
    }

    private Map<IndexEntity.IndexIdentifier, IndexEntity> getIndexesMap(List<IndexEntity> indexEntities) {
        LinkedHashMap originIndexMap = Maps.newLinkedHashMap();
        for (IndexEntity indexEntity : indexEntities) {
            IndexEntity.IndexIdentifier identifier = indexEntity.createIndexIdentifier();
            if (!originIndexMap.containsKey(identifier)) {
                originIndexMap.put(identifier, indexEntity);
                continue;
            }
            ((IndexEntity)originIndexMap.get(identifier)).getLayouts().addAll(indexEntity.getLayouts());
        }
        return this.isCachedAndShared ? ImmutableMap.copyOf((Map)originIndexMap) : originIndexMap;
    }

    @Override
    public int getEngineType() {
        return this.engineType;
    }

    public void setEngineType(int engineType) {
        this.checkIsNotCachedAndShared();
        this.engineType = engineType;
    }

    public List<NDictionaryDesc> getDictionaries() {
        return this.dictionaries == null ? null : (this.isCachedAndShared ? ImmutableList.copyOf(this.dictionaries) : Collections.unmodifiableList(this.dictionaries));
    }

    public void setDictionaries(List<NDictionaryDesc> dictionaries) {
        this.checkIsNotCachedAndShared();
        this.dictionaries = dictionaries;
    }

    public String toString() {
        return "IndexPlan [" + this.uuid + "(" + this.getModelAlias() + ")]";
    }

    public void removeLayouts(Set<Long> layoutIds, boolean deleteAuto, boolean deleteManual) {
        this.removeLayouts(this.indexes, layoutIds, deleteAuto, deleteManual);
        this.removeLayouts(this.toBeDeletedIndexes, layoutIds, deleteAuto, deleteManual);
        this.addRuleBasedBlackList((Collection<Long>)Sets.intersection(this.getRuleBaseLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toSet()), layoutIds));
    }

    private void removeLayouts(Collection<IndexEntity> indexes, Set<Long> layoutIds, boolean deleteAuto, boolean deleteManual) {
        this.checkIsNotCachedAndShared();
        Iterator<IndexEntity> indexIt = indexes.iterator();
        while (indexIt.hasNext()) {
            IndexEntity index = indexIt.next();
            Iterator<LayoutEntity> it = index.getLayouts().iterator();
            while (it.hasNext()) {
                LayoutEntity layout = it.next();
                if (!layoutIds.contains(layout.getId())) continue;
                if (deleteAuto) {
                    layout.setAuto(false);
                }
                if (deleteManual) {
                    layout.setManual(false);
                }
                if (!layout.isExpired()) continue;
                it.remove();
            }
            if (!index.getLayouts().isEmpty()) continue;
            indexIt.remove();
        }
    }

    public boolean isSkipEncodeIntegerFamilyEnabled() {
        return this.overrideProps.containsKey("kylin.query.skip-encode-integer-enabled") && Boolean.parseBoolean(this.overrideProps.get("kylin.query.skip-encode-integer-enabled"));
    }

    public boolean isFastBitmapEnabled() {
        return this.overrideProps.containsKey("kylin.query.fast-bitmap-enabled") && Boolean.parseBoolean(this.overrideProps.get("kylin.query.fast-bitmap-enabled"));
    }

    public boolean containBaseTableLayout() {
        return this.baseTableLayout != null;
    }

    public boolean containBaseAggLayout() {
        return this.baseAggLayout != null;
    }

    public int getBaseIndexCount() {
        int num = 0;
        if (this.baseAggLayout != null) {
            ++num;
        }
        if (this.baseTableLayout != null) {
            ++num;
        }
        return num;
    }

    public void addIndex(IndexEntity index, boolean needAssignId) {
        this.checkIsNotCachedAndShared();
        this.indexes.add(index);
        if (needAssignId) {
            if (!index.isTableIndex()) {
                index.assignId(this.nextAggregationIndexId);
            } else {
                index.assignId(this.nextTableIndexId);
            }
            this.updateNextId();
        }
    }

    public LayoutEntity createBaseAggIndex(NDataModel model) {
        Object dims;
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance(KylinConfig.getInstanceFromEnv(), model.getProject());
        if (this.isBaseAggIndexReduceHighCardinalityDim()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (Integer dimId : model.getEffectiveDimensions().keySet()) {
                TblColRef colRef = model.getColRef(dimId);
                if (tableManager.isHighCardinalityDim(colRef)) continue;
                list.add(dimId);
            }
            dims = list;
        } else {
            dims = model.getEffectiveDimensions().keySet().asList();
        }
        ImmutableList measures = model.getEffectiveMeasures().keySet().asList();
        List<Integer> colOrder = this.naturalOrderCombine((List<Integer>)dims, (List<Integer>)measures);
        return this.createLayout(colOrder, true, true, Lists.newArrayList());
    }

    public LayoutEntity createBaseTableIndex() {
        return this.createBaseTableIndex(this.getModel());
    }

    public LayoutEntity createBaseTableIndex(NDataModel model) {
        List<Integer> measureCols;
        ImmutableList dims = model.getEffectiveDimensions().keySet().asList();
        List<Integer> colOrder = this.naturalOrderCombine((List<Integer>)dims, measureCols = model.getMeasureRelatedCols());
        if (colOrder.isEmpty()) {
            return null;
        }
        return this.createLayout(colOrder, false, true, Lists.newArrayList());
    }

    public LayoutEntity createLayout(List<Integer> colOrder, boolean isAgg, boolean isBase, List<Integer> shardByCols) {
        LayoutEntity newLayout = new LayoutEntity();
        newLayout.setColOrder(colOrder);
        newLayout.setUpdateTime(System.currentTimeMillis());
        newLayout.setBase(isBase);
        newLayout.initalId(isAgg);
        newLayout.setShardByColumns(shardByCols);
        return newLayout;
    }

    private List<Integer> naturalOrderCombine(List<Integer> col1, List<Integer> col2) {
        return ImmutableSortedSet.naturalOrder().addAll(col1).addAll(col2).build().asList();
    }

    public Optional<LayoutEntity> removeLayoutSameWith(LayoutEntity layout) {
        Optional<LayoutEntity> oldLayout = this.getLayoutSameWith(layout);
        if (oldLayout.isPresent()) {
            this.removeLayouts(Sets.newHashSet((Object[])new Long[]{oldLayout.get().getId()}), true, true);
        }
        return oldLayout;
    }

    public Optional<LayoutEntity> getLayoutSameWith(LayoutEntity layout) {
        return this.getIdMapping().allLayoutMapping.values().stream().filter(l -> l.equals(layout)).findFirst();
    }

    public boolean needUpdateBaseAggLayout(LayoutEntity replace, boolean isAuto) {
        return this.needUpdate(this.baseAggLayout, replace, isAuto);
    }

    public boolean needUpdateBaseTableLayout(LayoutEntity replace, boolean isAuto) {
        return this.needUpdate(this.baseTableLayout, replace, isAuto);
    }

    private boolean needUpdate(LayoutEntity curLayout, LayoutEntity replace, boolean isAuto) {
        if (curLayout == null) {
            return false;
        }
        if (!isAuto) {
            return !curLayout.equals(replace);
        }
        return !curLayout.equalsCols(replace);
    }

    public void createAndAddBaseIndex(NDataModel model, List<IndexEntity.Source> sources) {
        LayoutEntity table;
        this.checkIsNotCachedAndShared();
        ArrayList baseLayouts = Lists.newArrayList();
        if (sources.contains((Object)IndexEntity.Source.BASE_AGG_INDEX)) {
            LayoutEntity agg = this.createBaseAggIndex(model);
            baseLayouts.add(agg);
        }
        if (sources.contains((Object)IndexEntity.Source.BASE_TABLE_INDEX) && (table = this.createBaseTableIndex(model)) != null) {
            baseLayouts.add(table);
        }
        if (!baseLayouts.isEmpty()) {
            this.createAndAddBaseIndex(baseLayouts);
        }
    }

    public void createAndAddBaseIndex(NDataModel model) {
        ArrayList sources = Lists.newArrayList((Object[])new IndexEntity.Source[]{IndexEntity.Source.BASE_AGG_INDEX, IndexEntity.Source.BASE_TABLE_INDEX});
        this.createAndAddBaseIndex(model, sources);
    }

    public void createAndAddBaseIndex(List<LayoutEntity> needCreateBaseLayouts) {
        this.checkIsNotCachedAndShared();
        Map<IndexEntity.IndexIdentifier, IndexEntity> allIndexMapping = this.getAllIndexesMap();
        for (LayoutEntity baseLayout : needCreateBaseLayouts) {
            IndexEntity newIndex;
            IndexEntity indexInAll;
            Optional<LayoutEntity> oldLayout = this.removeLayoutSameWith(baseLayout);
            if (oldLayout.isPresent()) {
                baseLayout.setId(oldLayout.get().getId());
            }
            if ((indexInAll = allIndexMapping.get((newIndex = IndexEntity.from(baseLayout)).createIndexIdentifier())) == null) {
                this.addIndex(newIndex, baseLayout.notAssignId());
                continue;
            }
            IndexEntity indexInWhiteList = this.getWhiteListIndexesMap().get(newIndex.createIndexIdentifier());
            if (indexInWhiteList != null) {
                IndexEntity realIndex = this.getIndexes().get(this.getIndexes().indexOf(indexInWhiteList));
                realIndex.addLayout(baseLayout);
                continue;
            }
            indexInAll.setLayouts(Lists.newArrayList());
            indexInAll.addLayout(baseLayout);
            this.getIndexes().add(indexInAll);
        }
    }

    public Long getBaseAggLayoutId() {
        return this.baseAggLayout != null ? Long.valueOf(this.baseAggLayout.getId()) : null;
    }

    public Long getBaseTableLayoutId() {
        return this.baseTableLayout != null ? Long.valueOf(this.baseTableLayout.getId()) : null;
    }

    public Set<Long> getAllLayoutIds(boolean includeTobeDeleted) {
        return this.getIdMapping().getAllLayoutIds(includeTobeDeleted);
    }

    public Set<Long> getAllToBeDeleteLayoutId() {
        return this.getIdMapping().getAllToBeDelete();
    }

    public long getAllLayoutsSize(boolean includeTobeDeleted) {
        return this.getIdMapping().getAllLayoutsSize(includeTobeDeleted);
    }

    public Set<Integer> getRelatedColIds() {
        HashSet colIds = Sets.newHashSet();
        HashSet measureIds = Sets.newHashSet();
        if (this.ruleBasedIndex != null) {
            this.ruleBasedIndex.getAggregationGroups().forEach(group -> {
                Integer[] dims = group.getIncludes();
                colIds.addAll(Arrays.asList(dims));
                Integer[] measures = group.getMeasures();
                measureIds.addAll(Arrays.asList(measures));
            });
        }
        this.indexes.forEach(index -> {
            colIds.addAll(index.getDimensions());
            measureIds.addAll(index.getMeasures());
        });
        this.toBeDeletedIndexes.forEach(index -> {
            colIds.addAll(index.getDimensions());
            measureIds.addAll(index.getMeasures());
        });
        NDataModel model = this.getModel();
        if (model.getProjectInstance().getConfig().exposeModelJoinKey()) {
            Map<String, Integer> aliasIdMap = model.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).collect(Collectors.toMap(NDataModel.NamedColumn::getAliasDotColumn, NDataModel.NamedColumn::getId));
            model.getJoinTables().forEach(join -> {
                List<String> joinKey = join.getJoin().getJoinKey();
                if (!joinKey.isEmpty()) {
                    colIds.addAll(joinKey.stream().map(aliasIdMap::get).collect(Collectors.toList()));
                }
            });
        }
        this.collectMeasuresRelatedCol(measureIds, colIds);
        return colIds;
    }

    private void collectMeasuresRelatedCol(Set<Integer> measureIds, Set<Integer> colIds) {
        List<NDataModel.Measure> measures = measureIds.stream().map(measureId -> (NDataModel.Measure)this.getModel().getEffectiveMeasures().get(measureId)).collect(Collectors.toList());
        measures.forEach(measure -> {
            List<TblColRef> colRefs = measure.getFunction().getColRefs();
            colRefs.forEach(colRef -> colIds.add(this.getModel().getColumnIdByColumnName(colRef.getAliasDotName())));
        });
    }

    public IndexPlanUpdateHandler createUpdateHandler() {
        return new IndexPlanUpdateHandler();
    }

    public IndexEntity.IndexIdentifier createIndexIdentifier(LayoutEntity layout, boolean agg) {
        return new IndexEntity.IndexIdentifier(this.getDimensions(layout), this.getMeasures(layout), !agg);
    }

    @JsonIgnore
    public List<Integer> getMeasures(LayoutEntity layout) {
        return layout.getColOrder().stream().filter(i -> i >= 100000).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<Integer> getDimensions(LayoutEntity layout) {
        return layout.getColOrder().stream().filter(i -> i < 100000).collect(Collectors.toList());
    }

    public boolean isOfflineManually() {
        return this.getOverrideProps().getOrDefault("kylin.model.offline", "false").trim().equals("true");
    }

    private IdMapping initIdMapping() {
        return new IdMapping();
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public RuleBasedIndex getRuleBasedIndex() {
        return this.ruleBasedIndex;
    }

    @Generated
    public List<IndexEntity> getIndexes() {
        return this.indexes;
    }

    @Generated
    public List<IndexEntity> getToBeDeletedIndexes() {
        return this.toBeDeletedIndexes;
    }

    @Generated
    public long getRetentionRange() {
        return this.retentionRange;
    }

    @Generated
    public long getNextAggregationIndexId() {
        return this.nextAggregationIndexId;
    }

    @Generated
    public long getNextTableIndexId() {
        return this.nextTableIndexId;
    }

    @Generated
    public List<Integer> getAggShardByColumns() {
        return this.aggShardByColumns;
    }

    @Generated
    public List<Integer> getExtendPartitionColumns() {
        return this.extendPartitionColumns;
    }

    @Generated
    public void setLayoutBucketNumMapping(Map<Long, Integer> layoutBucketNumMapping) {
        this.layoutBucketNumMapping = layoutBucketNumMapping;
    }

    @Generated
    public Map<Long, Integer> getLayoutBucketNumMapping() {
        return this.layoutBucketNumMapping;
    }

    @Generated
    public int getApprovedAdditionalRecs() {
        return this.approvedAdditionalRecs;
    }

    @Generated
    public void setApprovedAdditionalRecs(int approvedAdditionalRecs) {
        this.approvedAdditionalRecs = approvedAdditionalRecs;
    }

    @Generated
    public int getApprovedRemovalRecs() {
        return this.approvedRemovalRecs;
    }

    @Generated
    public void setApprovedRemovalRecs(int approvedRemovalRecs) {
        this.approvedRemovalRecs = approvedRemovalRecs;
    }

    @Generated
    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }

    @Generated
    public void setBaseAggLayout(LayoutEntity baseAggLayout) {
        this.baseAggLayout = baseAggLayout;
    }

    @Generated
    public LayoutEntity getBaseAggLayout() {
        return this.baseAggLayout;
    }

    @Generated
    public LayoutEntity getBaseTableLayout() {
        return this.baseTableLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private IdMapping getIdMapping() {
        Object value = this.idMapping.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.idMapping;
            synchronized (atomicReference) {
                value = this.idMapping.get();
                if (value == null) {
                    IdMapping actualValue = this.initIdMapping();
                    value = actualValue == null ? this.idMapping : actualValue;
                    this.idMapping.set(value);
                }
            }
        }
        return (IdMapping)(value == this.idMapping ? null : value);
    }

    @Generated
    public void setBaseAggIndexReduceHighCardinalityDim(boolean baseAggIndexReduceHighCardinalityDim) {
        this.baseAggIndexReduceHighCardinalityDim = baseAggIndexReduceHighCardinalityDim;
    }

    @Generated
    public boolean isBaseAggIndexReduceHighCardinalityDim() {
        return this.baseAggIndexReduceHighCardinalityDim;
    }

    @Generated
    public void setPlannerWhiteList(List<Long> plannerWhiteList) {
        this.plannerWhiteList = plannerWhiteList;
    }

    @Generated
    public List<Long> getPlannerWhiteList() {
        return this.plannerWhiteList;
    }

    private class IdMapping
    implements Serializable {
        private Map<Long, IndexEntity> allIndexMapping;
        private Map<Long, LayoutEntity> allLayoutMapping;

        IdMapping() {
            this.allIndexMapping = IndexPlan.this.getAllIndexes().stream().collect(Collectors.toMap(IndexEntity::getId, Function.identity()));
            this.allLayoutMapping = this.allIndexMapping.values().stream().flatMap(index -> index.getLayouts().stream()).collect(Collectors.toMap(LayoutEntity::getId, Function.identity()));
        }

        public IndexEntity getIndexEntity(long indexId) {
            return this.allIndexMapping.get(indexId);
        }

        public LayoutEntity getLayoutEntity(Long layoutId) {
            return this.allLayoutMapping.get(layoutId);
        }

        public Set<Long> getAllLayoutIds(boolean includeTobeDeleted) {
            if (includeTobeDeleted) {
                return this.allLayoutMapping.keySet();
            }
            return this.allLayoutMapping.values().stream().filter(layout -> !layout.isToBeDeleted()).map(LayoutEntity::getId).collect(Collectors.toSet());
        }

        public long getAllLayoutsSize(boolean includeTobeDeleted) {
            if (includeTobeDeleted) {
                return this.allLayoutMapping.size();
            }
            return this.allLayoutMapping.values().stream().filter(layout -> !layout.isToBeDeleted()).count();
        }

        public Set<Long> getAllToBeDelete() {
            return this.allLayoutMapping.values().stream().filter(LayoutEntity::isToBeDeleted).map(LayoutEntity::getId).collect(Collectors.toSet());
        }
    }

    public static class UpdateRuleImpact {
        private Set<LayoutEntity> decreaseLayouts;
        private Set<LayoutEntity> increaseLayouts;
        private Set<LayoutEntity> rollbackLayouts;

        @Generated
        public UpdateRuleImpact(Set<LayoutEntity> decreaseLayouts, Set<LayoutEntity> increaseLayouts, Set<LayoutEntity> rollbackLayouts) {
            this.decreaseLayouts = decreaseLayouts;
            this.increaseLayouts = increaseLayouts;
            this.rollbackLayouts = rollbackLayouts;
        }

        @Generated
        public Set<LayoutEntity> getDecreaseLayouts() {
            return this.decreaseLayouts;
        }

        @Generated
        public Set<LayoutEntity> getIncreaseLayouts() {
            return this.increaseLayouts;
        }

        @Generated
        public Set<LayoutEntity> getRollbackLayouts() {
            return this.rollbackLayouts;
        }

        @Generated
        public void setDecreaseLayouts(Set<LayoutEntity> decreaseLayouts) {
            this.decreaseLayouts = decreaseLayouts;
        }

        @Generated
        public void setIncreaseLayouts(Set<LayoutEntity> increaseLayouts) {
            this.increaseLayouts = increaseLayouts;
        }

        @Generated
        public void setRollbackLayouts(Set<LayoutEntity> rollbackLayouts) {
            this.rollbackLayouts = rollbackLayouts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateRuleImpact)) {
                return false;
            }
            UpdateRuleImpact other = (UpdateRuleImpact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<LayoutEntity> this$decreaseLayouts = this.getDecreaseLayouts();
            Set<LayoutEntity> other$decreaseLayouts = other.getDecreaseLayouts();
            if (this$decreaseLayouts == null ? other$decreaseLayouts != null : !((Object)this$decreaseLayouts).equals(other$decreaseLayouts)) {
                return false;
            }
            Set<LayoutEntity> this$increaseLayouts = this.getIncreaseLayouts();
            Set<LayoutEntity> other$increaseLayouts = other.getIncreaseLayouts();
            if (this$increaseLayouts == null ? other$increaseLayouts != null : !((Object)this$increaseLayouts).equals(other$increaseLayouts)) {
                return false;
            }
            Set<LayoutEntity> this$rollbackLayouts = this.getRollbackLayouts();
            Set<LayoutEntity> other$rollbackLayouts = other.getRollbackLayouts();
            return !(this$rollbackLayouts == null ? other$rollbackLayouts != null : !((Object)this$rollbackLayouts).equals(other$rollbackLayouts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UpdateRuleImpact;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<LayoutEntity> $decreaseLayouts = this.getDecreaseLayouts();
            result = result * 59 + ($decreaseLayouts == null ? 43 : ((Object)$decreaseLayouts).hashCode());
            Set<LayoutEntity> $increaseLayouts = this.getIncreaseLayouts();
            result = result * 59 + ($increaseLayouts == null ? 43 : ((Object)$increaseLayouts).hashCode());
            Set<LayoutEntity> $rollbackLayouts = this.getRollbackLayouts();
            result = result * 59 + ($rollbackLayouts == null ? 43 : ((Object)$rollbackLayouts).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IndexPlan.UpdateRuleImpact(decreaseLayouts=" + this.getDecreaseLayouts() + ", increaseLayouts=" + this.getIncreaseLayouts() + ", rollbackLayouts=" + this.getRollbackLayouts() + ")";
        }
    }

    public class IndexPlanUpdateHandler {
        IndexPlan indexPlan;
        Map<IndexEntity.IndexIdentifier, IndexEntity> whiteIndexesMap;
        Map<IndexEntity.IndexIdentifier, IndexEntity> allIndexesMap;
        AtomicLong nextAggregationIndexId;
        AtomicLong nextTableIndexId;
        int approvedAdditionalRecs;
        int approvedRemovalRecs;
        private Set<Long> addedLayouts = Sets.newHashSet();

        private IndexPlanUpdateHandler() {
            this.indexPlan = IndexPlan.this.isCachedAndShared ? (IndexPlan)JsonUtil.deepCopyQuietly((Object)IndexPlan.this, IndexPlan.class) : IndexPlan.this;
            this.whiteIndexesMap = this.indexPlan.getWhiteListIndexesMap();
            this.allIndexesMap = this.indexPlan.getAllIndexesMap();
            this.nextAggregationIndexId = new AtomicLong(this.indexPlan.getNextAggregationIndexId());
            this.nextTableIndexId = new AtomicLong(this.indexPlan.getNextTableIndexId());
        }

        public boolean add(LayoutEntity layout, boolean isAgg) {
            return this.add(layout, isAgg, true);
        }

        public boolean add(LayoutEntity layout, boolean isAgg, boolean needUpdateApprovedRecs) {
            IndexEntity.IndexIdentifier identifier = IndexPlan.this.createIndexIdentifier(layout, isAgg);
            if (this.allIndexesMap.get(identifier) != null && this.allIndexesMap.get(identifier).getLayouts().contains(layout)) {
                return false;
            }
            if (!this.whiteIndexesMap.containsKey(identifier)) {
                IndexEntity index = new IndexEntity();
                index.setDimensions(IndexPlan.this.getDimensions(layout));
                index.setMeasures(IndexPlan.this.getMeasures(layout));
                index.setNextLayoutOffset(1L);
                if (this.allIndexesMap.get(identifier) != null) {
                    index.setId(this.allIndexesMap.get(identifier).getId());
                    index.setNextLayoutOffset(this.allIndexesMap.get(identifier).getNextLayoutOffset());
                } else {
                    index.setId(isAgg ? this.nextAggregationIndexId.getAndAdd(10000L) : this.nextTableIndexId.getAndAdd(10000L));
                }
                layout.setIndex(index);
                layout.setId(index.getId() + index.getNextLayoutOffset());
                index.setLayouts(Lists.newArrayList((Object[])new LayoutEntity[]{layout}));
                index.setNextLayoutOffset(index.getNextLayoutOffset() + 1L);
                this.whiteIndexesMap.put(identifier, index);
                this.addedLayouts.add(layout.getId());
            } else {
                IndexEntity indexEntity = this.whiteIndexesMap.get(identifier);
                if (indexEntity.getLayouts().contains(layout)) {
                    return false;
                }
                layout.setId(indexEntity.getId() + indexEntity.getNextLayoutOffset());
                layout.setIndex(indexEntity);
                indexEntity.setNextLayoutOffset(indexEntity.getNextLayoutOffset() + 1L);
                indexEntity.getLayouts().add(layout);
                this.addedLayouts.add(layout.getId());
            }
            if (needUpdateApprovedRecs) {
                ++this.approvedAdditionalRecs;
            }
            return true;
        }

        public boolean remove(LayoutEntity layout, boolean isAgg, boolean needAddBlackList) {
            return this.remove(layout, isAgg, needAddBlackList, true);
        }

        public boolean remove(LayoutEntity layout, boolean isAgg, boolean needAddBlackList, boolean needUpdateApprovedRecs) {
            IndexEntity.IndexIdentifier identifier = IndexPlan.this.createIndexIdentifier(layout, isAgg);
            if (this.allIndexesMap.containsKey(identifier) && this.allIndexesMap.get(identifier).getLayouts().contains(layout)) {
                IndexEntity indexEntity = this.allIndexesMap.get(identifier);
                LayoutEntity layoutInIndexPlan = indexEntity.getLayout(layout.getId());
                if (layoutInIndexPlan == null) {
                    return false;
                }
                if (layoutInIndexPlan.isManual()) {
                    return this.removeManualPlan(layout, isAgg, needAddBlackList, needUpdateApprovedRecs, indexEntity, layoutInIndexPlan);
                }
                indexEntity.getLayouts().remove(layoutInIndexPlan);
                this.whiteIndexesMap.values().stream().filter(indexEntityInIndexPlan -> indexEntityInIndexPlan.getId() == indexEntity.getId()).findFirst().ifPresent(indexEntityInIndexPlan -> indexEntityInIndexPlan.getLayouts().remove(layoutInIndexPlan));
                if (needUpdateApprovedRecs) {
                    ++this.approvedRemovalRecs;
                }
                return true;
            }
            return false;
        }

        private boolean removeManualPlan(LayoutEntity layout, boolean isAgg, boolean needAddBlackList, boolean needUpdateApprovedRecs, IndexEntity indexEntity, LayoutEntity layoutInIndexPlan) {
            if (isAgg && needAddBlackList) {
                this.indexPlan.addRuleBasedBlackList(Lists.newArrayList((Object[])new Long[]{layout.getId()}));
                if (layoutInIndexPlan.isAuto()) {
                    indexEntity.getLayouts().remove(layoutInIndexPlan);
                    this.whiteIndexesMap.values().stream().filter(indexEntityInIndexPlan -> indexEntityInIndexPlan.getId() == indexEntity.getId()).findFirst().ifPresent(indexEntityInIndexPlan -> indexEntityInIndexPlan.getLayouts().remove(layoutInIndexPlan));
                }
                if (needUpdateApprovedRecs) {
                    ++this.approvedRemovalRecs;
                }
                return true;
            }
            return false;
        }

        public IndexPlan complete() {
            this.indexPlan.setIndexes(this.whiteIndexesMap.values().stream().sorted(Comparator.comparingLong(IndexEntity::getId)).collect(Collectors.toList()));
            this.indexPlan.setApprovedAdditionalRecs(this.indexPlan.getApprovedAdditionalRecs() + this.approvedAdditionalRecs);
            this.indexPlan.setApprovedRemovalRecs(this.indexPlan.getApprovedRemovalRecs() + this.approvedRemovalRecs);
            return this.indexPlan;
        }

        @Generated
        public Set<Long> getAddedLayouts() {
            return this.addedLayouts;
        }
    }
}

