/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.cuboid;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;

public class NCuboidLayoutChooser {
    public static LayoutEntity selectLayoutForBuild(NDataSegment segment, IndexEntity entity) {
        Optional<LayoutEntity> candidate = segment.getIndexPlan().getAllIndexes().stream().filter(index -> index.fullyDerive(entity)).flatMap(index -> index.getLayouts().stream()).filter(layout -> segment.getLayout(layout.getId()) != null).min(Comparator.comparingLong(layout -> segment.getLayout(layout.getId()).getRows()));
        return candidate.orElse(null);
    }

    public static LayoutEntity selectLayoutForBuild(NDataSegment segment, IndexEntity index, Long partitionId) {
        Optional<LayoutEntity> candidate = segment.getIndexPlan().getAllIndexes().stream().filter(parent -> parent.fullyDerive(index)).flatMap(parent -> parent.getLayouts().stream()).filter(parent -> Objects.nonNull(segment.getLayout(parent.getId()))).filter(parent -> Objects.nonNull(segment.getLayout(parent.getId()).getDataPartition(partitionId))).min(Comparator.comparingLong(parent -> segment.getLayout(parent.getId()).getDataPartition(partitionId).getRows()));
        return candidate.orElse(null);
    }
}

