/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.acl.DependentColumn;

public class DependentColumnInfo {
    Map<String, Map<String, DependentColumn>> infos = new HashMap<String, Map<String, DependentColumn>>();

    public boolean needMask() {
        return !this.infos.isEmpty();
    }

    public void add(String dbName, String tableName, Collection<DependentColumn> columnInfos) {
        for (DependentColumn info : columnInfos) {
            this.infos.putIfAbsent(dbName + "." + tableName + "." + info.getColumn(), new HashMap());
            DependentColumn dependentColumn = this.infos.get(dbName + "." + tableName + "." + info.getColumn()).get(info.getDependentColumnIdentity());
            if (dependentColumn != null) {
                this.infos.get(dbName + "." + tableName + "." + info.getColumn()).put(info.getDependentColumnIdentity(), dependentColumn.merge(info));
                continue;
            }
            this.infos.get(dbName + "." + tableName + "." + info.getColumn()).put(info.getDependentColumnIdentity(), info);
        }
    }

    public void validate() {
        this.infos.values().stream().flatMap(map -> map.values().stream()).forEach(col -> {
            if (!this.get(col.getDependentColumnIdentity()).isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getNotSupportNestedDependentCol());
            }
        });
    }

    public Collection<DependentColumn> get(String columnIdentity) {
        return ((Map)this.infos.getOrDefault(columnIdentity, new HashMap())).values();
    }
}

