/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.raw;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class RawSerializer
extends DataTypeSerializer<List<ByteArray>> {
    public static final int RAW_BUFFER_SIZE = 0x100000;

    public RawSerializer(DataType dataType) {
    }

    private List<ByteArray> current() {
        ArrayList l = (ArrayList)this.current.get();
        if (l == null) {
            l = new ArrayList();
            this.current.set(l);
        }
        return l;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        int len = 0;
        if (in.hasRemaining()) {
            int size = BytesUtil.readVInt((ByteBuffer)in);
            len = in.position() - mark;
            for (int i = 0; i < size; ++i) {
                int length = BytesUtil.peekByteArrayLength((ByteBuffer)in);
                in.position(in.position() + length);
                len += length;
            }
        }
        in.position(mark);
        return len;
    }

    @Override
    public int maxLength() {
        return 0x100000;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    public void serialize(List<ByteArray> values, ByteBuffer out) {
        if (values == null) {
            BytesUtil.writeVInt((int)0, (ByteBuffer)out);
        } else {
            BytesUtil.writeVInt((int)values.size(), (ByteBuffer)out);
            for (ByteArray array : values) {
                if (!out.hasRemaining() || out.remaining() < array.length()) {
                    throw new RuntimeException("BufferOverflow! Please use one higher cardinality column for dimension column when build RAW cube!");
                }
                BytesUtil.writeByteArray((byte[])BytesUtil.subarray((byte[])array.array(), (int)array.offset(), (int)(array.offset() + array.length())), (ByteBuffer)out);
            }
        }
    }

    public List<ByteArray> deserialize(ByteBuffer in) {
        ArrayList<ByteArray> values = new ArrayList<ByteArray>();
        int size = BytesUtil.readVInt((ByteBuffer)in);
        if (size >= 0) {
            for (int i = 0; i < size; ++i) {
                ByteArray ba = new ByteArray(BytesUtil.readByteArray((ByteBuffer)in));
                if (ba.length() == 0) continue;
                values.add(ba);
            }
        } else {
            throw new RuntimeException("Read error data size:" + size);
        }
        return values;
    }
}

